/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.runner;

import java.awt.Rectangle;
import java.util.List;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.PWFooter;
import kd.bos.print.core.model.widget.PrintAtPage;
import kd.bos.print.core.model.widget.runner.AbstractRunner;
import kd.bos.print.core.model.widget.runner.IRunner;

public class HeaderFooterRunner
extends AbstractRunner<PWFooter> {
    @Override
    public void execute(IWidgetExecuteHelper helper) {
        this.helper = helper;
        PWFooter outputWidget = (PWFooter)this.getOutputWidget();
        List children = outputWidget.getChildren();
        if (children != null && children.size() > 0) {
            this.executeChildren(children);
        }
        this.cacheOutput(outputWidget);
        this.endOutput(outputWidget);
    }

    public void executeChildren(List<AbstractPrintWidget> children) {
        for (AbstractPrintWidget widget : children) {
            widget.setPrintAtPage(PrintAtPage.InContainer);
            IRunner runner = widget.getRunner();
            runner.setRelativeContext(this.getRelativeContext());
            widget.setCanvasWidget(Boolean.FALSE);
            this.doBeforeExecuteChildren(widget);
            runner.execute(this.helper);
        }
    }

    protected void doBeforeExecuteChildren(IPrintWidget output) {
        Rectangle rectangle = ((PWFooter)this.getOutputWidget()).getRectangle();
        int containerHeight = rectangle.height;
        int containerWidth = rectangle.width;
        int maxHeightToAdjust = containerHeight - output.getRectangle().y;
        if ((double)maxHeightToAdjust < output.getRectangle().getHeight()) {
            output.getRectangle().setSize(output.getRectangle().width, maxHeightToAdjust);
        }
        output.getContext().setContainerWidth(containerWidth);
        output.getContext().setContainerHeight(containerHeight);
        output.getContext().setMaxHeightToAdjust(maxHeightToAdjust);
        output.setContainerHeight(containerHeight);
        output.setContainerWidth(containerWidth);
        output.setMaxHeightToAdjust(maxHeightToAdjust);
    }

    @Override
    public void beginOutput(AbstractPrintWidget outputWidget) {
        if ("Header".equals(outputWidget.getType()) || "Footer".equals(outputWidget.getType())) {
            outputWidget.setPrintAtPage(PrintAtPage.All);
            this.getRelativeContext().recordPosition(outputWidget);
        }
    }

    @Override
    public void cacheOutput(AbstractPrintWidget outputWidget) {
        this.getRelativeContext().addWidget(PrintAtPage.All.getCode(), outputWidget);
    }

    @Override
    public void endOutput(AbstractPrintWidget outputWidget) {
        this.outputWidget = null;
    }
}

