/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.runner;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.PWPage;
import kd.bos.print.core.model.widget.PWidgetUtil;
import kd.bos.print.core.model.widget.PrintAtPage;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGrid;
import kd.bos.print.core.model.widget.runner.RelativeContext;
import kd.bos.print.core.utils.PTuple;

public class MulPageRelativeContext
extends RelativeContext {
    protected int pageOffset = 0;
    private List<Integer> pageOffsetList = new ArrayList<Integer>(10);
    private int preFooterHeight = 0;

    public MulPageRelativeContext(PWPage page, int startPage, int designPageIndex) {
        super(page, startPage);
        this.emptyPage = (PWPage)page.copy();
        this.emptyPage.setChildren(new ArrayList());
        this.designPageIndex = designPageIndex;
        PTuple headerFooterHeight = PWidgetUtil.getHeaderFooterHeight(page);
        this.setHeaderHeight((Integer)headerFooterHeight.item1);
        this.setFooterHeight((Integer)headerFooterHeight.item2);
    }

    public void update(PWPage page, int nowPage, int designPageIndex) {
        this.emptyPage = (PWPage)page.copy();
        this.emptyPage.setChildren(new ArrayList());
        this.designPageIndex = designPageIndex;
        this.startPage = nowPage;
        PTuple headerFooterHeight = PWidgetUtil.getHeaderFooterHeight(page);
        this.setHeaderHeight((Integer)headerFooterHeight.item1);
        this.setFooterHeight((Integer)headerFooterHeight.item2);
    }

    @Override
    protected RelativeContext.RelativePosition createRelativePosition(AbstractPrintWidget widget) {
        MulPageRelativePosition relativePosition = new MulPageRelativePosition(widget);
        relativePosition.setdY1((double)this.pageOffset + relativePosition.getDY1ByOffset(true));
        relativePosition.setdY2((double)this.pageOffset + relativePosition.getDY2ByOffset(true));
        return relativePosition;
    }

    public List<Integer> getPageOffsetList() {
        return this.pageOffsetList;
    }

    @Override
    public void finishDesignPage() {
        this.preFooterHeight = super.getFooterHeight();
        int offset = this.emptyPage.getRectangle().height - super.getFooterHeight();
        this.pageOffset += offset;
        this.pageOffsetList.add(offset);
        this.widgetPool.clear();
        for (RelativeContext.RelativePosition position : this.positions) {
            if (!"Header".equals(position.widgetType) && !"Footer".equals(position.widgetType) && position.getAtPage() != PrintAtPage.All && position.getAtPage() != PrintAtPage.Last && !"DataGrid_Fix".equals(position.widgetType)) continue;
            position.setAtPage(PrintAtPage.Nature);
            if (!"DataGrid_Fix".equals(position.widgetType)) continue;
            position.widgetType = "DataGrid";
        }
    }

    @Override
    protected void initFirstPagePosition(AbstractPrintWidget widget, RelativeContext.RelativePosition curPosition) {
        super.initFirstPagePosition(widget, curPosition);
        if (curPosition.getDesignPageIndex() != 0) {
            Rectangle widgetRectangle = widget.getRectangle();
            double headerY = 0.0;
            double footerY = this.getEmptyPage().getRectangle().height;
            for (RelativeContext.RelativePosition temPoi : this.positions) {
                if ("Header".equals(temPoi.widgetType) && temPoi.getDesignPageIndex() == 0) {
                    headerY = temPoi.getrY2();
                }
                if (!"Footer".equals(temPoi.widgetType) || temPoi.getDesignPageIndex() != 0) continue;
                footerY = temPoi.getrY1();
            }
            if (curPosition.getOriDY1() < headerY) {
                widgetRectangle.setRect(widgetRectangle.getX(), headerY, widgetRectangle.getWidth(), widgetRectangle.getHeight());
            } else if (curPosition.getOriDY1() + widgetRectangle.getHeight() > footerY) {
                widgetRectangle.setRect(widgetRectangle.getX(), footerY - widgetRectangle.getHeight(), widgetRectangle.getWidth(), widgetRectangle.getHeight());
            }
            widget.setRectangle(widgetRectangle);
        }
    }

    @Override
    protected double calcRelativeY(RelativeContext.RelativePosition curPosition, RelativeContext.RelativePosition targetPosition) {
        if (targetPosition.isHideMove()) {
            return targetPosition.getrY1() - targetPosition.getrY2();
        }
        if (targetPosition.getDesignPageIndex() < curPosition.getDesignPageIndex()) {
            return curPosition.getDY1ByOffset(true) - targetPosition.getDY2ByOffset(true) - (double)super.getHeaderHeight();
        }
        return curPosition.getDY1ByOffset(true) - targetPosition.getDY2ByOffset(true);
    }

    @Override
    protected void setOffset(RelativeContext.RelativePosition curPosition, RelativeContext.RelativePosition targetPosition, double offset) {
        double height = curPosition.getDY2ByOffset(false) - curPosition.getDY1ByOffset(false);
        RelativeContext.RelativePosition copy = curPosition instanceof MulPageRelativePosition ? new MulPageRelativePosition((MulPageRelativePosition)curPosition) : new RelativeContext.RelativePosition(curPosition);
        copy.setOffset(offset);
        double y1 = this.getOffsetDY1(copy);
        int headerHeight = this.getHeaderHeight();
        double pageHeight = this.emptyPage.getRectangle().getHeight() - (double)this.getFooterHeight(targetPosition.getId());
        if (curPosition.getDesignPageIndex() != targetPosition.getDesignPageIndex()) {
            double offsetY2 = y1 + height;
            if (offsetY2 <= pageHeight) {
                curPosition.setOffset(offset);
                curPosition.setOffsetPageIndex(this.getOffsetDesignPageIndex(curPosition));
            }
        } else if (y1 < (double)headerHeight || y1 + height > pageHeight) {
            double curY1 = this.getOffsetDY1(curPosition);
            curPosition.setOffset(curY1 - (double)headerHeight);
        } else {
            curPosition.setOffset(offset);
            curPosition.setOffsetPageIndex(this.getOffsetDesignPageIndex(curPosition));
        }
    }

    protected double getOffsetDY1(RelativeContext.RelativePosition curPosition) {
        Integer pageOffset;
        MulPageRelativeContext mulPageRelativeContext = this;
        double offsetDY1 = curPosition.getDY1ByOffset(true);
        List<Integer> pageOffsetList = mulPageRelativeContext.getPageOffsetList();
        for (int index = 0; index < pageOffsetList.size() && !(offsetDY1 < (double)(pageOffset = pageOffsetList.get(index)).intValue()); offsetDY1 -= (double)pageOffset.intValue(), ++index) {
        }
        return offsetDY1;
    }

    @Override
    public int getFooterHeight(String widgetId) {
        if (widgetId == null || this.designPageIndex == 0) {
            return super.getFooterHeight();
        }
        Integer positionIndex = (Integer)this.positionMap.get(widgetId);
        if (positionIndex != null && positionIndex >= 0 && positionIndex < this.positions.size()) {
            PWPage pwPage;
            RelativeContext.RelativePosition relativePosition = (RelativeContext.RelativePosition)this.positions.get(positionIndex);
            if (!(CollectionUtils.isEmpty((Map)this.pagePools) || (pwPage = (PWPage)this.pagePools.get(relativePosition.getStartPageIndex())) != null && pwPage.getDesignPageIndex() != this.designPageIndex)) {
                return super.getFooterHeight();
            }
        }
        return this.preFooterHeight;
    }

    @Override
    protected double calcNewPageStartY(RelativeContext.RelativePosition curPosition, RelativeContext.RelativePosition targetPosition) {
        double heightY = super.calcNewPageStartY(curPosition, targetPosition);
        if (curPosition.getOffsetPageIndex() != targetPosition.getOffsetPageIndex()) {
            if (curPosition.getOffset() == 0.0) {
                return curPosition.getOriDY1();
            }
            double y1 = this.getOffsetDY1(curPosition);
            return y1;
        }
        return heightY;
    }

    @Override
    protected void setWidgetPageIndex(AbstractPrintWidget widget) {
        super.setWidgetPageIndex(widget);
        if (widget instanceof PWDataGrid && ((PWDataGrid)widget).isFixedRowAtPage() && this.designPageIndex != 0) {
            widget.setPageIndex(this.startPage + 1);
        } else if (widget.getPrintAtPage() == PrintAtPage.First && this.designPageIndex != 0) {
            widget.setPageIndex(this.startPage);
        }
    }

    public void updateFixedControlPosition(Set<String> widgetIds) {
        if (widgetIds == null) {
            return;
        }
        for (String widgetId : widgetIds) {
            RelativeContext.RelativePosition relativePosition;
            Integer positionIndex = (Integer)this.positionMap.get(widgetId);
            if (positionIndex == null || (relativePosition = (RelativeContext.RelativePosition)this.positions.get(positionIndex)) == null) continue;
            relativePosition.setPageIndex(relativePosition.getPageIndex() + 1 >= this.pagePools.size() ? this.pagePools.size() - 1 : relativePosition.getPageIndex() + 1);
        }
    }

    protected static class MulPageRelativePosition
    extends RelativeContext.RelativePosition {
        protected double oriDY1;

        MulPageRelativePosition(AbstractPrintWidget widget) {
            super(widget);
            this.oriDY1 = widget.getRectangle().y;
        }

        public MulPageRelativePosition(MulPageRelativePosition position) {
            super(position);
            this.oriDY1 = position.oriDY1;
        }

        @Override
        public double getOriDY1() {
            return this.oriDY1;
        }
    }
}

