/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.runner;

import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import kd.bos.print.core.data.R1PDataVisitor;
import kd.bos.print.core.data.field.CollectionField;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.IPrintWidgetContainer;
import kd.bos.print.core.model.widget.PWFooter;
import kd.bos.print.core.model.widget.PWPage;
import kd.bos.print.core.model.widget.PrintAtPage;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGrid;
import kd.bos.print.core.model.widget.grid.tabletail.PWTableTail;
import kd.bos.print.core.model.widget.runner.AbstractRunner;
import kd.bos.print.core.model.widget.runner.IRunner;

public class PageRunner
extends AbstractRunner<PWPage> {
    @Override
    public void execute(IWidgetExecuteHelper helper) {
        this.helper = helper;
        PWPage outputWidget = (PWPage)this.getOutputWidget();
        this.executeChildren(outputWidget, outputWidget.getChildren());
    }

    @Override
    public void executeChildren(IPrintWidgetContainer container, List<IPrintWidget> childs) {
        List<AbstractPrintWidget> children = ((PWPage)this.getOutputWidget()).getChildren();
        children = this.sort(container, children);
        for (AbstractPrintWidget widget : children) {
            IRunner runner = this.getRunner(widget);
            this.dataGridHideEmptyMove(widget);
            runner.beginOutput(widget);
            if (widget.isHideMove()) {
                this.hideMove(widget);
                continue;
            }
            this.doBeforeExecuteChildren(widget);
            runner.execute(this.helper);
        }
    }

    private void hideMove(AbstractPrintWidget widget) {
        PrintAtPage atPage = widget.getPrintAtPage();
        if (atPage == PrintAtPage.Nature || atPage == PrintAtPage.First || atPage == PrintAtPage.FlowNature || atPage == PrintAtPage.FlowAll) {
            this.getRelativeContext().recordPosition(widget);
        } else {
            this.getRelativeContext().addWidget(atPage.getCode(), widget);
        }
        if (!(widget instanceof PWDataGrid)) {
            return;
        }
        PWDataGrid pwDataGrid = (PWDataGrid)widget;
        PWTableTail tableTail = pwDataGrid.getTableTail();
        if (tableTail == null) {
            return;
        }
        IRunner runner = tableTail.getRunner();
        runner.setRelativeContext(this.getRelativeContext());
        tableTail.setCanvasWidget(Boolean.TRUE);
        runner.beginOutput(tableTail);
        if (tableTail.isHideMove()) {
            this.getRelativeContext().recordPosition(widget);
            return;
        }
        runner.execute(this.helper);
    }

    private void dataGridHideEmptyMove(AbstractPrintWidget widget) {
        if (widget.isHideMove()) {
            return;
        }
        if (!(widget instanceof PWDataGrid)) {
            return;
        }
        PWDataGrid pwDataGrid = (PWDataGrid)widget;
        if (!pwDataGrid.isHideEmptyMove()) {
            return;
        }
        String datasource = pwDataGrid.getDatasource();
        if (StringUtils.isBlank((CharSequence)datasource)) {
            widget.setHideMove(true);
            return;
        }
        IWidgetExecuteHelper.IDataHelper dataHelper = this.helper.getDataHelper();
        R1PDataVisitor dataVisitor = dataHelper.getDataVisitor(datasource);
        if (dataVisitor == null) {
            widget.setHideMove(true);
            return;
        }
        CollectionField entryField = dataVisitor.getCollectionField(pwDataGrid.getDatasource(), pwDataGrid.getKey());
        if (entryField == null || CollectionUtils.isEmpty((Collection)entryField.getValue())) {
            widget.setHideMove(true);
        }
    }

    private double getSortNum(AbstractPrintWidget widget, double containerHeight) {
        if (widget instanceof PWFooter) {
            return -(containerHeight + 10.0);
        }
        if (widget.getPrintAtPage() == PrintAtPage.All) {
            return widget.getRectangle().getY() - containerHeight;
        }
        return widget.getRectangle().getY();
    }

    protected void doBeforeExecuteChildren(IPrintWidget output) {
        Rectangle rectangle = ((PWPage)this.getOutputWidget()).getRectangle();
        int containerHeight = rectangle.height - this.getRelativeContext().getFooterHeight(output.getId());
        int containerWidth = rectangle.width;
        int maxHeightToAdjust = containerHeight - output.getRectangle().y;
        output.getContext().setContainerWidth(containerWidth);
        output.getContext().setContainerHeight(containerHeight);
        output.getContext().setMaxHeightToAdjust(maxHeightToAdjust);
        output.setContainerHeight(containerHeight);
        output.setContainerWidth(containerWidth);
        output.setMaxHeightToAdjust(maxHeightToAdjust);
    }

    protected List<AbstractPrintWidget> sort(IPrintWidgetContainer container, List<AbstractPrintWidget> children) {
        double containerHeight = container.getRectangle().getHeight();
        return children.stream().sorted((a, b) -> {
            double bNum;
            double aNum = this.getSortNum((AbstractPrintWidget)a, containerHeight);
            if (aNum > (bNum = this.getSortNum((AbstractPrintWidget)b, containerHeight))) {
                return 1;
            }
            if (aNum < bNum) {
                return -1;
            }
            return 0;
        }).collect(Collectors.toList());
    }

    protected IRunner getRunner(AbstractPrintWidget widget) {
        if (widget instanceof PWFooter) {
            String type = widget.getType();
            if ("Header".equals(type)) {
                this.setHeaderHeight(widget.getRectangle().height);
            } else {
                this.setFooterHeight(widget.getRectangle().height);
            }
        }
        IRunner runner = widget.getRunner();
        runner.setRelativeContext(this.getRelativeContext());
        widget.setCanvasWidget(Boolean.TRUE);
        return runner;
    }
}

