/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.runner;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.exception.PrintException;
import kd.bos.print.core.execute.ExecuteLife;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.PWPage;
import kd.bos.print.core.model.widget.PWText;
import kd.bos.print.core.model.widget.PrintAtPage;
import kd.bos.print.core.model.widget.grid.AbstractPWGrid;
import kd.bos.print.core.model.widget.grid.datagrid.AbstractPWDataGridRow;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGrid;
import kd.bos.print.core.model.widget.grid.datagrid.PWDetailRow;
import kd.bos.print.core.model.widget.runner.MulPageRelativeContext;

public class RelativeContext {
    protected int startPage;
    protected int designPageIndex;
    protected Map<Integer, PWPage> pagePools = new TreeMap(Comparator.naturalOrder());
    protected Map<String, List<AbstractPrintWidget>> widgetPool;
    protected List<RelativePosition> positions = new ArrayList<RelativePosition>();
    protected Map<String, Integer> positionMap = new HashMap<String, Integer>();
    protected PWPage emptyPage;
    private int headerHeight;
    private int footerHeight;
    private int pageLimit;
    private double outputGridActualY;
    private static final int textQuarkHeight = 80;

    public static int getTextQuarkHeight() {
        return 80;
    }

    public double getOutputGridActualY() {
        return this.outputGridActualY;
    }

    public void setOutputGridActualY(double outputGridActualY) {
        this.outputGridActualY = outputGridActualY;
    }

    public int getDesignPageIndex() {
        return this.designPageIndex;
    }

    public RelativeContext(PWPage emptyPage, int startPage) {
        this.emptyPage = emptyPage;
        this.startPage = startPage;
        this.pageLimit = ExecuteContext.get().getPageLimit();
    }

    public RelativeContext(PWPage emptyPage, int startPage, int designPageIndex) {
        this.emptyPage = emptyPage;
        this.startPage = startPage;
        this.designPageIndex = designPageIndex;
        this.pageLimit = ExecuteContext.get().getPageLimit();
    }

    public PWPage getEmptyPage() {
        return this.emptyPage;
    }

    public Map<Integer, PWPage> getPagePool() {
        if (!this.pagePools.containsKey(this.startPage)) {
            this.pagePools.put(this.startPage, (PWPage)this.emptyPage.copy());
        }
        return this.pagePools;
    }

    public void finishDesignPage() {
        if (this.positions != null) {
            this.positions.clear();
        }
        if (this.positionMap != null) {
            this.positionMap.clear();
        }
    }

    public void release() {
        this.finishDesignPage();
    }

    public void recordPosition(AbstractPrintWidget widget) {
        this.recordPosition(widget, this.getWidgetReact(widget));
    }

    public void recordOutPutPosition(AbstractPrintWidget widget) {
        this.recordPosition(widget, widget.getRectangle());
    }

    protected RelativePosition createRelativePosition(AbstractPrintWidget widget) {
        return new RelativePosition(widget);
    }

    private void recordPosition(AbstractPrintWidget widget, Rectangle rectangle) {
        int widgetPageIndex = widget.getPageIndex();
        String widgetId = widget.getId();
        if (!this.positionMap.containsKey(widgetId)) {
            RelativePosition position = this.createRelativePosition(widget);
            if (widget.getPrintAtPage() == PrintAtPage.All) {
                position.setrY1(widget.getRectangle().getY());
                position.setrY2(position.getrY1() + widget.getRectangle().getHeight());
            }
            this.setWidgetPageIndex(widget);
            position.setDesignPageIndex(this.designPageIndex);
            position.setOffsetPageIndex(this.designPageIndex);
            this.positionMap.put(widgetId, this.positions.size());
            this.positions.add(position);
        } else {
            RelativePosition position = this.positions.get(this.positionMap.get(widgetId));
            int positionIndex = position.getPageIndex();
            if (widgetPageIndex >= positionIndex || widgetPageIndex == this.startPage && positionIndex == this.startPage) {
                if (widget.getPrintAtPage() == PrintAtPage.All) {
                    position.setPageIndex(widgetPageIndex);
                } else {
                    double height = rectangle.getHeight();
                    double y = rectangle.getY();
                    position.setrY1(y);
                    position.setrY2(y + height);
                    position.setPageIndex(widgetPageIndex);
                }
            }
        }
    }

    protected void setWidgetPageIndex(AbstractPrintWidget widget) {
        if (widget.getPageIndex() < this.startPage) {
            widget.setPageIndex(this.startPage);
        }
    }

    public void flowTargetWidget(AbstractPrintWidget current, String targetId) {
        RelativePosition targetPosition;
        Integer index = this.positionMap.get(targetId);
        if (index == null || (targetPosition = this.positions.get(index)) == null) {
            this.scanRelative(current);
            return;
        }
        RelativePosition curPosition = this.findPosition(current);
        Rectangle rectangle = this.getWidgetReact(current);
        double curY1 = targetPosition.getrY2();
        if (targetPosition.isHideMove()) {
            curPosition.setOffset(targetPosition.getOffset() + curPosition.getDY1ByOffset(false) - targetPosition.getDY1ByOffset(false));
            curY1 = targetPosition.getrY1();
        }
        if (current.getPrintAtPage() == PrintAtPage.FlowAll) {
            int pageIndex = targetPosition.getPageIndex();
            curPosition.setPageIndex(pageIndex);
            curPosition.setStartPageIndex(pageIndex);
            rectangle.setRect(curPosition.getdX1(), curY1, rectangle.getWidth(), rectangle.getHeight());
            current.setPageIndex(pageIndex);
            current.setRectangle(rectangle);
            return;
        }
        double pageHeight = this.emptyPage.getRectangle().getHeight() - (double)this.getFooterHeight(targetPosition.getId());
        double quarkHeight = current.getRectangle().getHeight();
        double curY2 = curY1 + quarkHeight;
        int curPageIndex = targetPosition.getPageIndex();
        if (curY2 > pageHeight) {
            current.setPageIndex(++curPageIndex);
            curPosition.setStartPageIndex(curPageIndex);
            rectangle.setRect(curPosition.getdX1(), this.calcNewPageStartY(curPosition, targetPosition), rectangle.getWidth(), rectangle.getHeight());
        } else {
            curPosition.setPageIndex(curPageIndex);
            curPosition.setStartPageIndex(curPageIndex);
            if (curY1 < (double)this.getHeaderHeight()) {
                curY1 = this.getHeaderHeight();
            }
            rectangle.setRect(curPosition.getdX1(), curY1, rectangle.getWidth(), rectangle.getHeight());
        }
        current.setPageIndex(curPageIndex);
        current.setRectangle(rectangle);
    }

    public void scanRelative(AbstractPrintWidget widget) {
        RelativePosition curPosition = this.findPosition(widget);
        Rectangle rectangle = this.getWidgetReact(widget);
        RelativePosition targetPosition = this.scanRelativePosi(curPosition);
        RelativePosition absolutePosition = this.scanAbsolutePosi(curPosition);
        if (targetPosition == null) {
            this.initFirstPagePosition(widget, curPosition);
            return;
        }
        this.setOffset(curPosition, targetPosition);
        double relativeY = this.calcRelativeY(curPosition, targetPosition);
        double curY1 = relativeY + targetPosition.getrY2();
        boolean relativeTargetFirstPage = false;
        if (relativeY < 0.0) {
            if ("DataGrid".equals(targetPosition.widgetType) || "CardGrid".equals(targetPosition.widgetType) || "LayoutGrid".equals(targetPosition.widgetType) || "RichText".equals(targetPosition.widgetType)) {
                relativeY = curPosition.getDY1ByOffset(true) - targetPosition.getDY2ByOffset(true);
                curY1 = relativeY + targetPosition.getrY2();
            } else {
                List children;
                relativeTargetFirstPage = true;
                relativeY = curPosition.getDY1ByOffset(true) - targetPosition.getDY1ByOffset(true);
                curY1 = relativeY + targetPosition.getrY1();
                PWPage pwPage = this.pagePools.get(targetPosition.getStartPageIndex());
                if (pwPage != null && (children = pwPage.getChildren()) != null && !children.isEmpty()) {
                    for (AbstractPrintWidget tempWidget : children) {
                        if (!StringUtils.equals((CharSequence)targetPosition.getId(), (CharSequence)tempWidget.getId())) continue;
                        curY1 = relativeY + tempWidget.getRectangle().getY();
                        break;
                    }
                }
            }
        }
        int yFromEvery = -1;
        if (absolutePosition != null && !targetPosition.isHideMove()) {
            yFromEvery = this.calYByAbsolutePosi(curPosition, absolutePosition);
            if (absolutePosition.rY2 > targetPosition.rY2 && yFromEvery >= 0) {
                curY1 = yFromEvery;
            }
        }
        double pageHeight = this.emptyPage.getRectangle().getHeight() - (double)this.getFooterHeight(targetPosition.getId());
        double maxRemainHeight = pageHeight - curY1;
        double quarkHeight = widget instanceof PWText ? (((PWText)widget).isAdjustHeight() && maxRemainHeight >= 80.0 ? 80.0 : widget.getRectangle().getHeight()) : (widget instanceof AbstractPWGrid ? (maxRemainHeight < 80.0 || ((AbstractPWGrid)widget).isWholeGridPage() ? widget.getRectangle().getHeight() : 80.0) : widget.getRectangle().getHeight());
        double curY2 = curY1 + quarkHeight;
        int curPageIndex = targetPosition.getPageIndex();
        if (relativeTargetFirstPage) {
            curPageIndex = targetPosition.getStartPageIndex();
        }
        if (curY1 > pageHeight || curY2 > pageHeight && !curPosition.isHideMove()) {
            widget.setPageIndex(++curPageIndex);
            curPosition.setStartPageIndex(curPageIndex);
            rectangle.setRect(curPosition.getdX1(), yFromEvery < 0 ? this.calcNewPageStartY(curPosition, targetPosition) : (double)yFromEvery, rectangle.getWidth(), rectangle.getHeight());
        } else {
            widget.setPageIndex(curPageIndex);
            curPosition.setStartPageIndex(curPageIndex);
            if (curY1 < (double)this.getHeaderHeight()) {
                curY1 = this.getHeaderHeight();
            }
            rectangle.setRect(curPosition.getdX1(), curY1, rectangle.getWidth(), rectangle.getHeight());
        }
        widget.setRectangle(rectangle);
    }

    protected void initFirstPagePosition(AbstractPrintWidget widget, RelativePosition curPosition) {
        widget.setPageIndex(this.startPage);
        curPosition.setStartPageIndex(this.startPage);
    }

    private void setOffset(RelativePosition curPosition, RelativePosition targetPosition) {
        if (targetPosition.isHideMove()) {
            double offset = targetPosition.getOffset() + curPosition.getDY1ByOffset(false) - targetPosition.getDY1ByOffset(false);
            this.setOffset(curPosition, targetPosition, offset);
        } else if (targetPosition.getOffset() != 0.0) {
            double offset = targetPosition.getOffset();
            if (curPosition.getDesignPageIndex() != targetPosition.getDesignPageIndex()) {
                int headerHeight = this.getHeaderHeight();
                this.setOffset(curPosition, targetPosition, offset + (double)headerHeight);
            } else {
                this.setOffset(curPosition, targetPosition, offset);
            }
        }
    }

    protected int getOffsetDesignPageIndex(RelativePosition curPosition) {
        int pageIndex;
        Integer pageOffset;
        if (curPosition.getOffset() == 0.0) {
            return curPosition.getDesignPageIndex();
        }
        if (!(curPosition instanceof MulPageRelativeContext.MulPageRelativePosition)) {
            return curPosition.getDesignPageIndex();
        }
        MulPageRelativeContext mulPageRelativeContext = (MulPageRelativeContext)this;
        double tempDy1 = curPosition.getDY1ByOffset(true);
        List<Integer> pageOffsetList = mulPageRelativeContext.getPageOffsetList();
        for (pageIndex = 0; pageIndex < pageOffsetList.size() && !(tempDy1 < (double)(pageOffset = pageOffsetList.get(pageIndex)).intValue()); tempDy1 -= (double)pageOffset.intValue(), ++pageIndex) {
        }
        return pageIndex;
    }

    protected double calcNewPageStartY(RelativePosition curPosition, RelativePosition targetPosition) {
        return this.getHeaderHeight();
    }

    protected double calcRelativeY(RelativePosition curPosition, RelativePosition targetPosition) {
        if (targetPosition.isHideMove()) {
            return targetPosition.getrY1() - targetPosition.getrY2();
        }
        return curPosition.getDY1ByOffset(true) - targetPosition.getDY2ByOffset(true);
    }

    public void cacheOutPutWidget(AbstractPrintWidget widget) {
        PWPage pwPage;
        ExecuteLife.getOrCreate().doHeartBeat();
        int pageIndex = widget.getPageIndex();
        if (pageIndex < this.startPage) {
            pageIndex = this.startPage;
        }
        if ((pwPage = this.pagePools.get(pageIndex)) == null) {
            pwPage = (PWPage)this.emptyPage.copy();
            pwPage.setPageIndex(pageIndex);
            this.pagePools.put(pageIndex, pwPage);
            pwPage.setDesignPageIndex(this.getDesignPageIndex());
            if (this.pagePools.size() > this.pageLimit) {
                throw new PrintException("2", String.format(ResManager.loadKDString((String)"Pdf\u8f93\u51fa\u9875\u8d85\u51fa\u9650\u5236\uff1a%s\u9875\u3002", (String)"RelativeContext_0", (String)"bos-print-core", (Object[])new Object[0]), this.pageLimit));
            }
        }
        pwPage.addChildNoHide(widget);
    }

    public int scanYFromEveryPagePool(AbstractPrintWidget outputGrid) {
        RelativePosition curPosition = this.findPosition(outputGrid);
        RelativePosition targetPosition = this.scanAbsolutePosi(curPosition);
        return this.calYByAbsolutePosi(curPosition, targetPosition);
    }

    public Map<String, List<AbstractPrintWidget>> getWidgetPool() {
        if (this.widgetPool == null) {
            this.widgetPool = new HashMap<String, List<AbstractPrintWidget>>();
        }
        return this.widgetPool;
    }

    public void addWidget(String key, AbstractPrintWidget widget) {
        ExecuteLife.getOrCreate().doHeartBeat();
        Map<String, List<AbstractPrintWidget>> widgetPool = this.getWidgetPool();
        if (widgetPool.containsKey(key)) {
            widgetPool.get(key).add(widget);
        } else {
            ArrayList<AbstractPrintWidget> list = new ArrayList<AbstractPrintWidget>();
            list.add(widget);
            widgetPool.put(key, list);
        }
    }

    public int getHeaderHeight() {
        return this.headerHeight;
    }

    public void setHeaderHeight(int headerHeight) {
        this.headerHeight = headerHeight;
    }

    public int getFooterHeight() {
        return this.footerHeight;
    }

    public int getFooterHeight(String widgetId) {
        return this.footerHeight;
    }

    public int getCurFooterHeight() {
        return this.footerHeight;
    }

    public void setFooterHeight(int footerHeight) {
        this.footerHeight = footerHeight;
    }

    protected RelativePosition findPosition(AbstractPrintWidget widget) {
        Integer index = this.positionMap.get(widget.getId());
        if (index == null) {
            return this.createRelativePosition(widget);
        }
        return this.positions.get(index);
    }

    private boolean isXIntersect(RelativePosition target, RelativePosition cur) {
        return !(cur.getdX2() <= target.getdX1()) && !(cur.getdX1() >= target.getdX2());
    }

    private boolean isYIntersect(RelativePosition target, RelativePosition cur) {
        return !(cur.getDY1ByOffset(false) >= target.getDY2ByOffset(false)) && !(cur.getDY2ByOffset(false) <= target.getDY1ByOffset(false));
    }

    protected RelativePosition scanRelativePosi(RelativePosition curPosition) {
        RelativePosition targetPosition = null;
        for (RelativePosition temPoi : this.positions) {
            if ("Header".equals(temPoi.widgetType) || "Footer".equals(temPoi.widgetType) || StringUtils.equals((CharSequence)curPosition.getId(), (CharSequence)temPoi.getId()) || temPoi.getAtPage() == PrintAtPage.All || temPoi.getAtPage() == PrintAtPage.Last || "DataGrid_Fix".equals(temPoi.widgetType) || !this.isReferenceTarget(temPoi, curPosition)) continue;
            if (targetPosition == null) {
                targetPosition = temPoi;
                continue;
            }
            if (temPoi.getPageIndex() > targetPosition.getPageIndex()) {
                targetPosition = temPoi;
                continue;
            }
            if (temPoi.getPageIndex() != targetPosition.getPageIndex() || !(temPoi.getrY2() + temPoi.getOffset() > targetPosition.getrY2() + targetPosition.getOffset())) continue;
            targetPosition = temPoi;
        }
        return targetPosition;
    }

    protected void setOffset(RelativePosition curPosition, RelativePosition targetPosition, double offset) {
        curPosition.setOffset(offset);
    }

    protected RelativePosition scanAbsolutePosi(RelativePosition curPosition) {
        RelativePosition targetPosition = null;
        for (RelativePosition temPoi : this.positions) {
            if ("Header".equals(temPoi.widgetType) || "Footer".equals(temPoi.widgetType) || temPoi.getAtPage() != PrintAtPage.All || !this.isReferenceTarget(temPoi, curPosition)) continue;
            if (targetPosition == null) {
                targetPosition = temPoi;
                continue;
            }
            if (!(temPoi.getDY2ByOffset(false) > targetPosition.getDY2ByOffset(false))) continue;
            targetPosition = temPoi;
        }
        return targetPosition;
    }

    protected int calYByAbsolutePosi(RelativePosition curPosition, RelativePosition absolutePosi) {
        Map<String, List<AbstractPrintWidget>> widgetPool = this.getWidgetPool();
        List<AbstractPrintWidget> everyPagePrintWidgets = widgetPool.get(PrintAtPage.All.getCode());
        if (everyPagePrintWidgets == null || everyPagePrintWidgets.isEmpty()) {
            return -1;
        }
        if (absolutePosi == null) {
            return -1;
        }
        RelativePosition minPosition = null;
        for (RelativePosition temPoi : this.positions) {
            if (temPoi.getAtPage() == PrintAtPage.All || StringUtils.equals((CharSequence)temPoi.widgetType, (CharSequence)"Header") || StringUtils.equals((CharSequence)curPosition.getId(), (CharSequence)temPoi.getId()) || !(temPoi.getDY1ByOffset(true) >= absolutePosi.getDY2ByOffset(true)) || !this.isReferenceTarget(temPoi, curPosition)) continue;
            if (minPosition == null) {
                minPosition = temPoi;
                continue;
            }
            if (!(temPoi.getDY1ByOffset(true) < minPosition.getDY1ByOffset(true))) continue;
            minPosition = temPoi;
        }
        double startY = curPosition.getOriDY1();
        if (minPosition != null) {
            startY = minPosition.getOriDY1();
        }
        return (int)startY;
    }

    protected boolean isReferenceTarget(RelativePosition target, RelativePosition cur) {
        if (cur.getDY1ByOffset(false) >= target.getDY2ByOffset(false)) {
            return true;
        }
        return this.isXIntersect(target, cur) && this.isYIntersect(target, cur) && cur.getDY1ByOffset(false) > target.getDY1ByOffset(false);
    }

    protected Rectangle getWidgetReact(AbstractPrintWidget widget) {
        return widget.getRectangle();
    }

    public int getStartPage() {
        return this.startPage;
    }

    protected static class RelativePosition {
        private String id;
        protected String widgetType;
        private int pageIndex;
        private int startPageIndex;
        private int designPageIndex;
        private double dX1;
        private double dX2;
        private double dY1;
        private double dY2;
        private double rY1;
        private double rY2;
        private PrintAtPage atPage;
        private boolean hideMove;
        private double offset = 0.0;
        protected int offsetPageIndex;

        public RelativePosition(RelativePosition position) {
            this.id = position.id;
            this.widgetType = position.widgetType;
            this.pageIndex = position.pageIndex;
            this.startPageIndex = position.startPageIndex;
            this.designPageIndex = position.designPageIndex;
            this.dX1 = position.dX1;
            this.dX2 = position.dX2;
            this.dY1 = position.dY1;
            this.dY2 = position.dY2;
            this.rY1 = position.rY1;
            this.rY2 = position.rY2;
            this.atPage = position.atPage;
            this.hideMove = position.hideMove;
            this.offset = position.offset;
            this.offsetPageIndex = position.offsetPageIndex;
        }

        RelativePosition(AbstractPrintWidget widget) {
            this.id = widget.getId();
            this.widgetType = widget.getType();
            this.hideMove = widget.isHideMove();
            if (widget instanceof PWDataGrid) {
                PWDataGrid dataGrid = (PWDataGrid)widget;
                boolean isMergeSummary = false;
                for (int i = 0; i < dataGrid.getRowsCount(); ++i) {
                    if (((AbstractPWDataGridRow)dataGrid.getRow(i)).getRowType() != 2 || !StringUtils.isNotBlank((CharSequence)((PWDetailRow)dataGrid.getRow(i)).getMergeByField())) continue;
                    isMergeSummary = true;
                    break;
                }
                if (dataGrid.isFixedRowAtPage() && !isMergeSummary) {
                    this.widgetType = this.widgetType + "_Fix";
                }
            }
            this.pageIndex = widget.getPageIndex();
            Rectangle rectangle = widget.getRectangle();
            this.dX1 = rectangle.getX();
            this.dX2 = this.dX1 + rectangle.getWidth();
            this.dY1 = rectangle.getY();
            this.dY2 = this.dY1 + rectangle.getHeight();
            this.atPage = widget.getPrintAtPage();
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public int getPageIndex() {
            return this.pageIndex;
        }

        public void setPageIndex(int pageIndex) {
            this.pageIndex = pageIndex;
        }

        public int getStartPageIndex() {
            return this.startPageIndex;
        }

        public void setStartPageIndex(int startPageIndex) {
            if (this.startPageIndex == 0) {
                this.startPageIndex = startPageIndex;
            }
        }

        public int getDesignPageIndex() {
            return this.designPageIndex;
        }

        public void setDesignPageIndex(int designPageIndex) {
            this.designPageIndex = designPageIndex;
        }

        public double getdX1() {
            return this.dX1;
        }

        public void setdX1(double dX1) {
            this.dX1 = dX1;
        }

        public double getdX2() {
            return this.dX2;
        }

        public void setdX2(double dX2) {
            this.dX2 = dX2;
        }

        public double getdY1() {
            return this.dY1;
        }

        public double getDY1ByOffset(boolean withOffSet) {
            if (withOffSet) {
                return this.dY1 - this.offset;
            }
            return this.dY1;
        }

        public double getDY2ByOffset(boolean withOffSet) {
            if (withOffSet) {
                return this.dY2 - this.offset;
            }
            return this.dY2;
        }

        public void setdY1(double dY1) {
            this.dY1 = dY1;
        }

        public double getdY2() {
            return this.dY2;
        }

        public void setdY2(double dY2) {
            this.dY2 = dY2;
        }

        public double getrY1() {
            return this.rY1;
        }

        public void setrY1(double rY1) {
            this.rY1 = rY1;
        }

        public double getrY2() {
            return this.rY2;
        }

        public void setrY2(double rY2) {
            this.rY2 = rY2;
        }

        public PrintAtPage getAtPage() {
            return this.atPage;
        }

        public void setAtPage(PrintAtPage atPage) {
            this.atPage = atPage;
        }

        public double getOriDY1() {
            return this.dY1;
        }

        public double getOffset() {
            return this.offset;
        }

        public void setOffset(double offset) {
            this.offset = offset;
        }

        public boolean isHideMove() {
            return this.hideMove;
        }

        public void setHideMove(boolean hideMove) {
            this.hideMove = hideMove;
        }

        public void setOffsetPageIndex(int offsetPageIndex) {
            this.offsetPageIndex = offsetPageIndex;
        }

        public int getOffsetPageIndex() {
            return this.offsetPageIndex;
        }
    }
}

