/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.runner;

import java.awt.Font;
import java.awt.Rectangle;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ctrl.reportone.r1.print.common.R1PrintInfo;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.execute.helper.ExecuteHelper;
import kd.bos.print.core.model.widget.PWRichText;
import kd.bos.print.core.model.widget.runner.AbstractRunner;
import kd.bos.print.core.model.widget.runner.BuildRichTextBuilder;
import kd.bos.print.core.plugin.PrintPluginProxy;
import kd.bos.print.core.plugin.event.BeforeOutputWidgetEvent;

public class RichTextRunner
extends AbstractRunner<PWRichText> {
    @Override
    public void execute(IWidgetExecuteHelper helper) {
        PWRichText richText;
        String ds;
        if (!(helper instanceof ExecuteHelper)) {
            return;
        }
        PrintPluginProxy pluginProxy = ExecuteContext.get().getPluginProxy();
        if (pluginProxy != null) {
            BeforeOutputWidgetEvent evt = new BeforeOutputWidgetEvent(this.getOutputWidget());
            pluginProxy.fireBeforeOutputWidget(evt);
            if (evt.isHidden()) {
                return;
            }
        }
        if (StringUtils.isBlank((CharSequence)(ds = (richText = (PWRichText)this.getOutputWidget()).getDatasource()))) {
            return;
        }
        TextField textField = (TextField)this.getDataHelper(helper, ds).getFieldValue(ds, richText.getBindField());
        richText.setOutputValue(textField);
        PWRichText output = null;
        BuildRichTextBuilder.Result result = this.doExecuteRichText(richText, textField, helper);
        R1PrintInfo r1PrintInfo = ((ExecuteHelper)helper).getRuntimeModel().getReportModel().getR1PrintInfo();
        int richPageNum = result.getRichPageNum();
        if (richPageNum < 1) {
            return;
        }
        for (int i = 0; i < richPageNum; ++i) {
            output = (PWRichText)richText.copy();
            Rectangle rectangle = output.getRectangle();
            int pageIndex = output.getPageIndex() + i;
            output.setPageIndex(pageIndex);
            rectangle.y = i == 0 ? richText.getRectangle().y : result.getSecondStartY();
            rectangle.height = i == richPageNum - 1 ? result.getLastPageHeight() - rectangle.y : r1PrintInfo.getCustomHeight() - r1PrintInfo.getMarginTop() - r1PrintInfo.getMarginBottom() - rectangle.y - this.getFooterHeight();
            output.setPdfPageNum(i + 1);
            output.setHtmlPDFos(result.getHtmlPDFos());
            output.setFooterHeight(result.getFooterHeight());
            output.setBottom(result.getBottom());
            this.cacheOutput(output);
        }
        this.endOutput(output);
    }

    private BuildRichTextBuilder.Result doExecuteRichText(PWRichText richText, TextField textField, IWidgetExecuteHelper helper) {
        String richTextHtml = (String)textField.getValue();
        int height = richText.getMaxHeightToAdjust();
        int relativeY = this.getRelativeContext().scanYFromEveryPagePool(richText);
        int startY = this.getHeaderHeight();
        if (relativeY != -1) {
            startY = relativeY;
        }
        Font font = richText.getStyle().getFont();
        BuildRichTextBuilder.Result result = new BuildRichTextBuilder().build();
        if (helper instanceof ExecuteHelper) {
            ExecuteHelper executeHelper = (ExecuteHelper)helper;
            result = new BuildRichTextBuilder().firstPageHeight(height).richTextWitdh(richText.getRectangle().width).headerHeight(startY).footerHeight(this.getFooterHeight()).richTextFont(font).pageSize(executeHelper.getRuntimeModel().getReportModel().getR1PrintInfo()).withString(richTextHtml).build();
        }
        result.setSecondStartY(startY);
        return result;
    }
}

