/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.runner;

import java.util.HashMap;
import java.util.Map;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.PWFooter;
import kd.bos.print.core.model.widget.PWLine;
import kd.bos.print.core.model.widget.PWPage;
import kd.bos.print.core.model.widget.PWPicture;
import kd.bos.print.core.model.widget.PWRichText;
import kd.bos.print.core.model.widget.PWText;
import kd.bos.print.core.model.widget.barcode.PWBarcode;
import kd.bos.print.core.model.widget.grid.cardgrid.PWCardGrid;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGrid;
import kd.bos.print.core.model.widget.grid.layoutgrid.PWLayoutGrid;
import kd.bos.print.core.model.widget.grid.tabletail.PWTableTail;
import kd.bos.print.core.model.widget.runner.BarcodeRunner;
import kd.bos.print.core.model.widget.runner.HeaderFooterRunner;
import kd.bos.print.core.model.widget.runner.IRunner;
import kd.bos.print.core.model.widget.runner.LineRunner;
import kd.bos.print.core.model.widget.runner.PageRunner;
import kd.bos.print.core.model.widget.runner.PictureRunner;
import kd.bos.print.core.model.widget.runner.RichTextRunner;
import kd.bos.print.core.model.widget.runner.TextRunner;
import kd.bos.print.core.model.widget.runner.grid.CardGridRunner;
import kd.bos.print.core.model.widget.runner.grid.DataGridRunner;
import kd.bos.print.core.model.widget.runner.grid.LayoutGridRunner;
import kd.bos.print.core.model.widget.runner.grid.TableTailRunner;
import kd.bos.util.ThreadLocals;

public class RunnerFactory {
    private static ThreadLocal<Map<String, IRunner>> runnerPool = ThreadLocals.create();

    private static Map<String, IRunner> getRunnerMap() {
        Map<String, IRunner> context = runnerPool.get();
        if (context == null) {
            runnerPool.set(new HashMap());
        }
        return runnerPool.get();
    }

    private static IRunner createRunner(AbstractPrintWidget widget, boolean isSplicePrint) {
        if (widget instanceof PWPage) {
            return new PageRunner();
        }
        if (widget instanceof PWText) {
            return new TextRunner();
        }
        if (widget instanceof PWPicture) {
            return new PictureRunner();
        }
        if (widget instanceof PWBarcode) {
            return new BarcodeRunner();
        }
        if (widget instanceof PWFooter) {
            return new HeaderFooterRunner();
        }
        if (widget instanceof PWCardGrid) {
            return new CardGridRunner();
        }
        if (widget instanceof PWLayoutGrid) {
            return new LayoutGridRunner();
        }
        if (widget instanceof PWDataGrid) {
            return new DataGridRunner();
        }
        if (widget instanceof PWRichText) {
            return new RichTextRunner();
        }
        if (widget instanceof PWTableTail) {
            return new TableTailRunner();
        }
        if (widget instanceof PWLine) {
            return new LineRunner();
        }
        throw new RuntimeException("can not find runner " + widget.getClass().getName());
    }

    public static IRunner getRunner(AbstractPrintWidget widget) {
        IRunner runner;
        boolean isSplicePrint = ExecuteContext.get().isSplicePrint();
        String key = RunnerFactory.getRunnerKey(widget, isSplicePrint);
        Map<String, IRunner> runnerMap = RunnerFactory.getRunnerMap();
        if (!runnerMap.containsKey(key)) {
            runner = RunnerFactory.createRunner(widget, isSplicePrint);
            runnerMap.put(key, runner);
        }
        runner = runnerMap.get(key);
        runner.setWidget(widget);
        return runner;
    }

    private static String getRunnerKey(AbstractPrintWidget widget, boolean isSplicePrint) {
        String key = widget.getClass().getName();
        if (widget instanceof PWPage) {
            key = key + "_" + isSplicePrint;
        }
        return key;
    }

    public static IRunner getExistRunner(String widgetKey) {
        Map<String, IRunner> runnerMap = RunnerFactory.getRunnerMap();
        return runnerMap.get(widgetKey);
    }
}

