/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.runner.grid;

import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import kd.bos.print.core.data.PdIterator;
import kd.bos.print.core.data.R1PDataVisitor;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.NullField;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.IPrintWidgetContainer;
import kd.bos.print.core.model.widget.PWidgetUtil;
import kd.bos.print.core.model.widget.grid.AbstractPWGridCell;
import kd.bos.print.core.model.widget.grid.AbstractPWGridRow;
import kd.bos.print.core.model.widget.grid.datagrid.AbstractPWDataGridRow;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGrid;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueStat;
import kd.bos.print.core.model.widget.grid.datagrid.context.GridExecuteContext;
import kd.bos.print.core.model.widget.runner.grid.AbstractGridRunner;
import kd.bos.print.core.model.widget.runner.stat.GridStatSet;
import kd.bos.print.core.plugin.PrintPluginProxy;
import kd.bos.print.core.plugin.event.BeforeOutputRowEvent;
import kd.bos.print.core.service.ISensitiveService;

public class AbstractDataGridRunner
extends AbstractGridRunner<PWDataGrid> {
    protected GridStatSet statSet;

    @Override
    public void execute(IWidgetExecuteHelper helper) {
        super.execute(helper);
        this.statSet = new GridStatSet((PWDataGrid)this.getOutputWidget());
    }

    protected void executeDetailRow(PWDataGrid outputGrid, AbstractPWDataGridRow row, PdIterator iterator) {
        this.executeDetailRow(outputGrid, row, iterator, false);
    }

    protected void executeDetailRow(PWDataGrid outputGrid, AbstractPWDataGridRow row, PdIterator iterator, boolean executeRemainRow) {
        PrintPluginProxy pluginProxy = ExecuteContext.get().getPluginProxy();
        if (pluginProxy != null) {
            BeforeOutputRowEvent evt = new BeforeOutputRowEvent((AbstractPWGridRow)row, iterator);
            evt.setGrid(outputGrid);
            pluginProxy.fireBeforeOutputRow(evt);
            if (evt.isCancleOutput()) {
                return;
            }
        }
        String gridds = outputGrid.getDatasource();
        this.executeRow(outputGrid, row, (ds, field) -> {
            if (StringUtils.equals((CharSequence)gridds, (CharSequence)ds)) {
                Field fieldValue = iterator.getField(field.getField());
                return fieldValue;
            }
            if (!StringUtils.equals((CharSequence)gridds, (CharSequence)ds) && field == null) {
                String[] keys = ds.split("\\.");
                String valueKey = "";
                if (keys.length > 0) {
                    valueKey = keys[keys.length - 1];
                }
                return iterator.getField(valueKey);
            }
            Field fieldValue = this.helper.getDataHelper().getFieldValue(ds, field.getField());
            return fieldValue;
        });
        if (this.isOpenWholeRowPage() && outputGrid.getContext().isRowPagination()) {
            return;
        }
        outputGrid.getContext().setDetailRowHasOutput(true);
        if (!executeRemainRow) {
            ++this.detailRowNumber;
            ++this.detailGroupRowNumber;
            this.doStat(iterator);
        }
        if (row.isRemainContent()) {
            this.executeDetailRow(outputGrid, row, iterator, true);
        }
    }

    protected void executeStatRow(PWDataGrid outputGrid, AbstractPWDataGridRow row) {
        PrintPluginProxy pluginProxy = ExecuteContext.get().getPluginProxy();
        if (pluginProxy != null) {
            BeforeOutputRowEvent evt = new BeforeOutputRowEvent((AbstractPWGridRow)row, this.helper.getDataHelper());
            evt.setGrid(outputGrid);
            pluginProxy.fireBeforeOutputRow(evt);
            if (evt.isCancleOutput()) {
                return;
            }
        }
        this.executeRow(outputGrid, row, (ds, field) -> this.getStatVal(ds, (CellValueStat)field));
        if (row.isRemainContent()) {
            this.executeStatRow(outputGrid, row);
        }
    }

    protected void doStat(PdIterator iterator) {
        if (this.statSet.hasStatField()) {
            this.statSet.doStats(iterator);
        }
    }

    protected Field getStatVal(String ds, CellValueStat cellField) {
        String gridds = ((PWDataGrid)this.getOutputWidget()).getDatasource();
        if (this.groupRowCursor == -1 && cellField.getStatType() == 18) {
            return new TextField("");
        }
        if (StringUtils.equals((CharSequence)gridds, (CharSequence)ds) && cellField.getStatType() != 0) {
            Field statValue = this.statSet.getStatValue(cellField.getField() + "_" + cellField.getStatType());
            if (!(statValue instanceof NullField)) {
                ISensitiveService sensitiveService = ExecuteContext.get().getServiceProxy().getSensitiveService();
                String[] keyArrs = gridds.split("\\.");
                String formId = keyArrs[0];
                if (keyArrs.length > 1) {
                    String entryKey = keyArrs[1];
                    statValue = sensitiveService.doFieldViewPermission(formId, sensitiveService.getMainOrg(), cellField.getField(), statValue);
                    sensitiveService.deDesensitive(formId, entryKey, cellField.getField(), statValue);
                }
            }
            return statValue;
        }
        return this.helper.getDataHelper().getFieldValue(ds, cellField.getField());
    }

    protected R1PDataVisitor getDataVisitor() {
        PWDataGrid outputGrid = (PWDataGrid)this.getOutputWidget();
        String datasource = outputGrid.getDatasource();
        if (StringUtils.isBlank((CharSequence)datasource)) {
            return null;
        }
        IWidgetExecuteHelper.IDataHelper dataHelper = this.helper.getDataHelper();
        R1PDataVisitor dataVisitor = dataHelper.getDataVisitor(datasource);
        return dataVisitor;
    }

    @Override
    public void cacheOutput(AbstractPrintWidget outputWidget) {
        PWDataGrid outputGrid = (PWDataGrid)outputWidget;
        GridExecuteContext context = outputGrid.getContext();
        if (this.isOnlyTitleRow(outputGrid) && context.isDetailRowHasOutput()) {
            return;
        }
        super.cacheOutput(outputWidget);
    }

    protected boolean isOnlyTitleRow(PWDataGrid outputGrid) {
        List outputRows = outputGrid.getOutputRows();
        boolean onlyTitleRow = true;
        for (AbstractPWDataGridRow row : outputRows) {
            if (1 == row.getRowType()) continue;
            onlyTitleRow = false;
            break;
        }
        return onlyTitleRow;
    }

    @Override
    public void executeChildren(IPrintWidgetContainer cell, List<IPrintWidget> children) {
        PdIterator gridIterator;
        if (((PWDataGrid)this.getOutputWidget()).getCurrentRowType() == 2 && (gridIterator = ((PWDataGrid)this.getOutputWidget()).getContext().getGridIterator()) != null) {
            this.childrenWidgetBindField(((PWDataGrid)this.getOutputWidget()).getDatasource(), gridIterator, (AbstractPWGridCell)cell, children);
        }
        super.executeChildren(cell, children);
    }

    protected void iteratorNext(PdIterator iterator, AbstractPWGridRow row, boolean wholeRowPage) {
        if (wholeRowPage) {
            if (!row.isRemainContent() && !((PWDataGrid)this.getOutputWidget()).getContext().isRowPagination()) {
                iterator.next();
            } else {
                ((PWDataGrid)this.getOutputWidget()).setTempWholeRowPage(false);
            }
        } else if (!row.isRemainContent()) {
            iterator.next();
        }
    }

    protected void iterateDetailRow(PWDataGrid outputGrid, AbstractPWDataGridRow row, PdIterator iterator) {
        this.iterateDetailRow(outputGrid, row, iterator, true);
    }

    protected void iterateDetailRow(PWDataGrid outputGrid, AbstractPWDataGridRow row, PdIterator iterator, boolean statWithData) {
        outputGrid.setRowCursor(row.getRowIndex());
        if (statWithData && outputGrid.isStatWithData() && iterator.cursor() == iterator.rowSize() - 1) {
            outputGrid.setWholeRowPage(true);
            int height = PWidgetUtil.noPageSumStatRowsHeight(outputGrid);
            outputGrid.getContext().setMaxHeightToAdjust(outputGrid.getContext().getMaxHeightToAdjust() - height);
            boolean pagination = this.needPagination(outputGrid);
            this.executeDetailRow(outputGrid, row, iterator);
            if (!pagination) {
                outputGrid.getContext().setMaxHeightToAdjust(outputGrid.getContext().getMaxHeightToAdjust() + height);
            }
        } else {
            this.executeDetailRow(outputGrid, row, iterator);
        }
        this.iteratorNext(iterator, row, this.isOpenWholeRowPage());
    }
}

