/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.runner.grid;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ctrl.common.digitalstyle.FormatResult;
import kd.bos.print.core.ctrl.common.digitalstyle.Formats;
import kd.bos.print.core.ctrl.common.util.StringUtil;
import kd.bos.print.core.ctrl.common.variant.Variant;
import kd.bos.print.core.ctrl.kdf.util.style.Border;
import kd.bos.print.core.ctrl.kdf.util.style.LineStyle;
import kd.bos.print.core.ctrl.kdf.util.style.Rect;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.StyleAttributes;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.ctrl.reportone.r1.print.common.IR1PrintScriptable;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.DelayVarProvider;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import kd.bos.print.core.data.PdIterator;
import kd.bos.print.core.data.field.CollectionField;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.ImageField;
import kd.bos.print.core.data.field.NullField;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.exception.PrintException;
import kd.bos.print.core.execute.render.common.linewrap.param.LineWrapParam;
import kd.bos.print.core.model.designer.BarcodeObject;
import kd.bos.print.core.model.designer.grid.MergeBlock;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.AbstractPrintWidgetField;
import kd.bos.print.core.model.widget.AbstractPrintWidgetText;
import kd.bos.print.core.model.widget.IAdjustHeightSupport;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.IPrintWidgetContainer;
import kd.bos.print.core.model.widget.PWPicture;
import kd.bos.print.core.model.widget.PWText;
import kd.bos.print.core.model.widget.PWidgetUtil;
import kd.bos.print.core.model.widget.PrintAtPage;
import kd.bos.print.core.model.widget.StyleAccess;
import kd.bos.print.core.model.widget.barcode.PWBarcode;
import kd.bos.print.core.model.widget.grid.AbstractPWGrid;
import kd.bos.print.core.model.widget.grid.AbstractPWGridCell;
import kd.bos.print.core.model.widget.grid.AbstractPWGridColumn;
import kd.bos.print.core.model.widget.grid.AbstractPWGridRow;
import kd.bos.print.core.model.widget.grid.MergeType;
import kd.bos.print.core.model.widget.grid.datagrid.AbstractPWDataGridRow;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGrid;
import kd.bos.print.core.model.widget.grid.datagrid.PWDetailRow;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.ACellValue;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueField;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueStat;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueText;
import kd.bos.print.core.model.widget.grid.datagrid.context.GridExecuteContext;
import kd.bos.print.core.model.widget.grid.tabletail.ITableTailSupport;
import kd.bos.print.core.model.widget.grid.tabletail.PWTableTail;
import kd.bos.print.core.model.widget.runner.AbstractRunner;
import kd.bos.print.core.model.widget.runner.IRunner;
import kd.bos.print.core.model.widget.runner.IWholeRowPaginationSupport;
import kd.bos.print.core.model.widget.runner.RelativeContext;
import kd.bos.print.core.model.widget.runner.TextRunner;
import kd.bos.print.core.model.widget.runner.grid.CardGridRunner;
import kd.bos.print.core.model.widget.runner.grid.DataGridRunner;
import kd.bos.print.core.model.widget.runner.grid.subGrid.HSubGridRunner;
import kd.bos.print.core.model.widget.runner.grid.subGrid.VSubGridRunner;
import kd.bos.print.core.model.widget.runner.support.DefaultWholeRowPageRunner;
import kd.bos.print.core.model.widget.runner.support.IWholeRowPageRunner;
import kd.bos.print.core.model.widget.runner.support.NotSupportWholeRowPageRunner;
import kd.bos.print.core.model.widget.runner.util.AdjustHeightUtil;
import kd.bos.print.core.model.widget.runner.util.MergeUtils;
import kd.bos.print.core.model.widget.runner.util.SubGridUtils;
import kd.bos.print.core.plugin.PrintPluginProxy;
import kd.bos.print.core.plugin.event.AfterOutputGridEvent;
import kd.bos.print.core.plugin.event.AfterOutputRowEvent;
import kd.bos.print.core.plugin.event.BeforeOutputGridEvent;
import kd.bos.print.core.plugin.event.BeforeOutputRowEvent;
import kd.bos.print.core.service.IFormulaService;

public abstract class AbstractGridRunner<T extends AbstractPWGrid>
extends AbstractRunner<T>
implements IWholeRowPaginationSupport {
    private static int titleRowOut;
    private static final int MAX_TITLE_ROW_OUT = 50;
    protected static final int MIN_ROW_HEIGHT;
    protected int detailRowNumber = 1;
    protected int detailGroupRowNumber = 1;
    protected int groupRowCursor = -1;
    private IWholeRowPageRunner wholeRowPageRunner;

    @Override
    public void execute(IWidgetExecuteHelper helper) {
        this.wholeRowPageRunner = this.createWholeRowPageRunner();
        this.helper = helper;
        PrintPluginProxy pluginProxy = ExecuteContext.get().getPluginProxy();
        if (pluginProxy != null) {
            BeforeOutputGridEvent evt = new BeforeOutputGridEvent((AbstractPWGrid)this.getOutputWidget());
            pluginProxy.fireBeforeOutputWidget(evt);
        }
    }

    protected void executeTitleRow(T outputGrid, AbstractPWGridRow row) {
        PrintPluginProxy pluginProxy = ExecuteContext.get().getPluginProxy();
        if (pluginProxy != null) {
            BeforeOutputRowEvent evt = new BeforeOutputRowEvent(row, this.helper.getDataHelper());
            evt.setGrid((AbstractPWGrid)outputGrid);
            pluginProxy.fireBeforeOutputRow(evt);
            if (evt.isCancleOutput()) {
                return;
            }
        }
        this.executeRow(outputGrid, row, this.getTitleRowGridDataVisitor());
        if (row.isRemainContent()) {
            this.executeTitleRow(outputGrid, row);
        }
    }

    protected GridDataVisitor getTitleRowGridDataVisitor() {
        return (ds, field) -> {
            if (field == null) {
                return NullField.get();
            }
            Field fieldValue = this.helper.getDataHelper().getFieldValue(ds, field.getField());
            return fieldValue;
        };
    }

    protected void beforeExecuteRow(T outputGrid) {
        if (!this.needPagination((AbstractPWGrid)outputGrid) && !this.needWholePagination(outputGrid)) {
            return;
        }
        this.executePagination(outputGrid);
    }

    protected void executeRow(T outputGrid, AbstractPWGridRow row, GridDataVisitor visitor) {
        this.beforeExecuteRow(outputGrid);
        this.resetRowPaginationFlag(outputGrid, row);
        if (!this.isAdjuestHeightRow(row)) {
            row.setAdjustHeight(false);
        }
        int columnCursor = 0;
        int columnCount = ((AbstractPWGrid)((Object)outputGrid)).getColumnCount();
        int maxHeightToAdjust = ((AbstractPWGrid)((Object)outputGrid)).getContext().getMaxHeightToAdjust();
        AbstractPWGridRow outputRow = (AbstractPWGridRow)row.copy();
        outputRow.setMaxHeightToAdjust(maxHeightToAdjust);
        boolean remainContent = row.isRemainContent();
        if (remainContent) {
            int remainHeight = row.getReaminHeight();
            if (row.getHeight() < MIN_ROW_HEIGHT && remainHeight < row.getHeight()) {
                remainHeight = row.getHeight();
            }
            if (remainHeight < MIN_ROW_HEIGHT && row.getHeight() > MIN_ROW_HEIGHT) {
                remainHeight = MIN_ROW_HEIGHT;
            }
            if (remainHeight != 0) {
                outputRow.setHeight(remainHeight);
            }
            row.setRemainContent(false);
            row.setReaminHeight(0);
        }
        int realHeight = this.designRowHeightAdjust(row, outputRow.getHeight(), maxHeightToAdjust);
        int newPageAdjustHeight = 0;
        if (((AbstractPWGrid)((Object)outputGrid)).isWholeRowPage()) {
            newPageAdjustHeight = this.getNewPageAdjustHeight(outputGrid);
        }
        int realMaxRowHeight = 0;
        boolean isBlankRow = true;
        while (columnCursor < columnCount) {
            MergeBlock mergeBlock;
            Object column = ((AbstractPWGrid)((Object)outputGrid)).getColumn(columnCursor);
            int columnWidth = ((AbstractPWGridColumn)column).getWidth();
            Object cell = row.getCell(columnCursor);
            AbstractPWGridCell outputCell = (AbstractPWGridCell)((AbstractPWGridCell)cell).copy();
            if (remainContent) {
                outputCell.getChildren().clear();
            }
            String outputText = "";
            String dataSource = outputCell.getDatasource();
            List<IPrintWidget> children = outputCell.getChildren();
            if (children != null && children.size() > 0 && !this.isExecuteBlankRow()) {
                outputCell.setRectangle(new Rectangle(columnWidth, realHeight));
                outputCell.setAdjustHeight(outputRow.isAdjustHeight());
                outputCell.setMaxHeightToAdjust(maxHeightToAdjust);
                this.executeChildren(outputCell, children);
                if (this.isOpenWholeRowPage() && ((AbstractPWGrid)((Object)outputGrid)).getContext().isRowPagination()) {
                    return;
                }
                realHeight = outputCell.getRectangle().height;
            } else {
                Dimension mergeInfo;
                int width;
                ACellValue cellValue = outputCell.getCellValue();
                if (remainContent) {
                    int remainHeight = row.getReaminHeight();
                    outputText = ((AbstractPrintWidgetText)cell).getOutputText();
                    if (remainHeight != 0) {
                        outputRow.setHeight(remainHeight);
                    }
                } else if (StringUtils.isBlank((CharSequence)dataSource)) {
                    if (this.isExecuteBlankRow()) {
                        outputText = "";
                    } else if (cellValue instanceof CellValueText) {
                        outputText = ((CellValueText)cellValue).getValue();
                        Field outputValue = null;
                        List<Object> formulaData = outputCell.getFormulaData();
                        TextRunner runner = (TextRunner)outputCell.getRunner();
                        outputValue = formulaData != null && !formulaData.isEmpty() ? (row instanceof PWDetailRow || this instanceof CardGridRunner ? new TextField(this.getFormulaValue(formulaData, outputGrid, outputCell, this.helper, visitor)) : new TextField(runner.getFormulaValue(formulaData, outputGrid, this.helper))) : new TextField(outputText);
                        if (outputValue != null) {
                            outputCell.setOriOutPutText(outputValue.toString());
                            outputValue = runner.formatOutputValue(outputValue);
                            outputText = outputValue.toString();
                        }
                    }
                } else if (StringUtil.equals(dataSource, "$DsKey=[System]")) {
                    if (outputGrid.getPrintAtPage() != PrintAtPage.All) {
                        if (StringUtil.equals(outputCell.getBindField(), "=getRowNumber()")) {
                            if (outputRow instanceof PWDetailRow) {
                                TextField outputValue = new TextField(String.valueOf(this.detailRowNumber));
                                outputText = outputValue.toString();
                            } else {
                                outputText = "1";
                            }
                        } else if ("=getGroupRowNumber()".equals(outputCell.getBindField())) {
                            if (outputRow instanceof PWDetailRow) {
                                TextField outputValue = new TextField(String.valueOf(this.detailGroupRowNumber));
                                outputText = outputValue.toString();
                            } else {
                                outputText = "1";
                            }
                        } else {
                            String format;
                            outputCell.setPageIndex(outputGrid.getPageIndex());
                            Object formulaResult = this.runFormula(this.helper, outputCell, outputCell.getBindField());
                            TextField outputValue = new TextField(formulaResult == null ? "" : formulaResult.toString());
                            outputText = outputValue.toString();
                            if (("Date".equals(outputCell.getTextFormat()) || "Time".equals(outputCell.getTextFormat())) && !StringUtil.equals(this.getFormat(outputCell.getFormat(), outputValue), "-") && !StringUtil.equals(format = this.getFormat(outputCell.getFormat(), outputValue), "-")) {
                                FormatResult result = Formats.getFormat(format).format(new Variant(outputValue.getValue()));
                                outputValue = new TextField(result.toString());
                                outputText = outputValue.toString();
                            }
                        }
                        outputCell.setOriOutPutText(outputText);
                    }
                } else if (cellValue instanceof CellValueStat) {
                    CellValueStat statField = (CellValueStat)cellValue;
                    Field outputValue = visitor.getFieldVal(dataSource, statField);
                    if (outputValue instanceof ImageField) {
                        boolean hasImage = this.showImageField(outputCell, (ImageField)outputValue, realHeight, columnWidth);
                        if (hasImage) {
                            isBlankRow = false;
                        }
                        outputText = "";
                    } else {
                        TextRunner runner = (TextRunner)outputCell.getRunner();
                        outputValue = runner.formatOutputValue(outputValue);
                        outputText = outputValue.toString();
                    }
                } else if (cellValue instanceof CellValueField) {
                    CellValueField cellField = (CellValueField)cellValue;
                    Field outputValue = visitor.getFieldVal(dataSource, cellField);
                    if (outputValue instanceof ImageField) {
                        boolean hasImage = this.showImageField(outputCell, (ImageField)outputValue, realHeight, columnWidth);
                        if (hasImage) {
                            isBlankRow = false;
                        }
                        outputText = "";
                    } else if (outputValue != null) {
                        outputCell.setOriOutPutText(outputValue.toString());
                        TextRunner runner = (TextRunner)outputCell.getRunner();
                        outputValue = runner.formatOutputValue(outputValue);
                        outputText = outputValue.toString();
                    } else {
                        outputText = "";
                    }
                }
                if (outputCell.isAnchor()) {
                    outputCell.setLinkUrl(((TextRunner)outputCell.getRunner()).queryAnchorLink(visitor));
                }
                if (row.isRemainContent()) {
                    width = columnWidth;
                    int height = realHeight;
                    if (((AbstractPWGridCell)cell).getMergeType() == MergeType.Merged) {
                        MergeBlock mergeBlock2 = ((AbstractPWGridCell)cell).getMergeBlock();
                        mergeInfo = this.getMergeInfo(mergeBlock2, (AbstractPWGrid)((Object)outputGrid));
                        width = mergeInfo.width;
                        if (mergeInfo.height > height) {
                            height = mergeInfo.height;
                        }
                    }
                    if (!DelayVarProvider.isBindDelayVar(outputCell)) {
                        AdjustHeightUtil.AdjustInfo adjustInfo = AdjustHeightUtil.getInstance().adjustHeight(new LineWrapParam.Builder(outputText, ((PWText)cell).getLineWrapRule()).style(StyleAccess.getStyle(outputCell)).wordFlex(outputCell.isWordFlex()).minW(width).maxW(this.getRelativeContext().getEmptyPage().getRectangle().width).minH(height).maxH(maxHeightToAdjust).offsetY(0).build());
                        outputText = adjustInfo.getUsedText();
                        outputCell.setFlexOffset(adjustInfo.getFlexOffset());
                        outputCell.setTextHeight(adjustInfo.getTextHeight());
                        ((AbstractPrintWidgetText)cell).setOutputText(adjustInfo.getRemainText());
                        if (adjustInfo.getUsedHeight() > realHeight) {
                            realHeight = adjustInfo.getUsedHeight();
                        }
                    }
                    outputCell.setAdjustHeight(true);
                    if (this.isRowDesignPagination(row, maxHeightToAdjust)) {
                        ((AbstractPWGrid)((Object)outputGrid)).getContext().setMaxHeightToAdjust(0);
                        ((AbstractPWGrid)((Object)outputGrid)).getContext().setRowPagination(true);
                        ((AbstractPWGrid)((Object)outputGrid)).getContext().setRowType(row.getRowType());
                        row.setRemainContent(false);
                        this.beforeExecuteRow(outputGrid);
                        return;
                    }
                } else if (this.isAdjuestHeightRow(outputRow) && ((AbstractPrintWidgetText)cell).getDivideCharNums() <= 0) {
                    width = columnWidth;
                    int height = realHeight;
                    if (((AbstractPWGridCell)cell).getMergeType() == MergeType.Merged) {
                        MergeBlock mergeBlock3 = ((AbstractPWGridCell)cell).getMergeBlock();
                        mergeInfo = this.getMergeInfo(mergeBlock3, (AbstractPWGrid)((Object)outputGrid));
                        width = mergeInfo.width;
                        if (mergeInfo.height > height) {
                            height = mergeInfo.height;
                        }
                    }
                    LineWrapParam param = new LineWrapParam.Builder(outputText, ((PWText)cell).getLineWrapRule()).style(StyleAccess.getStyle(outputCell)).wordFlex(outputCell.isWordFlex()).minW(width).maxW(this.getRelativeContext().getEmptyPage().getRectangle().width).minH(remainContent ? row.getHeight() : height).maxH(maxHeightToAdjust).build();
                    AdjustHeightUtil.AdjustInfo adjustInfo = AdjustHeightUtil.getInstance().adjustHeight(param);
                    int usedHeight = adjustInfo.getUsedHeight();
                    if (this.isRowRuntimePagination(adjustInfo, newPageAdjustHeight, row)) {
                        ((AbstractPWGrid)((Object)outputGrid)).getContext().setMaxHeightToAdjust(0);
                        ((AbstractPWGrid)((Object)outputGrid)).getContext().setRowPagination(true);
                        ((AbstractPWGrid)((Object)outputGrid)).getContext().setRowType(row.getRowType());
                        this.beforeExecuteRow(outputGrid);
                        return;
                    }
                    if (usedHeight > height) {
                        int addHeight = usedHeight - height;
                        realHeight = ((AbstractPWGridCell)cell).getMergeType() == MergeType.Merged && realHeight < row.getHeight() ? row.getHeight() + addHeight : (realHeight += addHeight);
                    }
                    outputCell.setAdjustHeight(true);
                    outputCell.setFlexOffset(adjustInfo.getFlexOffset());
                    outputCell.setTextHeight(adjustInfo.getTextHeight());
                    ((AbstractPrintWidgetText)cell).setAdjustHeight(true);
                    if (this.rowOverPage()) {
                        String remainText = adjustInfo.getRemainText();
                        if (DelayVarProvider.isBindDelayVar(outputCell)) {
                            remainText = null;
                        } else {
                            outputText = adjustInfo.getUsedText();
                        }
                        ((AbstractPrintWidgetText)cell).setOutputText(remainText);
                        if (!row.isRemainContent() && remainText != null && outputGrid.getPrintAtPage() != PrintAtPage.All) {
                            realHeight = usedHeight;
                            row.setRemainContent(true);
                        }
                    } else if (!DelayVarProvider.isBindDelayVar(outputCell)) {
                        outputText = adjustInfo.getUsedText();
                    }
                } else {
                    ((AbstractPrintWidgetText)cell).setOutputText("");
                    ((PWText)cell).setRemainContent(false);
                }
            }
            outputCell.setRectangle(new Rectangle(columnWidth, realHeight));
            outputCell.setOutputText(outputText);
            outputRow.addCell(outputCell);
            if (realHeight > realMaxRowHeight) {
                realMaxRowHeight = realHeight;
            }
            if (StringUtils.isNotBlank((CharSequence)outputText) || !this.childIsEmpty(outputCell) || !remainContent && (mergeBlock = ((AbstractPWGridCell)cell).getMergeBlock()) != null && mergeBlock.isVerticalMerge()) {
                isBlankRow = false;
            }
            ++columnCursor;
        }
        GridExecuteContext context = ((AbstractPWGrid)this.getOutputWidget()).getContext();
        if (isBlankRow && (((AbstractPWGrid)((Object)outputGrid)).isNotBlankRow() || remainContent) && (!this.isHaveSubGrid((AbstractPWGrid)((Object)outputGrid)) || row.getRowType() == 3 || row.getRowType() == 1)) {
            if (remainContent) {
                context.setRemainBlank(true);
                row.setRemainContent(false);
            }
            if (row.isRemainContent() && realHeight >= maxHeightToAdjust) {
                ((AbstractPWGrid)((Object)outputGrid)).getContext().setMaxHeightToAdjust(0);
            }
            return;
        }
        context.setRemainBlank(false);
        if (isBlankRow && (((AbstractPWGrid)((Object)outputGrid)).isNotBlankRow() || remainContent)) {
            outputRow.setBlankRow(true);
        }
        if (outputRow.isAdjustHeight() || row.isRemainContent()) {
            int cellCount = outputRow.getCellCount();
            int cellIndex = 0;
            while (cellIndex < cellCount) {
                Object cell = outputRow.getCell(cellIndex);
                if (cell == null) {
                    ++cellIndex;
                    continue;
                }
                ((AbstractPWGridCell)cell).adjustHeight(realMaxRowHeight);
                ++cellIndex;
            }
        }
        outputRow.setHeight(realMaxRowHeight);
        PrintPluginProxy pluginProxy = ExecuteContext.get().getPluginProxy();
        if (pluginProxy != null) {
            AfterOutputRowEvent evt = new AfterOutputRowEvent(outputRow);
            evt.setGrid((AbstractPWGrid)((Object)outputGrid));
            pluginProxy.fireAfterOutputRow(evt);
            if (evt.isCancleOutput()) {
                return;
            }
        }
        ((AbstractPWGrid)((Object)outputGrid)).outputRow((AbstractPWGridRow)outputRow);
        ((AbstractPWGrid)((Object)outputGrid)).getContext().setMaxHeightToAdjust(maxHeightToAdjust -= outputRow.getHeight());
        this.executeCalSubGrid(outputGrid, row, visitor, outputRow, maxHeightToAdjust, remainContent);
    }

    private int getNewPageAdjustHeight(T outputGrid) {
        int relativeY = this.getRelativeContext().scanYFromEveryPagePool((AbstractPrintWidget)outputGrid);
        int startY = this.getHeaderHeight();
        if (relativeY != -1) {
            startY = relativeY;
        }
        int newPageAdjustHeight = (this.getRelativeContext().getEmptyPage().getRectangle().height - this.getRelativeContext().getHeaderHeight() - this.getRelativeContext().getFooterHeight() - startY) / 2;
        return newPageAdjustHeight;
    }

    private boolean childIsEmpty(AbstractPWGridCell outputCell) {
        if (!outputCell.hasChildren()) {
            return true;
        }
        IPrintWidget iPrintWidget = outputCell.getChildren().get(0);
        if (iPrintWidget instanceof PWText) {
            PWText pwText = (PWText)iPrintWidget;
            String outputText = pwText.getOutputText();
            return !StringUtils.isNotBlank((CharSequence)outputText);
        }
        if (iPrintWidget instanceof IR1PrintScriptable) {
            Map map;
            Object barcode;
            IR1PrintScriptable pwPicture = (IR1PrintScriptable)((Object)iPrintWidget);
            Field outputValue = pwPicture.getOutputValue();
            if (outputValue == null || outputValue.getValue() == null) {
                return true;
            }
            Object value = outputValue.getValue();
            if (StringUtils.isBlank(value)) {
                return true;
            }
            if (value instanceof Map && StringUtils.isBlank(barcode = (map = (Map)value).get("barcode"))) {
                return true;
            }
        }
        return false;
    }

    protected boolean isExecuteBlankRow() {
        return false;
    }

    protected int designRowHeightAdjust(AbstractPWGridRow row, int rowHeight, int maxHeightToAdjust) {
        if (rowHeight > maxHeightToAdjust) {
            row.setReaminHeight(rowHeight - maxHeightToAdjust);
            row.setRemainContent(true);
            return maxHeightToAdjust;
        }
        return rowHeight;
    }

    protected final void resetRowPaginationFlag(T outputGrid, AbstractPWGridRow row) {
        if (this.isOpenWholeRowPage() && row.getRowType() == ((AbstractPWGrid)outputGrid).getContext().getRowType()) {
            ((AbstractPWGrid)outputGrid).getContext().setRowPagination(false);
        }
    }

    protected boolean isAdjuestHeightRow(AbstractPWGridRow outputRow) {
        return outputRow.isAdjustHeight() && outputRow.getRowType() != 3;
    }

    protected boolean rowOverPage() {
        return true;
    }

    @Override
    public void executeChildren(IPrintWidgetContainer cell, List<IPrintWidget> children) {
        AbstractPWGridCell outputCell = (AbstractPWGridCell)cell;
        Rectangle rectangle = outputCell.getRectangle();
        int containerHeight = rectangle.height;
        int containerWidth = rectangle.width;
        int maxHeight = 0;
        for (IPrintWidget child : children) {
            AbstractPWGridRow row;
            child.setPageIndex(((AbstractPWGrid)this.getOutputWidget()).getPageIndex());
            if (outputCell.getMergeType() == MergeType.Merged) {
                MergeBlock mergeBlock = outputCell.getMergeBlock();
                Dimension mergeInfo = this.getMergeInfo(mergeBlock);
                containerWidth = mergeInfo.width;
                containerHeight = mergeInfo.height;
            }
            Rectangle curReact = child.getRectangle();
            int realWidth = curReact.width;
            int realHeight = curReact.height;
            if ((double)(containerHeight - curReact.y) < curReact.getHeight()) {
                realHeight = containerHeight - curReact.y;
            }
            if (containerWidth - curReact.x - curReact.width < 0) {
                realWidth = containerWidth - curReact.x;
            }
            int maxHeightToAdjuest = outputCell.isAdjustHeight() ? outputCell.getMaxHeightToAdjust() : containerHeight;
            child.setMaxHeightToAdjust(maxHeightToAdjuest -= curReact.y);
            if (child instanceof AbstractPrintWidget) {
                ((AbstractPrintWidget)child).setPrintAtPage(PrintAtPage.InContainer);
            }
            curReact.setSize(realWidth, realHeight);
            child.getRectangle().setRect(curReact);
            IRunner runner = child.getRunner();
            runner.setRelativeContext(this.getRelativeContext());
            runner.execute(this.helper);
            if (child instanceof IAdjustHeightSupport && (row = ((AbstractPWGrid)this.getOutputWidget()).getCurrentRow()) != null && this.isRowChildWidgetPagination((IAdjustHeightSupport)((Object)child), row)) {
                ((AbstractPWGrid)this.getOutputWidget()).getContext().setMaxHeightToAdjust(0);
                ((AbstractPWGrid)this.getOutputWidget()).getContext().setRowPagination(true);
                ((AbstractPWGrid)this.getOutputWidget()).getContext().setRowType(((AbstractPWGrid)this.getOutputWidget()).getCurrentRowType());
                this.beforeExecuteRow((AbstractPWGrid)this.getOutputWidget());
                return;
            }
            int height = curReact.height;
            int rY = curReact.y + height;
            if (maxHeight >= rY) continue;
            maxHeight = rY;
        }
        if (maxHeight > containerHeight) {
            rectangle.setSize(containerWidth, maxHeight);
            outputCell.setRectangle(rectangle);
        }
    }

    protected void executePagination(T outputGrid) {
        int relativeY = this.getRelativeContext().scanYFromEveryPagePool((AbstractPrintWidget)outputGrid);
        int startY = this.getHeaderHeight();
        if (relativeY != -1) {
            startY = relativeY;
        }
        int gridHeight = 0;
        boolean wholeGridPage = ((AbstractPWGrid)outputGrid).isWholeGridPage();
        if (wholeGridPage && startY < ((AbstractPrintWidget)outputGrid).getRectangle().y) {
            ((AbstractPWGrid)outputGrid).setWholeGridPage(false);
            ((AbstractPWGrid)outputGrid).setSkipTitleEvery(true);
            gridHeight = ((AbstractPWGrid)outputGrid).getOutputRows().stream().mapToInt(m -> ((AbstractPWGridRow)m).getHeight()).sum();
        } else {
            this.cacheOutputPagination((AbstractPrintWidget)outputGrid);
        }
        if (startY >= ((AbstractPrintWidget)outputGrid).getRectangle().y) {
            ((AbstractPWGrid)outputGrid).setWholeGridPage(false);
            wholeGridPage = false;
        }
        ((AbstractPrintWidget)outputGrid).setPageIndex(((AbstractPrintWidget)outputGrid).getPageIndex() + 1);
        Rectangle rectangle = ((AbstractPrintWidget)outputGrid).getRectangle();
        rectangle.setRect(rectangle.getX(), startY, rectangle.getWidth(), rectangle.getHeight());
        double needReserveHeight = this.getNeedReserveHeight();
        ((AbstractPWGrid)outputGrid).getContext().setMaxHeightToAdjust((int)((double)(this.getRelativeContext().getEmptyPage().getRectangle().height - this.getFooterHeight() - startY) - needReserveHeight - (double)gridHeight));
        if (outputGrid instanceof ITableTailSupport) {
            ((ITableTailSupport)outputGrid).calMaxHeightToAdjust(((AbstractPWGrid)outputGrid).getContext());
        }
        if (wholeGridPage) {
            this.beforeExecuteRow(outputGrid);
        }
    }

    protected double getNeedReserveHeight() {
        return 0.0;
    }

    protected boolean needWholePagination(T outputGrid) {
        int maxAdjustHeight = ((AbstractPWGrid)outputGrid).getContext().getMaxHeightToAdjust();
        int rowCursor = ((AbstractPWGrid)outputGrid).getRowCursor();
        Object row = ((AbstractPWGrid)outputGrid).getRow(rowCursor);
        if (this.isRowDesignPagination((AbstractPWGridRow)row, maxAdjustHeight)) {
            ((AbstractPWGrid)outputGrid).getContext().setRowPagination(true);
            ((AbstractPWGrid)outputGrid).getContext().setRowType(((AbstractPWGridRow)row).getRowType());
            return true;
        }
        return false;
    }

    protected boolean needPagination(AbstractPWGrid outputGrid) {
        int rowsCount;
        int maxAdjustHeight = outputGrid.getContext().getMaxHeightToAdjust();
        int rowCursor = outputGrid.getRowCursor();
        if (rowCursor >= (rowsCount = outputGrid.getRowsCount()) || outputGrid.getPrintAtPage() == PrintAtPage.InContainer) {
            return false;
        }
        Object row = outputGrid.getRow(rowCursor);
        int rowHeight = ((AbstractPWGridRow)row).getHeight();
        if (rowHeight >= MIN_ROW_HEIGHT && maxAdjustHeight < MIN_ROW_HEIGHT) {
            return true;
        }
        if (rowHeight <= MIN_ROW_HEIGHT && maxAdjustHeight < rowHeight) {
            return true;
        }
        return ((AbstractPWGridRow)row).isRemainContent();
    }

    @Override
    protected void beforeCacheOutput(AbstractPrintWidget outputWidget) {
        PrintPluginProxy pluginProxy = ExecuteContext.get().getPluginProxy();
        if (pluginProxy != null) {
            AfterOutputGridEvent evt = new AfterOutputGridEvent((AbstractPWGrid)outputWidget);
            pluginProxy.fireAfterOutputWidget(evt);
        }
    }

    @Override
    public void cacheOutput(AbstractPrintWidget outputWidget) {
        AbstractPWGrid grid = (AbstractPWGrid)outputWidget;
        grid.columnsOutput();
        if (grid.isCanvasWidget() && (grid.getOutputRows().size() > 0 || grid.isNotBlankRow())) {
            AbstractPWGrid copy = (AbstractPWGrid)grid.copy();
            List outputRows = grid.getOutputRows();
            for (AbstractPWGridRow row : outputRows) {
                copy.outputRow(row);
            }
            if (grid instanceof PWDataGrid) {
                ((PWDataGrid)copy).setSubDataGrids(((PWDataGrid)grid).getSubDataGrids());
            }
            this.handGridBorder(grid, copy);
            this.handMerge(copy);
            super.cacheOutput(copy);
            this.recordPosition(grid);
            grid.getOutputRows().clear();
        }
        this.processTableTail(grid);
    }

    protected void processTableTail(AbstractPWGrid grid) {
        if (!(grid instanceof ITableTailSupport)) {
            return;
        }
        ITableTailSupport support = (ITableTailSupport)((Object)grid);
        if (support.isTableTailFlowAll()) {
            this.executeTableTail(support.getTableTail().copy());
        }
    }

    protected void cacheOutputPagination(AbstractPrintWidget outputWidget) {
        this.cacheOutput(outputWidget);
    }

    protected void executeTableTail(PWTableTail tableTail) {
        IRunner runner = tableTail.getRunner();
        runner.setRelativeContext(this.getRelativeContext());
        tableTail.setCanvasWidget(Boolean.TRUE);
        runner.beginOutput(tableTail);
        runner.execute(this.helper);
    }

    protected void handMerge(AbstractPWGrid outputGrid) {
        PWDataGrid subGrid;
        List outputRows = outputGrid.getOutputRows();
        int columnCount = outputGrid.getColumnCount();
        boolean haveSubGrid = this.isHaveSubGrid(outputGrid);
        if (haveSubGrid && "right".equals((subGrid = this.getSubGrid((PWDataGrid)outputGrid)).getSubGridDirection())) {
            columnCount += subGrid.getColumnCount();
        }
        AbstractPWGrid curDesignGrid = outputGrid;
        for (int i = 0; i < outputRows.size(); ++i) {
            int curColumnCount;
            AbstractPWGridRow row = (AbstractPWGridRow)outputRows.get(i);
            if (row.isSubRow() && haveSubGrid) {
                curDesignGrid = this.getSubGrid((PWDataGrid)outputGrid);
                curColumnCount = curDesignGrid.getColumnCount();
            } else {
                curColumnCount = columnCount;
            }
            for (int j = 0; j < curColumnCount; ++j) {
                MergeBlock block;
                Object cell = row.getCell(j);
                if (cell == null) continue;
                if (((AbstractPWGridCell)cell).isSubCell() && haveSubGrid) {
                    curDesignGrid = this.getSubGrid((PWDataGrid)outputGrid);
                }
                if (i == 0 && MergeUtils.canChangeMergeType(cell, j)) {
                    ((AbstractPWGridCell)cell).setMergeType(MergeType.Merged);
                }
                if (((AbstractPWGridCell)cell).getMergeType() == MergeType.Merged) {
                    block = ((AbstractPWGridCell)cell).getMergeBlock();
                    Rectangle rectangle = ((AbstractPrintWidget)cell).getRectangle();
                    int columnStart = block.getLeft();
                    int colunmEnd = block.getRight();
                    int rowStart = block.getTop();
                    int rowEnd = block.getBottom();
                    int step = 1;
                    int rowHeight = rectangle.height;
                    for (int rowIndex = rowStart; rowIndex < rowEnd && i + step < outputRows.size(); ++rowIndex) {
                        AbstractPWGridRow nextRow = (AbstractPWGridRow)outputRows.get(i + step);
                        if (((AbstractPWGridCell)cell).isSubCell()) {
                            Object nextCell = nextRow.getCell(j);
                            if (nextCell != null && MergeType.BeMerged == ((AbstractPWGridCell)nextCell).getMergeType()) {
                                rowHeight += ((AbstractPrintWidget)nextCell).getRectangle().height;
                            }
                        } else {
                            rowHeight += MergeUtils.getMergeAddHeight(curDesignGrid, nextRow, block);
                        }
                        ++step;
                    }
                    step = 1;
                    int columnWidth = rectangle.width;
                    for (int colIndex = columnStart; colIndex < colunmEnd && j + step < curColumnCount; ++colIndex) {
                        columnWidth += ((AbstractPrintWidget)row.getCell((int)(j + step))).getRectangle().width;
                        ++step;
                    }
                    ((AbstractPrintWidget)cell).setRectangle(new Rectangle(rectangle.x, rectangle.y, columnWidth, rowHeight));
                    if (rowEnd <= rowStart || i + rowEnd - rowStart < outputRows.size() - 1) continue;
                    MergeUtils.adjustMergeCellStyle((AbstractPWGrid)this.getOutputWidget(), cell);
                    continue;
                }
                if (((AbstractPWGridCell)cell).getMergeType() != MergeType.BeMerged) continue;
                if (row.isSubRow() && outputGrid instanceof PWDataGrid && i == 0 && ((AbstractPWGridCell)cell).getMergeBlock().getBottom() > 0) {
                    ((AbstractPrintWidgetText)cell).setOutputText("");
                    block = ((AbstractPWGridCell)cell).getMergeBlock();
                    if (block.getBottom() == block.getTop()) {
                        if (j <= block.getLeft() || j > block.getRight()) continue;
                        row.setCell(j, null);
                        continue;
                    }
                    if (block.getBottom() - block.getTop() <= 0) continue;
                }
                if (row.isSubRow() && outputGrid instanceof PWDataGrid && i == outputRows.size() - 1 && ((AbstractPWGridCell)cell).getMergeBlock().getBottom() > 0) {
                    Style style = ((AbstractPrintWidget)cell).getStyle();
                    StyleAttributes sa = style.getNewAttribute();
                    sa.setBorderLineStyle(Styles.Position.TOP, LineStyle.NULL_LINE);
                    if (j == 0) {
                        sa.setBorderLineStyle(Styles.Position.LEFT, LineStyle.NULL_LINE);
                    } else if (j == curColumnCount - 1) {
                        sa.setBorderLineStyle(Styles.Position.RIGHT, LineStyle.NULL_LINE);
                    }
                    ((AbstractPrintWidget)cell).setStyle(Styles.getStyle(sa));
                    ((AbstractPrintWidgetText)cell).setOutputText("");
                    MergeBlock block2 = ((AbstractPWGridCell)cell).getMergeBlock();
                    if (block2.getBottom() != block2.getTop() || j <= block2.getLeft() || j > block2.getRight()) continue;
                    row.setCell(j, null);
                    continue;
                }
                row.setCell(j, null);
            }
        }
    }

    private PWDataGrid getSubGrid(PWDataGrid outputGrid) {
        return outputGrid.getSubDataGrids().get(0);
    }

    protected Dimension getMergeInfo(MergeBlock block) {
        return this.getMergeInfo(block, (AbstractPWGrid)this.getOutputWidget());
    }

    private Dimension getMergeInfo(MergeBlock block, AbstractPWGrid grid) {
        int columnStart = block.getLeft();
        int colunmEnd = block.getRight();
        int rowStart = block.getTop();
        int rowEnd = block.getBottom();
        int rowHeight = 0;
        for (int rowIndex = rowStart; rowIndex <= rowEnd; ++rowIndex) {
            rowHeight += ((AbstractPWGridRow)grid.getRow(rowIndex)).getHeight();
        }
        int columnWidth = 0;
        for (int colIndex = columnStart; colIndex <= colunmEnd; ++colIndex) {
            columnWidth += ((AbstractPWGridColumn)grid.getColumn(colIndex)).getWidth();
        }
        return new Dimension(columnWidth, rowHeight);
    }

    protected void handGridBorder(AbstractPWGrid grid, AbstractPWGrid copy) {
        PWDataGrid subGrid;
        Border borderTop;
        Style gridStyle = grid.getStyle();
        int rowCount = copy.getOutputRows().size();
        if (rowCount == 0) {
            return;
        }
        List<Object> subDataGrids = new ArrayList(10);
        if (copy instanceof PWDataGrid) {
            subDataGrids = ((PWDataGrid)copy).getSubDataGrids();
        }
        if ((borderTop = gridStyle.getBorder(Styles.Position.TOP)) != null && !borderTop.isNull()) {
            Object outputRow = copy.getOutputRow(0);
            int curRowIndex = ((AbstractPWGridRow)outputRow).getRowIndex();
            Object curDesignRow = ((AbstractPWGridRow)outputRow).isSubRow() ? this.getSubGrid((PWDataGrid)copy).getRow(curRowIndex) : copy.getRow(curRowIndex);
            int cellCount = ((AbstractPWGridRow)outputRow).getCellCount();
            for (int i = 0; i < cellCount; ++i) {
                Style style;
                LineStyle borderLineStyle;
                Object cell = ((AbstractPWGridRow)outputRow).getCell(i);
                if (cell == null || (borderLineStyle = (style = ((AbstractPrintWidget)cell).getStyle()).getBorderLineStyle(Styles.Position.TOP)) != LineStyle.NULL_LINE) continue;
                StyleAttributes sa = style.getNewAttribute();
                sa.setBorder(borderTop);
                if (!((AbstractPWGridCell)cell).isSubCell()) {
                    if (i <= ((AbstractPWGridRow)curDesignRow).getCellCount() - 1) {
                        Style curCellStyle = ((AbstractPrintWidget)((AbstractPWGridRow)curDesignRow).getCell(i)).getStyle();
                        sa.setBorderLineStyle(Styles.Position.TOP, curCellStyle.getBorderLineStyle(Styles.Position.TOP));
                        sa.setBorderColor(Styles.Position.TOP, curCellStyle.getBorderColor(Styles.Position.TOP));
                    }
                } else if (!subDataGrids.isEmpty()) {
                    int subRowIndex = ((AbstractPWGridCell)cell).getRowIndex();
                    Object curSubDesignRow = ((PWDataGrid)subDataGrids.get(0)).getRow(subRowIndex);
                    Style curSubCellStyle = ((AbstractPrintWidget)((AbstractPWGridRow)curSubDesignRow).getCell(i - ((AbstractPWGridRow)curDesignRow).getCellCount())).getStyle();
                    sa.setBorderLineStyle(Styles.Position.TOP, curSubCellStyle.getBorderLineStyle(Styles.Position.TOP));
                    sa.setBorderColor(Styles.Position.TOP, curSubCellStyle.getBorderColor(Styles.Position.TOP));
                }
                ((AbstractPrintWidget)cell).setStyle(Styles.getStyle(sa));
            }
        }
        Border borderButtom = gridStyle.getBorder(Styles.Position.BOTTOM);
        Border subBorderButtom = null;
        if (grid instanceof PWDataGrid && !CollectionUtils.isEmpty(((PWDataGrid)grid).getSubDataGrids()) && (subGrid = this.getSubGrid((PWDataGrid)grid)) != null) {
            subBorderButtom = subGrid.getStyle().getBorder(Styles.Position.BOTTOM);
        }
        if (borderButtom != null && !borderButtom.isNull()) {
            Object outputRow = copy.getOutputRow(rowCount - 1);
            int curRowIndex = ((AbstractPWGridRow)outputRow).getRowIndex();
            int designRowCount = copy.getRowsCount();
            boolean subRow = ((AbstractPWGridRow)outputRow).isSubRow();
            AbstractPWGridRow curDesignRow = null;
            if (!subRow) {
                curDesignRow = (AbstractPWGridRow)copy.getRow(curRowIndex);
            }
            AbstractPWGridRow finalDesignRow = null;
            AbstractPWGridRow nextDesignRow = null;
            if (curRowIndex + 1 == designRowCount) {
                finalDesignRow = (AbstractPWGridRow)copy.getRow(curRowIndex);
            } else if (curRowIndex + 1 < designRowCount) {
                nextDesignRow = (AbstractPWGridRow)copy.getRow(curRowIndex + 1);
            }
            int cellCount = this.getCellCountWithHSubGrid(grid, (AbstractPWGridRow)outputRow);
            for (int i = 0; i < cellCount; ++i) {
                Style nextCellStyle;
                MergeBlock mergeBlock;
                int bottom;
                Style finalCellStyle;
                AbstractPWGridRow finalSubDesignRow;
                int curSubRowIndex;
                Object cell = ((AbstractPWGridRow)outputRow).getCell(i);
                if (cell == null) {
                    ListIterator outRowIt = copy.getOutputRows().listIterator(rowCount - 1);
                    while (outRowIt.hasPrevious() && (cell = ((AbstractPWGridRow)outRowIt.previous()).getCell(i)) == null) {
                    }
                    if (cell == null) continue;
                }
                Style style = ((AbstractPrintWidget)cell).getStyle();
                MergeType mergeType = ((AbstractPWGridCell)cell).getMergeType();
                LineStyle borderLineStyle = style.getBorderLineStyle(Styles.Position.BOTTOM);
                if (borderLineStyle != LineStyle.NULL_LINE) continue;
                StyleAttributes sa = style.getNewAttribute();
                if (((AbstractPWGridCell)cell).isSubCell() && subBorderButtom != null) {
                    sa.setBorder(subBorderButtom);
                    if (!subDataGrids.isEmpty() && curDesignRow != null) {
                        curSubRowIndex = ((AbstractPWGridCell)cell).getRowIndex();
                        finalSubDesignRow = null;
                        AbstractPWGridRow nextSubDesignRow = null;
                        if (curSubRowIndex + 1 == ((PWDataGrid)subDataGrids.get(0)).getRowsCount()) {
                            finalSubDesignRow = (AbstractPWGridRow)((PWDataGrid)subDataGrids.get(0)).getRow(curSubRowIndex);
                            finalCellStyle = ((AbstractPrintWidget)finalSubDesignRow.getCell(i - curDesignRow.getCellCount())).getStyle();
                            if (!(finalSubDesignRow instanceof PWDetailRow)) {
                                sa.setBorderLineStyle(Styles.Position.BOTTOM, finalCellStyle.getBorderLineStyle(Styles.Position.BOTTOM));
                                sa.setBorderColor(Styles.Position.BOTTOM, finalCellStyle.getBorderColor(Styles.Position.BOTTOM));
                            }
                        } else {
                            nextSubDesignRow = (AbstractPWGridRow)((PWDataGrid)subDataGrids.get(0)).getRow(curSubRowIndex + 1);
                            if (mergeType == MergeType.Merged && (bottom = (mergeBlock = ((AbstractPWGridCell)cell).getMergeBlock()).getBottom()) + 1 < ((PWDataGrid)subDataGrids.get(0)).getRowsCount()) {
                                nextSubDesignRow = ((PWDataGrid)subDataGrids.get(0)).getRow(bottom + 1);
                            }
                            nextCellStyle = ((AbstractPrintWidget)nextSubDesignRow.getCell(i - curDesignRow.getCellCount())).getStyle();
                            sa.setBorderLineStyle(Styles.Position.BOTTOM, nextCellStyle.getBorderLineStyle(Styles.Position.TOP));
                            sa.setBorderColor(Styles.Position.BOTTOM, nextCellStyle.getBorderColor(Styles.Position.TOP));
                        }
                    }
                } else if (!subRow) {
                    sa.setBorder(borderButtom);
                    if (finalDesignRow != null) {
                        if (i < finalDesignRow.getCellCount()) {
                            Style finalCellStyle2 = ((AbstractPrintWidget)finalDesignRow.getCell(i)).getStyle();
                            if (!(finalDesignRow instanceof PWDetailRow)) {
                                sa.setBorderLineStyle(Styles.Position.BOTTOM, finalCellStyle2.getBorderLineStyle(Styles.Position.BOTTOM));
                                sa.setBorderColor(Styles.Position.BOTTOM, finalCellStyle2.getBorderColor(Styles.Position.BOTTOM));
                            }
                        }
                    } else if (nextDesignRow != null && i < nextDesignRow.getCellCount()) {
                        MergeBlock mergeBlock2;
                        int bottom2;
                        Style nextCellStyle2 = ((AbstractPrintWidget)nextDesignRow.getCell(i)).getStyle();
                        if (mergeType == MergeType.Merged && (bottom2 = (mergeBlock2 = ((AbstractPWGridCell)cell).getMergeBlock()).getBottom()) + 1 < designRowCount) {
                            nextDesignRow = copy.getRow(bottom2 + 1);
                        }
                        sa.setBorderLineStyle(Styles.Position.BOTTOM, nextCellStyle2.getBorderLineStyle(Styles.Position.TOP));
                        sa.setBorderColor(Styles.Position.BOTTOM, nextCellStyle2.getBorderColor(Styles.Position.TOP));
                    }
                    if (grid instanceof PWDataGrid && ((PWDataGrid)grid).isTitleRowEveryPage()) {
                        sa.setBorder(borderButtom);
                    }
                } else if (subBorderButtom != null && !subDataGrids.isEmpty()) {
                    sa.setBorder(subBorderButtom);
                    curSubRowIndex = ((AbstractPWGridRow)outputRow).getRowIndex();
                    finalSubDesignRow = null;
                    AbstractPWGridRow nextSubDesignRow = null;
                    if (curSubRowIndex + 1 == ((PWDataGrid)subDataGrids.get(0)).getRowsCount()) {
                        finalSubDesignRow = (AbstractPWGridRow)((PWDataGrid)subDataGrids.get(0)).getRow(curSubRowIndex);
                        finalCellStyle = ((AbstractPrintWidget)finalSubDesignRow.getCell(i)).getStyle();
                        if (!(finalSubDesignRow instanceof PWDetailRow)) {
                            sa.setBorderLineStyle(Styles.Position.BOTTOM, finalCellStyle.getBorderLineStyle(Styles.Position.BOTTOM));
                            sa.setBorderColor(Styles.Position.BOTTOM, finalCellStyle.getBorderColor(Styles.Position.BOTTOM));
                        }
                    } else {
                        nextSubDesignRow = (AbstractPWGridRow)((PWDataGrid)subDataGrids.get(0)).getRow(curSubRowIndex + 1);
                        if (mergeType == MergeType.Merged && (bottom = (mergeBlock = ((AbstractPWGridCell)cell).getMergeBlock()).getBottom()) + 1 < ((PWDataGrid)subDataGrids.get(0)).getRowsCount()) {
                            nextSubDesignRow = ((PWDataGrid)subDataGrids.get(0)).getRow(bottom + 1);
                        }
                        nextCellStyle = ((AbstractPrintWidget)nextSubDesignRow.getCell(i)).getStyle();
                        sa.setBorderLineStyle(Styles.Position.BOTTOM, nextCellStyle.getBorderLineStyle(Styles.Position.TOP));
                        sa.setBorderColor(Styles.Position.BOTTOM, nextCellStyle.getBorderColor(Styles.Position.TOP));
                    }
                }
                ((AbstractPrintWidget)cell).setStyle(Styles.getStyle(sa));
            }
        }
    }

    private int getCellCountWithHSubGrid(AbstractPWGrid grid, AbstractPWGridRow outputRow) {
        if (grid instanceof PWDataGrid && SubGridUtils.isHaveSubGrid(grid) && !SubGridUtils.checkVSubGrid((PWDataGrid)grid)) {
            PWDataGrid dataGrid = (PWDataGrid)grid;
            int pCells = 0;
            int subCells = 0;
            for (int i = dataGrid.getRowsCount() - 1; i >= 0; --i) {
                if (((AbstractPWDataGridRow)dataGrid.getRow(i)).getRowType() != outputRow.getRowType()) continue;
                pCells = ((AbstractPWDataGridRow)dataGrid.getRow(i)).getCellCount();
                break;
            }
            PWDataGrid subGrid = dataGrid.getSubDataGrids().get(0);
            for (int i = subGrid.getRowsCount() - 1; i >= 0; --i) {
                if (((AbstractPWDataGridRow)subGrid.getRow(i)).getRowType() != outputRow.getRowType()) continue;
                subCells = ((AbstractPWDataGridRow)subGrid.getRow(i)).getCellCount();
                break;
            }
            return pCells + subCells;
        }
        return outputRow.getCellCount();
    }

    @Override
    public void endOutput(AbstractPrintWidget outputWidget) {
        AbstractPWGrid grid = (AbstractPWGrid)outputWidget;
        grid.getContext().getMergeTypeMap().clear();
        this.processLastTableTail(grid);
        titleRowOut = 0;
        this.outputWidget = null;
    }

    protected void processLastTableTail(AbstractPWGrid grid) {
        if (grid instanceof ITableTailSupport && ((ITableTailSupport)((Object)grid)).isTableTailFlowNative()) {
            this.executeTableTail(((ITableTailSupport)((Object)grid)).getTableTail());
        }
    }

    protected void recordPosition(AbstractPWGrid grid) {
        Rectangle rectangle = grid.getRectangle();
        int height = 0;
        List outputRows = grid.getOutputRows();
        if (outputRows != null) {
            height = outputRows.stream().filter(Objects::nonNull).mapToInt(AbstractPWGridRow::getHeight).sum();
        }
        rectangle.setRect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), height);
        this.getRelativeContext().recordOutPutPosition(grid);
    }

    private void executeCalSubGrid(T outputGrid, AbstractPWGridRow row, GridDataVisitor visitor, AbstractPWGridRow outputRow, int maxHeightToAdjust, boolean remainContent) {
        DataGridRunner runner;
        Field subGridValue;
        String subDataSource;
        PWDataGrid subDataGrid;
        if (2 == row.getRowType() && outputGrid instanceof PWDataGrid && !CollectionUtils.isEmpty(((PWDataGrid)outputGrid).getSubDataGrids())) {
            subDataGrid = this.getSubGrid((PWDataGrid)outputGrid);
            subDataSource = subDataGrid.getDatasource();
            if (StringUtils.isBlank((CharSequence)subDataSource)) {
                return;
            }
            subGridValue = visitor.getFieldVal(subDataSource, null);
            if (subGridValue instanceof CollectionField && !CollectionUtils.isEmpty((Collection)((CollectionField)subGridValue).getValue()) && "bottom".equals(subDataGrid.getSubGridDirection())) {
                runner = (DataGridRunner)subDataGrid.getRunner();
                runner.beginOutput(subDataGrid);
                runner.execute(this.helper);
                if (!((VSubGridRunner)runner.runner).isSubGWGreaterThanParentGW((PWDataGrid)outputGrid, subDataGrid)) {
                    int cellCount = outputRow.getCellCount();
                    for (int cellIndex = 0; cellIndex < cellCount; ++cellIndex) {
                        Object designCell;
                        Object designRow;
                        Object cell = outputRow.getCell(cellIndex);
                        Style gridStyle = ((AbstractPrintWidget)outputGrid).getStyle();
                        Border borderTop = gridStyle.getBorder(Styles.Position.BOTTOM);
                        Style style = ((AbstractPrintWidget)cell).getStyle();
                        LineStyle borderLineStyle = style.getBorderLineStyle(Styles.Position.BOTTOM);
                        Color borderColor = style.getBorderColor(Styles.Position.BOTTOM);
                        if (borderLineStyle != LineStyle.NULL_LINE) continue;
                        int rowIndex = outputRow.getRowIndex();
                        if (rowIndex + 1 < ((AbstractPWGrid)outputGrid).getRowsCount()) {
                            designRow = ((AbstractPWGrid)outputGrid).getRow(rowIndex + 1);
                            designCell = ((AbstractPWGridRow)designRow).getCell(cellIndex);
                            borderColor = ((AbstractPrintWidget)designCell).getStyle().getBorderColor(Styles.Position.TOP);
                        } else if (rowIndex + 1 == ((AbstractPWGrid)outputGrid).getRowsCount()) {
                            designRow = ((AbstractPWGrid)outputGrid).getRow(rowIndex);
                            designCell = ((AbstractPWGridRow)designRow).getCell(cellIndex);
                            borderColor = ((AbstractPrintWidget)designCell).getStyle().getBorderColor(Styles.Position.BOTTOM);
                        }
                        StyleAttributes sa = style.getNewAttribute();
                        sa.setBorder(borderTop);
                        sa.setBorderColor(Styles.Position.BOTTOM, borderColor);
                        ((AbstractPrintWidget)cell).setStyle(Styles.getStyle(sa));
                    }
                }
                if (!row.isRemainContent()) {
                    ((VSubGridRunner)runner.runner).executeSubGrid((PWDataGrid)outputGrid, row, maxHeightToAdjust, (CollectionField)subGridValue, outputRow);
                }
            } else if (subGridValue == null || subGridValue instanceof CollectionField && CollectionUtils.isEmpty((Collection)((CollectionField)subGridValue).getValue()) && "bottom".equals(subDataGrid.getSubGridDirection())) {
                SubGridUtils.dealBlankRow((PWDataGrid)outputGrid, outputRow);
            }
        }
        if (outputGrid instanceof PWDataGrid && !CollectionUtils.isEmpty(((PWDataGrid)outputGrid).getSubDataGrids()) && "right".equals(this.getSubGrid((PWDataGrid)outputGrid).getSubGridDirection())) {
            subDataGrid = this.getSubGrid((PWDataGrid)outputGrid);
            subDataSource = subDataGrid.getDatasource();
            if (1 == row.getRowType() || 3 == row.getRowType()) {
                DataGridRunner runner2 = (DataGridRunner)subDataGrid.getRunner();
                runner2.beginOutput(subDataGrid);
                runner2.execute(this.helper);
                if (3 == row.getRowType()) {
                    outputRow.setRemainContent(row.isRemainContent());
                }
                ((HSubGridRunner)runner2.runner).executeSubGrid((PWDataGrid)outputGrid, outputRow, null);
            } else if (2 == row.getRowType() && (subGridValue = visitor.getFieldVal(subDataSource, null)) instanceof CollectionField) {
                runner = (DataGridRunner)subDataGrid.getRunner();
                runner.beginOutput(subDataGrid);
                runner.execute(this.helper);
                outputRow.setRemainContent(row.isRemainContent());
                if (!remainContent) {
                    ((HSubGridRunner)runner.runner).resetDataIndex((CollectionField)subGridValue);
                }
                ((HSubGridRunner)runner.runner).executeSubGrid((PWDataGrid)outputGrid, outputRow, (CollectionField)subGridValue);
            }
        }
    }

    private boolean isHaveSubGrid(AbstractPWGrid outputGrid) {
        return outputGrid instanceof PWDataGrid && !CollectionUtils.isEmpty(((PWDataGrid)outputGrid).getSubDataGrids());
    }

    protected String getFormulaValue(List<Object> formulaData, AbstractPrintWidget outputGrid, AbstractPrintWidget outputCell, IWidgetExecuteHelper helper, GridDataVisitor visitor) {
        ArrayList<Object> newFormulaData = new ArrayList<Object>(10);
        String gridds = ((PWDataGrid)outputGrid).getDatasource();
        for (int i = 0; i < formulaData.size(); ++i) {
            Object object = formulaData.get(i);
            if (object instanceof Map) {
                Map field = (Map)object;
                newFormulaData.add(object);
                String ds = (String)field.get("dataSource");
                String bf = (String)field.get("bindField");
                if (StringUtil.equals(ds, "$DsKey=[System]")) {
                    if (outputGrid.getPrintAtPage() == PrintAtPage.All) continue;
                    if (StringUtil.equals(bf, "=getRowNumber()")) {
                        field.put("value", new TextField(String.valueOf(this.detailRowNumber)));
                        continue;
                    }
                    outputCell.setPageIndex(outputGrid.getPageIndex());
                    Object formulaResult = this.runFormula(helper, outputCell, bf);
                    field.put("value", new TextField(formulaResult == null ? "" : formulaResult.toString()).getValue());
                    continue;
                }
                CellValueField cellField = new CellValueField(bf);
                Field fieldValue = null;
                fieldValue = StringUtil.equals(ds, gridds) ? visitor.getFieldVal(ds, cellField) : this.getDataHelper(helper, ds).getFieldValue(ds, bf);
                field.put("value", fieldValue);
                continue;
            }
            newFormulaData.add(object);
        }
        IFormulaService formulaService = ExecuteContext.get().getServiceProxy().getFormulaService();
        return formulaService.parseExp(newFormulaData);
    }

    protected void judgeTitleRowOut(PWDataGrid outputGrid) {
        List outputRows = outputGrid.getOutputRows();
        if (outputGrid.isTitleRowEveryPage() && outputRows.size() > 0 && ((AbstractPWGridRow)outputRows.get(outputRows.size() - 1)).getRowType() == 1 && ++titleRowOut >= 50) {
            String msg = ResManager.loadKDString((String)"\u6bcf\u9875\u6253\u5370\u6807\u9898\u884c\u7684\u5185\u5bb9\u8fc7\u591a\uff0c\u5bfc\u81f4\u6570\u636e\u884c\u5185\u5bb9\u65e0\u6cd5\u8f93\u51fa\uff0c\u8bf7\u8c03\u6574\u6a21\u677f\u540e\u6253\u5370\u3002", (String)"TitleRowEveryPageRunner_0", (String)"bos-print-core", (Object[])new Object[0]);
            titleRowOut = 0;
            throw new PrintException("0", msg);
        }
    }

    protected boolean showImageField(AbstractPWGridCell outputCell, ImageField imageField, int realHeight, int columnWidth) {
        Rect padding;
        if (imageField.showDisplayVal() && (imageField.isDesensitive() || kd.bos.util.StringUtils.isBlank((String)imageField.getDisplayVal()))) {
            imageField.setValue("");
        }
        PWPicture pwPicture = new PWPicture();
        pwPicture.setId("");
        pwPicture.setPrintable(true);
        pwPicture.setType("Picture");
        pwPicture.setScaleType(3);
        pwPicture.setAdjustHeight(true);
        pwPicture.setRectangle(new Rectangle(0, 0, columnWidth, realHeight));
        pwPicture.setOutputValue(imageField);
        Style style = outputCell.getStyle();
        Style pwPictureStyle = pwPicture.getStyle();
        StyleAttributes newAttribute = pwPictureStyle.getNewAttribute();
        if (style.getHorizontalAlign() != null) {
            newAttribute.setHorizontalAlign(style.getHorizontalAlign());
        }
        if (style.getVerticalAlign() != null) {
            newAttribute.setVerticalAlign(style.getVerticalAlign());
        }
        if ((padding = style.getPadding()) != null) {
            newAttribute.setPadding(padding.getCopy());
        }
        pwPicture.setStyle(Styles.getStyle(newAttribute));
        outputCell.addChild(pwPicture);
        outputCell.setOriOutPutText("");
        return StringUtils.isNotBlank((CharSequence)((CharSequence)imageField.getValue()));
    }

    protected List<IPrintWidget> childrenWidgetBindField(String datasource, PdIterator iterator, AbstractPWGridCell cell, List<IPrintWidget> children) {
        ArrayList<IPrintWidget> printWidgetList = new ArrayList<IPrintWidget>(children.size());
        for (IPrintWidget widget : children) {
            Field field = null;
            if (!(widget instanceof AbstractPrintWidgetField)) continue;
            AbstractPrintWidgetField widgetField = (AbstractPrintWidgetField)widget;
            String bindField = widgetField.getBindField();
            String widgetFieldDatasource = widgetField.getDatasource();
            if (StringUtil.equals(widgetFieldDatasource, "$DsKey=[System]") && ((AbstractPWGrid)this.getOutputWidget()).getPrintAtPage() != PrintAtPage.All) {
                AbstractPrintWidget copy;
                TextField outputValue;
                if (StringUtil.equals(bindField, "=getRowNumber()")) {
                    outputValue = new TextField(String.valueOf(this.detailRowNumber));
                    copy = (AbstractPrintWidget)widgetField.copy();
                    copy.setOutputValue(outputValue);
                    printWidgetList.add(copy);
                    continue;
                }
                if ("=getGroupRowNumber()".equals(bindField)) {
                    outputValue = new TextField(String.valueOf(this.detailGroupRowNumber));
                    copy = (AbstractPrintWidget)widgetField.copy();
                    copy.setOutputValue(outputValue);
                    printWidgetList.add(copy);
                    continue;
                }
            }
            field = this.getField(bindField, widgetFieldDatasource, datasource, bindField, iterator);
            if (widget instanceof PWText) {
                PWText pwText = (PWText)widget;
                List<Object> formulaData = pwText.getFormulaData();
                field = this.getFieldOrDefault(bindField, widgetFieldDatasource, datasource, formulaData, bindField, iterator);
            }
            if (widget instanceof PWBarcode) {
                PWBarcode barcode = (PWBarcode)widget;
                BarcodeObject barcodeObject = barcode.getBarcodeObject();
                bindField = barcodeObject.getBindField();
                List<Object> formulaData = barcode.getFormulaData();
                String defaultValue = bindField;
                if (StringUtils.isBlank((CharSequence)defaultValue)) {
                    defaultValue = barcodeObject.getSampleTxt();
                }
                field = this.getFieldOrDefault(bindField, widgetFieldDatasource, datasource, formulaData, defaultValue, iterator);
            }
            if (widget instanceof PWPicture && field instanceof TextField) {
                field = new ImageField((String)((TextField)field).getValue());
            }
            AbstractPrintWidget copy = (AbstractPrintWidget)widgetField.copy();
            copy.setOutputValue(field);
            printWidgetList.add(copy);
        }
        cell.getChildren().clear();
        cell.getChildren().addAll(printWidgetList);
        return printWidgetList;
    }

    private Field getFieldOrDefault(String bindField, String widgetFieldDatasource, String datasource, List<Object> formulaData, String defaultValue, PdIterator iterator) {
        if (StringUtils.isNotBlank((CharSequence)widgetFieldDatasource)) {
            return this.getField(bindField, widgetFieldDatasource, datasource, defaultValue, iterator);
        }
        Optional<TextField> optional = this.tryGetFormulaData(formulaData, datasource, iterator);
        return optional.orElseGet(() -> new TextField(defaultValue));
    }

    protected Optional<TextField> tryGetFormulaData(List<Object> formulaData, String datasource, PdIterator iterator) {
        ArrayList<Object> newFormulaData = new ArrayList<Object>(10);
        if (CollectionUtils.isEmpty(formulaData)) {
            return Optional.empty();
        }
        for (Object formulaDatum : formulaData) {
            if (formulaDatum instanceof Map) {
                Map field = (Map)formulaDatum;
                newFormulaData.add(formulaDatum);
                String ds = (String)field.get("dataSource");
                String bindField = (String)field.get("bindField");
                Field fieldValue = null;
                fieldValue = StringUtil.equals(ds, datasource) ? iterator.getField(bindField) : this.getDataHelper(this.helper, ds).getFieldValue(ds, bindField);
                field.put("value", fieldValue == null ? "" : fieldValue);
                continue;
            }
            newFormulaData.add(formulaDatum);
        }
        IFormulaService formulaService = ExecuteContext.get().getServiceProxy().getFormulaService();
        String res = formulaService.parseExp(newFormulaData);
        return Optional.of(new TextField(res));
    }

    private Field getField(String bindField, String widgetFieldDatasource, String datasource, String defaultValue, PdIterator iterator) {
        if (StringUtils.equals((CharSequence)widgetFieldDatasource, (CharSequence)datasource)) {
            return iterator.getField(bindField);
        }
        if (StringUtils.isNotBlank((CharSequence)widgetFieldDatasource)) {
            return this.helper.getDataHelper().getFieldValue(widgetFieldDatasource, bindField);
        }
        return new TextField(defaultValue);
    }

    @Override
    public IWholeRowPageRunner createWholeRowPageRunner() {
        PWDataGrid subGrid;
        PWDataGrid grid;
        AbstractPWGrid outputWidget = (AbstractPWGrid)this.getOutputWidget();
        if (outputWidget instanceof PWDataGrid && !CollectionUtils.isEmpty((grid = (PWDataGrid)outputWidget).getSubDataGrids()) && (subGrid = grid.getSubDataGrids().get(0)) != null && "right".equals(subGrid.getSubGridDirection())) {
            return new NotSupportWholeRowPageRunner();
        }
        return new DefaultWholeRowPageRunner((AbstractPWGrid)this.getOutputWidget());
    }

    @Override
    public final boolean isOpenWholeRowPage() {
        return this.wholeRowPageRunner.isOpenWholeRowPage();
    }

    @Override
    public final boolean isRowDesignPagination(AbstractPWGridRow row, int maxAdjustHeight) {
        return this.wholeRowPageRunner.isRowDesignPagination(row, maxAdjustHeight);
    }

    @Override
    public final boolean isRowRuntimePagination(AdjustHeightUtil.AdjustInfo adjustInfo, int pageHeight, AbstractPWGridRow row) {
        AbstractPWGrid outputWidget = (AbstractPWGrid)this.getOutputWidget();
        if (outputWidget.isTempWholeRowPage() && outputWidget.isWholeGridPage()) {
            return StringUtils.isNotBlank((CharSequence)adjustInfo.getRemainText()) && PWidgetUtil.isWholePagination(row);
        }
        return this.wholeRowPageRunner.isRowRuntimePagination(adjustInfo, pageHeight, row);
    }

    @Override
    public boolean isRowChildWidgetPagination(IAdjustHeightSupport childWidget, AbstractPWGridRow row) {
        return this.wholeRowPageRunner.isRowChildWidgetPagination(childWidget, row);
    }

    static {
        MIN_ROW_HEIGHT = RelativeContext.getTextQuarkHeight();
    }

    @FunctionalInterface
    public static interface GridDataVisitor {
        public Field getFieldVal(String var1, CellValueField var2);
    }
}

