/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.runner.grid;

import java.awt.Rectangle;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import kd.bos.print.core.data.PdIterator;
import kd.bos.print.core.data.R1PDataVisitor;
import kd.bos.print.core.data.field.CollectionField;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.NullField;
import kd.bos.print.core.exception.PrintException;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.IPrintWidgetContainer;
import kd.bos.print.core.model.widget.grid.AbstractPWGrid;
import kd.bos.print.core.model.widget.grid.AbstractPWGridCell;
import kd.bos.print.core.model.widget.grid.cardgrid.PWCardGrid;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueField;
import kd.bos.print.core.model.widget.grid.layoutgrid.PWLayoutGrid;
import kd.bos.print.core.model.widget.grid.layoutgrid.PWLayoutGridRow;
import kd.bos.print.core.model.widget.runner.grid.AbstractGridRunner;
import kd.bos.print.core.model.widget.runner.support.DefaultWholeRowPageRunner;
import kd.bos.print.core.model.widget.runner.support.IWholeRowPageRunner;
import kd.bos.print.core.model.widget.runner.support.NotSupportWholeRowPageRunner;

public class CardGridRunner
extends AbstractGridRunner<PWCardGrid> {
    private boolean endPagePrint = false;
    private PdIterator iterator = this.initPdIterator();

    private PdIterator initPdIterator() {
        return new PdIterator(){

            @Override
            public Field getField(String key) {
                return NullField.get();
            }

            public Object current() {
                return null;
            }

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public boolean hasNext(boolean flag) {
                return false;
            }

            @Override
            public int cursor() {
                return 0;
            }

            @Override
            public Object next() {
                return null;
            }
        };
    }

    @Override
    public void execute(IWidgetExecuteHelper helper) {
        PWCardGrid outputGrid = (PWCardGrid)this.getOutputWidget();
        outputGrid.calMaxHeightToAdjust(outputGrid.getContext());
        this.iterator = this.initPdIterator();
        super.execute(helper);
        if (outputGrid.isHide()) {
            return;
        }
        Optional<R1PDataVisitor> dataVisitorOptional = this.getDataVisitor();
        if (!dataVisitorOptional.isPresent()) {
            this.executeEmptyRow(outputGrid);
            return;
        }
        String datasource = outputGrid.getDatasource();
        R1PDataVisitor dataVisitor = dataVisitorOptional.get();
        CollectionField entryField = dataVisitor.getCollectionField(datasource, outputGrid.getKey());
        if (entryField.size() == 0) {
            this.executeEmptyRow(outputGrid);
            return;
        }
        this.iterator = entryField.iterator();
        boolean isPagePrint = outputGrid.isPagePrint();
        if (isPagePrint) {
            this.pagePrint(helper);
            return;
        }
        this.unPagePrint(helper);
    }

    private void unPagePrint(IWidgetExecuteHelper helper) {
        PWCardGrid outputGrid = (PWCardGrid)this.getOutputWidget();
        int rowsCount = outputGrid.getRowsCount();
        String datasource = outputGrid.getDatasource();
        int spacing = outputGrid.getSpacing() * 10;
        boolean wholeGridPage = outputGrid.isWholeGridPage();
        if (wholeGridPage) {
            outputGrid.setTempWholeRowPage(true);
        }
        while (this.iterator.hasNext()) {
            outputGrid.setWholeGridPage(wholeGridPage);
            this.executeCard(helper, outputGrid, rowsCount, datasource, this.iterator);
            int gridHeight = this.getGridHeight(outputGrid);
            this.cacheOutput(outputGrid);
            this.addSpacing(outputGrid, spacing, gridHeight);
            outputGrid.getContext().setRowCursor(0);
            this.iterator.next();
        }
        this.endOutput(outputGrid);
    }

    @Override
    protected void cacheOutputPagination(AbstractPrintWidget outputWidget) {
        PWCardGrid grid = (PWCardGrid)outputWidget;
        super.cacheOutput(grid);
        if (grid.isTableTailFlowAll()) {
            this.executeTableTail(grid.getTableTail().copy());
        }
    }

    private void pagePrint(IWidgetExecuteHelper helper) {
        PWCardGrid outputGrid = (PWCardGrid)this.getOutputWidget();
        int rowsCount = outputGrid.getRowsCount();
        String datasource = outputGrid.getDatasource();
        this.cancelAdjustHeight(outputGrid);
        Rectangle rectangle = new Rectangle(outputGrid.getRectangle());
        int maxHeightToAdjust = outputGrid.getContext().getMaxHeightToAdjust();
        int gridHeight = -1;
        Integer pagePrintNumber = outputGrid.getPagePrintN();
        while (this.iterator.hasNext()) {
            outputGrid.getContext().setRowCursor(0);
            outputGrid.setRectangle(new Rectangle(rectangle));
            outputGrid.getContext().setMaxHeightToAdjust(maxHeightToAdjust);
            for (int i = 0; i < pagePrintNumber; ++i) {
                if (!this.iterator.hasNext()) {
                    this.iterator = this.initPdIterator();
                    this.executeCard(helper, outputGrid, rowsCount, datasource, this.iterator);
                } else {
                    this.executeCard(helper, outputGrid, rowsCount, datasource, this.iterator);
                    this.iterator.next();
                }
                if (gridHeight == -1) {
                    gridHeight = this.getGridHeight(outputGrid);
                    if (pagePrintNumber * gridHeight >= maxHeightToAdjust) {
                        throw new PrintException("0", ResManager.loadKDString((String)"\u63a7\u4ef6\u6ea2\u51fa\u753b\u5e03\u53ef\u6253\u5370\u533a\u57df\uff0c\u8bf7\u8c03\u6574\u6a21\u677f\u3002", (String)"PrintMetadataUtil_4", (String)"bos-print-business", (Object[])new Object[0]));
                    }
                }
                if (i == pagePrintNumber - 1) {
                    this.endPagePrint = true;
                }
                this.cacheOutput(outputGrid);
                this.addSpacing(outputGrid, 0, gridHeight);
                outputGrid.getContext().setRowCursor(0);
            }
            if (!this.iterator.hasNext()) continue;
            this.endPagePrint = false;
            outputGrid.setPageIndex(outputGrid.getPageIndex() + 1);
        }
        this.endOutput(outputGrid);
    }

    @Override
    protected void processTableTail(AbstractPWGrid grid) {
        PWCardGrid cardGrid = (PWCardGrid)grid;
        if (cardGrid.isTableTailFlowAll() && cardGrid.isPagePrint() && this.endPagePrint) {
            this.executeTableTail(cardGrid.getTableTail().copy());
            this.endPagePrint = false;
        }
    }

    @Override
    protected void processLastTableTail(AbstractPWGrid grid) {
        PWCardGrid cardGrid = (PWCardGrid)grid;
        if (cardGrid.isPagePrint()) {
            if (cardGrid.isTableTailFlowNative()) {
                this.executeTableTail(cardGrid.getTableTail());
            }
        } else if (cardGrid.getTableTail() != null) {
            this.executeTableTail(cardGrid.getTableTail());
        }
    }

    private void addSpacing(PWLayoutGrid outputGrid, int spacing, int gridHeight) {
        Rectangle rectangle = outputGrid.getRectangle();
        int maxHeightToAdjust = outputGrid.getContext().getMaxHeightToAdjust();
        if (maxHeightToAdjust > spacing) {
            rectangle.y = rectangle.y + gridHeight + spacing;
            outputGrid.getContext().setMaxHeightToAdjust(maxHeightToAdjust - spacing);
        } else {
            outputGrid.getContext().setMaxHeightToAdjust(0);
        }
    }

    private int getGridHeight(PWLayoutGrid outputGrid) {
        int gridHeight = 0;
        for (PWLayoutGridRow outputRow : outputGrid.getOutputRows()) {
            gridHeight += outputRow.getHeight();
        }
        return gridHeight;
    }

    private void cancelAdjustHeight(PWLayoutGrid outputGrid) {
        int rowsCount = outputGrid.getRowsCount();
        for (int i = 0; i < rowsCount; ++i) {
            PWLayoutGridRow row = (PWLayoutGridRow)outputGrid.getRow(i);
            row.setAdjustHeight(false);
        }
    }

    private void executeEmptyRow(PWCardGrid outputGrid) {
        int rowCursor;
        this.endPagePrint = true;
        int rowsCount = outputGrid.getRowsCount();
        while ((rowCursor = outputGrid.getRowCursor()) < rowsCount) {
            PWLayoutGridRow row = (PWLayoutGridRow)outputGrid.getRow(rowCursor);
            this.executeTitleRow(outputGrid, row);
            outputGrid.addRowCursor();
        }
        this.cacheOutput(outputGrid);
        this.endOutput(outputGrid);
    }

    @Override
    protected AbstractGridRunner.GridDataVisitor getTitleRowGridDataVisitor() {
        return (ds, field) -> {
            PWCardGrid outputGrid = (PWCardGrid)this.getOutputWidget();
            if (String.valueOf(outputGrid.getDatasource()).equals(ds)) {
                return this.iterator.getField(field.getField());
            }
            Field fieldValue = this.helper.getDataHelper().getFieldValue(ds, field.getField());
            return fieldValue;
        };
    }

    private void executeCard(IWidgetExecuteHelper helper, PWCardGrid outputGrid, int rowsCount, String datasource, PdIterator iterator) {
        int rowCursor;
        while ((rowCursor = outputGrid.getRowCursor()) < rowsCount) {
            PWLayoutGridRow row = (PWLayoutGridRow)outputGrid.getRow(rowCursor);
            this.executeRow(outputGrid, row, (ds, field) -> this.getFieldValue(helper, datasource, iterator, ds, field));
            if (this.isOpenWholeRowPage() ? row.isRemainContent() || outputGrid.getContext().isRowPagination() : row.isRemainContent()) continue;
            outputGrid.addRowCursor();
        }
    }

    @Override
    public void executeChildren(IPrintWidgetContainer cell, List<IPrintWidget> children) {
        List<IPrintWidget> printWidgetList = this.childrenWidgetBindField(((PWCardGrid)this.getOutputWidget()).getDatasource(), this.iterator, (AbstractPWGridCell)cell, children);
        super.executeChildren(cell, printWidgetList);
    }

    @Override
    protected String getFormulaValue(List<Object> formulaData, AbstractPrintWidget outputGrid, AbstractPrintWidget outputCell, IWidgetExecuteHelper helper, AbstractGridRunner.GridDataVisitor visitor) {
        return (String)this.tryGetFormulaData(formulaData, ((PWCardGrid)this.getOutputWidget()).getDatasource(), this.iterator).get().getValue();
    }

    private Field getFieldValue(IWidgetExecuteHelper helper, String datasource, PdIterator iterator, String cellDataSource, CellValueField cellValueField) {
        if (StringUtils.equals((CharSequence)datasource, (CharSequence)cellDataSource)) {
            return iterator.getField(cellValueField.getField());
        }
        if (!StringUtils.equals((CharSequence)datasource, (CharSequence)cellDataSource) && cellValueField == null) {
            String[] keys = cellDataSource.split("\\.");
            String valueKey = "";
            if (keys.length > 0) {
                valueKey = keys[keys.length - 1];
            }
            return iterator.getField(valueKey);
        }
        return helper.getDataHelper().getFieldValue(cellDataSource, cellValueField.getField());
    }

    private Optional<R1PDataVisitor> getDataVisitor() {
        PWCardGrid outputWidget = (PWCardGrid)this.getOutputWidget();
        String datasource = outputWidget.getDatasource();
        if (StringUtils.isBlank((CharSequence)datasource)) {
            return Optional.empty();
        }
        IWidgetExecuteHelper.IDataHelper dataHelper = this.helper.getDataHelper();
        return Optional.ofNullable(dataHelper.getDataVisitor(datasource));
    }

    @Override
    public IWholeRowPageRunner createWholeRowPageRunner() {
        IWholeRowPageRunner wholeRowPageRunner = super.createWholeRowPageRunner();
        if (wholeRowPageRunner instanceof NotSupportWholeRowPageRunner) {
            return wholeRowPageRunner;
        }
        if (((PWCardGrid)this.getOutputWidget()).isPagePrint()) {
            return new NotSupportWholeRowPageRunner();
        }
        return new DefaultWholeRowPageRunner((AbstractPWGrid)this.getOutputWidget());
    }
}

