/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.runner.grid;

import java.util.ArrayList;
import java.util.Collections;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.PWidgetUtil;
import kd.bos.print.core.model.widget.grid.datagrid.AbstractPWDataGridRow;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGrid;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGridCell;
import kd.bos.print.core.model.widget.grid.datagrid.PWDetailRow;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.ACellValue;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueStat;
import kd.bos.print.core.model.widget.runner.AbstractRunner;
import kd.bos.print.core.model.widget.runner.grid.AbstractDataGridRunner;
import kd.bos.print.core.model.widget.runner.grid.GroupRunner;
import kd.bos.print.core.model.widget.runner.grid.GroupStatRowEveryPageRunner;
import kd.bos.print.core.model.widget.runner.grid.MergeSummaryRunner;
import kd.bos.print.core.model.widget.runner.grid.MergeSummaryStatRowRunner;
import kd.bos.print.core.model.widget.runner.grid.NormalRunner;
import kd.bos.print.core.model.widget.runner.grid.StatRowEveryPageRunner;
import kd.bos.print.core.model.widget.runner.grid.TemplateMergeSummaryRunner;
import kd.bos.print.core.model.widget.runner.grid.TemplateRunner;
import kd.bos.print.core.model.widget.runner.grid.TitleRowEveryPageRunner;
import kd.bos.print.core.model.widget.runner.grid.subGrid.HSubDateGridRunner;
import kd.bos.print.core.model.widget.runner.grid.subGrid.HSubGridRunner;
import kd.bos.print.core.model.widget.runner.grid.subGrid.VSubGridRunner;

public class DataGridRunner
extends AbstractRunner<PWDataGrid> {
    AbstractDataGridRunner runner = null;

    @Override
    public void setWidget(IPrintWidget outputWidget) {
        super.setWidget(outputWidget);
        PWDataGrid outputGrid = (PWDataGrid)this.getOutputWidget();
        boolean isExistGroupRow = false;
        boolean isMergeSummary = false;
        boolean statRowEveryPage = outputGrid.isStatRowEveryPage();
        for (int i = 0; i < outputGrid.getRowsCount(); ++i) {
            AbstractPWDataGridRow row = (AbstractPWDataGridRow)outputGrid.getRow(i);
            int rowType = row.getRowType();
            if (rowType == 4) {
                isExistGroupRow = true;
            }
            if (rowType == 2 && StringUtils.isNotBlank((CharSequence)((PWDetailRow)row).getMergeByField())) {
                ArrayList mergeByFieldList = new ArrayList();
                String mergeByField = ((PWDetailRow)row).getMergeByField();
                Collections.addAll(mergeByFieldList, mergeByField.split(";"));
                ArrayList<String> dataRowFieldList = new ArrayList<String>(10);
                for (int j = 0; j < row.getCellCount(); ++j) {
                    dataRowFieldList.add(((PWDataGridCell)row.getCell(j)).getBindField());
                }
                if (dataRowFieldList.containsAll(mergeByFieldList)) {
                    isMergeSummary = true;
                }
            }
            if (!statRowEveryPage || rowType != 3) continue;
            if (isExistGroupRow) {
                boolean groupStatRow = false;
                for (int j = 0; j < row.getCellCount(); ++j) {
                    ACellValue cellValue;
                    PWDataGridCell cell = (PWDataGridCell)row.getCell(j);
                    if (cell == null || (cellValue = cell.getCellValue()) == null || !(cellValue instanceof CellValueStat) || ((CellValueStat)cellValue).getStatType() != 18) continue;
                    groupStatRow = true;
                    break;
                }
                row.setDisplayEveryPage(!groupStatRow);
                continue;
            }
            row.setDisplayEveryPage(true);
        }
        if (isExistGroupRow) {
            this.runner = statRowEveryPage ? new GroupStatRowEveryPageRunner() : new GroupRunner();
        } else if (outputGrid.isWholeGridPage() && outputGrid.getSubGridDs() != null) {
            this.runner = new HSubDateGridRunner();
        } else if (isMergeSummary && !outputGrid.isFixedRowAtPage() && (outputGrid.getSubDataGrids() == null || outputGrid.getSubDataGrids().isEmpty())) {
            this.runner = PWidgetUtil.hasStatRowEveryPage(outputGrid) ? new MergeSummaryStatRowRunner() : new MergeSummaryRunner();
        } else if (outputGrid.isFixedRowAtPage()) {
            this.runner = isMergeSummary ? new TemplateMergeSummaryRunner() : new TemplateRunner();
        } else if (PWidgetUtil.hasStatRowEveryPage(outputGrid)) {
            this.runner = new StatRowEveryPageRunner();
        } else if (outputGrid.isTitleRowEveryPage()) {
            this.runner = new TitleRowEveryPageRunner();
        } else if (outputGrid.isSubGrid()) {
            if ("bottom".equals(outputGrid.getSubGridDirection()) && !(this.runner instanceof VSubGridRunner)) {
                this.runner = new VSubGridRunner();
            } else if ("right".equals(outputGrid.getSubGridDirection()) && !(this.runner instanceof HSubGridRunner)) {
                this.runner = new HSubGridRunner();
            }
        } else {
            this.runner = new NormalRunner();
        }
    }

    @Override
    public void execute(IWidgetExecuteHelper helper) {
        PWDataGrid dataGrid = (PWDataGrid)this.getOutputWidget();
        dataGrid.calMaxHeightToAdjust(dataGrid.getContext());
        this.runner.execute(helper);
    }

    @Override
    public void beginOutput(AbstractPrintWidget outputWidget) {
        this.fireBeforeInitWedget(outputWidget);
        this.runner.setRelativeContext(this.getRelativeContext());
        this.runner.setWidget(outputWidget);
        this.runner.beginOutput(outputWidget);
    }
}

