/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.runner.grid;

import java.awt.Rectangle;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.PdIterator;
import kd.bos.print.core.data.R1PDataVisitor;
import kd.bos.print.core.data.field.CollectionField;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.NumberField;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.PWidgetUtil;
import kd.bos.print.core.model.widget.grid.AbstractPWGrid;
import kd.bos.print.core.model.widget.grid.AbstractPWGridRow;
import kd.bos.print.core.model.widget.grid.datagrid.AbstractPWDataGridRow;
import kd.bos.print.core.model.widget.grid.datagrid.GroupDesc;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGrid;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGridCell;
import kd.bos.print.core.model.widget.grid.datagrid.PWGroupRow;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.ACellValue;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueStat;
import kd.bos.print.core.model.widget.runner.grid.AbstractDataGridRunner;
import kd.bos.print.core.model.widget.runner.support.DefaultWholeRowPageRunner;
import kd.bos.print.core.model.widget.runner.support.IWholeRowPageRunner;
import kd.bos.print.core.model.widget.runner.support.NotSupportWholeRowPageRunner;
import kd.bos.print.core.model.widget.runner.support.TitleEveryWholeRowPageRunner;
import kd.bos.print.core.model.widget.runner.support.TitleStatEveryWholeRowPageRunner;
import kd.bos.print.core.plugin.PrintPluginProxy;
import kd.bos.print.core.plugin.event.AfterOutputGroupGridEvent;
import kd.bos.print.core.plugin.event.BeforeOutputRowEvent;

public class GroupRunner
extends AbstractDataGridRunner {
    protected List<AbstractPWDataGridRow> titleRows;
    protected boolean isEndGroup;

    @Override
    public void execute(IWidgetExecuteHelper helper) {
        super.execute(helper);
        this.executeRunner();
    }

    protected void executeRunner() {
        PWDataGrid outputGrid = (PWDataGrid)this.getOutputWidget();
        if (outputGrid.isHide()) {
            return;
        }
        int rowCount = outputGrid.getRowsCount();
        this.getRelativeContext().setOutputGridActualY(outputGrid.getRectangle().getY());
        while (outputGrid.getRowCursor() < rowCount) {
            AbstractPWDataGridRow row = (AbstractPWDataGridRow)outputGrid.getRow(outputGrid.getRowCursor());
            row.setContext(outputGrid.getContext());
            if (row.getRowType() == 1) {
                if (!outputGrid.isTitleRowEveryPage()) {
                    this.executeTitleRow(outputGrid, row);
                } else {
                    if (this.titleRows == null) {
                        this.titleRows = new ArrayList<AbstractPWDataGridRow>();
                    }
                    this.titleRows.add(row);
                }
            } else if (row.getRowType() == 2) {
                R1PDataVisitor dataVisitor;
                if (outputGrid.isTitleRowEveryPage()) {
                    int dataRowIndex = row.getRowIndex();
                    this.executeTitleRows();
                    outputGrid.setRowCursor(dataRowIndex);
                }
                if ((dataVisitor = this.getDataVisitor()) == null) {
                    this.executeTitleRow(outputGrid, row);
                    outputGrid.addRowCursor();
                    continue;
                }
                CollectionField entryField = dataVisitor.getCollectionField(outputGrid.getDatasource(), outputGrid.getKey());
                Object ori = entryField.getValue();
                if (this.groupRowCursor > -1) {
                    entryField.setValue(this.getEntryFieldValueAfterSort(outputGrid, entryField));
                }
                PdIterator iterator = entryField.iterator();
                outputGrid.getContext().setGridIterator(iterator);
                while (iterator.hasNext()) {
                    this.iterateDetailRow(outputGrid, row, iterator);
                }
                entryField.setValue((List<DataRowSet>)ori);
            } else if (row.getRowType() == 3) {
                this.executeGroupStatRow(outputGrid, row);
            } else if (row.getRowType() == 4) {
                this.groupRowCursor = outputGrid.getRowCursor();
            }
            outputGrid.addRowCursor();
        }
        this.isEndGroup = true;
        this.cacheOutput(outputGrid);
        this.endOutput(outputGrid);
    }

    @Override
    protected void executeDetailRow(PWDataGrid outputGrid, AbstractPWDataGridRow row, PdIterator iterator) {
        PWGroupRow groupRow;
        PrintPluginProxy pluginProxy = ExecuteContext.get().getPluginProxy();
        if (pluginProxy != null) {
            BeforeOutputRowEvent evt = new BeforeOutputRowEvent((AbstractPWGridRow)row, iterator);
            evt.setGrid(outputGrid);
            pluginProxy.fireBeforeOutputRow(evt);
            if (evt.isCancleOutput()) {
                return;
            }
        }
        if ((groupRow = this.executeGroupRow(outputGrid, iterator)) != null && groupRow.isRemainContent()) {
            this.executeRow(outputGrid, groupRow, (ds, field) -> {
                if (StringUtils.equals((CharSequence)outputGrid.getDatasource(), (CharSequence)ds)) {
                    return iterator.getField(field.getField());
                }
                return this.helper.getDataHelper().getFieldValue(ds, field.getField());
            });
        }
        outputGrid.setRowCursor(row.getRowIndex());
        if (this.isOpenWholeRowPage() && outputGrid.getContext().isRowPagination()) {
            if (outputGrid.getContext().getRowType() == 4) {
                this.executeDetailRow(outputGrid, row, iterator);
            } else if (outputGrid.getContext().getRowType() == 2) {
                super.executeDetailRow(outputGrid, row, iterator);
            }
        } else {
            super.executeDetailRow(outputGrid, row, iterator);
        }
    }

    protected List<DataRowSet> getEntryFieldValueAfterSort(PWDataGrid outputGrid, CollectionField entryField) {
        PWGroupRow groupRow = (PWGroupRow)outputGrid.getRow(this.groupRowCursor);
        GroupDesc groupDesc = groupRow.getGroupDesc();
        String groupField = groupDesc.getGroupField();
        LinkedHashSet<Object> lhs = new LinkedHashSet<Object>();
        LinkedHashSet blank = new LinkedHashSet(16);
        Iterator iterator = entryField.getValue().iterator();
        while (iterator.hasNext()) {
            DataRowSet drs = (DataRowSet)iterator.next();
            Field field = drs.getField(groupField);
            Object value = field.getValue();
            if (field instanceof NumberField) {
                if (!((NumberField)field).isShowZero() && BigDecimal.ZERO.compareTo(new BigDecimal(value.toString())) == 0) {
                    blank.add(value);
                    continue;
                }
                lhs.add(value);
                continue;
            }
            if (StringUtils.isNotBlank(value)) {
                lhs.add(value);
                continue;
            }
            blank.add(value);
        }
        lhs.addAll(blank);
        ArrayList<DataRowSet> dataRowSetList = new ArrayList<DataRowSet>(16);
        for (Object e : lhs) {
            Iterator iterator2 = entryField.getValue().iterator();
            while (iterator2.hasNext()) {
                DataRowSet drs = (DataRowSet)iterator2.next();
                if (!drs.getField(groupField).getValue().equals(e)) continue;
                dataRowSetList.add(drs);
            }
        }
        return dataRowSetList;
    }

    protected void executeTitleRows() {
        if (this.titleRows == null || this.titleRows.size() < 1) {
            return;
        }
        for (AbstractPWDataGridRow row : this.titleRows) {
            int rowCursor = ((PWDataGrid)this.getOutputWidget()).getRowCursor();
            int rowIndex = row.getRowIndex();
            ((PWDataGrid)this.getOutputWidget()).setRowCursor(rowIndex);
            this.executeTitleRow((AbstractPWGrid)this.getOutputWidget(), row);
            ((PWDataGrid)this.getOutputWidget()).setRowCursor(rowCursor);
        }
    }

    @Override
    protected void executePagination(PWDataGrid outputGrid) {
        if (!this.needPagination(outputGrid) && !this.needWholePagination(outputGrid)) {
            return;
        }
        this.judgeTitleRowOut(outputGrid);
        super.executePagination(outputGrid);
        if (outputGrid.isSkipTitleEvery()) {
            outputGrid.setSkipTitleEvery(false);
            return;
        }
        this.executeTitleRows();
    }

    private PWGroupRow executeGroupRow(PWDataGrid outputGrid, PdIterator iterator) {
        String gridds = outputGrid.getDatasource();
        PWGroupRow groupRow = null;
        if (this.groupRowCursor > -1) {
            groupRow = (PWGroupRow)outputGrid.getRow(this.groupRowCursor);
            GroupDesc groupDesc = groupRow.getGroupDesc();
            String groupField = groupDesc.getGroupField();
            boolean isDividePage = groupDesc.isDividePageWhenDifferent();
            Map<String, Object> groupValue = outputGrid.getContext().getGroupValue();
            if (groupValue == null) {
                HashMap<String, Object> gv = new HashMap<String, Object>(2);
                gv.put(groupField, iterator.getField(groupField));
                outputGrid.getContext().setGroupValue(gv);
                outputGrid.getContext().setRowCursor(groupRow.getRowIndex());
                this.detailGroupRowNumber = 1;
                this.executeRow(outputGrid, groupRow, (ds, field) -> {
                    if (StringUtils.equals((CharSequence)gridds, (CharSequence)ds)) {
                        return iterator.getField(field.getField());
                    }
                    return this.helper.getDataHelper().getFieldValue(ds, field.getField());
                });
                if (this.isOpenWholeRowPage() && outputGrid.getContext().isRowPagination()) {
                    gv.clear();
                    outputGrid.getContext().setGroupValue(null);
                }
            } else {
                Field groupFiledValue = (Field)groupValue.get(groupField);
                Field filedValue = iterator.getField(groupField);
                if (groupFiledValue.getValue() != null && !groupFiledValue.getValue().equals(filedValue.getValue())) {
                    int groupStatRowCursor = this.executeStatRow(outputGrid);
                    if (groupStatRowCursor > -1) {
                        this.statSet.clearGroupStat();
                    }
                    this.isEndGroup = true;
                    if (isDividePage) {
                        this.cacheOutput(outputGrid);
                        outputGrid.setPageIndex(outputGrid.getPageIndex() + 1);
                        double y = this.getRelativeContext().getOutputGridActualY();
                        Rectangle rectangle = outputGrid.getRectangle();
                        rectangle.setRect(rectangle.getX(), y, rectangle.getWidth(), rectangle.getHeight());
                        outputGrid.getContext().setMaxHeightToAdjust(this.getRelativeContext().getEmptyPage().getRectangle().height - this.getFooterHeight() - (int)y);
                        this.calMaxHeightToAdjust(outputGrid);
                        this.executeTitleRows();
                    }
                    outputGrid.getContext().setRowCursor(groupRow.getRowIndex());
                    this.detailGroupRowNumber = 1;
                    this.executeRow(outputGrid, groupRow, (ds, field) -> {
                        if (StringUtils.equals((CharSequence)gridds, (CharSequence)ds)) {
                            return iterator.getField(field.getField());
                        }
                        return this.helper.getDataHelper().getFieldValue(ds, field.getField());
                    });
                    if (!this.isOpenWholeRowPage() || this.isOpenWholeRowPage() && !outputGrid.getContext().isRowPagination()) {
                        Map<String, Object> gv = outputGrid.getContext().getGroupValue();
                        gv.put(groupField, filedValue);
                        outputGrid.getContext().setGroupValue(gv);
                    }
                }
            }
        }
        return groupRow;
    }

    protected void calMaxHeightToAdjust(PWDataGrid outputGrid) {
        outputGrid.calMaxHeightToAdjust(outputGrid.getContext());
    }

    protected int executeStatRow(PWDataGrid outputGrid) {
        int groupStatRowCursor = -1;
        block0: for (int i = 0; i < outputGrid.getRowsCount(); ++i) {
            AbstractPWDataGridRow row = (AbstractPWDataGridRow)outputGrid.getRow(i);
            if (row.getRowType() != 3) continue;
            int cellCount = row.getCellCount();
            for (int j = 0; j < cellCount; ++j) {
                ACellValue cellValue = ((PWDataGridCell)row.getCell(j)).getCellValue();
                if (!(cellValue instanceof CellValueStat) || ((CellValueStat)cellValue).getStatType() != 18) continue;
                groupStatRowCursor = i;
                outputGrid.setRowCursor(groupStatRowCursor);
                this.executeRow(outputGrid, (AbstractPWGridRow)outputGrid.getRow(groupStatRowCursor), (ds, field) -> this.getGroupStatVal(ds, (CellValueStat)field));
                if (!this.needPagination(outputGrid) || !((AbstractPWDataGridRow)outputGrid.getRow(groupStatRowCursor)).isRemainContent()) continue block0;
                this.executeRow(outputGrid, (AbstractPWGridRow)outputGrid.getRow(groupStatRowCursor), (ds, field) -> this.getGroupStatVal(ds, (CellValueStat)field));
                continue block0;
            }
        }
        return groupStatRowCursor;
    }

    @Override
    protected void beforeCacheOutput(AbstractPrintWidget outputWidget) {
        PrintPluginProxy pluginProxy = ExecuteContext.get().getPluginProxy();
        if (pluginProxy != null) {
            AfterOutputGroupGridEvent evt = new AfterOutputGroupGridEvent((AbstractPWGrid)outputWidget);
            evt.setGroupEnd(this.isEndGroup);
            pluginProxy.fireAfterOutputWidget(evt);
        }
    }

    @Override
    public void cacheOutput(AbstractPrintWidget outputWidget) {
        super.cacheOutput(outputWidget);
        this.isEndGroup = false;
    }

    private void executeGroupStatRow(PWDataGrid outputGrid, AbstractPWDataGridRow row) {
        PrintPluginProxy pluginProxy = ExecuteContext.get().getPluginProxy();
        if (pluginProxy != null) {
            BeforeOutputRowEvent evt = new BeforeOutputRowEvent((AbstractPWGridRow)row, this.helper.getDataHelper());
            evt.setGrid(outputGrid);
            pluginProxy.fireBeforeOutputRow(evt);
            if (evt.isCancleOutput()) {
                return;
            }
        }
        this.executeRow(outputGrid, row, (ds, field) -> this.getGroupStatVal(ds, (CellValueStat)field));
        if (row.isRemainContent()) {
            this.executeGroupStatRow(outputGrid, row);
        }
    }

    private Field getGroupStatVal(String ds, CellValueStat cellField) {
        String gridds = ((PWDataGrid)this.getOutputWidget()).getDatasource();
        if (cellField.getStatType() == 6) {
            return new TextField("");
        }
        if (StringUtils.equals((CharSequence)gridds, (CharSequence)ds) && cellField.getStatType() != 0) {
            return this.statSet.getStatValue(cellField.getField() + "_" + cellField.getStatType());
        }
        return this.helper.getDataHelper().getFieldValue(ds, cellField.getField());
    }

    @Override
    public IWholeRowPageRunner createWholeRowPageRunner() {
        IWholeRowPageRunner wholeRowPageRunner = super.createWholeRowPageRunner();
        if (wholeRowPageRunner instanceof NotSupportWholeRowPageRunner) {
            return wholeRowPageRunner;
        }
        PWDataGrid outputGrid = (PWDataGrid)this.getOutputWidget();
        if (PWidgetUtil.hasTitleRowStatRowEveryPage(outputGrid)) {
            return new TitleStatEveryWholeRowPageRunner(outputGrid);
        }
        if (outputGrid.isTitleRowEveryPage()) {
            return new TitleEveryWholeRowPageRunner(outputGrid);
        }
        return new DefaultWholeRowPageRunner(outputGrid);
    }
}

