/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.runner.grid;

import java.util.ArrayList;
import java.util.List;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.PdIterator;
import kd.bos.print.core.data.R1PDataVisitor;
import kd.bos.print.core.data.field.CollectionField;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.grid.AbstractPWGrid;
import kd.bos.print.core.model.widget.grid.AbstractPWGridRow;
import kd.bos.print.core.model.widget.grid.datagrid.AbstractPWDataGridRow;
import kd.bos.print.core.model.widget.grid.datagrid.GroupDesc;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGrid;
import kd.bos.print.core.model.widget.grid.datagrid.PWGroupRow;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueStat;
import kd.bos.print.core.model.widget.runner.grid.GroupRunner;

public class GroupStatRowEveryPageRunner
extends GroupRunner {
    private final List<AbstractPWDataGridRow> statRows = new ArrayList<AbstractPWDataGridRow>(4);
    private List<AbstractPWDataGridRow> groupStatRows = new ArrayList<AbstractPWDataGridRow>(4);
    private double statRowHeight;

    @Override
    protected void executeRunner() {
        R1PDataVisitor dataVisitor;
        PWDataGrid outputGrid = (PWDataGrid)this.getOutputWidget();
        if (outputGrid.isHide()) {
            return;
        }
        boolean titleRowEveryPage = outputGrid.isTitleRowEveryPage();
        AbstractPWDataGridRow dataRow = null;
        int rowCount = outputGrid.getRowsCount();
        this.getRelativeContext().setOutputGridActualY(outputGrid.getRectangle().getY());
        for (int i = 0; i < rowCount; ++i) {
            AbstractPWDataGridRow row = (AbstractPWDataGridRow)outputGrid.getRow(i);
            row.setContext(outputGrid.getContext());
            if (row.getRowType() == 1) {
                if (titleRowEveryPage) {
                    if (this.titleRows == null) {
                        this.titleRows = new ArrayList();
                    }
                    this.titleRows.add(row);
                    continue;
                }
                this.executeTitleRow(outputGrid, row);
                outputGrid.addRowCursor();
                continue;
            }
            if (row.getRowType() == 2) {
                dataRow = row;
                continue;
            }
            if (row.getRowType() == 3) {
                if (row.isDisplayEveryPage()) {
                    this.statRows.add(row);
                    this.statRowHeight += (double)row.getHeight();
                    continue;
                }
                this.groupStatRows.add(row);
                continue;
            }
            if (row.getRowType() != 4) continue;
            this.groupRowCursor = i;
        }
        int maxHeightToAdjust = outputGrid.getContext().getMaxHeightToAdjust();
        maxHeightToAdjust = (int)((double)maxHeightToAdjust - this.statRowHeight);
        outputGrid.getContext().setMaxHeightToAdjust(maxHeightToAdjust);
        if (titleRowEveryPage) {
            this.executeTitleRows();
        }
        if ((dataVisitor = this.getDataVisitor()) == null) {
            this.executeTitleRow(outputGrid, dataRow);
            outputGrid.addRowCursor();
        } else if (dataRow != null) {
            CollectionField entryField = dataVisitor.getCollectionField(outputGrid.getDatasource(), outputGrid.getKey());
            Object ori = entryField.getValue();
            entryField.setValue(this.getEntryFieldValueAfterSort(outputGrid, entryField));
            PdIterator iterator = entryField.iterator();
            outputGrid.getContext().setGridIterator(iterator);
            while (iterator.hasNext()) {
                outputGrid.setRowCursor(dataRow.getRowIndex());
                this.iterateDetailRow(outputGrid, dataRow, iterator);
            }
            outputGrid.addRowCursor();
            entryField.setValue((List<DataRowSet>)ori);
        }
        this.executeGroupStatRows();
        this.executeAllStatRows();
        this.isEndGroup = true;
        this.cacheOutput(outputGrid);
        this.endOutput(outputGrid);
    }

    private void executeGroupStatRows() {
        for (AbstractPWDataGridRow row : this.groupStatRows) {
            ((PWDataGrid)this.getOutputWidget()).setRowCursor(row.getRowIndex());
            super.executeStatRow((PWDataGrid)this.getOutputWidget(), row);
            ((PWDataGrid)this.getOutputWidget()).addRowCursor();
        }
    }

    @Override
    protected void beforeExecuteRow(PWDataGrid outputGrid) {
        if (this.needPagination(outputGrid)) {
            this.judgeTitleRowOut(outputGrid);
            if (outputGrid.isWholeGridPage()) {
                this.executePagination(outputGrid);
                return;
            }
            if (outputGrid.getContext().isDetailRowHasOutput() && outputGrid.getCurrentRowType() != 1) {
                this.executeAllStatRows();
            }
            this.executePagination(outputGrid);
        }
    }

    @Override
    protected boolean needPagination(AbstractPWGrid outputGrid) {
        int rowsCount;
        int maxAdjustHeight = outputGrid.getContext().getMaxHeightToAdjust();
        int rowCursor = outputGrid.getRowCursor();
        if (rowCursor >= (rowsCount = outputGrid.getRowsCount())) {
            return false;
        }
        Object row = outputGrid.getRow(rowCursor);
        int rowHeight = ((AbstractPWGridRow)row).getHeight();
        return rowHeight > maxAdjustHeight;
    }

    @Override
    public void cacheOutput(AbstractPrintWidget outputWidget) {
        PWDataGrid grid = (PWDataGrid)outputWidget;
        super.cacheOutput(grid);
        grid.getOutputRows().clear();
        this.statSet.clearPageStat();
    }

    @Override
    protected boolean rowOverPage() {
        return ((PWDataGrid)this.getOutputWidget()).getCurrentRowType() != 2;
    }

    @Override
    protected void executePagination(PWDataGrid outputGrid) {
        super.executePagination(outputGrid);
    }

    @Override
    protected double getNeedReserveHeight() {
        return (int)this.statRowHeight;
    }

    @Override
    protected int executeStatRow(PWDataGrid outputGrid) {
        PWGroupRow groupRow = (PWGroupRow)outputGrid.getRow(this.groupRowCursor);
        GroupDesc groupDesc = groupRow.getGroupDesc();
        if (groupDesc.isDividePageWhenDifferent()) {
            int groupStatRowCursor = super.executeStatRow(outputGrid);
            this.executeAllStatRows();
            return groupStatRowCursor;
        }
        return super.executeStatRow(outputGrid);
    }

    private void executeAllStatRows() {
        if (((PWDataGrid)this.getOutputWidget()).getContext().isRemainBlank()) {
            return;
        }
        PWDataGrid outputWidget = (PWDataGrid)this.getOutputWidget();
        for (AbstractPWDataGridRow row : this.statRows) {
            int maxHeightToAdjust = outputWidget.getContext().getMaxHeightToAdjust();
            outputWidget.getContext().setMaxHeightToAdjust(maxHeightToAdjust += row.getHeight());
            int originRowIndex = outputWidget.getRowCursor();
            outputWidget.setRowCursor(row.getRowIndex());
            this.executeRow(outputWidget, row, (ds, field) -> this.getStatVal(ds, (CellValueStat)field));
            outputWidget.setRowCursor(originRowIndex);
        }
    }

    @Override
    protected void calMaxHeightToAdjust(PWDataGrid outputGrid) {
        super.calMaxHeightToAdjust(outputGrid);
        outputGrid.getContext().setMaxHeightToAdjust((int)((double)outputGrid.getContext().getMaxHeightToAdjust() - this.statRowHeight));
    }
}

