/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.runner.grid;

import kd.bos.print.core.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.PrintAtPage;
import kd.bos.print.core.model.widget.grid.AbstractPWGrid;
import kd.bos.print.core.model.widget.grid.AbstractPWGridRow;
import kd.bos.print.core.model.widget.grid.layoutgrid.PWLayoutGrid;
import kd.bos.print.core.model.widget.grid.layoutgrid.PWLayoutGridRow;
import kd.bos.print.core.model.widget.runner.grid.AbstractGridRunner;

public class LayoutGridRunner
extends AbstractGridRunner<PWLayoutGrid> {
    @Override
    public void execute(IWidgetExecuteHelper helper) {
        super.execute(helper);
        PWLayoutGrid outputGrid = (PWLayoutGrid)this.getOutputWidget();
        if (outputGrid.isHide()) {
            return;
        }
        int rowCount = outputGrid.getRowsCount();
        while (outputGrid.getRowCursor() < rowCount) {
            PWLayoutGridRow row = (PWLayoutGridRow)outputGrid.getRow(outputGrid.getRowCursor());
            this.executeTitleRow(outputGrid, row);
            outputGrid.addRowCursor();
            if (((PWLayoutGrid)this.getOutputWidget()).getPrintAtPage() != PrintAtPage.All || !this.needPagination(outputGrid)) continue;
            break;
        }
        this.cacheOutput(outputGrid);
        this.endOutput(outputGrid);
    }

    @Override
    protected boolean rowOverPage() {
        return ((PWLayoutGrid)this.getOutputWidget()).getPrintAtPage() != PrintAtPage.InContainer;
    }

    @Override
    protected int designRowHeightAdjust(AbstractPWGridRow row, int rowHeight, int maxHeightToAdjust) {
        if (((PWLayoutGrid)this.getOutputWidget()).getPrintAtPage() == PrintAtPage.InContainer) {
            return Math.min(rowHeight, maxHeightToAdjust);
        }
        return super.designRowHeightAdjust(row, rowHeight, maxHeightToAdjust);
    }

    @Override
    public void cacheOutput(AbstractPrintWidget outputWidget) {
        AbstractPWGrid grid = (AbstractPWGrid)outputWidget;
        if (outputWidget.getPrintAtPage() == PrintAtPage.InContainer) {
            grid.columnsOutput();
            this.handGridBorder(grid, grid);
            this.handMerge(grid);
        } else {
            super.cacheOutput(outputWidget);
        }
    }
}

