/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.runner.grid;

import kd.bos.print.core.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import kd.bos.print.core.data.PdIterator;
import kd.bos.print.core.data.R1PDataVisitor;
import kd.bos.print.core.data.field.CollectionField;
import kd.bos.print.core.model.widget.grid.datagrid.AbstractPWDataGridRow;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGrid;
import kd.bos.print.core.model.widget.runner.grid.AbstractDataGridRunner;

public class NormalRunner
extends AbstractDataGridRunner {
    @Override
    public void execute(IWidgetExecuteHelper helper) {
        super.execute(helper);
        PWDataGrid outputGrid = (PWDataGrid)this.getOutputWidget();
        if (outputGrid.isHide()) {
            return;
        }
        int rowCount = outputGrid.getRowsCount();
        while (outputGrid.getRowCursor() < rowCount) {
            AbstractPWDataGridRow row = (AbstractPWDataGridRow)outputGrid.getRow(outputGrid.getRowCursor());
            row.setContext(outputGrid.getContext());
            if (row.getRowType() == 1) {
                this.executeTitleRow(outputGrid, row);
            } else if (row.getRowType() == 2) {
                R1PDataVisitor dataVisitor = this.getDataVisitor();
                if (dataVisitor == null) {
                    this.executeTitleRow(outputGrid, row);
                    outputGrid.addRowCursor();
                    continue;
                }
                CollectionField entryField = dataVisitor.getCollectionField(outputGrid.getDatasource(), outputGrid.getKey());
                PdIterator iterator = entryField.iterator();
                outputGrid.getContext().setGridIterator(iterator);
                while (iterator.hasNext()) {
                    this.iterateDetailRow(outputGrid, row, iterator);
                }
            } else if (row.getRowType() == 3) {
                this.executeStatRow(outputGrid, row);
            }
            outputGrid.addRowCursor();
        }
        this.cacheOutput(outputGrid);
        this.endOutput(outputGrid);
    }

    @Override
    protected boolean isOnlyTitleRow(PWDataGrid outputGrid) {
        return false;
    }
}

