/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.runner.grid;

import java.util.ArrayList;
import java.util.List;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import kd.bos.print.core.data.PdIterator;
import kd.bos.print.core.data.R1PDataVisitor;
import kd.bos.print.core.data.field.CollectionField;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.PWidgetUtil;
import kd.bos.print.core.model.widget.grid.AbstractPWGrid;
import kd.bos.print.core.model.widget.grid.AbstractPWGridRow;
import kd.bos.print.core.model.widget.grid.datagrid.AbstractPWDataGridRow;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGrid;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueStat;
import kd.bos.print.core.model.widget.runner.grid.AbstractDataGridRunner;
import kd.bos.print.core.model.widget.runner.support.IWholeRowPageRunner;
import kd.bos.print.core.model.widget.runner.support.NotSupportWholeRowPageRunner;
import kd.bos.print.core.model.widget.runner.support.TitleStatEveryWholeRowPageRunner;

public class StatRowEveryPageRunner
extends AbstractDataGridRunner {
    private boolean isLastPage;
    private List<AbstractPWDataGridRow> titleRows = new ArrayList<AbstractPWDataGridRow>();
    private int startCursor = 0;
    private List<AbstractPWDataGridRow> statRows = new ArrayList<AbstractPWDataGridRow>();
    private List<AbstractPWDataGridRow> lastStatRows = new ArrayList<AbstractPWDataGridRow>();
    private AbstractPWDataGridRow dataRow;
    private double statRowHeight;

    @Override
    public void execute(IWidgetExecuteHelper helper) {
        super.execute(helper);
        PWDataGrid outputGrid = (PWDataGrid)this.getOutputWidget();
        if (outputGrid.isHide()) {
            return;
        }
        ArrayList<AbstractPWDataGridRow> tempTitleRows = new ArrayList<AbstractPWDataGridRow>();
        int rowCount = outputGrid.getRowsCount();
        for (int index = 0; index < rowCount; ++index) {
            AbstractPWDataGridRow row = (AbstractPWDataGridRow)outputGrid.getRow(index);
            row.setContext(outputGrid.getContext());
            if (row.getRowType() == 1) {
                tempTitleRows.add(row);
                ++this.startCursor;
                if (!row.isDisplayEveryPage()) continue;
                this.titleRows.add(row);
                continue;
            }
            if (row.getRowType() == 2) {
                this.dataRow = row;
                continue;
            }
            if (row.getRowType() != 3) continue;
            if (row.isDisplayEveryPage()) {
                this.statRows.add(row);
                this.statRowHeight += (double)row.getHeight();
                continue;
            }
            this.lastStatRows.add(row);
        }
        if (outputGrid.isTitleRowEveryPage()) {
            this.startCursor = 0;
        }
        int maxHeightToAdjust = outputGrid.getContext().getMaxHeightToAdjust();
        maxHeightToAdjust = (int)((double)maxHeightToAdjust - this.statRowHeight);
        outputGrid.getContext().setMaxHeightToAdjust(maxHeightToAdjust);
        for (AbstractPWDataGridRow row : tempTitleRows) {
            this.executeTitleRow(outputGrid, row);
            outputGrid.addRowCursor();
        }
        R1PDataVisitor dataVisitor = this.getDataVisitor();
        if (dataVisitor != null) {
            CollectionField entryField = dataVisitor.getCollectionField(outputGrid.getDatasource(), outputGrid.getKey());
            PdIterator iterator = entryField.iterator();
            outputGrid.getContext().setGridIterator(iterator);
            while (iterator.hasNext()) {
                this.iterateDetailRow(outputGrid, this.dataRow, iterator);
            }
        } else {
            this.executeTitleRow(outputGrid, this.dataRow);
            outputGrid.addRowCursor();
        }
        this.isLastPage = true;
        outputGrid.addRowCursor();
        this.executeStatRows();
        this.beforeExecuteRow(outputGrid);
        this.executeLastStatRows();
        this.cacheOutput(outputGrid);
        this.endOutput(outputGrid);
    }

    @Override
    protected void beforeExecuteRow(PWDataGrid outputGrid) {
        if (this.needPagination(outputGrid)) {
            this.judgeTitleRowOut(outputGrid);
            if (outputGrid.isWholeGridPage()) {
                this.executePagination(outputGrid);
                return;
            }
            if (!this.isLastPage && outputGrid.getContext().isDetailRowHasOutput() && outputGrid.getCurrentRowType() == 2) {
                PdIterator gridIterator;
                if (outputGrid.isStatWithData() && (gridIterator = outputGrid.getContext().getGridIterator()) != null && gridIterator.rowSize() == gridIterator.cursor() + 1) {
                    int height = PWidgetUtil.noPageSumStatRowsHeight(outputGrid);
                    outputGrid.getContext().setMaxHeightToAdjust(outputGrid.getContext().getMaxHeightToAdjust() + height);
                }
                this.executeStatRows();
            }
            this.executePagination(outputGrid);
        }
    }

    private void executeTitleRows() {
        if (this.titleRows == null || this.titleRows.size() < 1) {
            return;
        }
        for (AbstractPWDataGridRow row : this.titleRows) {
            this.executeTitleRow((AbstractPWGrid)this.getOutputWidget(), row);
            ((PWDataGrid)this.getOutputWidget()).addRowCursor();
        }
    }

    private void executeStatRows() {
        if (this.statRows == null || this.statRows.size() < 1) {
            return;
        }
        PWDataGrid outputWidget = (PWDataGrid)this.getOutputWidget();
        for (AbstractPWDataGridRow row : this.statRows) {
            int maxHeightToAdjust = outputWidget.getContext().getMaxHeightToAdjust();
            outputWidget.getContext().setMaxHeightToAdjust(maxHeightToAdjust += row.getHeight());
            outputWidget.setRowCursor(row.getRowIndex());
            this.executeRow(outputWidget, row, (ds, field) -> this.getStatVal(ds, (CellValueStat)field));
        }
        if (this.isLastPage) {
            this.statRows.clear();
        }
    }

    @Override
    protected boolean rowOverPage() {
        return Boolean.FALSE;
    }

    private void executeLastStatRows() {
        for (AbstractPWDataGridRow row : this.lastStatRows) {
            ((PWDataGrid)this.getOutputWidget()).setRowCursor(row.getRowIndex());
            super.executeStatRow((PWDataGrid)this.getOutputWidget(), row);
            ((PWDataGrid)this.getOutputWidget()).addRowCursor();
        }
    }

    @Override
    protected boolean needPagination(AbstractPWGrid outputGrid) {
        int rowsCount;
        int maxAdjustHeight = outputGrid.getContext().getMaxHeightToAdjust();
        int rowCursor = outputGrid.getRowCursor();
        if (rowCursor >= (rowsCount = outputGrid.getRowsCount())) {
            return false;
        }
        Object row = outputGrid.getRow(rowCursor);
        int rowHeight = ((AbstractPWGridRow)row).getHeight();
        return rowHeight > maxAdjustHeight;
    }

    @Override
    protected void executePagination(PWDataGrid outputGrid) {
        super.executePagination(outputGrid);
        if (outputGrid.isSkipTitleEvery()) {
            outputGrid.setSkipTitleEvery(false);
            return;
        }
        this.executeTitleRows();
    }

    @Override
    protected double getNeedReserveHeight() {
        return (int)this.statRowHeight;
    }

    @Override
    public void cacheOutput(AbstractPrintWidget outputWidget) {
        PWDataGrid grid = (PWDataGrid)outputWidget;
        super.cacheOutput(grid);
        grid.getContext().setRowCursor(this.startCursor);
        this.statSet.clearPageStat();
    }

    @Override
    public IWholeRowPageRunner createWholeRowPageRunner() {
        IWholeRowPageRunner wholeRowPageRunner = super.createWholeRowPageRunner();
        if (wholeRowPageRunner instanceof NotSupportWholeRowPageRunner) {
            return wholeRowPageRunner;
        }
        return new TitleStatEveryWholeRowPageRunner((AbstractPWGrid)this.getOutputWidget());
    }
}

