/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.runner.grid;

import java.awt.Rectangle;
import java.util.List;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.PrintAtPage;
import kd.bos.print.core.model.widget.grid.AbstractPWGrid;
import kd.bos.print.core.model.widget.grid.tabletail.PWTableTail;
import kd.bos.print.core.model.widget.runner.AbstractRunner;
import kd.bos.print.core.model.widget.runner.IRunner;

public class TableTailRunner
extends AbstractRunner<PWTableTail> {
    @Override
    public void execute(IWidgetExecuteHelper helper) {
        this.helper = helper;
        PWTableTail outputWidget = (PWTableTail)this.getOutputWidget();
        this.doBeforeExecuteChildren(outputWidget);
        List<AbstractPrintWidget> children = outputWidget.getChildren();
        if (children != null && children.size() > 0) {
            this.executeChildren(children);
        }
        this.cacheOutput(outputWidget);
        this.endOutput(outputWidget);
    }

    public void executeChildren(List<AbstractPrintWidget> children) {
        for (AbstractPrintWidget widget : children) {
            widget.setPrintAtPage(PrintAtPage.InContainer);
            if (widget instanceof AbstractPWGrid) {
                ((AbstractPWGrid)widget).setWholeRowPage(false);
            }
            IRunner runner = widget.getRunner();
            runner.setRelativeContext(this.getRelativeContext());
            widget.setCanvasWidget(Boolean.FALSE);
            this.doBeforeExecuteChildren(widget);
            widget.setPageIndex(((PWTableTail)this.getOutputWidget()).getPageIndex());
            runner.execute(this.helper);
        }
    }

    protected void doBeforeExecuteChildren(IPrintWidget output) {
        Rectangle rectangle = ((PWTableTail)this.getOutputWidget()).getRectangle();
        int containerHeight = rectangle.height;
        int containerWidth = rectangle.width;
        int maxHeightToAdjust = containerHeight - output.getRectangle().y;
        output.getContext().setContainerWidth(containerWidth);
        output.getContext().setContainerHeight(containerHeight);
        output.getContext().setMaxHeightToAdjust(maxHeightToAdjust);
        output.setContainerHeight(containerHeight);
        output.setContainerWidth(containerWidth);
        output.setMaxHeightToAdjust(maxHeightToAdjust);
    }

    @Override
    public void beginOutput(AbstractPrintWidget outputWidget) {
        if (outputWidget.isCanvasWidget()) {
            this.fireBeforeInitWedget(outputWidget);
            this.getRelativeContext().recordPosition(outputWidget);
            this.getRelativeContext().flowTargetWidget(outputWidget, ((PWTableTail)this.getOutputWidget()).getParentGridId());
        }
    }
}

