/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.runner.grid;

import java.awt.Rectangle;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import kd.bos.print.core.data.PdIterator;
import kd.bos.print.core.data.R1PDataVisitor;
import kd.bos.print.core.data.field.CollectionField;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.NullField;
import kd.bos.print.core.exception.PrintException;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.grid.AbstractPWGrid;
import kd.bos.print.core.model.widget.grid.AbstractPWGridRow;
import kd.bos.print.core.model.widget.grid.datagrid.AbstractPWDataGridRow;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGrid;
import kd.bos.print.core.model.widget.runner.grid.AbstractDataGridRunner;
import kd.bos.print.core.model.widget.runner.grid.AbstractGridRunner;
import kd.bos.print.core.model.widget.runner.support.IWholeRowPageRunner;
import kd.bos.print.core.model.widget.runner.support.NotSupportWholeRowPageRunner;

public class TemplateRunner
extends AbstractDataGridRunner {
    private boolean isExecuteBlankRow;
    private boolean isEmptyEntry = false;

    @Override
    public void execute(IWidgetExecuteHelper helper) {
        super.execute(helper);
        PWDataGrid outputGrid = (PWDataGrid)this.getOutputWidget();
        if (outputGrid.isHide()) {
            return;
        }
        int fixedRowCount = outputGrid.getFixedRowCount();
        if (fixedRowCount < 1) {
            throw new PrintException("-1", ResManager.loadKDString((String)"\u6570\u636e\u8868\u683c\u4e2d\u6bcf\u9875\u6253\u5370\u884c\u6570\u4e0d\u53ef\u5c0f\u4e8e1\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TemplateRunner_1", (String)"bos-print-core", (Object[])new Object[0]));
        }
        int rowCount = outputGrid.getRowsCount();
        R1PDataVisitor dataVisitor = this.getDataVisitor();
        if (dataVisitor == null) {
            this.executeNoDataGrid(outputGrid, fixedRowCount, rowCount);
        } else {
            CollectionField entryField = dataVisitor.getCollectionField(outputGrid.getDatasource(), outputGrid.getKey());
            PdIterator iterator = entryField.iterator();
            outputGrid.getContext().setGridIterator(iterator);
            boolean isFirstOutput = Boolean.TRUE;
            if (!iterator.hasNext()) {
                this.executeNoDataGrid(outputGrid, fixedRowCount, rowCount);
            } else {
                while (iterator.hasNext()) {
                    for (int i = 0; i < rowCount; ++i) {
                        AbstractPWDataGridRow row = (AbstractPWDataGridRow)outputGrid.getRow(i);
                        row.setContext(outputGrid.getContext());
                        if (row.getRowType() == 1) {
                            if (isFirstOutput || row.isDisplayEveryPage()) {
                                this.executeTitleRow(outputGrid, row);
                            }
                        } else if (row.getRowType() == 2) {
                            for (int loop = 0; loop < fixedRowCount; ++loop) {
                                if (iterator.hasNext()) {
                                    this.iterateDetailRow(outputGrid, row, iterator);
                                    continue;
                                }
                                this.executeBlankRow(outputGrid, row);
                            }
                        } else if (row.getRowType() == 3 && (!iterator.hasNext() || row.isDisplayEveryPage())) {
                            this.executeStatRow(outputGrid, row);
                        }
                        outputGrid.addRowCursor();
                    }
                    isFirstOutput = Boolean.FALSE;
                    this.executePagination(outputGrid);
                    if (!iterator.hasNext()) continue;
                    this.statSet.clearPageStat();
                    outputGrid.setPageIndex(outputGrid.getPageIndex() + 1);
                    outputGrid.getContext().setMaxHeightToAdjust(outputGrid.getContext().getContainerHeight());
                }
            }
        }
        this.endOutput(outputGrid);
    }

    private void executeNoDataGrid(PWDataGrid outputGrid, int fixedRowCount, int rowCount) {
        this.isEmptyEntry = true;
        for (int i = 0; i < rowCount; ++i) {
            AbstractPWDataGridRow row = (AbstractPWDataGridRow)outputGrid.getRow(i);
            row.setContext(outputGrid.getContext());
            if (row.getRowType() == 2) {
                for (int loop = 0; loop < fixedRowCount; ++loop) {
                    this.executeTitleRow(outputGrid, row);
                    ++this.detailRowNumber;
                    ++this.detailGroupRowNumber;
                }
            } else {
                this.executeTitleRow(outputGrid, row);
            }
            outputGrid.addRowCursor();
        }
        this.executePagination(outputGrid);
    }

    @Override
    protected AbstractGridRunner.GridDataVisitor getTitleRowGridDataVisitor() {
        return (ds, field) -> {
            PWDataGrid outputWidget = (PWDataGrid)this.getOutputWidget();
            if (String.valueOf(outputWidget.getDatasource()).equals(ds) && this.isEmptyEntry) {
                return NullField.get();
            }
            Field fieldValue = this.helper.getDataHelper().getFieldValue(ds, field.getField());
            return fieldValue;
        };
    }

    private void executeBlankRow(PWDataGrid outputGrid, AbstractPWGridRow row) {
        this.isExecuteBlankRow = true;
        this.executeRow(outputGrid, row, (ds, field) -> NullField.get());
        this.isExecuteBlankRow = false;
        ++this.detailRowNumber;
        ++this.detailGroupRowNumber;
    }

    @Override
    protected boolean isExecuteBlankRow() {
        return this.isExecuteBlankRow;
    }

    @Override
    protected String getFormulaValue(List<Object> formulaData, AbstractPrintWidget outputGrid, AbstractPrintWidget outputCell, IWidgetExecuteHelper helper, AbstractGridRunner.GridDataVisitor visitor) {
        if (this.isExecuteBlankRow) {
            return "";
        }
        return super.getFormulaValue(formulaData, outputGrid, outputCell, helper, visitor);
    }

    @Override
    public void endOutput(AbstractPrintWidget outputWidget) {
        super.endOutput(outputWidget);
        this.outputWidget = null;
    }

    @Override
    protected boolean isAdjuestHeightRow(AbstractPWGridRow outputRow) {
        return false;
    }

    @Override
    public void recordPosition(AbstractPWGrid grid) {
        List outputRows = ((AbstractPWGrid)this.outputWidget).getOutputRows();
        double gridHeight = 0.0;
        for (AbstractPWGridRow row : outputRows) {
            Object cell = row.getCell(0);
            if (cell == null) continue;
            gridHeight += ((AbstractPrintWidget)cell).getRectangle().getHeight();
        }
        Rectangle rectangle = grid.getRectangle();
        rectangle.setRect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), gridHeight);
        if (this.outputWidget.isCanvasWidget()) {
            this.getRelativeContext().recordPosition(grid);
        }
    }

    @Override
    public void beginOutput(AbstractPrintWidget outputWidget) {
        if (outputWidget.isCanvasWidget()) {
            this.fireBeforeInitWedget(outputWidget);
            this.getRelativeContext().recordPosition(outputWidget);
        }
    }

    @Override
    protected void beforeExecuteRow(PWDataGrid outputGrid) {
        int rowCursor;
        int rowHeight;
        int maxAdjustHeight = outputGrid.getContext().getMaxHeightToAdjust();
        if (maxAdjustHeight < (rowHeight = ((AbstractPWDataGridRow)outputGrid.getRow(rowCursor = outputGrid.getRowCursor())).getHeight())) {
            throw new PrintException("0", ResManager.loadKDString((String)"\u6253\u5370\u6267\u884c\u8fc7\u7a0b\u4e2d\u9047\u5230\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u6a21\u677f\u8bbe\u8ba1\u4e0d\u5408\u7406\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u8868\u683c\u8bbe\u8ba1\u65f6\uff0c\u662f\u5426\u8d85\u51fa\u753b\u5e03\u3002", (String)"TemplateRunner_0", (String)"bos-print-core", (Object[])new Object[0]), 1);
        }
    }

    @Override
    protected void executePagination(PWDataGrid outputGrid) {
        this.cacheOutput(outputGrid);
        outputGrid.getContext().setRowCursor(0);
    }

    @Override
    public IWholeRowPageRunner createWholeRowPageRunner() {
        IWholeRowPageRunner wholeRowPageRunner = super.createWholeRowPageRunner();
        if (wholeRowPageRunner instanceof NotSupportWholeRowPageRunner) {
            return wholeRowPageRunner;
        }
        return new NotSupportWholeRowPageRunner();
    }
}

