/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.runner.grid;

import java.util.ArrayList;
import java.util.List;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import kd.bos.print.core.data.PdIterator;
import kd.bos.print.core.data.R1PDataVisitor;
import kd.bos.print.core.data.field.CollectionField;
import kd.bos.print.core.model.widget.grid.AbstractPWGrid;
import kd.bos.print.core.model.widget.grid.datagrid.AbstractPWDataGridRow;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGrid;
import kd.bos.print.core.model.widget.grid.datagrid.context.GridExecuteContext;
import kd.bos.print.core.model.widget.runner.grid.AbstractDataGridRunner;
import kd.bos.print.core.model.widget.runner.support.IWholeRowPageRunner;
import kd.bos.print.core.model.widget.runner.support.NotSupportWholeRowPageRunner;
import kd.bos.print.core.model.widget.runner.support.TitleEveryWholeRowPageRunner;
import kd.bos.print.core.model.widget.runner.util.SubGridUtils;

public class TitleRowEveryPageRunner
extends AbstractDataGridRunner {
    private List<AbstractPWDataGridRow> titleRows;

    @Override
    public void execute(IWidgetExecuteHelper helper) {
        super.execute(helper);
        PWDataGrid outputGrid = (PWDataGrid)this.getOutputWidget();
        if (outputGrid.isHide()) {
            return;
        }
        int rowCount = outputGrid.getRowsCount();
        while (outputGrid.getRowCursor() < rowCount) {
            AbstractPWDataGridRow row = (AbstractPWDataGridRow)outputGrid.getRow(outputGrid.getRowCursor());
            row.setContext(outputGrid.getContext());
            if (row.getRowType() == 1) {
                if (this.titleRows == null) {
                    this.titleRows = new ArrayList<AbstractPWDataGridRow>();
                }
                this.titleRows.add(row);
            } else if (row.getRowType() == 2) {
                this.executeTitleRows();
                R1PDataVisitor dataVisitor = this.getDataVisitor();
                if (dataVisitor == null) {
                    this.executeTitleRow(outputGrid, row);
                    outputGrid.addRowCursor();
                } else {
                    CollectionField entryField = dataVisitor.getCollectionField(outputGrid.getDatasource(), outputGrid.getKey());
                    PdIterator iterator = entryField.iterator();
                    outputGrid.getContext().setGridIterator(iterator);
                    while (iterator.hasNext()) {
                        this.iterateDetailRow(outputGrid, row, iterator);
                    }
                }
            } else if (row.getRowType() == 3) {
                this.executeStatRow(outputGrid, row);
            }
            outputGrid.addRowCursor();
        }
        this.cacheOutput(outputGrid);
        this.endOutput(outputGrid);
    }

    private void executeTitleRows() {
        if (this.titleRows == null || this.titleRows.size() < 1) {
            return;
        }
        PWDataGrid outputWidget = (PWDataGrid)this.getOutputWidget();
        GridExecuteContext context = outputWidget.getContext();
        int rowCursor = context.getRowCursor();
        int i = 0;
        while (i < this.titleRows.size()) {
            AbstractPWDataGridRow row = this.titleRows.get(i);
            outputWidget.setRowCursor(row.getRowIndex());
            this.executeTitleRow(outputWidget, row);
            if (outputWidget.isWholeRowPage() && context.isRowPagination() && context.getRowType() == ((AbstractPWDataGridRow)outputWidget.getRow(row.getRowIndex())).getRowType()) continue;
            ++i;
        }
        context.setRowCursor(rowCursor);
    }

    @Override
    protected boolean needPagination(AbstractPWGrid outputGrid) {
        boolean isNeedPagine = super.needPagination(outputGrid);
        if (isNeedPagine && outputGrid instanceof PWDataGrid) {
            this.judgeTitleRowOut((PWDataGrid)outputGrid);
        }
        return isNeedPagine;
    }

    @Override
    protected void executePagination(PWDataGrid outputGrid) {
        if (!this.needPagination(outputGrid) && !this.needWholePagination(outputGrid)) {
            return;
        }
        super.executePagination(outputGrid);
        if (SubGridUtils.checkVSubGrid(outputGrid) || outputGrid.isSkipTitleEvery()) {
            outputGrid.setSkipTitleEvery(false);
            return;
        }
        this.executeTitleRows();
    }

    @Override
    public IWholeRowPageRunner createWholeRowPageRunner() {
        IWholeRowPageRunner wholeRowPageRunner = super.createWholeRowPageRunner();
        if (wholeRowPageRunner instanceof NotSupportWholeRowPageRunner) {
            return wholeRowPageRunner;
        }
        return new TitleEveryWholeRowPageRunner((AbstractPWGrid)this.getOutputWidget());
    }
}

