/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.runner.grid.subGrid;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.ctrl.common.util.StringUtil;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.DelayVarProvider;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.field.CollectionField;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.ImageField;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.execute.render.common.linewrap.param.LineWrapParam;
import kd.bos.print.core.model.designer.grid.MergeBlock;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.AbstractPrintWidgetText;
import kd.bos.print.core.model.widget.PWText;
import kd.bos.print.core.model.widget.PrintAtPage;
import kd.bos.print.core.model.widget.StyleAccess;
import kd.bos.print.core.model.widget.grid.AbstractPWGridCell;
import kd.bos.print.core.model.widget.grid.AbstractPWGridColumn;
import kd.bos.print.core.model.widget.grid.AbstractPWGridRow;
import kd.bos.print.core.model.widget.grid.MergeType;
import kd.bos.print.core.model.widget.grid.datagrid.AbstractPWDataGridRow;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGrid;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGridCell;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGridColumn;
import kd.bos.print.core.model.widget.grid.datagrid.PWDetailRow;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.ACellValue;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueField;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueStat;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueText;
import kd.bos.print.core.model.widget.runner.TextRunner;
import kd.bos.print.core.model.widget.runner.grid.AbstractDataGridRunner;
import kd.bos.print.core.model.widget.runner.grid.AbstractGridRunner;
import kd.bos.print.core.model.widget.runner.grid.subGrid.Tuple3;
import kd.bos.print.core.model.widget.runner.stat.GridStatSet;
import kd.bos.print.core.model.widget.runner.support.IWholeRowPageRunner;
import kd.bos.print.core.model.widget.runner.support.NotSupportWholeRowPageRunner;
import kd.bos.print.core.model.widget.runner.util.AdjustHeightUtil;
import kd.bos.print.core.model.widget.runner.util.SubGridUtils;

public class HSubGridRunner
extends AbstractDataGridRunner {
    private static final Log log = LogFactory.getLog(HSubGridRunner.class);
    private int currentTitleIndex = 0;
    private int currentStatIndex = 0;
    private int currentDataIndex = 0;
    private Queue<AbstractPWGridRow> unExecuteRow = new LinkedList<AbstractPWGridRow>();
    private List<DataRowSet> subRowSets = new ArrayList<DataRowSet>();
    private Set<AbstractPWGridRow> parentOutputRows = new HashSet<AbstractPWGridRow>();
    private Set<AbstractPWGridRow> subOutputRows = new HashSet<AbstractPWGridRow>();
    private Queue<String> pagingFlagQ = new LinkedList<String>();
    private boolean statRowPaging = false;
    private Queue<AbstractPWDataGridRow> statRowsQ;
    private Queue<AbstractPWDataGridRow> pStatRowsQ;
    private List<AbstractPWGridRow> pOutputStatRows = new ArrayList<AbstractPWGridRow>(10);
    private List<AbstractPWGridRow> sOutputStatRows = new ArrayList<AbstractPWGridRow>(10);

    @Override
    public void execute(IWidgetExecuteHelper helper) {
        super.execute(helper);
        this.helper = helper;
        if (this.statSet == null) {
            this.statSet = new GridStatSet((PWDataGrid)this.getOutputWidget());
        }
    }

    public void resetDataIndex(CollectionField subGridValue) {
        this.currentDataIndex = 0;
        this.parentOutputRows.clear();
        this.subOutputRows.clear();
        this.pagingFlagQ.clear();
        if (CollectionUtils.isEmpty((Collection)subGridValue.getValue())) {
            this.subRowSets = subGridValue.getValue();
        } else {
            this.subRowSets = new ArrayList<DataRowSet>(10);
            this.subRowSets.addAll((Collection<DataRowSet>)subGridValue.getValue());
        }
    }

    public void executeSubGrid(PWDataGrid parentOutputGrid, AbstractPWGridRow parentOutputRow, CollectionField data) {
        PWDataGrid subDataGrid = (PWDataGrid)this.getOutputWidget();
        if (1 == parentOutputRow.getRowType()) {
            if (this.currentTitleIndex < SubGridUtils.getTitleRowCount(subDataGrid)) {
                AbstractPWDataGridRow subTitleRow = (AbstractPWDataGridRow)subDataGrid.getRow(this.currentTitleIndex);
                ArrayList<AbstractPWDataGridRow> paginationRows = null;
                if (this.needPagination(parentOutputGrid)) {
                    paginationRows = new ArrayList<AbstractPWDataGridRow>(parentOutputGrid.getOutputRows().size());
                    paginationRows.addAll(parentOutputGrid.getOutputRows());
                }
                this.executeSubGridTitleRow(parentOutputGrid, parentOutputRow, subTitleRow);
                if (paginationRows != null) {
                    SubGridUtils.subGridBorderHandler(parentOutputGrid, subDataGrid, 1, paginationRows);
                }
                ++this.currentTitleIndex;
            }
            int pGridTitleRowN = SubGridUtils.getTitleRowCount(parentOutputGrid);
            int sGridTitleRowN = SubGridUtils.getTitleRowCount(subDataGrid);
            if (this.currentTitleIndex == pGridTitleRowN && this.currentTitleIndex < sGridTitleRowN) {
                int addIndex = parentOutputGrid.getOutputRows().size() - 1;
                while (this.currentTitleIndex < sGridTitleRowN) {
                    AbstractPWDataGridRow subTitleRow = (AbstractPWDataGridRow)subDataGrid.getRow(this.currentTitleIndex);
                    AbstractPWGridRow outputTitleRow = (AbstractPWGridRow)((AbstractPWDataGridRow)parentOutputGrid.getOutputRows().get(0)).copy();
                    for (int i = 0; i < parentOutputGrid.getColumnCount(); ++i) {
                        outputTitleRow.addCell(null);
                    }
                    outputTitleRow.setHeight(subTitleRow.getHeight());
                    outputTitleRow.setAddRow(true);
                    this.executeSubGridTitleRow(parentOutputGrid, outputTitleRow, subTitleRow);
                    parentOutputGrid.outputRow((AbstractPWDataGridRow)outputTitleRow);
                    ++this.currentTitleIndex;
                    ++addIndex;
                }
            }
            boolean adjustHeight = false;
            if (sGridTitleRowN > pGridTitleRowN && this.currentTitleIndex == sGridTitleRowN) {
                adjustHeight = true;
            } else if (sGridTitleRowN < pGridTitleRowN && (parentOutputGrid.getRowCursor() + 1 == pGridTitleRowN || parentOutputGrid.getRowCursor() == pGridTitleRowN)) {
                adjustHeight = true;
            } else if (sGridTitleRowN == pGridTitleRowN && this.currentTitleIndex == pGridTitleRowN) {
                adjustHeight = true;
            }
            if (adjustHeight) {
                SubGridUtils.adjustRowHeight(parentOutputGrid, subDataGrid, 1);
            }
        } else if (2 == parentOutputRow.getRowType()) {
            this.dealSubGridDetailRow(parentOutputGrid, subDataGrid, parentOutputRow, data);
        } else if (3 == parentOutputRow.getRowType()) {
            this.dealSubGridStatRow(parentOutputGrid, subDataGrid, parentOutputRow);
        }
    }

    private void dealSubGridStatRow(PWDataGrid parentOutputGrid, PWDataGrid subDataGrid, AbstractPWGridRow parentOutputRow) {
        int i;
        AbstractPWDataGridRow sOutputStatRow;
        if (this.currentStatIndex == 0) {
            this.parentOutputRows.clear();
            this.subOutputRows.clear();
            this.pagingFlagQ.clear();
            this.statRowsQ = SubGridUtils.getRowsByType(subDataGrid, 3);
            this.pStatRowsQ = SubGridUtils.getRowsByType(parentOutputGrid, 3);
            this.pOutputStatRows.clear();
            this.sOutputStatRows.clear();
        }
        ++this.currentStatIndex;
        this.pStatRowsQ.poll();
        this.parentOutputRows.add(parentOutputRow);
        this.pOutputStatRows.add(parentOutputRow);
        AbstractPWDataGridRow subStatRow = this.statRowsQ.peek();
        if (subStatRow != null) {
            int remainHeight;
            int needHeight = subStatRow.getHeight();
            if (needHeight > (remainHeight = parentOutputGrid.getContext().getMaxHeightToAdjust() + parentOutputRow.getHeight())) {
                SubGridUtils.addEmptyCellToRow(parentOutputGrid, subDataGrid, parentOutputRow, subStatRow);
                this.sOutputStatRows.add(subStatRow);
            } else {
                subStatRow = this.statRowsQ.poll();
                if (subStatRow != null) {
                    parentOutputGrid.getContext().setMaxHeightToAdjust(parentOutputGrid.getContext().getMaxHeightToAdjust() + parentOutputRow.getHeight());
                    sOutputStatRow = (AbstractPWDataGridRow)subStatRow.copy();
                    for (i = 0; i < subDataGrid.getColumnCount(); ++i) {
                        PWDataGridCell cell = (PWDataGridCell)((PWDataGridCell)subStatRow.getCell(i)).copy();
                        cell.setRowIndex(subStatRow.getRowIndex());
                        sOutputStatRow.addCell(cell);
                    }
                    this.executeSubGridStatRow(parentOutputGrid, parentOutputRow, sOutputStatRow);
                    parentOutputGrid.getContext().setMaxHeightToAdjust(parentOutputGrid.getContext().getMaxHeightToAdjust() - Math.max(sOutputStatRow.getHeight(), parentOutputRow.getHeight()));
                    this.sOutputStatRows.add(sOutputStatRow);
                }
            }
        } else if (this.statRowPaging && this.statRowsQ.isEmpty() && this.sOutputStatRows.isEmpty()) {
            Object sStatRow = subDataGrid.getRow(subDataGrid.getRowsCount() - 1);
            AbstractPWGridRow sOutputStatRow2 = (AbstractPWGridRow)((AbstractPWGridRow)sStatRow).copy();
            for (int i2 = 0; i2 < subDataGrid.getColumnCount(); ++i2) {
                PWDataGridCell cell = (PWDataGridCell)((AbstractPWGridCell)((AbstractPWGridRow)sStatRow).getCell(i2)).copy();
                cell.setRowIndex(((AbstractPWGridRow)sStatRow).getRowIndex());
                sOutputStatRow2.addCell(cell);
            }
            SubGridUtils.addEmptyCellToRow(parentOutputGrid, subDataGrid, parentOutputRow, sOutputStatRow2);
            this.sOutputStatRows.add(sOutputStatRow2);
        }
        if (this.needPagination(parentOutputGrid)) {
            this.statRowPaging = true;
            if (parentOutputGrid.isTitleRowEveryPage()) {
                this.currentTitleIndex = 0;
            }
            SubGridUtils.adjustStatRowHeight(parentOutputGrid, subDataGrid, this.pOutputStatRows, this.sOutputStatRows);
            this.pOutputStatRows.clear();
            this.sOutputStatRows.clear();
            if (this.pStatRowsQ.isEmpty() && !parentOutputRow.isRemainContent()) {
                int index = 0;
                while (this.statRowsQ.peek() != null) {
                    AbstractPWDataGridRow sStatRow = this.statRowsQ.poll();
                    sOutputStatRow = (AbstractPWDataGridRow)sStatRow.copy();
                    for (i = 0; i < subDataGrid.getColumnCount(); ++i) {
                        PWDataGridCell cell = (PWDataGridCell)((PWDataGridCell)sStatRow.getCell(i)).copy();
                        cell.setRowIndex(sStatRow.getRowIndex());
                        sOutputStatRow.addCell(cell);
                    }
                    AbstractPWGridRow outputStatRow = (AbstractPWGridRow)((AbstractPWDataGridRow)parentOutputGrid.getRow(parentOutputGrid.getRowsCount() - 1)).copy();
                    for (int i3 = 0; i3 < parentOutputGrid.getColumnCount(); ++i3) {
                        if (index == 0) {
                            Object tempRow = parentOutputGrid.getRow(parentOutputGrid.getRowsCount() - 1);
                            if (tempRow == null) continue;
                            AbstractPWGridCell rawCell = (AbstractPWGridCell)((AbstractPWGridCell)((AbstractPWGridRow)tempRow).getCell(i3)).copy();
                            rawCell.setRectangle(new Rectangle(((PWDataGridColumn)parentOutputGrid.getColumn(i3)).getWidth(), sOutputStatRow.getHeight()));
                            rawCell.setCellValue(new CellValueText(""));
                            rawCell.setSubCell(false);
                            rawCell.setRowIndex(((AbstractPWGridRow)tempRow).getRowIndex());
                            outputStatRow.addCell(rawCell);
                            continue;
                        }
                        outputStatRow.setAddRow(true);
                        outputStatRow.addCell(null);
                    }
                    this.executeSubGridStatRow(parentOutputGrid, outputStatRow, sOutputStatRow);
                    this.sOutputStatRows.add(sOutputStatRow);
                    this.pOutputStatRows.add(outputStatRow);
                    outputStatRow.setHeight(index == 0 ? sOutputStatRow.getHeight() : 0);
                    parentOutputGrid.outputRow((AbstractPWDataGridRow)outputStatRow);
                    parentOutputGrid.getContext().setMaxHeightToAdjust(parentOutputGrid.getContext().getMaxHeightToAdjust() - sOutputStatRow.getHeight());
                    ++index;
                }
            }
        } else if (this.pStatRowsQ.isEmpty()) {
            boolean isNeedPage = false;
            while (this.statRowsQ.peek() != null) {
                AbstractPWDataGridRow sStatRow = this.statRowsQ.poll();
                sOutputStatRow = (AbstractPWDataGridRow)sStatRow.copy();
                for (i = 0; i < subDataGrid.getColumnCount(); ++i) {
                    PWDataGridCell cell = (PWDataGridCell)((PWDataGridCell)sStatRow.getCell(i)).copy();
                    cell.setRowIndex(sStatRow.getRowIndex());
                    sOutputStatRow.addCell(cell);
                }
                AbstractPWGridRow outputStatRow = (AbstractPWGridRow)((AbstractPWDataGridRow)parentOutputGrid.getRow(parentOutputGrid.getRowsCount() - 1)).copy();
                for (int i4 = 0; i4 < parentOutputGrid.getColumnCount(); ++i4) {
                    if (isNeedPage) {
                        Object tempRow = parentOutputGrid.getRow(parentOutputGrid.getRowsCount() - 1);
                        if (tempRow == null) continue;
                        AbstractPWGridCell rawCell = (AbstractPWGridCell)((AbstractPWGridCell)((AbstractPWGridRow)tempRow).getCell(i4)).copy();
                        rawCell.setRectangle(new Rectangle(((PWDataGridColumn)parentOutputGrid.getColumn(i4)).getWidth(), sOutputStatRow.getHeight()));
                        rawCell.setCellValue(new CellValueText(""));
                        rawCell.setSubCell(false);
                        rawCell.setRowIndex(((AbstractPWGridRow)tempRow).getRowIndex());
                        outputStatRow.addCell(rawCell);
                        continue;
                    }
                    outputStatRow.setAddRow(true);
                    outputStatRow.addCell(null);
                }
                this.executeSubGridStatRow(parentOutputGrid, outputStatRow, sOutputStatRow);
                this.sOutputStatRows.add(sOutputStatRow);
                this.pOutputStatRows.add(outputStatRow);
                outputStatRow.setHeight(isNeedPage ? sOutputStatRow.getHeight() : 0);
                parentOutputGrid.outputRow((AbstractPWDataGridRow)outputStatRow);
                parentOutputGrid.getContext().setMaxHeightToAdjust(parentOutputGrid.getContext().getMaxHeightToAdjust() - sOutputStatRow.getHeight());
                if (!this.needPagination(parentOutputGrid)) continue;
                isNeedPage = true;
                this.statRowPaging = true;
                if (parentOutputGrid.isTitleRowEveryPage()) {
                    this.currentTitleIndex = 0;
                }
                SubGridUtils.adjustStatRowHeight(parentOutputGrid, subDataGrid, this.pOutputStatRows, this.sOutputStatRows);
                this.pOutputStatRows.clear();
                this.sOutputStatRows.clear();
            }
        }
        if (this.pStatRowsQ.isEmpty() && this.statRowsQ.isEmpty()) {
            SubGridUtils.adjustStatRowHeight(parentOutputGrid, subDataGrid, this.pOutputStatRows, this.sOutputStatRows);
            this.pOutputStatRows.clear();
            this.sOutputStatRows.clear();
        }
    }

    private void dealSubGridDetailRow(PWDataGrid parentOutputGrid, PWDataGrid subDataGrid, AbstractPWGridRow parentOutputRow, CollectionField data) {
        AbstractPWGridRow needModifyRow;
        if (this.currentDataIndex == 0) {
            this.parentOutputRows.clear();
            this.subOutputRows.clear();
            this.pagingFlagQ.clear();
        }
        this.parentOutputRows.add(parentOutputRow);
        subDataGrid.getContext().setRowCursor(this.currentTitleIndex);
        Object rowSets = data.getValue();
        AbstractPWDataGridRow rawRow = (AbstractPWDataGridRow)subDataGrid.getRow(subDataGrid.getRowCursor());
        AbstractPWDataGridRow row = (AbstractPWDataGridRow)rawRow.copy();
        if (CollectionUtils.isEmpty(this.subRowSets) && this.unExecuteRow.peek() == null || this.currentDataIndex >= rowSets.size() && this.unExecuteRow.peek() == null) {
            if (parentOutputRow.isBlankRow() && parentOutputGrid.isNotBlankRow()) {
                SubGridUtils.dealBlankRow(parentOutputGrid, this.parentOutputRows, this.subOutputRows, this.pagingFlagQ);
                return;
            }
            int cellCount = rawRow.getCellCount();
            for (int i = 0; i < cellCount; ++i) {
                PWDataGridCell cell = (PWDataGridCell)rawRow.getCell(i);
                cell.setRowIndex(rawRow.getRowIndex());
                row.addCell(cell);
            }
            SubGridUtils.addEmptyCellToRow(parentOutputGrid, subDataGrid, parentOutputRow, row);
            if (this.needPagination(parentOutputGrid) && parentOutputGrid.isTitleRowEveryPage()) {
                this.currentTitleIndex = 0;
            }
            return;
        }
        parentOutputGrid.getContext().setMaxHeightToAdjust(parentOutputGrid.getContext().getMaxHeightToAdjust() + parentOutputRow.getHeight());
        int subRowTotalH = 0;
        boolean parentRowModify = false;
        LinkedList<AbstractPWGridRow> addModifyRowQ = new LinkedList<AbstractPWGridRow>();
        ArrayList<AbstractPWGridRow> outputRows = new ArrayList<AbstractPWGridRow>(10);
        AbstractPWGridRow unExecute = this.unExecuteRow.poll();
        if (unExecute != null) {
            this.executeSubGridDetailRow(parentOutputGrid, parentOutputRow, unExecute, (DataRowSet)rowSets.get(0));
            subRowTotalH += unExecute.getHeight();
            parentOutputGrid.getContext().setMaxHeightToAdjust(parentOutputGrid.getContext().getMaxHeightToAdjust() - unExecute.getHeight());
            if (!parentRowModify && !addModifyRowQ.contains(parentOutputRow)) {
                addModifyRowQ.offer(parentOutputRow);
            }
            outputRows.add(parentOutputRow);
            if (this.needPagination(parentOutputGrid)) {
                needModifyRow = (AbstractPWGridRow)addModifyRowQ.poll();
                if (needModifyRow != null) {
                    if (!needModifyRow.isAddRow()) {
                        parentRowModify = true;
                    }
                    this.adjustModifyRowHeight(parentOutputGrid, subDataGrid, needModifyRow, subRowTotalH, outputRows, this.needPagination(parentOutputGrid));
                    outputRows.clear();
                    subRowTotalH = 0;
                }
                if (parentOutputRow.isRemainContent()) {
                    if (unExecute.isRemainContent()) {
                        this.unExecuteRow.offer(unExecute);
                    }
                    if (parentOutputGrid.isTitleRowEveryPage()) {
                        this.currentTitleIndex = 0;
                    }
                    return;
                }
                if (unExecute.isRemainContent()) {
                    Tuple3<Boolean, Boolean, Integer> result = this.executeSubRowUntilComplete(parentOutputGrid, subDataGrid, parentOutputRow, addModifyRowQ, (AbstractPWDataGridRow)unExecute, (List<DataRowSet>)rowSets, subRowTotalH, outputRows);
                    if (!parentRowModify) {
                        parentRowModify = (Boolean)result.item1;
                    }
                    subRowTotalH = (Integer)result.item3;
                }
            }
        }
        while (this.currentDataIndex < rowSets.size()) {
            AbstractPWGridRow needModifyRow2;
            row = (AbstractPWDataGridRow)rawRow.copy();
            int cellCount = rawRow.getCellCount();
            for (int h = 0; h < cellCount; ++h) {
                PWDataGridCell cell = (PWDataGridCell)rawRow.getCell(h);
                cell.setRowIndex(rawRow.getRowIndex());
                row.addCell(cell);
            }
            DataRowSet rowSet = (DataRowSet)rowSets.get(this.currentDataIndex);
            if (this.currentDataIndex == 0) {
                AbstractPWGridRow needModifyRow3;
                this.executeSubGridDetailRow(parentOutputGrid, parentOutputRow, row, rowSet);
                if (row.isBlankRow()) {
                    this.subOutputRows.add(row);
                }
                subRowTotalH += row.getHeight();
                parentOutputGrid.getContext().setMaxHeightToAdjust(parentOutputGrid.getContext().getMaxHeightToAdjust() - row.getHeight());
                ++this.currentDataIndex;
                if (!parentRowModify && !addModifyRowQ.contains(parentOutputRow)) {
                    addModifyRowQ.offer(parentOutputRow);
                }
                outputRows.add(parentOutputRow);
                if (this.needPagination(parentOutputGrid)) {
                    needModifyRow3 = (AbstractPWGridRow)addModifyRowQ.poll();
                    if (needModifyRow3 != null) {
                        if (!needModifyRow3.isAddRow()) {
                            parentRowModify = true;
                        }
                        this.adjustModifyRowHeight(parentOutputGrid, subDataGrid, needModifyRow3, subRowTotalH, outputRows, this.needPagination(parentOutputGrid));
                        outputRows.clear();
                        subRowTotalH = 0;
                    }
                    if (parentOutputGrid.isTitleRowEveryPage()) {
                        this.currentTitleIndex = 0;
                    }
                    if (parentOutputGrid.isNotBlankRow() && this.currentDataIndex != rowSets.size()) {
                        this.pagingFlagQ.offer("paging");
                    }
                } else if (this.currentDataIndex == rowSets.size()) {
                    this.subRowSets.clear();
                    needModifyRow3 = (AbstractPWGridRow)addModifyRowQ.poll();
                    if (needModifyRow3 != null) {
                        if (!needModifyRow3.isAddRow()) {
                            parentRowModify = true;
                        }
                        this.adjustModifyRowHeight(parentOutputGrid, subDataGrid, needModifyRow3, subRowTotalH, outputRows, this.needPagination(parentOutputGrid));
                        outputRows.clear();
                        subRowTotalH = 0;
                    }
                }
                if (parentOutputGrid.isNotBlankRow() && this.currentDataIndex == rowSets.size()) {
                    SubGridUtils.dealBlankRow(parentOutputGrid, this.parentOutputRows, this.subOutputRows, this.pagingFlagQ);
                }
                if (this.needPagination(parentOutputGrid) && parentOutputRow.isRemainContent()) {
                    if (!row.isRemainContent()) break;
                    this.unExecuteRow.offer(row);
                    break;
                }
                if (!this.needPagination(parentOutputGrid) || parentOutputRow.isRemainContent() || !row.isRemainContent()) continue;
                Tuple3<Boolean, Boolean, Integer> result = this.executeSubRowUntilComplete(parentOutputGrid, subDataGrid, parentOutputRow, addModifyRowQ, row, (List<DataRowSet>)rowSets, subRowTotalH, outputRows);
                if (!parentRowModify) {
                    parentRowModify = (Boolean)result.item1;
                }
                subRowTotalH = (Integer)result.item3;
                continue;
            }
            if (!(parentRowModify || addModifyRowQ.contains(parentOutputRow) || parentOutputRow.isBlankRow())) {
                addModifyRowQ.offer(parentOutputRow);
            }
            boolean shouldDo = true;
            boolean shouldBreak = false;
            while (shouldDo) {
                AbstractPWGridRow actualOutputRow = (AbstractPWGridRow)parentOutputRow.copy();
                actualOutputRow.setAddRow(true);
                actualOutputRow.setBlankRow(parentOutputRow.isBlankRow());
                int parentColumnCount = parentOutputGrid.getColumnCount();
                boolean isNeedPage = this.needPagination(parentOutputGrid);
                if (isNeedPage && !addModifyRowQ.contains(actualOutputRow)) {
                    addModifyRowQ.offer(actualOutputRow);
                }
                for (int j = 0; j < parentColumnCount; ++j) {
                    AbstractPWGridCell rawCell = (AbstractPWGridCell)((AbstractPWGridCell)parentOutputRow.getCell(j)).copy();
                    if (isNeedPage) {
                        rawCell.setStyle(((PWDataGridCell)((AbstractPWDataGridRow)parentOutputGrid.getRow(parentOutputRow.getRowIndex())).getCell(j)).getStyle());
                        actualOutputRow.addCell(rawCell);
                        continue;
                    }
                    actualOutputRow.addCell(null);
                }
                this.executeSubGridDetailRow(parentOutputGrid, actualOutputRow, row, rowSet);
                actualOutputRow.setHeight(0);
                parentOutputGrid.outputRow((AbstractPWDataGridRow)actualOutputRow);
                parentOutputGrid.getContext().setMaxHeightToAdjust(parentOutputGrid.getContext().getMaxHeightToAdjust() - row.getHeight());
                outputRows.add(actualOutputRow);
                this.parentOutputRows.add(actualOutputRow);
                this.subOutputRows.add(row);
                if (this.needPagination(parentOutputGrid)) {
                    if (parentOutputRow.isRemainContent()) {
                        shouldDo = false;
                        shouldBreak = true;
                        if (row.isRemainContent()) {
                            this.unExecuteRow.offer(row);
                            if (this.needPagination(parentOutputGrid) && parentOutputGrid.isTitleRowEveryPage()) {
                                this.currentTitleIndex = 0;
                            }
                        }
                    } else if (!row.isRemainContent()) {
                        shouldDo = false;
                    }
                    if (parentOutputGrid.isTitleRowEveryPage()) {
                        this.currentTitleIndex = 0;
                    }
                } else {
                    shouldDo = false;
                }
                if (!shouldDo) continue;
                subRowTotalH += row.getHeight();
                if (!this.needPagination(parentOutputGrid)) continue;
                AbstractPWGridRow needModifyRow4 = (AbstractPWGridRow)addModifyRowQ.poll();
                if (needModifyRow4 != null) {
                    if (!needModifyRow4.isAddRow()) {
                        parentRowModify = true;
                    }
                    this.adjustModifyRowHeight(parentOutputGrid, subDataGrid, needModifyRow4, subRowTotalH, outputRows, this.needPagination(parentOutputGrid));
                    outputRows.clear();
                    subRowTotalH = 0;
                }
                if (!parentOutputGrid.isTitleRowEveryPage()) continue;
                this.currentTitleIndex = 0;
            }
            ++this.currentDataIndex;
            subRowTotalH += row.getHeight();
            if (this.needPagination(parentOutputGrid)) {
                needModifyRow2 = (AbstractPWGridRow)addModifyRowQ.poll();
                if (needModifyRow2 != null) {
                    if (!needModifyRow2.isAddRow()) {
                        parentRowModify = true;
                    }
                    this.adjustModifyRowHeight(parentOutputGrid, subDataGrid, needModifyRow2, subRowTotalH, outputRows, this.needPagination(parentOutputGrid));
                    outputRows.clear();
                    subRowTotalH = 0;
                    if (this.currentDataIndex == rowSets.size()) {
                        this.subRowSets.clear();
                    }
                }
                if (parentOutputGrid.isTitleRowEveryPage()) {
                    this.currentTitleIndex = 0;
                }
                if (parentOutputGrid.isNotBlankRow() && this.currentDataIndex != rowSets.size()) {
                    this.pagingFlagQ.offer("paging");
                }
            } else if (this.currentDataIndex == rowSets.size()) {
                this.subRowSets.clear();
                needModifyRow2 = (AbstractPWGridRow)addModifyRowQ.poll();
                if (needModifyRow2 != null) {
                    if (!needModifyRow2.isAddRow()) {
                        parentRowModify = true;
                    }
                    this.adjustModifyRowHeight(parentOutputGrid, subDataGrid, needModifyRow2, subRowTotalH, outputRows, this.needPagination(parentOutputGrid));
                    outputRows.clear();
                    subRowTotalH = 0;
                }
            }
            if (parentOutputGrid.isNotBlankRow() && this.currentDataIndex == rowSets.size()) {
                SubGridUtils.dealBlankRow(parentOutputGrid, this.parentOutputRows, this.subOutputRows, this.pagingFlagQ);
            }
            if (!shouldBreak) continue;
            break;
        }
        if (this.currentDataIndex == rowSets.size() && !parentOutputRow.isRemainContent()) {
            this.currentDataIndex = 0;
        }
        if ((needModifyRow = (AbstractPWGridRow)addModifyRowQ.poll()) != null) {
            if (!needModifyRow.isAddRow()) {
                parentRowModify = true;
            }
            this.adjustModifyRowHeight(parentOutputGrid, subDataGrid, needModifyRow, subRowTotalH, outputRows, this.needPagination(parentOutputGrid));
            outputRows.clear();
        }
    }

    private void adjustModifyRowHeight(PWDataGrid parentOutputGrid, PWDataGrid subDataGrid, AbstractPWGridRow needModifyRow, int subRowTotalH, List<AbstractPWGridRow> outputRows, boolean isNeedPage) {
        int maxHeight = Math.max(needModifyRow.getHeight(), subRowTotalH);
        if (needModifyRow.getHeight() <= subRowTotalH) {
            for (int k = 0; k < parentOutputGrid.getColumnCount(); ++k) {
                Object cell = needModifyRow.getCell(k);
                if (cell == null) continue;
                Rectangle rectangle = ((AbstractPrintWidget)cell).getRectangle();
                ((AbstractPWGridCell)cell).setRowIndex(needModifyRow.getRowIndex());
                ((AbstractPrintWidget)cell).setRectangle(new Rectangle(rectangle.x, rectangle.y, rectangle.width, subRowTotalH));
                if (!isNeedPage) continue;
                SubGridUtils.adjustCellStyle(parentOutputGrid, subDataGrid, cell, k);
            }
        } else if (needModifyRow.getHeight() > subRowTotalH) {
            int i;
            LinkedList<Integer> addHeightQ = new LinkedList<Integer>();
            int diffHeight = needModifyRow.getHeight() - subRowTotalH;
            int rowCount = outputRows.size();
            int avgH = diffHeight / rowCount;
            int value = diffHeight % rowCount;
            for (i = 0; i < rowCount; ++i) {
                if (i == 0) {
                    addHeightQ.add(avgH + value);
                    continue;
                }
                addHeightQ.add(avgH);
            }
            for (i = 0; i < rowCount; ++i) {
                AbstractPWGridRow row = outputRows.get(i);
                if (row == null) continue;
                int cellCount = row.getCellCount();
                Integer addH = (Integer)addHeightQ.poll();
                for (int j = 0; j < cellCount; ++j) {
                    Object cell = row.getCell(j);
                    if (cell != null && ((AbstractPWGridCell)cell).isSubCell() && addH != null) {
                        ((AbstractPWGridCell)cell).setRowIndex(row.getRowIndex());
                        Rectangle rectangle = ((AbstractPrintWidget)cell).getRectangle();
                        ((AbstractPrintWidget)cell).setRectangle(new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height + addH));
                        if (!isNeedPage) continue;
                        SubGridUtils.adjustCellStyle(parentOutputGrid, subDataGrid, cell, j);
                        continue;
                    }
                    if (cell == null || ((AbstractPWGridCell)cell).isSubCell()) continue;
                    ((AbstractPWGridCell)cell).setRowIndex(row.getRowIndex());
                    if (!isNeedPage) continue;
                    SubGridUtils.adjustCellStyle(parentOutputGrid, subDataGrid, cell, j);
                }
            }
            int cellCount = needModifyRow.getCellCount();
            for (int i2 = 0; i2 < cellCount; ++i2) {
                Object cell = needModifyRow.getCell(i2);
                if (cell == null || ((AbstractPWGridCell)cell).isSubCell()) continue;
                ((AbstractPWGridCell)cell).setRowIndex(needModifyRow.getRowIndex());
                if (!isNeedPage) continue;
                SubGridUtils.adjustCellStyle(parentOutputGrid, subDataGrid, cell, i2);
            }
            parentOutputGrid.getContext().setMaxHeightToAdjust(parentOutputGrid.getContext().getMaxHeightToAdjust() - (needModifyRow.getHeight() - subRowTotalH));
            if (this.needPagination(parentOutputGrid) && parentOutputGrid.isTitleRowEveryPage()) {
                this.currentTitleIndex = 0;
            }
        }
        needModifyRow.setHeight(maxHeight);
    }

    private void executeSubGridStatRow(PWDataGrid parentOutputGrid, AbstractPWGridRow parentRow, AbstractPWGridRow subGridRow) {
        this.executeSubGridRow(parentOutputGrid, parentRow, subGridRow, new AbstractGridRunner.GridDataVisitor(){

            @Override
            public Field getFieldVal(String ds, CellValueField field) {
                return HSubGridRunner.this.getStatVal(ds, (CellValueStat)field);
            }
        });
    }

    private void executeSubGridDetailRow(PWDataGrid parentOutputGrid, AbstractPWGridRow parentRow, AbstractPWGridRow subGridRow, final DataRowSet rowSet) {
        if (!subGridRow.isRemainContent()) {
            this.statSet.doStats(rowSet);
        }
        this.executeSubGridRow(parentOutputGrid, parentRow, subGridRow, new AbstractGridRunner.GridDataVisitor(){

            @Override
            public Field getFieldVal(String ds, CellValueField cellValue) {
                return rowSet.getField(cellValue.getField());
            }
        });
        ++this.detailRowNumber;
        ++this.detailGroupRowNumber;
    }

    public void executeSubGridTitleRow(PWDataGrid parentOutputGrid, AbstractPWGridRow parentOutputRow, AbstractPWGridRow subGridRow) {
        this.executeSubGridRow(parentOutputGrid, parentOutputRow, subGridRow, new AbstractGridRunner.GridDataVisitor(){

            @Override
            public Field getFieldVal(String ds, CellValueField cellValue) {
                Field fieldValue = HSubGridRunner.this.helper.getDataHelper().getFieldValue(ds, cellValue.getField());
                return fieldValue;
            }
        });
    }

    private void executeSubGridRow(PWDataGrid parentOutputGrid, AbstractPWGridRow parentOutputRow, AbstractPWGridRow subGridRow, AbstractGridRunner.GridDataVisitor visitor) {
        Object cell;
        int rowHeight;
        this.beforeExecuteRow(parentOutputGrid);
        PWDataGrid subDataGrid = (PWDataGrid)this.getOutputWidget();
        int columnCursor = 0;
        int columnCount = subDataGrid.getColumnCount();
        int maxHeightToAdjust = parentOutputGrid.getContext().getMaxHeightToAdjust();
        boolean remainContent = subGridRow.isRemainContent();
        if (remainContent) {
            int remainHeight = subGridRow.getReaminHeight();
            if (remainHeight < MIN_ROW_HEIGHT) {
                remainHeight = MIN_ROW_HEIGHT;
            }
            subGridRow.setHeight(remainHeight);
            subGridRow.setRemainContent(false);
            subGridRow.setReaminHeight(0);
        }
        int realHeight = rowHeight = subGridRow.getHeight();
        if (rowHeight > maxHeightToAdjust) {
            realHeight = maxHeightToAdjust;
            int remainHeight = rowHeight - maxHeightToAdjust;
            subGridRow.setReaminHeight(remainHeight);
            subGridRow.setRemainContent(true);
        }
        int realMaxRowHeight = 0;
        boolean isBlankRow = true;
        boolean rowRemain = false;
        while (columnCursor < columnCount) {
            int width;
            Object column = subDataGrid.getColumn(columnCursor);
            int columnWidth = ((AbstractPWGridColumn)column).getWidth();
            cell = subGridRow.getCell(columnCursor);
            AbstractPWGridCell outputCell = (AbstractPWGridCell)((AbstractPWGridCell)cell).copy();
            String outputText = "";
            String dataSource = outputCell.getDatasource();
            ACellValue cellValue = outputCell.getCellValue();
            if (remainContent) {
                int remainHeight = subGridRow.getReaminHeight();
                outputText = ((AbstractPrintWidgetText)cell).getOutputText();
                if (remainHeight != 0) {
                    subGridRow.setHeight(remainHeight);
                }
            } else if (StringUtils.isBlank((CharSequence)dataSource)) {
                if (cellValue instanceof CellValueText) {
                    outputText = ((CellValueText)cellValue).getValue();
                    Field outputValue = null;
                    List<Object> formulaData = outputCell.getFormulaData();
                    TextRunner runner = (TextRunner)outputCell.getRunner();
                    if (formulaData != null && !formulaData.isEmpty()) {
                        if (subGridRow instanceof PWDetailRow) {
                            subDataGrid.setPageIndex(parentOutputGrid.getPageIndex());
                            outputValue = new TextField(this.getFormulaValue(formulaData, subDataGrid, outputCell, this.helper, visitor));
                        } else {
                            outputValue = new TextField(runner.getFormulaValue(formulaData, subDataGrid, this.helper));
                        }
                    } else {
                        outputValue = new TextField(outputText);
                    }
                    if (outputValue != null) {
                        outputCell.setOriOutPutText(outputValue.toString());
                        outputValue = runner.formatOutputValue(outputValue);
                        outputText = outputValue.toString();
                    }
                }
            } else if (StringUtil.equals(dataSource, "$DsKey=[System]")) {
                if (parentOutputGrid.getPrintAtPage() != PrintAtPage.All) {
                    if (StringUtil.equals(outputCell.getBindField(), "=getRowNumber()")) {
                        if (subGridRow instanceof PWDetailRow) {
                            TextField outputValue = new TextField(String.valueOf(this.detailRowNumber));
                            outputText = outputValue.toString();
                        } else {
                            outputText = "1";
                        }
                    } else {
                        Object formulaResult = this.runFormula(this.helper, outputCell, outputCell.getBindField());
                        TextField outputValue = new TextField(formulaResult == null ? "" : formulaResult.toString());
                        outputText = outputValue.toString();
                    }
                }
            } else if (cellValue instanceof CellValueStat) {
                CellValueStat statField = (CellValueStat)cellValue;
                Field outputValue = visitor.getFieldVal(dataSource, statField);
                TextRunner runner = (TextRunner)outputCell.getRunner();
                outputValue = runner.formatOutputValue(outputValue);
                outputText = outputValue.toString();
            } else if (cellValue instanceof CellValueField) {
                CellValueField cellField = (CellValueField)cellValue;
                Field outputValue = visitor.getFieldVal(dataSource, cellField);
                if (outputValue instanceof ImageField) {
                    boolean hasImage = this.showImageField(outputCell, (ImageField)outputValue, realHeight, columnWidth);
                    if (hasImage) {
                        isBlankRow = false;
                    }
                    outputText = "";
                } else {
                    TextRunner runner = (TextRunner)outputCell.getRunner();
                    outputValue = runner.formatOutputValue(outputValue);
                    outputText = outputValue.toString();
                }
            }
            if (outputCell.isAnchor()) {
                outputCell.setLinkUrl(((TextRunner)outputCell.getRunner()).queryAnchorLink(visitor));
            }
            if (subGridRow.isRemainContent()) {
                width = columnWidth;
                int height = realHeight;
                AdjustHeightUtil.AdjustInfo adjustInfo = AdjustHeightUtil.getInstance().adjustHeight(new LineWrapParam.Builder(outputText, ((PWText)cell).getLineWrapRule()).style(StyleAccess.getStyle(outputCell)).wordFlex(outputCell.isWordFlex()).minW(width).maxW(this.getRelativeContext().getEmptyPage().getRectangle().width).minH(height).maxH(maxHeightToAdjust).build());
                outputCell.setTextHeight(adjustInfo.getTextHeight());
                outputCell.setFlexOffset(adjustInfo.getFlexOffset());
                outputText = adjustInfo.getUsedText();
                ((AbstractPrintWidgetText)cell).setOutputText(adjustInfo.getRemainText());
                if (adjustInfo.getRemainText() != null) {
                    rowRemain = true;
                }
            } else if (subGridRow.isAdjustHeight() && subGridRow.getRowType() != 3) {
                width = columnWidth;
                int height = realHeight;
                if (((AbstractPWGridCell)cell).getMergeType() == MergeType.Merged) {
                    MergeBlock mergeBlock = ((AbstractPWGridCell)cell).getMergeBlock();
                    Dimension mergeInfo = this.getMergeInfo(mergeBlock);
                    width = mergeInfo.width;
                    height = mergeInfo.height;
                }
                AdjustHeightUtil.AdjustInfo adjustInfo = AdjustHeightUtil.getInstance().adjustHeight(new LineWrapParam.Builder(outputText, ((PWText)cell).getLineWrapRule()).style(StyleAccess.getStyle(outputCell)).wordFlex(outputCell.isWordFlex()).minW(width).maxW(this.getRelativeContext().getEmptyPage().getRectangle().width).minH(height).maxH(maxHeightToAdjust).build());
                outputCell.setTextHeight(adjustInfo.getTextHeight());
                outputCell.setFlexOffset(adjustInfo.getFlexOffset());
                int usedHeight = adjustInfo.getUsedHeight();
                realHeight = usedHeight < height ? realHeight : realHeight + usedHeight - height;
                outputCell.setAdjustHeight(true);
                ((AbstractPrintWidgetText)cell).setAdjustHeight(true);
                if (this.rowOverPage()) {
                    String remainText = adjustInfo.getRemainText();
                    if (DelayVarProvider.isBindDelayVar(outputCell)) {
                        remainText = null;
                    } else {
                        outputText = adjustInfo.getUsedText();
                    }
                    ((AbstractPrintWidgetText)cell).setOutputText(remainText);
                    if (!subGridRow.isRemainContent() && remainText != null) {
                        rowRemain = true;
                        subGridRow.setRemainContent(true);
                    }
                } else if (!DelayVarProvider.isBindDelayVar(outputCell)) {
                    outputText = adjustInfo.getUsedText();
                }
            } else {
                ((AbstractPrintWidgetText)cell).setOutputText("");
                ((PWText)cell).setRemainContent(false);
            }
            outputCell.setRectangle(new Rectangle(columnWidth, realHeight));
            outputCell.setOutputText(outputText);
            outputCell.setSubCell(true);
            outputCell.setRowIndex(subGridRow.getRowIndex());
            parentOutputRow.addCell(outputCell);
            if (parentOutputGrid.isNotBlankRow() && !this.subRowSets.isEmpty() && this.currentDataIndex == this.subRowSets.size() - 1) {
                SubGridUtils.adjustCellStyle(parentOutputGrid, subDataGrid, outputCell, columnCursor);
            }
            if (realHeight > realMaxRowHeight) {
                realMaxRowHeight = realHeight;
            }
            if (StringUtils.isNotBlank((CharSequence)outputText)) {
                isBlankRow = false;
            }
            ++columnCursor;
        }
        subGridRow.setRemainContent(rowRemain);
        if (subGridRow.isAdjustHeight() || subGridRow.isRemainContent()) {
            int cellCount = parentOutputRow.getCellCount();
            int cellIndex = parentOutputGrid.getColumnCount();
            while (cellIndex < cellCount) {
                cell = parentOutputRow.getCell(cellIndex);
                if (cell == null) {
                    ++cellIndex;
                    continue;
                }
                ((AbstractPWGridCell)cell).adjustHeight(realMaxRowHeight);
                ++cellIndex;
            }
        }
        subGridRow.setHeight(realMaxRowHeight);
        if (isBlankRow && (parentOutputGrid.isNotBlankRow() || remainContent)) {
            subGridRow.setBlankRow(true);
        }
    }

    @Override
    protected void executePagination(PWDataGrid outputGrid) {
        if (!this.needPagination(outputGrid)) {
            return;
        }
        super.executePagination(outputGrid);
        if (outputGrid.isTitleRowEveryPage()) {
            this.currentTitleIndex = 0;
            int rowCount = outputGrid.getRowsCount();
            ArrayList<AbstractPWDataGridRow> titleRows = new ArrayList<AbstractPWDataGridRow>(10);
            for (int i = 0; i < rowCount; ++i) {
                AbstractPWDataGridRow row = (AbstractPWDataGridRow)outputGrid.getRow(i);
                if (1 != row.getRowType()) continue;
                titleRows.add(row);
            }
            for (int j = 0; j < titleRows.size(); ++j) {
                this.executeTitleRow(outputGrid, (AbstractPWGridRow)titleRows.get(j));
            }
        }
    }

    private Tuple3<Boolean, Boolean, Integer> executeSubRowUntilComplete(PWDataGrid parentOutputGrid, PWDataGrid subDataGrid, AbstractPWGridRow parentOutputRow, Queue<AbstractPWGridRow> addModifyRowQ, AbstractPWDataGridRow row, List<DataRowSet> rowSets, int subRowTotalH, List<AbstractPWGridRow> outputRows) {
        boolean parentRowModify = false;
        boolean subRowAllBlank = true;
        boolean remainShouldDo = true;
        while (remainShouldDo) {
            AbstractPWGridRow actualOutputRow = (AbstractPWGridRow)parentOutputRow.copy();
            actualOutputRow.setAddRow(true);
            actualOutputRow.setBlankRow(parentOutputRow.isBlankRow());
            int parentColumnCount = parentOutputGrid.getColumnCount();
            boolean isNeedPage = this.needPagination(parentOutputGrid);
            if (isNeedPage && !addModifyRowQ.contains(actualOutputRow)) {
                addModifyRowQ.offer(actualOutputRow);
            }
            for (int j = 0; j < parentColumnCount; ++j) {
                AbstractPWGridCell rawCell = (AbstractPWGridCell)((AbstractPWGridCell)parentOutputRow.getCell(j)).copy();
                if (isNeedPage) {
                    actualOutputRow.addCell(rawCell);
                    continue;
                }
                actualOutputRow.addCell(null);
            }
            this.executeSubGridDetailRow(parentOutputGrid, actualOutputRow, row, rowSets.get(0));
            if (!row.isBlankRow()) {
                subRowAllBlank = false;
            }
            actualOutputRow.setHeight(0);
            parentOutputGrid.outputRow((AbstractPWDataGridRow)actualOutputRow);
            parentOutputGrid.getContext().setMaxHeightToAdjust(parentOutputGrid.getContext().getMaxHeightToAdjust() - row.getHeight());
            outputRows.add(actualOutputRow);
            if (this.needPagination(parentOutputGrid)) {
                if (!row.isRemainContent()) {
                    remainShouldDo = false;
                }
                if (parentOutputGrid.isTitleRowEveryPage()) {
                    this.currentTitleIndex = 0;
                }
            } else {
                remainShouldDo = false;
            }
            if (!remainShouldDo) continue;
            subRowTotalH += row.getHeight();
            if (!this.needPagination(parentOutputGrid)) continue;
            AbstractPWGridRow needModifyRow2 = addModifyRowQ.poll();
            if (needModifyRow2 != null) {
                if (!needModifyRow2.isAddRow()) {
                    parentRowModify = true;
                }
                this.adjustModifyRowHeight(parentOutputGrid, subDataGrid, needModifyRow2, subRowTotalH, outputRows, this.needPagination(parentOutputGrid));
                outputRows.clear();
                subRowTotalH = 0;
            }
            if (!parentOutputGrid.isTitleRowEveryPage()) continue;
            this.currentTitleIndex = 0;
        }
        subRowTotalH += row.getHeight();
        if (this.needPagination(parentOutputGrid)) {
            AbstractPWGridRow needModifyRow3 = addModifyRowQ.poll();
            if (needModifyRow3 != null) {
                if (!needModifyRow3.isAddRow()) {
                    parentRowModify = true;
                }
                this.adjustModifyRowHeight(parentOutputGrid, subDataGrid, needModifyRow3, subRowTotalH, outputRows, this.needPagination(parentOutputGrid));
                outputRows.clear();
            }
            if (parentOutputGrid.isTitleRowEveryPage()) {
                this.currentTitleIndex = 0;
            }
        }
        return new Tuple3<Boolean, Boolean, Integer>(parentRowModify, subRowAllBlank, subRowTotalH);
    }

    @Override
    public IWholeRowPageRunner createWholeRowPageRunner() {
        return new NotSupportWholeRowPageRunner();
    }
}

