/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.runner.grid.subGrid;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.ctrl.common.util.StringUtil;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.DelayVarProvider;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.PdIterator;
import kd.bos.print.core.data.R1PDataVisitor;
import kd.bos.print.core.data.field.CollectionField;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.ImageField;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.execute.render.common.linewrap.param.LineWrapParam;
import kd.bos.print.core.model.designer.grid.MergeBlock;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.AbstractPrintWidgetText;
import kd.bos.print.core.model.widget.PWText;
import kd.bos.print.core.model.widget.PrintAtPage;
import kd.bos.print.core.model.widget.StyleAccess;
import kd.bos.print.core.model.widget.grid.AbstractPWGrid;
import kd.bos.print.core.model.widget.grid.AbstractPWGridCell;
import kd.bos.print.core.model.widget.grid.AbstractPWGridColumn;
import kd.bos.print.core.model.widget.grid.AbstractPWGridRow;
import kd.bos.print.core.model.widget.grid.MergeType;
import kd.bos.print.core.model.widget.grid.datagrid.AbstractPWDataGridRow;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGrid;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGridColumn;
import kd.bos.print.core.model.widget.grid.datagrid.PWDetailRow;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.ACellValue;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueField;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueStat;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueText;
import kd.bos.print.core.model.widget.grid.datagrid.context.GridExecuteContext;
import kd.bos.print.core.model.widget.runner.TextRunner;
import kd.bos.print.core.model.widget.runner.grid.AbstractDataGridRunner;
import kd.bos.print.core.model.widget.runner.grid.AbstractGridRunner;
import kd.bos.print.core.model.widget.runner.util.AdjustHeightUtil;

public class VSubGridRunner
extends AbstractDataGridRunner {
    private Set<AbstractPWGridRow> parentOutputRows = new HashSet<AbstractPWGridRow>();
    private Set<AbstractPWGridRow> subOutputRows = new HashSet<AbstractPWGridRow>();
    private Queue<String> pagingFlagQ = new LinkedList<String>();

    @Override
    public void execute(IWidgetExecuteHelper helper) {
        super.execute(helper);
    }

    private void reset() {
        this.parentOutputRows.clear();
        this.subOutputRows.clear();
        this.pagingFlagQ.clear();
    }

    public void executeSubGrid(PWDataGrid parentOutputGrid, AbstractPWGridRow parentRow, int maxHeightToAdjust, CollectionField data, AbstractPWGridRow parentOutputRow) {
        this.parentOutputRows.add(parentOutputRow);
        R1PDataVisitor dataVisitor = this.getDataVisitor();
        PWDataGrid subDataGrid = (PWDataGrid)this.getOutputWidget();
        int rowCount = subDataGrid.getRowsCount();
        while (subDataGrid.getRowCursor() < rowCount) {
            AbstractPWDataGridRow row = (AbstractPWDataGridRow)subDataGrid.getRow(subDataGrid.getRowCursor());
            if (1 == row.getRowType()) {
                this.executeSubGridTitleRow(parentOutputGrid, parentRow, row);
            } else if (2 == row.getRowType()) {
                Object rowSets = data.getValue();
                if (CollectionUtils.isEmpty((Collection)rowSets)) {
                    subDataGrid.addRowCursor();
                    continue;
                }
                PdIterator iterator = new CollectionField((List<DataRowSet>)rowSets).iterator();
                while (iterator.hasNext()) {
                    DataRowSet rowSet = (DataRowSet)iterator.current();
                    this.executeSubGridDetailRow(parentOutputGrid, parentRow, row, rowSet, false);
                    this.iteratorNext(iterator, row, this.isOpenWholeRowPage());
                }
            } else if (3 == row.getRowType()) {
                this.executeSubGridStatRow(parentOutputGrid, parentRow, row);
            }
            subDataGrid.addRowCursor();
        }
        subDataGrid.getContext().setRowCursor(0);
        this.dealBlankRow(parentOutputGrid);
        this.reset();
    }

    private void dealBlankRow(PWDataGrid parentOutputGrid) {
        if (parentOutputGrid.isNotBlankRow()) {
            boolean shouldDeal = true;
            if (!this.pagingFlagQ.isEmpty()) {
                shouldDeal = false;
            }
            if (shouldDeal) {
                boolean parentAllBlank = true;
                boolean subAllBlank = true;
                for (AbstractPWGridRow temp : this.parentOutputRows) {
                    if (temp.isBlankRow()) continue;
                    parentAllBlank = false;
                }
                for (AbstractPWGridRow temp : this.subOutputRows) {
                    if (temp.isBlankRow()) continue;
                    subAllBlank = false;
                }
                if (parentAllBlank && subAllBlank) {
                    this.parentOutputRows.addAll(this.subOutputRows);
                    List outputRows = parentOutputGrid.getOutputRows();
                    if (!CollectionUtils.isEmpty(outputRows)) {
                        outputRows.removeAll(this.parentOutputRows);
                    }
                }
            }
        }
    }

    private void executeSubGridTitleRow(PWDataGrid parentOutputGrid, AbstractPWGridRow parentRow, AbstractPWGridRow subGridRow) {
        this.executeSubGridRow(parentOutputGrid, parentRow, subGridRow, new AbstractGridRunner.GridDataVisitor(){

            @Override
            public Field getFieldVal(String ds, CellValueField cellValue) {
                Field fieldValue = VSubGridRunner.this.helper.getDataHelper().getFieldValue(ds, cellValue.getField());
                return fieldValue;
            }
        });
        if (subGridRow.isRemainContent()) {
            this.executeSubGridTitleRow(parentOutputGrid, parentRow, subGridRow);
        }
    }

    private void executeSubGridDetailRow(PWDataGrid parentOutputGrid, AbstractPWGridRow parentRow, AbstractPWGridRow subGridRow, final DataRowSet rowSet, boolean executeRemainRow) {
        if (!executeRemainRow) {
            this.statSet.doStats(rowSet);
        }
        this.executeSubGridRow(parentOutputGrid, parentRow, subGridRow, new AbstractGridRunner.GridDataVisitor(){

            @Override
            public Field getFieldVal(String ds, CellValueField field) {
                return rowSet.getField(field.getField());
            }
        });
        if (!executeRemainRow) {
            ++this.detailRowNumber;
            ++this.detailGroupRowNumber;
        }
        if (subGridRow.isRemainContent()) {
            this.executeSubGridDetailRow(parentOutputGrid, parentRow, subGridRow, rowSet, true);
        }
    }

    private void executeSubGridStatRow(PWDataGrid parentOutputGrid, AbstractPWGridRow parentRow, AbstractPWGridRow subGridRow) {
        this.executeSubGridRow(parentOutputGrid, parentRow, subGridRow, new AbstractGridRunner.GridDataVisitor(){

            @Override
            public Field getFieldVal(String ds, CellValueField field) {
                return VSubGridRunner.this.getStatVal(ds, (CellValueStat)field);
            }
        });
    }

    @Override
    protected boolean needWholePagination(PWDataGrid outputGrid) {
        int rowCursor;
        int maxAdjustHeight = outputGrid.getContext().getMaxHeightToAdjust();
        PWDataGrid dataGrid = (PWDataGrid)this.getOutputWidget();
        Object row = dataGrid.getRow(rowCursor = dataGrid.getRowCursor());
        if (this.isRowDesignPagination((AbstractPWGridRow)row, maxAdjustHeight)) {
            GridExecuteContext context = dataGrid.getContext();
            context.setRowPagination(true);
            context.setRowType(((AbstractPWGridRow)row).getRowType());
            return true;
        }
        return false;
    }

    private void executeSubGridRow(PWDataGrid parentOutputGrid, AbstractPWGridRow parentRow, AbstractPWGridRow subGridRow, AbstractGridRunner.GridDataVisitor visitor) {
        Object cell;
        int rowHeight;
        this.beforeExecuteRow(parentOutputGrid);
        PWDataGrid subDataGrid = (PWDataGrid)this.getOutputWidget();
        this.resetRowPaginationFlag(subDataGrid, subGridRow);
        int columnCursor = 0;
        int columnCount = subDataGrid.getColumnCount();
        int maxHeightToAdjust = parentOutputGrid.getContext().getMaxHeightToAdjust();
        AbstractPWGridRow subOutputRow = (AbstractPWGridRow)subGridRow.copy();
        subOutputRow.setMaxHeightToAdjust(maxHeightToAdjust);
        boolean remainContent = subGridRow.isRemainContent();
        if (remainContent) {
            int remainHeight = subGridRow.getReaminHeight();
            if (remainHeight < MIN_ROW_HEIGHT) {
                remainHeight = MIN_ROW_HEIGHT;
            }
            if (remainHeight != 0) {
                subOutputRow.setHeight(remainHeight);
            }
            subGridRow.setRemainContent(false);
            subGridRow.setReaminHeight(0);
        }
        int realHeight = rowHeight = subOutputRow.getHeight();
        if (rowHeight > maxHeightToAdjust) {
            realHeight = maxHeightToAdjust;
            int remainHeight = rowHeight - maxHeightToAdjust;
            subGridRow.setReaminHeight(remainHeight);
            subGridRow.setRemainContent(true);
        }
        int newPageAdjustHeight = 0;
        if (subDataGrid.isWholeRowPage()) {
            newPageAdjustHeight = this.getNewPageAdjustHeight(subDataGrid);
        }
        int realMaxRowHeight = 0;
        boolean isBlankRow = true;
        boolean rowRemain = false;
        while (columnCursor < columnCount) {
            int width;
            Object column = subDataGrid.getColumn(columnCursor);
            int columnWidth = ((AbstractPWGridColumn)column).getWidth();
            cell = subGridRow.getCell(columnCursor);
            AbstractPWGridCell outputCell = (AbstractPWGridCell)((AbstractPWGridCell)cell).copy();
            String outputText = "";
            String dataSource = outputCell.getDatasource();
            ACellValue cellValue = outputCell.getCellValue();
            if (remainContent) {
                int remainHeight = subGridRow.getReaminHeight();
                outputText = ((AbstractPrintWidgetText)cell).getOutputText();
                if (remainHeight != 0) {
                    subOutputRow.setHeight(remainHeight);
                }
            } else if (StringUtils.isBlank((CharSequence)dataSource)) {
                if (cellValue instanceof CellValueText) {
                    outputText = ((CellValueText)cellValue).getValue();
                    Field outputValue = null;
                    List<Object> formulaData = outputCell.getFormulaData();
                    TextRunner runner = (TextRunner)outputCell.getRunner();
                    if (formulaData != null && !formulaData.isEmpty()) {
                        if (subGridRow instanceof PWDetailRow) {
                            subDataGrid.setPageIndex(parentOutputGrid.getPageIndex());
                            outputValue = new TextField(this.getFormulaValue(formulaData, subDataGrid, outputCell, this.helper, visitor));
                        } else {
                            outputValue = new TextField(runner.getFormulaValue(formulaData, subDataGrid, this.helper));
                        }
                    } else {
                        outputValue = new TextField(outputText);
                    }
                    if (outputValue != null) {
                        outputCell.setOriOutPutText(outputValue.toString());
                        outputValue = runner.formatOutputValue(outputValue);
                        outputText = outputValue.toString();
                    }
                }
            } else if (StringUtil.equals(dataSource, "$DsKey=[System]")) {
                if (parentOutputGrid.getPrintAtPage() != PrintAtPage.All) {
                    if (StringUtil.equals(outputCell.getBindField(), "=getRowNumber()")) {
                        if (subOutputRow instanceof PWDetailRow) {
                            TextField outputValue = new TextField(String.valueOf(this.detailRowNumber));
                            outputText = outputValue.toString();
                        } else {
                            outputText = "1";
                        }
                    } else {
                        Object formulaResult = this.runFormula(this.helper, outputCell, outputCell.getBindField());
                        TextField outputValue = new TextField(formulaResult == null ? "" : formulaResult.toString());
                        outputText = outputValue.toString();
                    }
                }
            } else if (cellValue instanceof CellValueStat) {
                CellValueStat statField = (CellValueStat)cellValue;
                Field outputValue = visitor.getFieldVal(dataSource, statField);
                TextRunner runner = (TextRunner)outputCell.getRunner();
                outputValue = runner.formatOutputValue(outputValue);
                outputText = outputValue.toString();
            } else if (cellValue instanceof CellValueField) {
                CellValueField cellField = (CellValueField)cellValue;
                Field outputValue = visitor.getFieldVal(dataSource, cellField);
                if (outputValue instanceof ImageField) {
                    boolean hasImage = this.showImageField(outputCell, (ImageField)outputValue, realHeight, columnWidth);
                    if (hasImage) {
                        isBlankRow = false;
                    }
                    outputText = "";
                } else {
                    TextRunner runner = (TextRunner)outputCell.getRunner();
                    outputValue = runner.formatOutputValue(outputValue);
                    outputText = outputValue.toString();
                }
            }
            if (outputCell.isAnchor()) {
                outputCell.setLinkUrl(((TextRunner)outputCell.getRunner()).queryAnchorLink(visitor));
            }
            if (subGridRow.isRemainContent()) {
                width = columnWidth;
                int height = realHeight;
                AdjustHeightUtil.AdjustInfo adjustInfo = AdjustHeightUtil.getInstance().adjustHeight(new LineWrapParam.Builder(outputText, ((PWText)cell).getLineWrapRule()).style(StyleAccess.getStyle(outputCell)).wordFlex(((PWText)cell).isWordFlex()).minW(width).maxW(this.getRelativeContext().getEmptyPage().getRectangle().width).minH(height).maxH(maxHeightToAdjust).build());
                outputText = adjustInfo.getUsedText();
                outputCell.setTextHeight(adjustInfo.getTextHeight());
                outputCell.setFlexOffset(adjustInfo.getFlexOffset());
                ((AbstractPrintWidgetText)cell).setOutputText(adjustInfo.getRemainText());
                if (adjustInfo.getRemainText() != null) {
                    rowRemain = true;
                }
            } else if (subOutputRow.isAdjustHeight() && subOutputRow.getRowType() != 3) {
                width = columnWidth;
                int height = realHeight;
                if (((AbstractPWGridCell)cell).getMergeType() == MergeType.Merged) {
                    MergeBlock mergeBlock = ((AbstractPWGridCell)cell).getMergeBlock();
                    Dimension mergeInfo = this.getMergeInfo(mergeBlock);
                    width = mergeInfo.width;
                    height = mergeInfo.height;
                }
                LineWrapParam param = new LineWrapParam.Builder(outputText, ((PWText)cell).getLineWrapRule()).style(StyleAccess.getStyle(outputCell)).wordFlex(((PWText)cell).isWordFlex()).minW(width).maxW(this.getRelativeContext().getEmptyPage().getRectangle().width).minH(height).maxH(maxHeightToAdjust).build();
                AdjustHeightUtil.AdjustInfo adjustInfo = AdjustHeightUtil.getInstance().adjustHeight(param);
                if (this.isRowRuntimePagination(adjustInfo, newPageAdjustHeight, subGridRow)) {
                    parentOutputGrid.getContext().setMaxHeightToAdjust(0);
                    subDataGrid.getContext().setRowPagination(true);
                    subDataGrid.getContext().setRowType(subGridRow.getRowType());
                    this.beforeExecuteRow(parentOutputGrid);
                    return;
                }
                int usedHeight = adjustInfo.getUsedHeight();
                outputCell.setTextHeight(adjustInfo.getTextHeight());
                outputCell.setFlexOffset(adjustInfo.getFlexOffset());
                realHeight = usedHeight < height ? realHeight : realHeight + usedHeight - height;
                outputCell.setAdjustHeight(true);
                ((AbstractPrintWidgetText)cell).setAdjustHeight(true);
                if (this.rowOverPage()) {
                    String remainText = adjustInfo.getRemainText();
                    if (DelayVarProvider.isBindDelayVar(outputCell)) {
                        remainText = null;
                    } else {
                        outputText = adjustInfo.getUsedText();
                    }
                    ((AbstractPrintWidgetText)cell).setOutputText(remainText);
                    if (!subGridRow.isRemainContent() && remainText != null) {
                        rowRemain = true;
                        subGridRow.setRemainContent(true);
                    }
                } else if (!DelayVarProvider.isBindDelayVar(outputCell)) {
                    outputText = adjustInfo.getUsedText();
                }
            } else {
                ((AbstractPrintWidgetText)cell).setOutputText("");
                ((PWText)cell).setRemainContent(false);
            }
            outputCell.setRectangle(new Rectangle(columnWidth, realHeight));
            outputCell.setOutputText(outputText);
            subOutputRow.addCell(outputCell);
            if (realHeight > realMaxRowHeight) {
                realMaxRowHeight = realHeight;
            }
            if (StringUtils.isNotBlank((CharSequence)outputText)) {
                isBlankRow = false;
            }
            ++columnCursor;
        }
        subGridRow.setRemainContent(rowRemain);
        if (isBlankRow && (parentOutputGrid.isNotBlankRow() || remainContent)) {
            subOutputRow.setBlankRow(true);
        }
        if (subOutputRow.isAdjustHeight() || subGridRow.isRemainContent()) {
            int cellCount = subOutputRow.getCellCount();
            int cellIndex = 0;
            while (cellIndex < cellCount) {
                cell = subOutputRow.getCell(cellIndex);
                if (cell == null) {
                    ++cellIndex;
                    continue;
                }
                ((AbstractPWGridCell)cell).adjustHeight(realMaxRowHeight);
                ++cellIndex;
            }
        }
        subOutputRow.setHeight(realMaxRowHeight);
        subOutputRow.setSubRow(true);
        parentOutputGrid.outputRow((AbstractPWDataGridRow)subOutputRow);
        parentOutputGrid.getContext().setMaxHeightToAdjust(maxHeightToAdjust -= subOutputRow.getHeight());
        this.subOutputRows.add(subOutputRow);
        if (parentOutputGrid.isNotBlankRow()) {
            int rowCount = subDataGrid.getRowsCount();
            int currentRowCursor = subDataGrid.getRowCursor();
            if (currentRowCursor != rowCount - 1 && this.needPagination(parentOutputGrid)) {
                this.pagingFlagQ.offer("paging");
            } else if (currentRowCursor == rowCount - 1 && this.needPagination(parentOutputGrid)) {
                this.dealBlankRow(parentOutputGrid);
            }
        }
    }

    private int getNewPageAdjustHeight(AbstractPrintWidget outputGrid) {
        int relativeY = this.getRelativeContext().scanYFromEveryPagePool(outputGrid);
        int startY = this.getHeaderHeight();
        if (relativeY != -1) {
            startY = relativeY;
        }
        int newPageAdjustHeight = (this.getRelativeContext().getEmptyPage().getRectangle().height - this.getRelativeContext().getHeaderHeight() - this.getRelativeContext().getFooterHeight() - startY) / 2;
        return newPageAdjustHeight;
    }

    public boolean isSubGWGreaterThanParentGW(PWDataGrid parentGrid, PWDataGrid subGrid) {
        int subGridWidth = 0;
        int parentGridWidth = 0;
        int subColCount = subGrid.getColumnCount();
        for (int i = 0; i < subColCount; ++i) {
            subGridWidth += ((PWDataGridColumn)subGrid.getColumn(i)).getWidth();
        }
        int parentColCount = parentGrid.getColumnCount();
        for (int j = 0; j < parentColCount; ++j) {
            parentGridWidth += ((PWDataGridColumn)parentGrid.getColumn(j)).getWidth();
        }
        return subGridWidth > parentGridWidth;
    }

    @Override
    protected boolean needPagination(AbstractPWGrid outputGrid) {
        int rowsCount;
        int maxAdjustHeight = outputGrid.getContext().getMaxHeightToAdjust();
        PWDataGrid dataGrid = (PWDataGrid)outputGrid;
        PWDataGrid subGrid = dataGrid.getSubDataGrids().get(0);
        int rowCursor = subGrid.getRowCursor();
        if (rowCursor >= (rowsCount = subGrid.getRowsCount()) || subGrid.getPrintAtPage() == PrintAtPage.InContainer) {
            return false;
        }
        Object row = subGrid.getRow(rowCursor);
        int rowHeight = ((AbstractPWGridRow)row).getHeight();
        if (rowHeight >= MIN_ROW_HEIGHT && maxAdjustHeight < MIN_ROW_HEIGHT) {
            return true;
        }
        return rowHeight <= MIN_ROW_HEIGHT && maxAdjustHeight < rowHeight;
    }

    static interface SubGridDataVisitor {
        public Field getFieldVal(String var1, CellValueField var2);
    }
}

