/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.runner.stat;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.PdIterator;
import kd.bos.print.core.data.R1PDataVisitor;
import kd.bos.print.core.data.field.DecimalField;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.NullField;
import kd.bos.print.core.data.field.NumberField;
import kd.bos.print.core.model.widget.grid.datagrid.AbstractPWDataGridRow;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGrid;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGridCell;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueStat;
import kd.bos.print.core.model.widget.runner.stat.StatValue;

public class GridStatSet {
    private Map<String, StatValue> statMap = new HashMap<String, StatValue>(16);
    private boolean isFinish;

    public GridStatSet(PWDataGrid grid) {
        this.initStats(grid);
    }

    public boolean hasStatField() {
        return this.statMap.size() > 0;
    }

    public Field getStatValue(String fieldKey) {
        StatValue statValue = this.statMap.get(fieldKey);
        Field value = statValue.getValue();
        if (value == null) {
            value = NullField.get();
        }
        if (value instanceof DecimalField) {
            DecimalField decimalField = (DecimalField)value;
            BigDecimal bigDecimal = decimalField.getValue();
            bigDecimal = bigDecimal.setScale(decimalField.getScale(), 4);
            decimalField.setValue(bigDecimal);
            return decimalField;
        }
        return value;
    }

    public void clearStat() {
        for (Map.Entry<String, StatValue> entry : this.statMap.entrySet()) {
            StatValue statValue = entry.getValue();
            statValue.reset();
        }
    }

    public void clearPageStat() {
        for (Map.Entry<String, StatValue> entry : this.statMap.entrySet()) {
            StatValue statValue = entry.getValue();
            statValue.restePageSet();
        }
    }

    public void clearGroupStat() {
        for (Map.Entry<String, StatValue> entry : this.statMap.entrySet()) {
            StatValue statValue = entry.getValue();
            statValue.resteGroupSet();
        }
    }

    public void doStats(R1PDataVisitor dataVisitor) {
        R1PDataVisitor.Iterator iterator = dataVisitor.iterator();
        while (iterator.hasNext()) {
            for (Map.Entry<String, StatValue> entry : this.statMap.entrySet()) {
                StatValue statValue = entry.getValue();
                String field = statValue.getCellValue().getField();
                Field fieldValue = iterator.getField(field);
                if (!(fieldValue instanceof NumberField)) continue;
                statValue.doStat((NumberField)fieldValue);
            }
            iterator.next();
        }
        this.isFinish = !iterator.hasNext();
    }

    public void doStats(PdIterator iterator) {
        for (Map.Entry<String, StatValue> entry : this.statMap.entrySet()) {
            StatValue statValue = entry.getValue();
            String field = statValue.getCellValue().getField();
            Field fieldValue = iterator.getField(field);
            if (!(fieldValue instanceof NumberField)) continue;
            statValue.doStat((NumberField)fieldValue);
        }
        this.isFinish = !iterator.hasNext();
    }

    public void doStats(DataRowSet rowSet) {
        for (Map.Entry<String, StatValue> entry : this.statMap.entrySet()) {
            StatValue statValue = entry.getValue();
            String field = statValue.getCellValue().getField();
            Field fieldValue = rowSet.getField(field);
            if (!(fieldValue instanceof NumberField)) continue;
            statValue.doStat((NumberField)fieldValue);
        }
    }

    private void initStats(PWDataGrid grid) {
        int rc = grid.getRowsCount();
        for (int i = 0; i < rc; ++i) {
            AbstractPWDataGridRow row = (AbstractPWDataGridRow)grid.getRow(i);
            int cc = row.getCellCount();
            for (int j = 0; j < cc; ++j) {
                CellValueStat cellValue;
                String key;
                PWDataGridCell cell = (PWDataGridCell)row.getCell(j);
                if (cell.getCellValue() == null || cell.getCellValue().getCellType() != 3 || this.statMap.containsKey(key = (cellValue = (CellValueStat)cell.getCellValue()).getField() + "_" + cellValue.getStatType())) continue;
                StatValue statValue = new StatValue(cellValue);
                this.statMap.put(key, statValue);
            }
        }
    }
}

