/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.runner.stat;

import java.math.BigDecimal;
import kd.bos.print.core.data.field.BigIntegerField;
import kd.bos.print.core.data.field.DecimalField;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.IntegerField;
import kd.bos.print.core.data.field.LongField;
import kd.bos.print.core.data.field.NullField;
import kd.bos.print.core.data.field.NumberField;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueStat;

public class StatValue {
    private int count;
    private CellValueStat cellValue;
    private NumberField minVal;
    private NumberField maxVal;
    private NumberField sumVal;
    private NumberField pageSumVal;
    private NumberField groupSumVal;
    private DecimalField maxFieldOfSum;
    private DecimalField maxFieldOfPageSum;
    private DecimalField maxFieldOfGroupSum;

    public StatValue(CellValueStat cellValue) {
        this.cellValue = cellValue;
    }

    public int getCount() {
        return this.count;
    }

    public void reset() {
        this.count = 0;
        this.minVal = null;
        this.maxVal = null;
        this.sumVal = null;
        this.pageSumVal = null;
        this.groupSumVal = null;
    }

    public void restePageSet() {
        if (this.pageSumVal != null) {
            this.pageSumVal.setZero();
            this.maxFieldOfPageSum = null;
        }
    }

    public void resteGroupSet() {
        if (this.groupSumVal != null) {
            this.groupSumVal.setZero();
            this.maxFieldOfGroupSum = null;
        }
    }

    public NumberField getMinVal() {
        return this.minVal;
    }

    public NumberField getMaxVal() {
        return this.maxVal;
    }

    public NumberField getSumVal() {
        return this.sumVal;
    }

    public NumberField getPageSumVal() {
        return this.pageSumVal;
    }

    public NumberField getGroupSumVal() {
        return this.groupSumVal;
    }

    public CellValueStat getCellValue() {
        return this.cellValue;
    }

    public Field getValue() {
        int statType = this.getCellValue().getStatType();
        Field returnField = NullField.get();
        if (statType == 1) {
            returnField = this.getSumVal();
            this.formatStatField(returnField, this.maxFieldOfSum);
        } else if (statType == 6) {
            returnField = this.getPageSumVal();
            this.formatStatField(returnField, this.maxFieldOfPageSum);
        } else if (statType == 18) {
            returnField = this.getGroupSumVal();
            this.formatStatField(returnField, this.maxFieldOfGroupSum);
        } else {
            if (statType == 2) {
                double sumValue = this.getSumVal().getValue().doubleValue();
                double avg = sumValue % (double)this.count;
                return new DecimalField(BigDecimal.valueOf(avg));
            }
            if (statType == 5) {
                return new IntegerField(this.count);
            }
            if (statType == 3) {
                return this.getMaxVal();
            }
            if (statType == 4) {
                return this.getMinVal();
            }
        }
        return returnField;
    }

    private void formatStatField(Field returnField, DecimalField maxField) {
        if (returnField instanceof DecimalField && maxField instanceof DecimalField) {
            DecimalField returnDecimalField = (DecimalField)returnField;
            returnDecimalField.setScale(maxField.getScale());
            returnDecimalField.setPrecision(maxField.getPrecision());
            returnDecimalField.setShowZero(maxField.isShowZero());
            returnDecimalField.setCode(maxField.getCode());
            returnDecimalField.setSymbol(maxField.getSymbol());
        }
    }

    public void doStat(NumberField field) {
        int curFieldScale;
        int statType;
        ++this.count;
        if (field instanceof DecimalField) {
            if (this.maxFieldOfSum == null) {
                this.maxFieldOfSum = (DecimalField)field;
            } else {
                int maxFieldScale;
                int curFieldScale2 = ((DecimalField)field).getScale();
                if (curFieldScale2 > (maxFieldScale = this.maxFieldOfSum.getScale())) {
                    this.maxFieldOfSum = (DecimalField)field;
                }
            }
        }
        if ((statType = this.getCellValue().getStatType()) == 1 || statType == 2) {
            NumberField sumVal = this.getSumVal();
            if (sumVal == null) {
                sumVal = this.createInstance(field);
            }
            sumVal.addNum(field.getValue());
            this.sumVal = sumVal;
        }
        if (statType == 18) {
            NumberField sumVal;
            if (field instanceof DecimalField) {
                if (this.maxFieldOfGroupSum == null) {
                    this.maxFieldOfGroupSum = (DecimalField)field;
                } else {
                    int maxFieldScale;
                    curFieldScale = ((DecimalField)field).getScale();
                    if (curFieldScale > (maxFieldScale = this.maxFieldOfGroupSum.getScale())) {
                        this.maxFieldOfGroupSum = (DecimalField)field;
                    }
                }
            }
            if ((sumVal = this.getGroupSumVal()) == null) {
                sumVal = this.createInstance(field);
            }
            sumVal.addNum(field.getValue());
            this.groupSumVal = sumVal;
        } else if (statType == 6) {
            NumberField pageSumVal;
            if (field instanceof DecimalField) {
                if (this.maxFieldOfPageSum == null) {
                    this.maxFieldOfPageSum = (DecimalField)field;
                } else {
                    int maxFieldScale;
                    curFieldScale = ((DecimalField)field).getScale();
                    if (curFieldScale > (maxFieldScale = this.maxFieldOfPageSum.getScale())) {
                        this.maxFieldOfPageSum = (DecimalField)field;
                    }
                }
            }
            if ((pageSumVal = this.getPageSumVal()) == null) {
                pageSumVal = this.createInstance(field);
            }
            pageSumVal.addNum(field.getValue());
            this.pageSumVal = pageSumVal;
        } else if (statType == 3) {
            NumberField maxVal = this.getMaxVal();
            if (maxVal == null) {
                maxVal = field;
            }
            if (maxVal.compareTo(field) < 0) {
                maxVal = field;
            }
            this.maxVal = maxVal;
        } else if (statType == 4) {
            NumberField minVal = this.getMinVal();
            if (minVal == null) {
                minVal = field;
            }
            if (minVal.compareTo(field) > 0) {
                minVal = field;
            }
            this.minVal = minVal;
        }
    }

    private NumberField createInstance(NumberField field) {
        if (field instanceof IntegerField || field instanceof LongField) {
            BigIntegerField bigField = new BigIntegerField();
            bigField.setShowZero(field.isShowZero());
            if (field.isDesensitive()) {
                bigField.setDesensitive(field.isDesensitive());
                bigField.setDisplayVal(field.getDisplayVal());
            }
            return bigField;
        }
        DecimalField decimalField = new DecimalField();
        if (field instanceof DecimalField) {
            DecimalField oriField = (DecimalField)field;
            decimalField.setScale(oriField.getScale());
            decimalField.setPrecision(oriField.getPrecision());
            decimalField.setShowZero(oriField.isShowZero());
            decimalField.setCode(oriField.getCode());
            decimalField.setSymbol(oriField.getSymbol());
            if (oriField.isDesensitive()) {
                decimalField.setDesensitive(oriField.isDesensitive());
                decimalField.setDisplayVal(oriField.getDisplayVal());
            }
        }
        return decimalField;
    }
}

