/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.runner.util;

import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.print.util.KPrintUtil;
import kd.bos.print.core.ctrl.reportone.r1.common.designercore.util.Util;
import kd.bos.print.core.execute.render.common.AdjustHeightInfo;
import kd.bos.print.core.execute.render.common.AdjustHeightRenderUtil;
import kd.bos.print.core.execute.render.common.linewrap.param.LineWrapParam;
import kd.bos.print.core.execute.render.common.linewrap.param.LineWrapRule;

public class AdjustHeightUtil {
    private static volatile AdjustHeightUtil _instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AdjustHeightUtil getInstance() {
        if (_instance != null) return _instance;
        Class<AdjustHeightUtil> clazz = AdjustHeightUtil.class;
        synchronized (AdjustHeightUtil.class) {
            if (_instance != null) return _instance;
            _instance = new AdjustHeightUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    public AdjustInfo adjustHeight(String outputText, Style style, int width, int minHeight, int maxHeight) {
        return this.adjustHeight(new LineWrapParam.Builder(outputText, LineWrapRule.ChunkLine).style(style).minW(width).minH(minHeight).maxH(maxHeight).build());
    }

    public AdjustInfo adjustHeight(LineWrapParam param) {
        String outputText = param.getText();
        int width = param.getMinW();
        Style style = param.getStyle();
        int minHeight = param.getMinH();
        int maxHeight = param.getMaxH();
        int calMinHeight = Util.lom2Pixel(minHeight) - 1;
        int calMaxHeight = Util.lom2Pixel(maxHeight) - 1;
        int minWidth = (int)KPrintUtil.lomToPrintPoint(width);
        int maxWidth = (int)KPrintUtil.lomToPrintPoint(param.getMaxW());
        if (outputText == null) {
            outputText = "";
        }
        AdjustHeightInfo adjustHeightInfo = AdjustHeightRenderUtil.adjustHeight(param.text(outputText).minW(minWidth).maxW(maxWidth).minH(calMinHeight).maxH(calMaxHeight));
        int realHeight = 0;
        if (adjustHeightInfo.getUsedHeight() != 0) {
            realHeight = Util.pixel2Lom(adjustHeightInfo.getUsedHeight() + 1, 0);
        }
        if (realHeight > maxHeight) {
            realHeight = maxHeight;
        }
        AdjustInfo adjustInfo = new AdjustInfo(realHeight, adjustHeightInfo.getUsedText(), adjustHeightInfo.getRemainText());
        int textHeight = 0;
        if (adjustHeightInfo.getTextHeight() != 0) {
            textHeight = Util.pixel2Lom(adjustHeightInfo.getTextHeight());
        }
        adjustInfo.setTextHeight(textHeight);
        adjustInfo.setFlexOffset(adjustHeightInfo.getFlexOffset());
        return adjustInfo;
    }

    public AdjustInfo getAdjustInfo(String outputText, Style style, int width, int minHeight, int maxHeight) {
        return this.adjustHeight(new LineWrapParam.Builder(outputText, LineWrapRule.ChunkLine).style(style).minW(width).minH(minHeight).maxH(maxHeight).build());
    }

    public static class AdjustInfo {
        private int usedHeight;
        private int textHeight;
        private String usedText;
        private String remainText;
        private float[] flexOffset;

        public AdjustInfo(int usedHeight, String usedText, String remainText) {
            this.usedHeight = usedHeight;
            this.usedText = usedText;
            this.remainText = remainText;
        }

        public int getUsedHeight() {
            return this.usedHeight;
        }

        public void setUsedHeight(int usedHeight) {
            this.usedHeight = usedHeight;
        }

        public String getUsedText() {
            return this.usedText;
        }

        public void setUsedText(String usedText) {
            this.usedText = usedText;
        }

        public String getRemainText() {
            return this.remainText;
        }

        public void setRemainText(String remainText) {
            this.remainText = remainText;
        }

        public int getTextHeight() {
            return this.textHeight;
        }

        public void setTextHeight(int textHeight) {
            this.textHeight = textHeight;
        }

        public float[] getFlexOffset() {
            return this.flexOffset;
        }

        public void setFlexOffset(float[] flexOffset) {
            this.flexOffset = flexOffset;
        }
    }
}

