/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.runner.util;

import java.awt.Color;
import java.util.List;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.ctrl.kdf.util.style.Border;
import kd.bos.print.core.ctrl.kdf.util.style.LineStyle;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.StyleAttributes;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.model.designer.grid.MergeBlock;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.grid.AbstractPWGrid;
import kd.bos.print.core.model.widget.grid.AbstractPWGridCell;
import kd.bos.print.core.model.widget.grid.AbstractPWGridRow;
import kd.bos.print.core.model.widget.grid.MergeType;
import org.apache.commons.lang.StringUtils;

public class MergeUtils {
    private MergeUtils() {
    }

    public static int cellMergeAddHeight(AbstractPWGrid designGrid, int index, AbstractPWGrid outputGrid, AbstractPWGridRow outputRow) {
        try {
            Object row = designGrid.getRow(index);
            int height = 0;
            if (row != null && !outputRow.getId().equals(((AbstractPrintWidget)row).getId())) {
                String rowId = ((AbstractPrintWidget)row).getId();
                List outputRows = outputGrid.getOutputRows();
                if (!CollectionUtils.isEmpty(outputRows)) {
                    for (AbstractPWGridRow temp : outputRows) {
                        if (!rowId.equals(temp.getId())) continue;
                        height = temp.getHeight();
                        break;
                    }
                }
            }
            return height;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static int getMergeAddHeight(AbstractPWGrid designGrid, AbstractPWGridRow nextOutputRow, MergeBlock block) {
        try {
            int rowStart = block.getTop();
            int rowEnd = block.getBottom();
            int height = 0;
            if (nextOutputRow == null) {
                return height;
            }
            for (int rowIndex = rowStart; rowIndex <= rowEnd; ++rowIndex) {
                Object designRow = designGrid.getRow(rowIndex);
                if (designRow == null || !StringUtils.equals((String)((AbstractPrintWidget)designRow).getId(), (String)nextOutputRow.getId())) continue;
                height = nextOutputRow.getHeight();
                break;
            }
            return height;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static boolean canChangeMergeType(AbstractPWGridCell cell, int colIndex) {
        MergeBlock block;
        boolean change = false;
        if (cell.getMergeType() == MergeType.BeMerged && (block = cell.getMergeBlock()) != null && block.isVerticalMerge()) {
            int columnStart = block.getLeft();
            int rowStart = block.getTop();
            int rowEnd = block.getBottom();
            if (rowEnd != rowStart && columnStart == colIndex) {
                change = true;
            }
        }
        return change;
    }

    public static boolean canChangeMergeType(AbstractPWGridCell cell) {
        MergeBlock block;
        boolean change = false;
        if (cell.getMergeType() == MergeType.BeMerged && (block = cell.getMergeBlock()) != null && block.isVerticalMerge()) {
            int columnStart = block.getLeft();
            int columnEnd = block.getRight();
            int rowStart = block.getTop();
            int rowEnd = block.getBottom();
            if (rowEnd != rowStart && columnStart == columnEnd) {
                change = true;
            }
        }
        return change;
    }

    public static void adjustMergeCellStyle(AbstractPWGrid designGrid, AbstractPWGridCell cell) {
        Style gridStyle = designGrid.getStyle();
        Border borderBottom = gridStyle.getBorder(Styles.Position.BOTTOM);
        if (borderBottom != null && !borderBottom.isNull()) {
            Style style = cell.getStyle();
            LineStyle borderLineStyle = style.getBorderLineStyle(Styles.Position.BOTTOM);
            Color borderColor = style.getBorderColor(Styles.Position.BOTTOM);
            MergeType mergeType = cell.getMergeType();
            if (MergeType.Merged == mergeType) {
                MergeBlock mergeBlock = cell.getMergeBlock();
                int bottom = mergeBlock.getBottom();
                if (bottom + 1 < designGrid.getRowsCount()) {
                    borderColor = ((AbstractPrintWidget)((AbstractPWGridRow)designGrid.getRow(bottom + 1)).getCell(mergeBlock.getLeft())).getStyle().getBorderColor(Styles.Position.TOP);
                }
                StyleAttributes sa = style.getNewAttribute();
                sa.setBorder(borderBottom);
                if (borderColor != null) {
                    sa.setBorderColor(Styles.Position.BOTTOM, borderColor);
                }
                cell.setStyle(Styles.getStyle(sa));
            }
            if (borderLineStyle == LineStyle.NULL_LINE) {
                StyleAttributes sa = style.getNewAttribute();
                sa.setBorder(borderBottom);
                if (borderColor != null) {
                    sa.setBorderColor(Styles.Position.BOTTOM, borderColor);
                }
                cell.setStyle(Styles.getStyle(sa));
            }
        }
    }
}

