/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.runner.util;

import com.google.common.collect.Sets;
import java.awt.Font;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.print.core.ExecuteService;
import kd.bos.print.core.service.PrtFont;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;

public class RichTextFontUtils {
    public static String pattern = "font-family:.*?;";

    private RichTextFontUtils() {
    }

    public static String htmlFontTransform(String htmlString, Font defaultFont) {
        Document doc = Jsoup.parse((String)htmlString, (String)"", (Parser)Parser.xmlParser());
        Elements elements = doc.select("[style]");
        for (Element element : elements) {
            Attributes attributes = element.attributes();
            for (Attribute attribute : attributes) {
                if (!"style".equals(attribute.getKey()) || !attribute.getValue().contains("font-family")) continue;
                attribute.setValue(RichTextFontUtils.convertFont(attribute.getValue(), defaultFont));
            }
        }
        return doc.toString();
    }

    public static String convertFont(String context, Font defaultFont) {
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(context);
        while (m.find()) {
            String fontStrings = m.group();
            fontStrings = fontStrings.replace("\"", "");
            fontStrings = fontStrings.replace("'", "");
            fontStrings = fontStrings.replace(";", "");
            fontStrings = fontStrings.replace("font-family:", "");
            String[] fontStringArr = fontStrings.split(",");
            HashSet<String> fonts = new HashSet<String>();
            if (fontStringArr.length > 0) {
                for (String fontString : fontStringArr) {
                    fonts.add(fontString.trim());
                }
            } else {
                fonts.add(fontStrings.trim());
            }
            FontMatchResult fontMatchResult = RichTextFontUtils.isMatchFont(fonts, context, defaultFont.getFamily(Locale.ENGLISH));
            if (!fontMatchResult.isMatch()) {
                return RichTextFontUtils.createDefuatFontString(context, fonts, defaultFont);
            }
            context = fontMatchResult.getContext();
        }
        return context;
    }

    public static String createDefuatFontString(String origString, Set<String> fonts, Font defaultFont) {
        for (String fontName : fonts) {
            origString = origString.replaceAll(fontName.trim(), defaultFont.getFamily(Locale.ENGLISH));
        }
        return origString;
    }

    public static FontMatchResult isMatchFont(Set<String> fonts, String origString, String defaultFontCode) {
        HashSet<String> fontCodes = new HashSet<String>(16);
        List<PrtFont> fontsList = ExecuteService.getFontService().getFonts();
        for (PrtFont prtFont : fontsList) {
            fontCodes.add(prtFont.getFontCode());
        }
        Sets.SetView intersection = Sets.intersection(fontCodes, fonts);
        if (intersection.isEmpty()) {
            HashSet<String> fontName = new HashSet<String>(16);
            for (PrtFont prtFont : fontsList) {
                fontName.add(prtFont.getFontName());
            }
            Sets.SetView intersections = Sets.intersection(fontName, fonts);
            if (intersections.isEmpty()) {
                return new FontMatchResult(false, origString);
            }
            for (String temp : intersections) {
                Optional<PrtFont> prtFont = fontsList.stream().filter(font -> font.getFontName().equals(temp)).findFirst();
                String fontCode = defaultFontCode;
                if (prtFont.isPresent()) {
                    fontCode = prtFont.get().getFontCode();
                }
                origString = origString.replaceAll(temp, fontCode);
            }
            return new FontMatchResult(true, origString);
        }
        return new FontMatchResult(true, origString);
    }

    private static class FontMatchResult {
        private boolean isMatch;
        private String context;

        public FontMatchResult(boolean isMatch, String context) {
            this.isMatch = isMatch;
            this.context = context;
        }

        public boolean isMatch() {
            return this.isMatch;
        }

        public void setMatch(boolean match) {
            this.isMatch = match;
        }

        public String getContext() {
            return this.context;
        }

        public void setContext(String context) {
            this.context = context;
        }
    }
}

