/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.runner.util;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.entity.plugin.support.util.ReflectionUtils;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ExecuteService;
import kd.bos.print.core.ctrl.reportone.r1.print.common.R1PrintInfo;
import kd.bos.print.core.plugin.PrintPluginProxy;
import kd.bos.print.core.plugin.event.ParseRichImgEvent;
import kd.bos.print.core.service.PrtFont;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.url.UrlService;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;

public class RichTextUtil {
    private static final Log logger = LogFactory.getLog(RichTextUtil.class);

    public static StringBuilder getPageHtmlStringBuilder(R1PrintInfo printInfo, boolean isFirst) {
        String paperName = printInfo.getPaperName();
        String landscape = printInfo.getOrientation();
        int width = RichTextUtil.getRealMM(printInfo.getCustomWidth());
        int height = RichTextUtil.getRealMM(printInfo.getCustomHeight());
        StringBuilder sb = new StringBuilder("@page ");
        if (isFirst) {
            sb = new StringBuilder("@page :first ");
        }
        sb.append("{");
        sb.append(" size:").append(width).append("mm ").append(height).append("mm;");
        sb.append("margin-top:").append(RichTextUtil.getRealMM(printInfo.getMarginTop())).append("mm;");
        sb.append("margin-bottom:").append(RichTextUtil.getRealMM(printInfo.getMarginBottom())).append("mm;");
        sb.append("margin-left:").append(RichTextUtil.getRealMM(printInfo.getMarginLeft())).append("mm;");
        sb.append("margin-right:").append(RichTextUtil.getRealMM(printInfo.getMarginRight())).append("mm;");
        sb.append("}");
        return sb;
    }

    public static String[] getFontsList() {
        String fontDir = ExecuteService.getFontService().getFontFilesDir();
        List<PrtFont> fonts = ExecuteService.getFontService().getFonts();
        ArrayList<String> fontList = new ArrayList<String>(fonts.size());
        for (PrtFont prtFont : fonts) {
            String fontPath = fontDir + File.separator + prtFont.getFontFileName();
            File file = new File(fontPath);
            if (!file.exists()) {
                file = ExecuteService.getFontService().downloadFont(prtFont);
            }
            if (!file.exists()) continue;
            fontList.add(fontPath);
        }
        return fontList.toArray(new String[fontList.size()]);
    }

    public static StringBuilder initPageHtmlString() {
        return new StringBuilder("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">");
    }

    public static String parseHtmlImgSrc(String prtHtml, List<String> srcList) {
        if (srcList == null || srcList.isEmpty()) {
            return prtHtml;
        }
        PrintPluginProxy pluginProxy = ExecuteContext.get().getPluginProxy();
        Document doc = Jsoup.parse((String)prtHtml, (String)"", (Parser)Parser.xmlParser());
        Elements imgList = doc.select("img[src]");
        int i = 0;
        for (Element element : imgList) {
            String src = element.attr("src");
            String newSrc = srcList.get(i);
            if (pluginProxy != null) {
                ParseRichImgEvent evt = new ParseRichImgEvent(newSrc);
                pluginProxy.fireParseRichImg(evt);
                newSrc = evt.getImageSrc();
            }
            element.attr("src", newSrc);
            ++i;
        }
        return doc.toString();
    }

    public static List<String> getSrcList(String prtHtml) {
        ArrayList<String> srcList = new ArrayList<String>(10);
        Document doc = Jsoup.parse((String)prtHtml, (String)"", (Parser)Parser.xmlParser());
        Elements imgList = doc.select("img[src]");
        for (Element element : imgList) {
            String src = element.attr("src");
            String newSrc = RichTextUtil.getActualSrc(src);
            srcList.add(newSrc);
        }
        return srcList;
    }

    private static String getActualSrc(String src) {
        if (StringUtils.isEmpty((CharSequence)src)) {
            return src;
        }
        if (src.contains("blob:")) {
            src = src.replace("blob:", "");
        }
        String imageServerUrl = System.getProperty("image.fileserver");
        if (StringUtils.isNotEmpty((CharSequence)RequestContext.get().getClientImageServer())) {
            imageServerUrl = RequestContext.get().getClientImageServer();
        }
        if (StringUtils.isBlank((CharSequence)imageServerUrl)) {
            imageServerUrl = System.getProperty("fileserver");
        }
        if (StringUtils.isNotBlank((CharSequence)imageServerUrl) && !imageServerUrl.endsWith("/")) {
            imageServerUrl = imageServerUrl + "/";
        }
        if (StringUtils.isNotBlank((CharSequence)imageServerUrl) && src.contains(imageServerUrl)) {
            String path = src.replace(imageServerUrl, "");
            path = FileServiceExtFactory.getImageFileServiceExt().getRealPath(path);
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            return imageServerUrl + path;
        }
        String downloadPrefix = null;
        try {
            Method method = UrlService.class.getDeclaredMethod("getDownloadImageFullUrl", String.class);
            ReflectionUtils.makeAccessible((Method)method);
            downloadPrefix = (String)method.invoke(UrlService.class, "");
        }
        catch (Exception e) {
            logger.error("\u5bcc\u6587\u672c\u56fe\u7247\u63a7\u4ef6\u5730\u5740\u4fee\u6539\u65f6\u8c03\u7528UrlService\u5f02\u5e38", (Throwable)e);
        }
        if (StringUtils.isNotEmpty(downloadPrefix) && src.contains(downloadPrefix)) {
            return EncreptSessionUtils.encryptSession((String)src);
        }
        return src;
    }

    private static int getRealMM(double mmValue) {
        return (int)(mmValue / 10.0);
    }
}

