/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.runner.util;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.ctrl.kdf.util.style.LineStyle;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.StyleAttributes;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.model.designer.grid.MergeBlock;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.grid.AbstractPWGrid;
import kd.bos.print.core.model.widget.grid.AbstractPWGridCell;
import kd.bos.print.core.model.widget.grid.AbstractPWGridRow;
import kd.bos.print.core.model.widget.grid.MergeType;
import kd.bos.print.core.model.widget.grid.datagrid.AbstractPWDataGridRow;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGrid;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGridColumn;
import kd.bos.print.core.model.widget.grid.datagrid.PWDetailRow;

public class SubGridUtils {
    private SubGridUtils() {
    }

    public static void dealBlankRow(PWDataGrid parentOutputGrid, AbstractPWGridRow parentOutputRow) {
        if (parentOutputRow.isBlankRow() && parentOutputGrid.isNotBlankRow()) {
            Iterator iterator = parentOutputGrid.getOutputRows().iterator();
            while (iterator.hasNext()) {
                AbstractPWDataGridRow row = (AbstractPWDataGridRow)iterator.next();
                if (row != parentOutputRow) continue;
                iterator.remove();
                parentOutputGrid.getContext().setMaxHeightToAdjust(parentOutputGrid.getContext().getMaxHeightToAdjust() + parentOutputRow.getHeight());
                break;
            }
        }
    }

    public static boolean isHaveSubGrid(Object outputGrid) {
        return outputGrid instanceof PWDataGrid && !CollectionUtils.isEmpty(((PWDataGrid)outputGrid).getSubDataGrids());
    }

    public static boolean checkVSubGrid(PWDataGrid outputGrid) {
        return SubGridUtils.isHaveSubGrid(outputGrid) && "bottom".equals(outputGrid.getSubDataGrids().get(0).getSubGridDirection());
    }

    public static void handMerge(AbstractPWGrid parentGrid, AbstractPWGridRow parentOutputRow) {
        PWDataGrid subGrid;
        int columnCount = parentGrid.getColumnCount();
        if (parentGrid instanceof PWDataGrid && !CollectionUtils.isEmpty(((PWDataGrid)parentGrid).getSubDataGrids()) && "right".equals((subGrid = ((PWDataGrid)parentGrid).getSubDataGrids().get(0)).getSubGridDirection())) {
            columnCount += subGrid.getColumnCount();
        }
        for (int j = 0; j < columnCount; ++j) {
            Object cell = parentOutputRow.getCell(j);
            if (cell == null || !((AbstractPWGridCell)cell).isSubCell()) continue;
            if (((AbstractPWGridCell)cell).getMergeType() == MergeType.Merged) {
                MergeBlock block = ((AbstractPWGridCell)cell).getMergeBlock();
                Rectangle rectangle = ((AbstractPrintWidget)cell).getRectangle();
                int columnStart = block.getLeft();
                int colunmEnd = block.getRight();
                int step = 1;
                int columnWidth = rectangle.width;
                for (int colIndex = columnStart; colIndex < colunmEnd && j + step < columnCount; ++colIndex) {
                    columnWidth += ((AbstractPrintWidget)parentOutputRow.getCell((int)(j + step))).getRectangle().width;
                    ++step;
                }
                ((AbstractPrintWidget)cell).setRectangle(new Rectangle(rectangle.x, rectangle.y, columnWidth, rectangle.height));
                continue;
            }
            if (((AbstractPWGridCell)cell).getMergeType() != MergeType.BeMerged) continue;
            parentOutputRow.setCell(j, null);
        }
    }

    public static int getTitleRowCount(PWDataGrid grid) {
        return SubGridUtils.getRowCountByType(grid, 1);
    }

    public static int getStatRowCount(PWDataGrid grid) {
        return SubGridUtils.getRowCountByType(grid, 3);
    }

    public static Queue<AbstractPWDataGridRow> getRowsByType(PWDataGrid grid, int type) {
        LinkedList<AbstractPWDataGridRow> rowsQ = new LinkedList<AbstractPWDataGridRow>();
        int rowCount = grid.getRowsCount();
        for (int i = 0; i < rowCount; ++i) {
            AbstractPWDataGridRow row = (AbstractPWDataGridRow)grid.getRow(i);
            if (type != row.getRowType()) continue;
            rowsQ.offer(row);
        }
        return rowsQ;
    }

    public static int getRowCountByType(PWDataGrid grid, int type) {
        int rowCount = grid.getRowsCount();
        int count = 0;
        for (int i = 0; i < rowCount; ++i) {
            AbstractPWDataGridRow row = (AbstractPWDataGridRow)grid.getRow(i);
            if (type != row.getRowType()) continue;
            ++count;
        }
        return count;
    }

    public static void adjustCellStyle(PWDataGrid parentOutputGrid, PWDataGrid subDataGrid, AbstractPWGridCell cell) {
        Style style = cell.getStyle();
        LineStyle cBorderLineStyle = style.getBorderLineStyle(Styles.Position.BOTTOM);
        StyleAttributes sa = style.getNewAttribute();
        LineStyle borderLineStyle = cell.isSubCell() ? subDataGrid.getStyle().getBorderLineStyle(Styles.Position.BOTTOM) : parentOutputGrid.getStyle().getBorderLineStyle(Styles.Position.BOTTOM);
        if (cBorderLineStyle == LineStyle.NULL_LINE) {
            sa.setBorderLineStyle(Styles.Position.BOTTOM, borderLineStyle);
            cell.setStyle(Styles.getStyle(sa));
        }
    }

    public static void adjustCellStyle(PWDataGrid parentOutputGrid, PWDataGrid subDataGrid, AbstractPWGridCell cell, int i) {
        Style style = cell.getStyle();
        LineStyle cBorderLineStyle = style.getBorderLineStyle(Styles.Position.BOTTOM);
        StyleAttributes sa = style.getNewAttribute();
        LineStyle borderLineStyle = LineStyle.SINGLE_LINE;
        Color borderColor = Color.BLACK;
        int rowindex = cell.getRowIndex();
        if (cell.isSubCell()) {
            Object nextDesignRowCell;
            int designRowCount = subDataGrid.getRowsCount();
            AbstractPWGridRow finalDesignRow = null;
            AbstractPWGridRow nextDesignRow = null;
            if (rowindex + 1 == designRowCount) {
                finalDesignRow = (AbstractPWGridRow)subDataGrid.getRow(rowindex);
            } else {
                nextDesignRow = (AbstractPWGridRow)subDataGrid.getRow(rowindex + 1);
            }
            if (finalDesignRow != null) {
                if (!(finalDesignRow instanceof PWDetailRow)) {
                    Object finalDesignRowCell = finalDesignRow.getCell(i - parentOutputGrid.getColumnCount());
                    if (finalDesignRowCell != null) {
                        borderLineStyle = ((AbstractPrintWidget)finalDesignRowCell).getStyle().getBorderLineStyle(Styles.Position.BOTTOM);
                        borderColor = ((AbstractPrintWidget)finalDesignRowCell).getStyle().getBorderColor(Styles.Position.BOTTOM);
                    }
                } else {
                    borderLineStyle = sa.getBorderLineStyle(Styles.Position.BOTTOM);
                    borderColor = sa.getBorderColor(Styles.Position.BOTTOM);
                }
            } else if (nextDesignRow != null && (nextDesignRowCell = nextDesignRow.getCell(i - parentOutputGrid.getColumnCount())) != null) {
                borderLineStyle = ((AbstractPrintWidget)nextDesignRowCell).getStyle().getBorderLineStyle(Styles.Position.TOP);
                borderColor = ((AbstractPrintWidget)nextDesignRowCell).getStyle().getBorderColor(Styles.Position.TOP);
            }
        } else {
            int designRowCount = parentOutputGrid.getRowsCount();
            AbstractPWGridRow finalDesignRow = null;
            Object nextDesignRow = null;
            if (rowindex + 1 == designRowCount) {
                finalDesignRow = (AbstractPWGridRow)parentOutputGrid.getRow(rowindex);
            } else {
                nextDesignRow = parentOutputGrid.getRow(rowindex + 1);
            }
            if (finalDesignRow != null) {
                if (!(finalDesignRow instanceof PWDetailRow)) {
                    borderLineStyle = ((AbstractPrintWidget)finalDesignRow.getCell(i)).getStyle().getBorderLineStyle(Styles.Position.BOTTOM);
                    borderColor = ((AbstractPrintWidget)finalDesignRow.getCell(i)).getStyle().getBorderColor(Styles.Position.BOTTOM);
                } else {
                    borderLineStyle = sa.getBorderLineStyle(Styles.Position.BOTTOM);
                    borderColor = sa.getBorderColor(Styles.Position.BOTTOM);
                }
            } else {
                AbstractPWGridCell nextDesignRowCell = Optional.ofNullable(nextDesignRow).map(m -> m.getCell(i)).orElse(null);
                if (nextDesignRowCell != null) {
                    borderLineStyle = nextDesignRowCell.getStyle().getBorderLineStyle(Styles.Position.TOP);
                    borderColor = nextDesignRowCell.getStyle().getBorderColor(Styles.Position.TOP);
                }
            }
        }
        if (cBorderLineStyle == LineStyle.NULL_LINE) {
            sa.setBorderLineStyle(Styles.Position.BOTTOM, borderLineStyle);
            sa.setBorderColor(Styles.Position.BOTTOM, borderColor);
            cell.setStyle(Styles.getStyle(sa));
        }
    }

    public static void addEmptyCellToRow(PWDataGrid parentOutputGrid, PWDataGrid subDataGrid, AbstractPWGridRow parentOutputRow, AbstractPWGridRow subGridRow) {
        int columnCount = subDataGrid.getColumnCount();
        int height = parentOutputRow.getHeight();
        for (int i = 0; i < columnCount; ++i) {
            PWDataGridColumn col = (PWDataGridColumn)subDataGrid.getColumn(i);
            Object outputCell = subGridRow.getCell(i);
            AbstractPWGridCell copy = (AbstractPWGridCell)((AbstractPWGridCell)outputCell).copy();
            copy.setRectangle(new Rectangle(col.getWidth(), height));
            copy.setOutputText("");
            copy.setMergeType(((AbstractPWGridCell)outputCell).getMergeType());
            copy.setSubCell(true);
            copy.setRowIndex(subGridRow.getRowIndex());
            parentOutputRow.addCell(copy);
        }
        if (parentOutputGrid.isNotBlankRow()) {
            int cellCount = parentOutputRow.getCellCount();
            for (int i = 0; i < cellCount; ++i) {
                Object cell = parentOutputRow.getCell(i);
                if (cell == null) continue;
                ((AbstractPWGridCell)cell).setRowIndex(parentOutputRow.getRowIndex());
                SubGridUtils.adjustCellStyle(parentOutputGrid, subDataGrid, cell, i);
            }
        }
    }

    public static void adjustStatRowHeight(PWDataGrid parentOutputGrid, PWDataGrid subDataGrid, List<AbstractPWGridRow> pOutputStatRows, List<AbstractPWGridRow> sOutputStatRows) {
        int parentCellTotalHeight = 0;
        int subCellTotalHeight = 0;
        int subCellIndex = 0;
        for (int j = 0; j < pOutputStatRows.size(); ++j) {
            AbstractPWGridRow row = pOutputStatRows.get(j);
            int cellCount = row.getCellCount();
            int parentCellMaxH = 0;
            int subCellMaxH = 0;
            for (int i = 0; i < cellCount; ++i) {
                MergeBlock mb;
                Object cell = row.getCell(i);
                if (cell == null || ((AbstractPrintWidget)cell).getRectangle() == null) continue;
                if (!((AbstractPWGridCell)cell).isSubCell()) {
                    parentCellMaxH = Math.max(parentCellMaxH, ((AbstractPrintWidget)cell).getRectangle().height);
                    continue;
                }
                subCellMaxH = Math.max(subCellMaxH, ((AbstractPrintWidget)cell).getRectangle().height);
                if (j == 0 && ((AbstractPWGridCell)cell).getMergeType() == MergeType.BeMerged && (mb = ((AbstractPWGridCell)cell).getMergeBlock()).getLeft() == subCellIndex) {
                    ((AbstractPWGridCell)cell).setMergeType(MergeType.Merged);
                }
                ++subCellIndex;
            }
            parentCellTotalHeight += parentCellMaxH;
            subCellTotalHeight += subCellMaxH;
        }
        LinkedList<Integer> addHeightQ = new LinkedList<Integer>();
        int diffHeight = 0;
        int titleRowCount = 0;
        int flag = 0;
        if (parentCellTotalHeight > subCellTotalHeight) {
            diffHeight = parentCellTotalHeight - subCellTotalHeight;
            titleRowCount = sOutputStatRows.size();
            flag = 1;
        } else if (parentCellTotalHeight < subCellTotalHeight) {
            diffHeight = subCellTotalHeight - parentCellTotalHeight;
            titleRowCount = SubGridUtils.getModifyStatRowSize(pOutputStatRows);
            flag = 2;
        }
        if (flag != 0 && titleRowCount > 0) {
            int avgH = diffHeight / titleRowCount;
            int value = diffHeight % titleRowCount;
            for (int i = 0; i < titleRowCount; ++i) {
                if (i == 0) {
                    addHeightQ.add(avgH + value);
                    continue;
                }
                addHeightQ.add(avgH);
            }
            for (AbstractPWGridRow row : pOutputStatRows) {
                if (row.isAddRow()) continue;
                int cellCount = row.getCellCount();
                Integer addH = (Integer)addHeightQ.poll();
                for (int i = 0; i < cellCount; ++i) {
                    Object cell = row.getCell(i);
                    if (cell == null || ((AbstractPrintWidget)cell).getRectangle() == null) continue;
                    Rectangle rectangle = ((AbstractPrintWidget)cell).getRectangle();
                    if (flag == 1 && ((AbstractPWGridCell)cell).isSubCell() && addH != null) {
                        ((AbstractPrintWidget)cell).setRectangle(new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height + addH));
                        continue;
                    }
                    if (flag != 2 || ((AbstractPWGridCell)cell).isSubCell() || addH == null) continue;
                    ((AbstractPrintWidget)cell).setRectangle(new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height + addH));
                    if (rectangle.height + addH <= row.getHeight()) continue;
                    row.setHeight(rectangle.height + addH);
                }
            }
        }
    }

    private static int getModifyStatRowSize(List<AbstractPWGridRow> pOutputStatRows) {
        int i = 0;
        for (AbstractPWGridRow row : pOutputStatRows) {
            if (row.isAddRow()) continue;
            ++i;
        }
        return i;
    }

    public static void adjustRowHeight(PWDataGrid parentOutputGrid, PWDataGrid subDataGrid, int rowType) {
        List<AbstractPWDataGridRow> outputRows = parentOutputGrid.getOutputRows();
        int parentCellTotalHeight = 0;
        int subCellTotalHeight = 0;
        for (AbstractPWDataGridRow row : outputRows) {
            if (rowType != row.getRowType()) continue;
            int cellCount = row.getCellCount();
            int parentCellMaxH = 0;
            int subCellMaxH = 0;
            for (int i = 0; i < cellCount; ++i) {
                Object cell = row.getCell(i);
                if (cell == null || ((AbstractPrintWidget)cell).getRectangle() == null) continue;
                if (!((AbstractPWGridCell)cell).isSubCell()) {
                    parentCellMaxH = Math.max(parentCellMaxH, ((AbstractPrintWidget)cell).getRectangle().height);
                    continue;
                }
                subCellMaxH = Math.max(subCellMaxH, ((AbstractPrintWidget)cell).getRectangle().height);
            }
            parentCellTotalHeight += parentCellMaxH;
            subCellTotalHeight += subCellMaxH;
        }
        LinkedList<Integer> addHeightQ = new LinkedList<Integer>();
        int diffHeight = 0;
        int titleRowCount = 0;
        int flag = 0;
        if (parentCellTotalHeight > subCellTotalHeight) {
            diffHeight = parentCellTotalHeight - subCellTotalHeight;
            titleRowCount = SubGridUtils.getRowCountByType(subDataGrid, rowType);
            flag = 1;
        } else if (parentCellTotalHeight < subCellTotalHeight) {
            diffHeight = subCellTotalHeight - parentCellTotalHeight;
            titleRowCount = SubGridUtils.getRowCountByType(parentOutputGrid, rowType);
            flag = 2;
            if (rowType == 1) {
                parentOutputGrid.getContext().setMaxHeightToAdjust(parentOutputGrid.getContext().getMaxHeightToAdjust() - diffHeight);
            }
        }
        if (flag != 0 && titleRowCount > 0) {
            int avgH = diffHeight / titleRowCount;
            int value = diffHeight % titleRowCount;
            for (int i = 0; i < titleRowCount; ++i) {
                if (i == 0) {
                    addHeightQ.add(avgH + value);
                    continue;
                }
                addHeightQ.add(avgH);
            }
            for (AbstractPWDataGridRow row : outputRows) {
                if (rowType != row.getRowType()) continue;
                int cellCount = row.getCellCount();
                Integer addH = (Integer)addHeightQ.poll();
                for (int i = 0; i < cellCount; ++i) {
                    Object cell = row.getCell(i);
                    if (cell == null || ((AbstractPrintWidget)cell).getRectangle() == null) continue;
                    Rectangle rectangle = ((AbstractPrintWidget)cell).getRectangle();
                    if (flag == 1 && ((AbstractPWGridCell)cell).isSubCell() && addH != null) {
                        ((AbstractPrintWidget)cell).setRectangle(new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height + addH));
                        continue;
                    }
                    if (flag != 2 || ((AbstractPWGridCell)cell).isSubCell() || addH == null) continue;
                    ((AbstractPrintWidget)cell).setRectangle(new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height + addH));
                }
                if (flag == 2 && addH != null) {
                    row.setHeight(row.getHeight() + addH);
                    if (row.isAddRow()) {
                        row.setHeight(0);
                    }
                }
                if (!row.isAddRow()) continue;
                row.setHeight(0);
            }
        }
        if (parentOutputGrid.isNotBlankRow()) {
            SubGridUtils.subGridBorderHandler(parentOutputGrid, subDataGrid, rowType, outputRows);
        }
    }

    public static void subGridBorderHandler(PWDataGrid parentOutputGrid, PWDataGrid subDataGrid, int rowType, List<AbstractPWDataGridRow> outputRows) {
        for (AbstractPWDataGridRow row : outputRows) {
            if (rowType != row.getRowType()) continue;
            int cellCount = row.getCellCount();
            for (int i = 0; i < cellCount; ++i) {
                Object cell = row.getCell(i);
                if (cell == null) continue;
                ((AbstractPWGridCell)cell).setRowIndex(row.getRowIndex());
                SubGridUtils.adjustCellStyle(parentOutputGrid, subDataGrid, cell, i);
            }
        }
    }

    public static void dealBlankRow(PWDataGrid parentOutputGrid, Set<AbstractPWGridRow> parentOutputRows, Set<AbstractPWGridRow> subOutputRows, Queue<String> pagingFlagQ) {
        if (parentOutputGrid.isNotBlankRow()) {
            boolean shouldDeal = true;
            if (!pagingFlagQ.isEmpty()) {
                shouldDeal = false;
            }
            if (shouldDeal) {
                boolean parentAllBlank = true;
                boolean subAllBlank = true;
                for (AbstractPWGridRow temp : parentOutputRows) {
                    if (temp.isAddRow() || temp.isBlankRow()) continue;
                    parentAllBlank = false;
                }
                for (AbstractPWGridRow temp : subOutputRows) {
                    if (temp.isBlankRow()) continue;
                    subAllBlank = false;
                }
                if (parentAllBlank && subAllBlank) {
                    for (AbstractPWGridRow row : parentOutputRows) {
                        parentOutputGrid.getContext().setMaxHeightToAdjust(parentOutputGrid.getContext().getMaxHeightToAdjust() + row.getHeight());
                        row.setHeight(0);
                        int cellCount = row.getCellCount();
                        for (int j = 0; j < cellCount; ++j) {
                            row.setCell(j, null);
                        }
                    }
                }
            }
        }
    }
}

