/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.Plugin;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.data.R1PDataVisitor;
import kd.bos.print.core.plugin.AbstractKsPrintPlugin;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.AbstractPrintSeniorPlugin;
import kd.bos.print.core.plugin.IPrintPlugin;
import kd.bos.print.core.plugin.event.AfterLoadDataEvent;
import kd.bos.print.core.plugin.event.AfterOutputRowEvent;
import kd.bos.print.core.plugin.event.AfterOutputWidgetEvent;
import kd.bos.print.core.plugin.event.BeforeExportEvent;
import kd.bos.print.core.plugin.event.BeforeInitWidgetEvent;
import kd.bos.print.core.plugin.event.BeforeLoadDataEvent;
import kd.bos.print.core.plugin.event.BeforeOutputRowEvent;
import kd.bos.print.core.plugin.event.BeforeOutputWidgetEvent;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.bos.print.core.plugin.event.DataVisitorEvent;
import kd.bos.print.core.plugin.event.EndExportEvent;
import kd.bos.print.core.plugin.event.ExpFileEvent;
import kd.bos.print.core.plugin.event.LineWrapEvent;
import kd.bos.print.core.plugin.event.ParseRichImgEvent;
import kd.bos.print.core.plugin.event.bo.PluginDataVisitorBo;
import kd.bos.print.core.plugin.tpl.TplInfo;
import kd.bos.print.core.unitest.PrintUntiTestPluginProxy;
import kd.bos.script.ProjectInitializerManager;
import kd.bos.script.ScriptExecutor;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.kingscript.mixture.MixtureFactory;
import kd.sdk.kingscript.mixture.MixtureProxy;
import kd.sdk.kingscript.mixture.PluginMixtureProxy;

public class PrintPluginProxy {
    private static Log log = LogFactory.getLog(PrintPluginProxy.class);
    private List<IPrintPlugin> plugIns = new ArrayList<IPrintPlugin>();
    private ScriptExecutor scriptExecutor;

    public PrintPluginProxy(List<Map<String, Object>> plugins) {
        for (Map<String, Object> ins : plugins) {
            IPrintPlugin splugin;
            Object enable = ins.get("Enabled");
            if (enable != Boolean.TRUE) continue;
            int type = (Integer)ins.get("Type");
            String className = (String)ins.get("ClassName");
            if (0 == type) {
                try {
                    splugin = (IPrintPlugin)TypesContainer.createInstance((String)className);
                    if (splugin instanceof AbstractPrintPlugin) {
                        AbstractPrintPlugin abstractPrintPlugin = (AbstractPrintPlugin)splugin;
                        abstractPrintPlugin.setExtParam(ExecuteContext.get().getExtParam());
                        TplInfo tplInfo = new TplInfo();
                        tplInfo.setId(ExecuteContext.get().getTplId());
                        tplInfo.setKey(ExecuteContext.get().getTplKey());
                        abstractPrintPlugin.setTplInfo(tplInfo);
                        abstractPrintPlugin.setPreview(ExecuteContext.get().isPreview());
                        abstractPrintPlugin.setTotalPageMap(ExecuteContext.get().getTotalPageMap());
                    }
                    this.plugIns.add(splugin);
                }
                catch (Exception e) {
                    log.error("##print_plugin_error:className:" + className + e.getMessage());
                }
                continue;
            }
            if (1 == type) {
                try {
                    splugin = this.createScriptPlugin(className);
                    if (splugin == null) continue;
                    this.plugIns.add(splugin);
                    continue;
                }
                catch (Exception e) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"KS\u6253\u5370\u63d2\u4ef6\u8f6c\u6362\u5f02\u5e38%s\u3002", (String)"PrintPluginProxy_0", (String)"bos-print-core", (Object[])new Object[0]), e.getMessage()));
                }
            }
            if (4 != type || !Plugin.enableKingScript((String)"ScriptInitial")) continue;
            try {
                splugin = (IPrintPlugin)MixtureFactory.createMixtureProxy((MixtureProxy)new PluginMixtureProxy(className, scriptPath -> ProjectInitializerManager.getEngineAutoDebug((String)scriptPath)));
                if (splugin == null) continue;
                this.plugIns.add(splugin);
            }
            catch (Exception e) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"KS\u6253\u5370\u63d2\u4ef6\u8f6c\u6362\u5f02\u5e38%s\u3002", (String)"PrintPluginProxy_0", (String)"bos-print-core", (Object[])new Object[0]), e.getMessage()));
            }
        }
    }

    public void registerPlugin(IPrintPlugin plugIn) {
        this.plugIns.add(plugIn);
    }

    public IPrintPlugin createScriptPlugin(String scriptName) {
        String script = EntityMetadataCache.getPluginScripts((String)scriptName);
        this.scriptExecutor = ScriptExecutor.getOrCreate();
        this.scriptExecutor.init(ctx -> ctx.require(new String[]{AbstractKsPrintPlugin.class.getName()}));
        this.scriptExecutor.begin();
        this.scriptExecutor.exec(new String[]{script});
        return (IPrintPlugin)this.scriptExecutor.getContext().get("plugin");
    }

    public void destory() {
        if (this.scriptExecutor != null) {
            this.scriptExecutor.end();
        }
    }

    public void initDataVisitor(HashMap<String, R1PDataVisitor> dataVisitorMap) {
        if (dataVisitorMap == null) {
            return;
        }
        HashMap<String, PluginDataVisitorBo> visitorBoMap = new HashMap<String, PluginDataVisitorBo>(dataVisitorMap.size());
        for (Map.Entry<String, R1PDataVisitor> entry : dataVisitorMap.entrySet()) {
            visitorBoMap.put(entry.getKey(), new PluginDataVisitorBo(entry.getValue()));
        }
        for (IPrintPlugin pl : this.plugIns) {
            if (!(pl instanceof AbstractPrintPlugin)) continue;
            AbstractPrintPlugin abstractPrintPlugin = (AbstractPrintPlugin)pl;
            abstractPrintPlugin.setDataVisitorMap(visitorBoMap);
        }
    }

    public void fireBeforeLoadData(BeforeLoadDataEvent evt) {
        for (IPrintPlugin pl : this.plugIns) {
            pl.beforeLoadData(evt);
        }
    }

    public void fireAfterLoadData(AfterLoadDataEvent evt) {
        for (IPrintPlugin pl : this.plugIns) {
            pl.afterLoadData(evt);
        }
    }

    public void fireLoadCustomData(CustomDataLoadEvent evt) {
        for (IPrintPlugin pl : this.plugIns) {
            pl.loadCustomData(evt);
        }
    }

    public void fireBeforeInitWidgetEvent(BeforeInitWidgetEvent evt) {
        for (IPrintPlugin pl : this.plugIns) {
            pl.beforeInitWidget(evt);
        }
    }

    public void fireBeforeOutputWidget(BeforeOutputWidgetEvent evt) {
        for (IPrintPlugin pl : this.plugIns) {
            pl.beforeOutputWidget(evt);
        }
    }

    public void fireAfterOutputWidget(AfterOutputWidgetEvent evt) {
        for (IPrintPlugin pl : this.plugIns) {
            pl.afterOutputWidget(evt);
        }
    }

    public void fireBeforeOutputRow(BeforeOutputRowEvent evt) {
        for (IPrintPlugin pl : this.plugIns) {
            pl.beforeOutputRow(evt);
        }
    }

    public void fireAfterOutputRow(AfterOutputRowEvent evt) {
        for (IPrintPlugin pl : this.plugIns) {
            pl.afterOutputRow(evt);
        }
    }

    public void fireBeforeExport(BeforeExportEvent evt) {
        for (IPrintPlugin pl : this.plugIns) {
            pl.beforeExport(evt);
        }
    }

    public void fireEndOutput(EndExportEvent evt) {
        for (IPrintPlugin pl : this.plugIns) {
            pl.endExport(evt);
        }
    }

    public void fireBeforeExpFile(ExpFileEvent evt) {
        for (IPrintPlugin pl : this.plugIns) {
            pl.beforeExpFile(evt);
        }
    }

    public void fireParseRichImg(ParseRichImgEvent evt) {
        for (IPrintPlugin pl : this.plugIns) {
            pl.parseRichImg(evt);
        }
    }

    public void fireBeforeLineWrap(LineWrapEvent evt) {
        for (IPrintPlugin pl : this.plugIns) {
            pl.beforeLineWrap(evt);
        }
    }

    public void fireBeforeInitDataVisitor(DataVisitorEvent evt) {
        for (IPrintPlugin pl : this.plugIns) {
            if (!(pl instanceof AbstractPrintSeniorPlugin)) continue;
            AbstractPrintSeniorPlugin spl = (AbstractPrintSeniorPlugin)pl;
            spl.beforeInitDataVisitor(evt);
            log.info(String.format("execute fireBeforeInitDataVisitor(),maxQuerySize=%s,maxEntrySize=%s", evt.getMaxQuerySize(), evt.getMaxEntrySize()));
        }
    }

    @SdkInternal
    public void fireUnitestPlugin(PrintUntiTestPluginProxy.Method method, Object ... params) {
        try {
            PrintUntiTestPluginProxy.fireUnittestPlugin(this.plugIns, method, params);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

