/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.plugin.event;

import java.awt.Rectangle;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import kd.bos.print.core.ctrl.kdf.util.style.LineStyle;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.StyleAttributes;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.model.designer.grid.MergeBlock;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.AbstractPrintWidgetText;
import kd.bos.print.core.model.widget.StyleKey;
import kd.bos.print.core.model.widget.grid.AbstractPWGrid;
import kd.bos.print.core.model.widget.grid.AbstractPWGridCell;
import kd.bos.print.core.model.widget.grid.AbstractPWGridColumn;
import kd.bos.print.core.model.widget.grid.AbstractPWGridRow;
import kd.bos.print.core.plugin.event.AfterOutputWidgetEvent;
import kd.bos.print.core.plugin.event.bo.PWGridBo;
import kd.bos.print.core.plugin.event.bo.PWGridCellBo;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.lang3.StringUtils;

@SdkPublic
public class AfterOutputGridEvent
extends AfterOutputWidgetEvent<AbstractPWGrid> {
    private PWGridBo gridBo;

    public AfterOutputGridEvent(AbstractPWGrid widget) {
        super(widget);
        this.gridBo = new PWGridBo(widget);
    }

    @Deprecated
    @SdkInternal
    public AbstractPWGrid getWidget() {
        return (AbstractPWGrid)this.widget;
    }

    public PWGridBo getGrid() {
        return this.gridBo;
    }

    public int getRightSpace() {
        if (this.widget == null) {
            return -1;
        }
        Rectangle rectangle = ((AbstractPWGrid)this.widget).getRectangle();
        int x = rectangle.x;
        int columnCount = ((AbstractPWGrid)this.widget).getColumnCount();
        int widgetWidth = 0;
        for (int i = 0; i < columnCount; ++i) {
            widgetWidth += ((AbstractPWGridColumn)((AbstractPWGrid)this.widget).getColumn(i)).getWidth();
        }
        int containerWidth = ((AbstractPWGrid)this.widget).getContext().getContainerWidth();
        int rightSpace = containerWidth - x - widgetWidth;
        return rightSpace;
    }

    public PWGridCellBo addMerge(MergeBlock mergeBlock) {
        return this.addMerge(mergeBlock, null);
    }

    public PWGridCellBo addMerge(MergeBlock mergeBlock, String mergeValue) {
        int columnStart = mergeBlock.getLeft();
        int colunmEnd = mergeBlock.getRight();
        int rowStart = mergeBlock.getTop();
        int rowEnd = mergeBlock.getBottom();
        List outputRows = ((AbstractPWGrid)this.widget).getOutputRows();
        int columnCount = ((AbstractPWGrid)this.widget).getColumnCount();
        int rowCount = outputRows.size();
        int rowHeight = 0;
        int columnWidth = 0;
        for (int rowIndex = rowStart; rowIndex <= rowEnd; ++rowIndex) {
            rowHeight += ((AbstractPWGridRow)outputRows.get(rowIndex)).getHeight();
            for (int colIndex = columnStart; colIndex <= colunmEnd; ++colIndex) {
                Object cell = ((AbstractPWGridRow)outputRows.get(rowStart)).getCell(colIndex);
                if (rowIndex == rowStart) {
                    columnWidth += ((AbstractPrintWidget)cell).getRectangle().width;
                }
                if (rowIndex == rowStart && colIndex == columnStart) {
                    LineStyle borderRLineStyle;
                    Style style = ((AbstractPrintWidget)cell).getStyle();
                    StyleAttributes newAttribute = null;
                    if (colunmEnd == columnCount - 1 && (borderRLineStyle = style.getBorderLineStyle(Styles.Position.RIGHT)) == LineStyle.NULL_LINE) {
                        newAttribute = style.getNewAttribute();
                        newAttribute.setBorderLineStyle(Styles.Position.RIGHT, ((AbstractPrintWidget)((AbstractPWGridRow)outputRows.get(rowStart)).getCell(colunmEnd)).getStyle().getBorderLineStyle(Styles.Position.RIGHT));
                        ((AbstractPrintWidget)cell).setStyle(Styles.getStyle(newAttribute));
                    }
                    if (rowEnd == rowCount - 1) {
                        LineStyle borderBLineStyle;
                        if (newAttribute == null) {
                            newAttribute = style.getNewAttribute();
                        }
                        if ((borderBLineStyle = style.getBorderLineStyle(Styles.Position.BOTTOM)) == LineStyle.NULL_LINE) {
                            newAttribute.setBorderLineStyle(Styles.Position.BOTTOM, ((AbstractPrintWidget)((AbstractPWGridRow)outputRows.get(rowEnd)).getCell(columnStart)).getStyle().getBorderLineStyle(Styles.Position.BOTTOM));
                        }
                    }
                    if (newAttribute != null) {
                        ((AbstractPrintWidget)cell).setStyle(Styles.getStyle(newAttribute));
                    }
                }
                if (rowIndex == rowStart && colIndex == columnStart) continue;
                ((AbstractPWGridRow)outputRows.get(rowIndex)).setCell(colIndex, null);
            }
        }
        Object cell = ((AbstractPWGridRow)outputRows.get(rowStart)).getCell(columnStart);
        Rectangle rectangle = ((AbstractPrintWidget)cell).getRectangle();
        rectangle.width = columnWidth;
        rectangle.height = rowHeight;
        if (StringUtils.isNotBlank((CharSequence)mergeValue)) {
            ((AbstractPrintWidgetText)cell).setOutputText(mergeValue);
        }
        return new PWGridCellBo((AbstractPWGridCell)cell);
    }

    public void setRowStyle(StyleKey styleKey, Object value, int rowIndex) {
        if (!this.isGrid()) {
            return;
        }
        List outputRows = ((AbstractPWGrid)this.widget).getOutputRows();
        AbstractPWGridRow row = (AbstractPWGridRow)outputRows.get(rowIndex);
        int cellCount = row.getCellCount();
        for (int i = 0; i < cellCount; ++i) {
            Object cell = row.getCell(i);
            if (cell == null) continue;
            ((AbstractPrintWidget)cell).setProperty(styleKey.getKey(), value);
        }
    }

    public void setRowStyle(EnumMap<StyleKey, Object> styles, int rowIndex) {
        if (!this.isGrid()) {
            return;
        }
        AbstractPWGrid pwGrid = (AbstractPWGrid)this.widget;
        List outputRows = pwGrid.getOutputRows();
        AbstractPWGridRow row = (AbstractPWGridRow)outputRows.get(rowIndex);
        int cellCount = row.getCellCount();
        for (int i = 0; i < cellCount; ++i) {
            Object cell = row.getCell(i);
            if (cell == null) continue;
            for (Map.Entry<StyleKey, Object> entry : styles.entrySet()) {
                ((AbstractPrintWidget)cell).setProperty(entry.getKey().getKey(), entry.getValue());
            }
        }
    }

    public void setColStyle(StyleKey styleKey, Object value, int colIndex) {
        if (!this.isGrid()) {
            return;
        }
        AbstractPWGrid pwGrid = (AbstractPWGrid)this.widget;
        List outputRows = pwGrid.getOutputRows();
        for (AbstractPWGridRow row : outputRows) {
            Object cell = row.getCell(colIndex);
            if (cell == null) continue;
            ((AbstractPrintWidget)cell).setProperty(styleKey.getKey(), value);
        }
    }

    public void setColStyle(EnumMap<StyleKey, Object> styles, int colIndex) {
        if (!this.isGrid()) {
            return;
        }
        List outputRows = ((AbstractPWGrid)this.widget).getOutputRows();
        for (AbstractPWGridRow row : outputRows) {
            Object cell = row.getCell(colIndex);
            if (cell == null) continue;
            for (Map.Entry<StyleKey, Object> entry : styles.entrySet()) {
                ((AbstractPrintWidget)cell).setProperty(entry.getKey().getKey(), entry.getValue());
            }
        }
    }

    public void cancleVerticalBorder() {
        if (!this.isGrid()) {
            return;
        }
        List outputRows = ((AbstractPWGrid)this.widget).getOutputRows();
        for (AbstractPWGridRow row : outputRows) {
            int cellCount = row.getCellCount();
            for (int i = 0; i < cellCount; ++i) {
                Object cell = row.getCell(i);
                if (cell == null) continue;
                ((AbstractPrintWidget)cell).setProperty("border-left-width", 0);
                ((AbstractPrintWidget)cell).setProperty("border-right-width", 0);
            }
        }
    }

    public void cancleHorizontalBorder() {
        if (!this.isGrid()) {
            return;
        }
        List outputRows = ((AbstractPWGrid)this.widget).getOutputRows();
        for (AbstractPWGridRow row : outputRows) {
            int cellCount = row.getCellCount();
            for (int i = 0; i < cellCount; ++i) {
                Object cell = row.getCell(i);
                if (cell == null) continue;
                ((AbstractPrintWidget)cell).setProperty("border-top-width", 0);
                ((AbstractPrintWidget)cell).setProperty("border-bottom-width", 0);
            }
        }
    }

    private boolean isGrid() {
        return this.widget instanceof AbstractPWGrid;
    }
}

