/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.plugin.event;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.print.core.ctrl.kdf.util.style.LineStyle;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.StyleAttributes;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.exception.PrintException;
import kd.bos.print.core.model.designer.grid.MergeBlock;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.grid.AbstractPWGrid;
import kd.bos.print.core.model.widget.grid.AbstractPWGridCell;
import kd.bos.print.core.model.widget.grid.AbstractPWGridColumn;
import kd.bos.print.core.model.widget.grid.AbstractPWGridRow;
import kd.bos.print.core.model.widget.grid.MergeType;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGrid;
import kd.bos.print.core.model.widget.grid.datagrid.PWDetailRow;
import kd.bos.print.core.plugin.event.BeforeOutputWidgetEvent;
import kd.bos.print.core.plugin.event.bo.PWGridBo;
import kd.bos.print.core.plugin.event.bo.PWGridCellBo;
import kd.bos.print.core.plugin.event.bo.PWGridRowBo;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class BeforeOutputGridEvent
extends BeforeOutputWidgetEvent<AbstractPWGrid> {
    private PWGridBo gridBo;

    public BeforeOutputGridEvent(AbstractPWGrid widget) {
        super(widget);
        this.gridBo = new PWGridBo(widget);
    }

    public PWGridBo getGrid() {
        return this.gridBo;
    }

    @Override
    public String getWidgetKey() {
        return ((AbstractPWGrid)this.widget).getKey();
    }

    public int getRightSpace() {
        if (this.widget == null) {
            return -1;
        }
        Rectangle rectangle = ((AbstractPWGrid)this.widget).getRectangle();
        int x = rectangle.x;
        int columnCount = ((AbstractPWGrid)this.widget).getColumnCount();
        int widgetWidth = 0;
        for (int i = 0; i < columnCount; ++i) {
            widgetWidth += ((AbstractPWGridColumn)((AbstractPWGrid)this.widget).getColumn(i)).getWidth();
        }
        int containerWidth = ((AbstractPWGrid)this.widget).getContext().getContainerWidth();
        int rightSpace = containerWidth - x - widgetWidth;
        return rightSpace;
    }

    public int getButtomSpace() {
        if (this.widget == null) {
            return -1;
        }
        Rectangle rectangle = ((AbstractPWGrid)this.widget).getRectangle();
        int y = rectangle.y;
        int rowsCount = ((AbstractPWGrid)this.widget).getRowsCount();
        int widgetHeight = 0;
        for (int i = 0; i < rowsCount; ++i) {
            widgetHeight += ((AbstractPWGridRow)((AbstractPWGrid)this.widget).getRow(i)).getHeight();
        }
        int containerHeight = ((AbstractPWGrid)this.widget).getContext().getContainerHeight();
        int buttomSpace = containerHeight - y - widgetHeight;
        return buttomSpace;
    }

    public List<PWGridCellBo> addColumn(int colWidth) {
        int columnCount = ((AbstractPWGrid)this.widget).getColumnCount();
        return this.insertColumn(columnCount, colWidth);
    }

    public List<PWGridCellBo> insertColumn(int index, int colWidth) {
        return this.insertColumn(index, colWidth, false);
    }

    public List<PWGridCellBo> insertColumn(int index, int colWidth, boolean isReMerge) {
        int columnCount = ((AbstractPWGrid)this.widget).getColumnCount();
        if (index > columnCount || index < 0) {
            throw new PrintException("3", "index over exception,columnCount=" + columnCount);
        }
        Object pwGridColumn = ((AbstractPWGrid)this.widget).insertColumn(index);
        ((AbstractPWGridColumn)pwGridColumn).setWidth(colWidth);
        ((AbstractPrintWidget)pwGridColumn).setPrintable(true);
        int rowsCount = ((AbstractPWGrid)this.widget).getRowsCount();
        columnCount = ((AbstractPWGrid)this.widget).getColumnCount();
        boolean isLastColumn = false;
        if (index == columnCount - 1) {
            isLastColumn = true;
        }
        ArrayList<PWGridCellBo> cellBOList = new ArrayList<PWGridCellBo>(rowsCount);
        for (int i = 0; i < rowsCount; ++i) {
            Object cell = ((AbstractPWGridRow)((AbstractPWGrid)this.widget).getRow(i)).getCell(index);
            Object referCell = ((AbstractPWGridRow)((AbstractPWGrid)this.widget).getRow(i)).getCell(isLastColumn ? index - 1 : index + 1);
            ((AbstractPrintWidget)cell).setStyle(((AbstractPrintWidget)referCell).getStyle());
            ((AbstractPrintWidget)cell).setPrintable(true);
            if (isLastColumn) {
                StyleAttributes newAttribute = ((AbstractPrintWidget)referCell).getStyle().getNewAttribute();
                newAttribute.setBorderLineStyle(Styles.Position.RIGHT, LineStyle.NULL_LINE);
                ((AbstractPrintWidget)referCell).setStyle(Styles.getStyle(newAttribute));
            }
            cellBOList.add(new PWGridCellBo((AbstractPWGridCell)cell));
        }
        if (isReMerge) {
            this.calcMerge(mb -> {
                int left = mb.getLeft();
                int right = mb.getRight();
                if (index > left && index <= right) {
                    ++right;
                } else if (index <= left) {
                    ++left;
                    ++right;
                }
                return MergeBlock.create(left, right, mb.getTop(), mb.getBottom());
            });
            this.reMerge();
        }
        return cellBOList;
    }

    private void calcMerge(Function<MergeBlock, MergeBlock> biFunction) {
        Map<String, MergeBlock> mergeBlocks = ((AbstractPWGrid)this.widget).getMergeBlocks();
        ArrayList<MergeBlock> newMergeBlocks = new ArrayList<MergeBlock>(mergeBlocks.size());
        for (MergeBlock mergeBlock : mergeBlocks.values()) {
            newMergeBlocks.add(biFunction.apply(mergeBlock));
        }
        mergeBlocks.clear();
        for (MergeBlock block : newMergeBlocks) {
            String key = block.getTop() + "_" + block.getLeft();
            mergeBlocks.put(key, block);
        }
    }

    public void delColumn(int colIndex) {
        this.delColumn(colIndex, false);
    }

    public void delColumn(int colIndex, boolean isReMerge) {
        int columnCount = ((AbstractPWGrid)this.widget).getColumnCount();
        if (columnCount == 1) {
            throw new PrintException("-1", "Grid is only one Column,Not support to delete.");
        }
        if (colIndex == columnCount - 1) {
            int rowsCount = ((AbstractPWGrid)this.widget).getRowsCount();
            for (int i = 0; i < rowsCount; ++i) {
                Object targetCell = ((AbstractPWGridRow)((AbstractPWGrid)this.widget).getRow(i)).getCell(colIndex - 1);
                Object referCell = ((AbstractPWGridRow)((AbstractPWGrid)this.widget).getRow(i)).getCell(colIndex);
                if (targetCell == null || referCell == null) continue;
                LineStyle tarRBorderStyle = ((AbstractPrintWidget)targetCell).getStyle().getBorderLineStyle(Styles.Position.RIGHT);
                LineStyle refRBorderStyle = ((AbstractPrintWidget)referCell).getStyle().getBorderLineStyle(Styles.Position.RIGHT);
                if (tarRBorderStyle != LineStyle.NULL_LINE || refRBorderStyle == LineStyle.NULL_LINE) continue;
                StyleAttributes newAttribute = ((AbstractPrintWidget)targetCell).getStyle().getNewAttribute();
                newAttribute.setBorderLineStyle(Styles.Position.RIGHT, refRBorderStyle);
                ((AbstractPrintWidget)targetCell).setStyle(Styles.getStyle(newAttribute));
            }
        }
        if (isReMerge) {
            this.calcMerge(mb -> {
                int left = mb.getLeft();
                int right = mb.getRight();
                if (colIndex >= left && colIndex <= right) {
                    --right;
                } else if (colIndex < left) {
                    --left;
                    --right;
                }
                return MergeBlock.create(left, right, mb.getTop(), mb.getBottom());
            });
        }
        ((AbstractPWGrid)this.widget).delColumn(colIndex);
        if (isReMerge) {
            this.reMerge();
        }
    }

    private void reMerge() {
        try {
            Map<String, MergeBlock> mergeBlocks = ((AbstractPWGrid)this.widget).getMergeBlocks();
            for (MergeBlock mergeBlock : mergeBlocks.values()) {
                this.addMerge(mergeBlock);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void delColumns(List<Integer> colIndexs) {
        if (colIndexs == null || colIndexs.isEmpty()) {
            return;
        }
        colIndexs = colIndexs.stream().distinct().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        int columnCount = ((AbstractPWGrid)this.widget).getColumnCount();
        if (columnCount == 1) {
            throw new PrintException("-1", "Grid is only one Column,Not support to delete.");
        }
        if (colIndexs.size() >= columnCount) {
            throw new PrintException("-1", "Grid is can not delete all column.");
        }
        int lastCol = columnCount - 1;
        boolean containLasCol = colIndexs.contains(lastCol);
        for (Integer colIndex : colIndexs) {
            if (colIndex == lastCol) continue;
            ((AbstractPWGrid)this.widget).delColumn(colIndex);
        }
        if (containLasCol) {
            this.delColumn(((AbstractPWGrid)this.widget).getColumnCount() - 1);
        }
    }

    public List<PWGridCellBo> addRow(int rowHeight) {
        PWGridRowBo pwGridRowBo = this.addGridRow(rowHeight);
        return pwGridRowBo.getRowCell();
    }

    public PWGridRowBo addGridRow(int rowHeight) {
        int rowIndex = ((AbstractPWGrid)this.widget).getRowsCount();
        return this.insertGridRow(rowIndex, rowHeight);
    }

    public List<PWGridCellBo> insertRow(int index, int rowHeight) {
        PWGridRowBo gridRowBo = this.insertGridRow(index, rowHeight);
        return gridRowBo.getRowCell();
    }

    public PWGridRowBo insertGridRow(int index, int rowHeight) {
        return this.insertGridRow(index, rowHeight, false);
    }

    public PWGridRowBo insertGridRow(int index, int rowHeight, boolean isReMerge) {
        int rowCount = ((AbstractPWGrid)this.widget).getRowsCount();
        if (rowCount <= 0) {
            throw new PrintException("3", "DataGrid Rows is Zero.");
        }
        if (index > rowCount || index < 0) {
            throw new PrintException("3", "index over exception,rowCount=" + rowCount);
        }
        int detailRowIndex = -1;
        PWDetailRow detailRow = this.findDetailRow((AbstractPWGrid)this.widget);
        if (detailRow != null) {
            detailRowIndex = detailRow.getRowIndex();
        }
        AbstractPrintWidget row = null;
        row = detailRowIndex == -1 || index <= detailRowIndex ? (AbstractPrintWidget)((AbstractPWGrid)this.widget).insertRow(1, index) : (AbstractPrintWidget)((AbstractPWGrid)this.widget).insertRow(3, index);
        row.setId(DB.genStringId((String)"noTable"));
        row.setPrintable(true);
        ((AbstractPWGridRow)row).setHeight(rowHeight);
        rowCount = ((AbstractPWGrid)this.widget).getRowsCount();
        int cellCount = ((AbstractPWGridRow)row).getCellCount();
        AbstractPWGridRow referRow = null;
        referRow = index == rowCount - 1 ? (AbstractPWGridRow)((AbstractPWGrid)this.widget).getRow(index - 1) : (AbstractPWGridRow)((AbstractPWGrid)this.widget).getRow(index + 1);
        for (int i = 0; i < cellCount; ++i) {
            Object cell = ((AbstractPWGridRow)row).getCell(i);
            ((AbstractPrintWidget)cell).setPrintable(true);
            StyleAttributes newAttribute = ((AbstractPrintWidget)referRow.getCell(i)).getStyle().getNewAttribute();
            ((AbstractPrintWidget)cell).setStyle(Styles.getStyle(newAttribute));
        }
        if (isReMerge) {
            this.calcMerge(mb -> {
                int top = mb.getTop();
                int bottom = mb.getBottom();
                if (index > top && index <= bottom) {
                    ++bottom;
                } else if (index <= top) {
                    ++top;
                    ++bottom;
                }
                return MergeBlock.create(mb.getLeft(), mb.getRight(), top, bottom);
            });
            this.reMerge();
        }
        return new PWGridRowBo((AbstractPWGridRow)row);
    }

    public void delRow(int rowIndex) {
        this.delRow(rowIndex, false);
    }

    public void delRow(int rowIndex, boolean isReMerge) {
        int rowCount = ((AbstractPWGrid)this.widget).getRowsCount();
        int columnCount = ((AbstractPWGrid)this.widget).getColumnCount();
        if (rowIndex == rowCount - 1) {
            Object referRow = ((AbstractPWGrid)this.widget).getRow(rowIndex);
            Object targetRow = ((AbstractPWGrid)this.widget).getRow(rowIndex - 1);
            for (int i = 0; i < columnCount; ++i) {
                Object targetCell = ((AbstractPWGridRow)targetRow).getCell(i);
                Object referCell = ((AbstractPWGridRow)referRow).getCell(i);
                if (targetCell == null || referCell == null) continue;
                LineStyle tarRBorderStyle = ((AbstractPrintWidget)targetCell).getStyle().getBorderLineStyle(Styles.Position.BOTTOM);
                LineStyle refRBorderStyle = ((AbstractPrintWidget)referCell).getStyle().getBorderLineStyle(Styles.Position.BOTTOM);
                if (tarRBorderStyle != LineStyle.NULL_LINE || refRBorderStyle == LineStyle.NULL_LINE) continue;
                StyleAttributes newAttribute = ((AbstractPrintWidget)targetCell).getStyle().getNewAttribute();
                newAttribute.setBorderLineStyle(Styles.Position.BOTTOM, refRBorderStyle);
                ((AbstractPrintWidget)targetCell).setStyle(Styles.getStyle(newAttribute));
            }
        }
        if (isReMerge) {
            this.calcMerge(mb -> {
                int top = mb.getTop();
                int bottom = mb.getBottom();
                if (rowIndex >= top && rowIndex <= bottom) {
                    --bottom;
                } else if (rowIndex < top) {
                    --top;
                    --bottom;
                }
                return MergeBlock.create(mb.getLeft(), mb.getRight(), top, bottom);
            });
        }
        ((AbstractPWGrid)this.widget).delRow(rowIndex);
        if (isReMerge) {
            this.reMerge();
        }
    }

    public Map<String, MergeBlock> getMergeBlockMap() {
        return ((AbstractPWGrid)this.widget).getMergeBlocks();
    }

    private PWDetailRow findDetailRow(AbstractPWGrid grid) {
        if (grid instanceof PWDataGrid) {
            return null;
        }
        int rowCount = grid.getRowsCount();
        for (int i = 0; i < rowCount; ++i) {
            Object row = ((AbstractPWGrid)this.widget).getRow(i);
            if (!(row instanceof PWDetailRow)) continue;
            return (PWDetailRow)row;
        }
        return null;
    }

    public void addMerge(MergeBlock mergeBlock) {
        Map<String, MergeBlock> mergeBlocks = ((AbstractPWGrid)this.widget).getMergeBlocks();
        int columnStart = mergeBlock.getLeft();
        int colunmEnd = mergeBlock.getRight();
        int rowStart = mergeBlock.getTop();
        int rowEnd = mergeBlock.getBottom();
        mergeBlocks.put(rowStart + "_" + columnStart, mergeBlock);
        int columnCount = ((AbstractPWGrid)this.widget).getColumnCount();
        int rowsCount = ((AbstractPWGrid)this.widget).getRowsCount();
        for (int rowIndex = rowStart; rowIndex <= rowEnd; ++rowIndex) {
            for (int colIndex = columnStart; colIndex <= colunmEnd; ++colIndex) {
                Object row = ((AbstractPWGrid)this.widget).getRow(rowIndex);
                if (row instanceof PWDetailRow) {
                    throw new PrintException("3", "PWDetailRow is unsupport to Merge");
                }
                Object cell = ((AbstractPWGridRow)row).getCell(colIndex);
                if (cell == null) continue;
                Style style = ((AbstractPrintWidget)cell).getStyle();
                if (rowIndex == rowStart && colIndex == columnStart) {
                    ((AbstractPWGridCell)cell).setMergeType(MergeType.Merged);
                    StyleAttributes newAttribute = null;
                    if (colunmEnd == columnCount - 1) {
                        LineStyle borderRLineStyle = style.getBorderLineStyle(Styles.Position.RIGHT);
                        if (borderRLineStyle == LineStyle.NULL_LINE) {
                            newAttribute = style.getNewAttribute();
                            newAttribute.setBorderLineStyle(Styles.Position.RIGHT, ((AbstractPrintWidget)((AbstractPWGridRow)row).getCell(colunmEnd)).getStyle().getBorderLineStyle(Styles.Position.RIGHT));
                            ((AbstractPrintWidget)cell).setStyle(Styles.getStyle(newAttribute));
                        }
                        if (rowEnd == rowsCount - 1) {
                            LineStyle borderBLineStyle;
                            if (newAttribute == null) {
                                newAttribute = style.getNewAttribute();
                            }
                            if ((borderBLineStyle = style.getBorderLineStyle(Styles.Position.BOTTOM)) == LineStyle.NULL_LINE) {
                                newAttribute.setBorderLineStyle(Styles.Position.BOTTOM, ((AbstractPrintWidget)((AbstractPWGridRow)((AbstractPWGrid)this.widget).getRow(rowEnd)).getCell(columnStart)).getStyle().getBorderLineStyle(Styles.Position.BOTTOM));
                            }
                        }
                    }
                } else {
                    ((AbstractPWGridCell)cell).setMergeType(MergeType.BeMerged);
                }
                ((AbstractPWGridCell)cell).setMergeBlock(mergeBlock);
            }
        }
    }

    public PWGridCellBo getCell(int rowIndex, int colIndex) {
        return this.gridBo.getCell(rowIndex, colIndex);
    }

    public List<PWGridCellBo> getRowCell(int rowIndex) {
        return this.gridBo.getRowCell(rowIndex);
    }

    public List<PWGridCellBo> getColCell(int colIndex) {
        return this.gridBo.getColCell(colIndex);
    }

    @Override
    public void setLineSpace(double lineSpace, int type) {
        if (lineSpace < 1.0) {
            throw new KDBizException("lineHeight must > 1");
        }
        int rowCount = ((AbstractPWGrid)this.widget).getRowsCount();
        for (int index = 0; index < rowCount; ++index) {
            Object row = ((AbstractPWGrid)this.widget).getRow(index);
            int cellCount = ((AbstractPWGridRow)row).getCellCount();
            for (int cellIndex = 0; cellIndex < cellCount; ++cellIndex) {
                Object cell = ((AbstractPWGridRow)row).getCell(cellIndex);
                this.setLineSpace((AbstractPrintWidget)cell, lineSpace, type);
            }
        }
    }

    public void setLineSpace(double lineSpace, int type, int rowIndex, int colIndex) {
        if (lineSpace < 1.0) {
            throw new KDBizException("lineSpace must > 1");
        }
        int rowCount = ((AbstractPWGrid)this.widget).getRowsCount();
        if (rowIndex >= rowCount || rowIndex < 0) {
            throw new KDBizException(String.format("rowIndex must <%s and >=0", rowCount));
        }
        Object row = ((AbstractPWGrid)this.widget).getRow(rowIndex);
        int cellCount = ((AbstractPWGridRow)row).getCellCount();
        if (colIndex >= cellCount) {
            throw new KDBizException(String.format("colIndex must <%s and>=0", cellCount));
        }
        Object cell = ((AbstractPWGridRow)row).getCell(colIndex);
        this.setLineSpace((AbstractPrintWidget)cell, lineSpace, type);
    }
}

