/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.plugin.event;

import java.io.Serializable;
import kd.bos.exception.KDBizException;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.AbstractPrintWidgetField;
import kd.bos.print.core.model.widget.StyleKey;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class BeforeOutputWidgetEvent<T extends AbstractPrintWidget>
implements Serializable {
    @SdkInternal
    protected T widget;
    private boolean needFormat = true;

    @SdkInternal
    public BeforeOutputWidgetEvent(T widget) {
        this.widget = widget;
    }

    public String getWidgetKey() {
        return ((AbstractPrintWidget)this.widget).getKey();
    }

    public int getPageIndex() {
        if (this.widget == null) {
            return -1;
        }
        return ((AbstractPrintWidget)this.widget).getPageIndex();
    }

    public void setStyle(StyleKey styleKey, Object value) {
        ((AbstractPrintWidget)this.widget).setProperty(styleKey.getKey(), value);
    }

    public void setLineSpace(double lineSpace, int type) {
        if (lineSpace < 1.0) {
            throw new KDBizException("lineSpace must > 1");
        }
        this.setLineSpace((AbstractPrintWidget)this.widget, lineSpace, type);
    }

    protected void setLineSpace(AbstractPrintWidget widget, double lineSpace, int type) {
        widget.setProperty(StyleKey.LINE_SPACE.getKey(), Float.valueOf((float)lineSpace));
        widget.setProperty(StyleKey.LINE_SPACE_TYPE.getKey(), type);
    }

    public void setHidden(boolean isHidden) {
        ((AbstractPrintWidget)this.widget).setHide(isHidden);
        if (isHidden) {
            ((AbstractPrintWidget)this.widget).setHideMove(false);
        }
    }

    public boolean isHidden() {
        return ((AbstractPrintWidget)this.widget).isHide() || ((AbstractPrintWidget)this.widget).isHideMove();
    }

    public void setOutputValue(Field field) {
        this.widget.setOutputValue(field);
    }

    public void bindField(String dataSource, String field) {
        if (this.widget instanceof AbstractPrintWidgetField) {
            AbstractPrintWidgetField widgetField = (AbstractPrintWidgetField)this.widget;
            widgetField.setDatasource(dataSource);
            widgetField.setBindField(field);
        }
    }

    public boolean isNeedFormat() {
        return this.needFormat;
    }

    public void setNeedFormat(boolean needFormat) {
        this.needFormat = needFormat;
    }

    public void setHideMove(boolean hideMove) {
        ((AbstractPrintWidget)this.widget).setHideMove(hideMove);
    }
}

