/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.plugin.event;

import java.io.Serializable;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.print.core.execute.render.common.linewrap.ILineWrapSymbols;
import kd.bos.print.core.execute.render.common.linewrap.param.LineWrapSymbolType;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class LineWrapEvent
implements Serializable {
    private final ILineWrapSymbols lineWrapSymbols;

    public LineWrapEvent(ILineWrapSymbols lineWrapSymbols) {
        this.lineWrapSymbols = lineWrapSymbols;
    }

    public void setSymbolType(char symbol, LineWrapSymbolType type) {
        this.addSymbol(symbol, type);
        if (type == LineWrapSymbolType.SPLIT_SYMBOL) {
            this.removeSymbol(symbol, LineWrapSymbolType.BEFORE_SYMBOL);
            this.removeSymbol(symbol, LineWrapSymbolType.LAST_SYMBOL);
            this.removeSymbol(symbol, LineWrapSymbolType.NO_SPLIT_SYMBOL);
        } else if (type == LineWrapSymbolType.NO_SPLIT_SYMBOL) {
            this.removeSymbol(symbol, LineWrapSymbolType.BEFORE_SYMBOL);
            this.removeSymbol(symbol, LineWrapSymbolType.LAST_SYMBOL);
            this.removeSymbol(symbol, LineWrapSymbolType.SPLIT_SYMBOL);
        }
    }

    private void addSymbol(char symbol, LineWrapSymbolType type) {
        char[] symbols;
        for (char c : symbols = this.lineWrapSymbols.getSymbols(type)) {
            if (c != symbol) continue;
            return;
        }
        this.lineWrapSymbols.setSymbols(ArrayUtils.add((char[])symbols, (char)symbol), type);
    }

    private void removeSymbol(char symbol, LineWrapSymbolType type) {
        char[] symbols = this.lineWrapSymbols.getSymbols(type);
        this.lineWrapSymbols.setSymbols(ArrayUtils.removeElement((char[])symbols, (char)symbol), type);
    }
}

