/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.plugin.event.bo;

import java.util.ArrayList;
import java.util.List;
import kd.bos.print.core.data.PdIterator;
import kd.bos.print.core.model.widget.grid.AbstractPWGrid;
import kd.bos.print.core.model.widget.grid.AbstractPWGridCell;
import kd.bos.print.core.model.widget.grid.AbstractPWGridColumn;
import kd.bos.print.core.model.widget.grid.AbstractPWGridRow;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGrid;
import kd.bos.print.core.model.widget.grid.datagrid.PWDetailRow;
import kd.bos.print.core.model.widget.grid.datagrid.context.GridExecuteContext;
import kd.bos.print.core.plugin.event.bo.IPrintEventBo;
import kd.bos.print.core.plugin.event.bo.PWGridCellBo;
import kd.bos.print.core.plugin.event.bo.PWGridColumnBo;
import kd.bos.print.core.plugin.event.bo.PWGridRowBo;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class PWGridBo
implements IPrintEventBo {
    private AbstractPWGrid grid;

    @SdkInternal
    public PWGridBo(AbstractPWGrid grid) {
        this.grid = grid;
    }

    public int getColumnCount() {
        return this.grid.getColumnCount();
    }

    public int getRowCount() {
        return this.grid.getRowsCount();
    }

    public int getOutputRowCount() {
        return this.grid.getOutputRows().size();
    }

    public int gridIterCursor() {
        GridExecuteContext context = this.grid.getContext();
        if (context == null) {
            return 0;
        }
        PdIterator gridIterator = context.getGridIterator();
        if (gridIterator == null) {
            return 0;
        }
        return gridIterator.cursor();
    }

    public int getPageIndex() {
        if (this.grid == null) {
            return -1;
        }
        return this.grid.getPageIndex();
    }

    public boolean isDataGrid() {
        return this.grid instanceof PWDataGrid;
    }

    public String getDataSource() {
        if (this.isDataGrid()) {
            PWDataGrid pwDataGrid = (PWDataGrid)this.grid;
            return pwDataGrid.getDatasource();
        }
        return null;
    }

    public int getDataRowIndex() {
        if (!this.isDataGrid()) {
            return -1;
        }
        int rowsCount = this.grid.getRowsCount();
        for (int i = 0; i < rowsCount; ++i) {
            if (!(this.grid.getRow(i) instanceof PWDetailRow)) continue;
            return i;
        }
        return -1;
    }

    public PWGridRowBo getRow(int rowIndex) {
        Object row = this.grid.getRow(rowIndex);
        if (row == null) {
            return null;
        }
        return new PWGridRowBo((AbstractPWGridRow)row);
    }

    public PWGridColumnBo getColumn(int colIndex) {
        Object column = this.grid.getColumn(colIndex);
        if (column == null) {
            return null;
        }
        return new PWGridColumnBo((AbstractPWGridColumn)column);
    }

    public PWGridCellBo getCell(int rowIndex, int cellIndex) {
        Object row = this.grid.getRow(rowIndex);
        Object cell = ((AbstractPWGridRow)row).getCell(cellIndex);
        if (cell == null) {
            return null;
        }
        PWGridCellBo pwGridCellBo = new PWGridCellBo((AbstractPWGridCell)cell);
        return pwGridCellBo;
    }

    public List<PWGridCellBo> getRowCell(int rowIndex) {
        Object row = this.grid.getRow(rowIndex);
        int columnCount = this.grid.getColumnCount();
        ArrayList<PWGridCellBo> list = new ArrayList<PWGridCellBo>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            list.add(new PWGridCellBo((AbstractPWGridCell)((AbstractPWGridRow)row).getCell(i)));
        }
        return list;
    }

    public List<PWGridCellBo> getColCell(int colIndex) {
        int rowsCount = this.grid.getRowsCount();
        ArrayList<PWGridCellBo> list = new ArrayList<PWGridCellBo>(rowsCount);
        for (int i = 0; i < rowsCount; ++i) {
            Object cell = ((AbstractPWGridRow)this.grid.getRow(i)).getCell(colIndex);
            if (cell == null) {
                throw new IndexOutOfBoundsException(String.format("colIndex=%s,size=%s", colIndex, this.grid.getColumnCount()));
            }
            list.add(new PWGridCellBo((AbstractPWGridCell)cell));
        }
        return list;
    }

    public List<PWGridRowBo> getOutputRows() {
        List outputRows = this.grid.getOutputRows();
        ArrayList<PWGridRowBo> pwGridRowBos = new ArrayList<PWGridRowBo>(outputRows.size());
        for (AbstractPWGridRow row : outputRows) {
            pwGridRowBos.add(new PWGridRowBo(row));
        }
        return pwGridRowBos;
    }

    public PWGridCellBo getOutputCell(int rowIndex, int cellIndex) {
        List outputRows = this.grid.getOutputRows();
        Object cell = ((AbstractPWGridRow)outputRows.get(rowIndex)).getCell(cellIndex);
        if (cell == null) {
            return null;
        }
        PWGridCellBo pwGridCellBo = new PWGridCellBo((AbstractPWGridCell)cell);
        return pwGridCellBo;
    }

    @Override
    public boolean isNullBo() {
        return this.grid == null;
    }

    public String getKey() {
        return this.grid.getKey() == null ? "" : this.grid.getKey();
    }
}

