/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.plugin.event.bo;

import kd.bos.print.core.execute.render.common.linewrap.param.LineWrapRule;
import kd.bos.print.core.model.CurrencyFormat;
import kd.bos.print.core.model.UppercaseType;
import kd.bos.print.core.model.widget.StyleKey;
import kd.bos.print.core.model.widget.grid.AbstractPWGridCell;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.ACellValue;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueField;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueStat;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueText;
import kd.bos.print.core.plugin.event.bo.IPrintEventBo;
import kd.bos.print.core.plugin.event.bo.propenum.NegativeTypeEnum;
import kd.bos.print.core.plugin.event.bo.propenum.TextFormatEnum;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class PWGridCellBo
implements IPrintEventBo {
    private AbstractPWGridCell cell;

    @SdkInternal
    public PWGridCellBo(AbstractPWGridCell cell) {
        this.cell = cell;
    }

    public String getDatasource() {
        return this.cell.getDatasource();
    }

    public String getBindField() {
        return this.cell.getBindField();
    }

    public String getOutputText() {
        return this.cell.getOutputText();
    }

    public void setOutputText(String text) {
        this.cell.setOutputText(text);
    }

    public ACellValue getCellValue() {
        return this.cell.getCellValue();
    }

    public void setCellValue(String value) {
        this.cell.setCellValue(new CellValueText(value));
    }

    public void setCellValue(String dataSource, String field) {
        this.cell.setDatasource(dataSource);
        CellValueField cellValue = new CellValueField();
        cellValue.setField(field);
        this.cell.setCellValue(cellValue);
    }

    public void setCellValue(String dataSource, String field, int statType) {
        this.cell.setDatasource(dataSource);
        CellValueStat cellValue = new CellValueStat();
        cellValue.setField(field);
        if (statType == 1 || statType == 6) {
            cellValue.setStatType(statType);
        } else {
            cellValue.setStatType(0);
        }
        this.cell.setCellValue(cellValue);
    }

    public void setStyle(StyleKey styleKey, Object value) {
        this.cell.setProperty(styleKey.getKey(), value);
    }

    public void setTextFormat(TextFormatEnum textFormatEnum) {
        if (textFormatEnum == null) {
            this.cell.setTextFormat(TextFormatEnum.NORMAL.getType());
            return;
        }
        this.cell.setTextFormat(textFormatEnum.getType());
    }

    public String getTextFormat() {
        return this.cell.getTextFormat();
    }

    public String getNegativeType() {
        return this.cell.getNegativeType();
    }

    public void setNegativeType(NegativeTypeEnum negativeType) {
        if (negativeType == null) {
            negativeType = NegativeTypeEnum.NORMAL;
        }
        this.cell.setNegativeType(negativeType.getType());
    }

    public void setShowRedNegative(boolean showRedNegative) {
        this.cell.setShowRedNegative(showRedNegative);
    }

    public boolean isShowRedNegative() {
        return this.cell.isShowRedNegative();
    }

    public int getPrecision() {
        return this.cell.getPrecision();
    }

    public void setPrecision(int precision) {
        this.cell.setPrecision(precision);
    }

    public String getFormat() {
        return this.cell.getFormat();
    }

    public void setFormat(String format) {
        this.cell.setFormat(format);
    }

    public boolean isShowPercentage() {
        return this.cell.isShowPercentage();
    }

    public void setShowPercentage(boolean showPercentage) {
        this.cell.setShowPercentage(showPercentage);
    }

    public CurrencyFormat getCurrencyFormat() {
        return this.cell.getCurrencyFormat();
    }

    public void setCurrencyFormat(CurrencyFormat currencyFormat) {
        this.cell.setCurrencyFormat(currencyFormat);
    }

    public String getUppercaseType() {
        return this.cell.getUppercaseType();
    }

    public void setUppercaseType(UppercaseType uppercaseType) {
        this.cell.setUppercaseType(uppercaseType.getValue());
    }

    public LineWrapRule getLineWrapRule() {
        return LineWrapRule.getRule(this.cell.getLineWrapRule());
    }

    public void setLineWrapRule(LineWrapRule lineWrapRule) {
        this.cell.setLineWrapRule(lineWrapRule.ordinal());
    }

    public boolean isIgnoreTailZero() {
        return this.cell.isIgnoreTailZero();
    }

    public void setIgnoreTailZero(boolean ignoreTailZero) {
        this.cell.setIgnoreTailZero(ignoreTailZero);
    }

    public boolean isIgnoreZero() {
        return this.cell.isIgnoreZero();
    }

    public void setIgnoreZero(boolean ignoreZero) {
        this.cell.setIgnoreZero(ignoreZero);
    }

    @Override
    public boolean isNullBo() {
        return this.cell == null;
    }
}

