/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.plugin.event.bo;

import java.util.ArrayList;
import java.util.List;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.StyleKey;
import kd.bos.print.core.model.widget.grid.AbstractPWGridCell;
import kd.bos.print.core.model.widget.grid.AbstractPWGridRow;
import kd.bos.print.core.model.widget.grid.datagrid.AbstractPWDataGridRow;
import kd.bos.print.core.model.widget.grid.datagrid.PWDetailRow;
import kd.bos.print.core.model.widget.grid.datagrid.PWNormalRow;
import kd.bos.print.core.plugin.event.bo.IPrintEventBo;
import kd.bos.print.core.plugin.event.bo.PWGridCellBo;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class PWGridRowBo
implements IPrintEventBo {
    private AbstractPWGridRow gridRow;
    public static final int ROW_TITLE = 1;
    public static final int ROW_DETAIL = 2;
    public static final int ROW_STAT = 3;

    public PWGridRowBo(AbstractPWGridRow gridRow) {
        this.gridRow = gridRow;
    }

    public List<PWGridCellBo> getRowCell() {
        int cellCount = this.gridRow.getCellCount();
        ArrayList<PWGridCellBo> cellBOList = new ArrayList<PWGridCellBo>(cellCount);
        for (int i = 0; i < cellCount; ++i) {
            Object cell = this.gridRow.getCell(i);
            cellBOList.add(new PWGridCellBo((AbstractPWGridCell)cell));
        }
        return cellBOList;
    }

    public void setDisplayEveryPage(boolean displayEveryPage) {
        if (this.gridRow instanceof PWNormalRow && this.getRowType() == 1) {
            AbstractPWDataGridRow pwDataGridRow = (AbstractPWDataGridRow)this.gridRow;
            pwDataGridRow.setDisplayEveryPage(displayEveryPage);
        }
    }

    public boolean isDisplayEveryPage() {
        if (this.gridRow instanceof AbstractPWDataGridRow) {
            AbstractPWDataGridRow pwDataGridRow = (AbstractPWDataGridRow)this.gridRow;
            return pwDataGridRow.isDisplayEveryPage();
        }
        return false;
    }

    public boolean isDetailRow() {
        return this.gridRow instanceof PWDetailRow;
    }

    public int getRowType() {
        return this.gridRow.getRowType();
    }

    public void setRowStyle(StyleKey styleKey, Object value) {
        int cellCount = this.gridRow.getCellCount();
        for (int i = 0; i < cellCount; ++i) {
            Object cell = this.gridRow.getCell(i);
            if (cell == null) continue;
            ((AbstractPrintWidget)cell).setProperty(styleKey.getKey(), value);
        }
    }

    public PWGridCellBo getCell(int cellIndex) {
        Object cell = this.gridRow.getCell(cellIndex);
        if (cell == null) {
            return null;
        }
        PWGridCellBo pwGridCellBo = new PWGridCellBo((AbstractPWGridCell)cell);
        return pwGridCellBo;
    }

    @Override
    public boolean isNullBo() {
        return this.gridRow == null;
    }
}

