/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.script;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.script.ScriptSystemFun;

public class ScriptExecutor {
    private static Log log = LogFactory.getLog(ScriptExecutor.class);
    private ScriptSystemFun scriptSystemFun = new ScriptSystemFun();

    public String execute(String script, Object target) {
        String[] arr = script.split("\\+");
        if (arr.length == 5 && arr[1] != null && arr[2] != null && arr[3] != null) {
            String pageNumFormula = arr[1].trim();
            String pageNumType = arr[2].trim();
            String pageTotalFormula = arr[3].trim();
            if ("getPageNumber()".equals(pageNumFormula) && "getPageTotal()".equals(pageTotalFormula)) {
                if (pageNumType.contains("/")) {
                    arr[0] = ResManager.loadKDString((String)"\u7b2c", (String)"SystemDsBuilder_11", (String)"bos-print-business", (Object[])new Object[0]);
                    arr[4] = ResManager.loadKDString((String)"\u9875", (String)"SystemDsBuilder_12", (String)"bos-print-business", (Object[])new Object[0]);
                } else if (pageNumType.contains("\uff0c")) {
                    arr[0] = ResManager.loadKDString((String)"\u7b2c", (String)"SystemDsBuilder_11", (String)"bos-print-business", (Object[])new Object[0]);
                    arr[2] = String.format("%1$s\uff0c%2$s", ResManager.loadKDString((String)"\u9875", (String)"SystemDsBuilder_12", (String)"bos-print-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5171", (String)"SystemDsBuilder_13", (String)"bos-print-business", (Object[])new Object[0]));
                    arr[4] = ResManager.loadKDString((String)"\u9875", (String)"SystemDsBuilder_12", (String)"bos-print-business", (Object[])new Object[0]);
                }
            }
        }
        StringBuilder builder = new StringBuilder();
        for (String str : arr) {
            FORMULA_TYPE formulaType = FORMULA_TYPE.from(str = str.trim());
            if (formulaType == FORMULA_TYPE.STATIC_STRING) {
                builder.append(this.handString(str));
                continue;
            }
            if (formulaType == FORMULA_TYPE.SYS_FUN) {
                builder.append(this.runMethod(str, this.scriptSystemFun));
                continue;
            }
            if (formulaType == FORMULA_TYPE.PAGE_NUMBER || formulaType == FORMULA_TYPE.PAGE_TOTAL) {
                builder.append(this.runMethod(str, target));
                continue;
            }
            if (formulaType != FORMULA_TYPE.UNKNOW_FORMULA) continue;
            builder.append(str);
        }
        return builder.toString();
    }

    private String runMethod(String script, Object target) {
        try {
            Method method = this.findMethod(target.getClass(), script, Collections.emptyList());
            if (method == null) {
                return script;
            }
            Object invoke = method.invoke(target, new Object[0]);
            return String.valueOf(invoke);
        }
        catch (Exception e) {
            log.warn("\u6253\u5370\u83b7\u53d6\u7cfb\u7edf\u5b57\u6bb5\u5931\u8d25\uff1a", (Throwable)e);
            return script;
        }
    }

    private Method findMethod(Class<?> cl, String methodName, List<?> params) {
        Method m = null;
        Method[] ms = cl.getMethods();
        methodName = methodName.substring(0, methodName.indexOf("("));
        for (int i = 0; i < ms.length; ++i) {
            Class<?>[] parameterTypes;
            m = ms[i];
            if (!m.getName().equals(methodName)) continue;
            if (params == null && m.getParameterTypes().length == 0) {
                return m;
            }
            if (null == params || (parameterTypes = m.getParameterTypes()).length != params.size()) continue;
            for (int j = 0; j < params.size(); ++j) {
                if (params.get(j).getClass() == parameterTypes[j]) continue;
            }
            return m;
        }
        return null;
    }

    private String handString(String str) {
        str = str.replace("\"", "");
        str = str.trim();
        return str;
    }

    private static enum FORMULA_TYPE {
        PAGE_NUMBER,
        PAGE_TOTAL,
        SYS_FUN,
        STATIC_STRING,
        UNKNOW_FORMULA;


        public static FORMULA_TYPE from(String script) {
            if ("getPageNumber()".equals(script)) {
                return PAGE_NUMBER;
            }
            if ("getPageTotal()".equals(script)) {
                return PAGE_TOTAL;
            }
            if (script.endsWith("()")) {
                return SYS_FUN;
            }
            if (script.startsWith("\"") && script.endsWith("\"")) {
                return STATIC_STRING;
            }
            return UNKNOW_FORMULA;
        }
    }
}

