/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.CompareTypeDto;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.svc.attach.IAttachmentProp;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.FormDataSource;
import kd.bos.print.core.data.datasource.PrtDataSource;
import kd.bos.print.core.data.datasource.prop.Condition;
import kd.bos.print.core.data.datasource.prop.LogicTypes;
import kd.bos.print.core.data.field.CollectionField;

public class FilterUtil {
    private static final Log logger = LogFactory.getLog(FilterUtil.class);
    private static Map<String, Set<String>> SUPPORT_PROPERTIES_MAP = FilterUtil.getSupportPropertiesMap();
    private static Map<String, LogicTypes> logicTypesMap = FilterUtil.getLogicTypesMap();

    public static CollectionField filter(PrtDataSource dataSource, String ds, String controlKey, List<DataRowSet> listDataRowSet) {
        if (!(dataSource instanceof FormDataSource)) {
            return new CollectionField(listDataRowSet);
        }
        FormDataSource formDataSource = (FormDataSource)dataSource;
        PrtDataSource entityDataSource = FilterUtil.getEntityDataSource(ds, formDataSource);
        if (entityDataSource == null) {
            return new CollectionField(listDataRowSet);
        }
        List<Condition> conditionList = entityDataSource.getConditionList(controlKey);
        if (CollectionUtils.isEmpty(conditionList)) {
            return new CollectionField(listDataRowSet);
        }
        List<DataRowSet> filterDawSetList = FilterUtil.filter(conditionList, listDataRowSet);
        return new CollectionField(filterDawSetList);
    }

    private static PrtDataSource getEntityDataSource(String ds, FormDataSource formDataSource) {
        PrtDataSource entityDataSource = null;
        for (PrtDataSource childrenD : formDataSource.getChildrenDs()) {
            String dsName = childrenD.getDsName();
            if (!ds.equals(dsName)) continue;
            entityDataSource = childrenD;
            break;
        }
        return entityDataSource;
    }

    public static List<DataRowSet> filter(List<Condition> conditionList, List<DataRowSet> dataList) {
        return dataList.stream().filter(dataMap -> FilterUtil.filter(conditionList, dataMap)).collect(Collectors.toList());
    }

    private static boolean filter(List<Condition> conditionList, DataRowSet dataMap) {
        List<Object> prefix = FilterUtil.getPrefixExpression(conditionList, dataMap);
        try {
            return FilterUtil.resolve(prefix);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return false;
        }
    }

    private static List<Object> getPrefixExpression(List<Condition> conditionList, DataRowSet dataMap) {
        ArrayList<Object> prefix = new ArrayList<Object>();
        for (int i = 0; i < conditionList.size(); ++i) {
            Condition condition = conditionList.get(i);
            boolean res = condition.filter(dataMap.getField(condition.getField()));
            List<LogicTypes> leftBrackets = condition.getLeftBrackets();
            List<LogicTypes> rightBrackets = condition.getRightBrackets();
            prefix.addAll(leftBrackets);
            prefix.add(res);
            prefix.addAll(rightBrackets);
            if (i == conditionList.size() - 1) break;
            prefix.add((Object)condition.getLogic());
        }
        return prefix;
    }

    private static boolean resolve(List<Object> prefix) {
        Stack<Boolean> numStack = new Stack<Boolean>();
        Stack<LogicTypes> logicTypesStack = new Stack<LogicTypes>();
        for (Object o : prefix) {
            if (!(o instanceof LogicTypes)) {
                numStack.push((Boolean)o);
                continue;
            }
            LogicTypes logicType = (LogicTypes)((Object)o);
            if (logicType != LogicTypes.LEFT_BRACKETS && logicType != LogicTypes.RIGHT_BRACKETS) {
                FilterUtil.calculate(numStack, logicTypesStack, logicType);
                continue;
            }
            if (logicType == LogicTypes.LEFT_BRACKETS) {
                logicTypesStack.push(logicType);
                continue;
            }
            if (logicType != LogicTypes.RIGHT_BRACKETS) continue;
            while (logicTypesStack.peek() != LogicTypes.LEFT_BRACKETS) {
                FilterUtil.calculateOne(numStack, logicTypesStack);
            }
            logicTypesStack.pop();
        }
        while (!logicTypesStack.isEmpty()) {
            FilterUtil.calculateOne(numStack, logicTypesStack);
        }
        return (Boolean)numStack.get(0);
    }

    private static void calculateOne(Stack<Boolean> numStack, Stack<LogicTypes> logicTypesStack) {
        LogicTypes logic = logicTypesStack.pop();
        Boolean b1 = numStack.pop();
        Boolean b2 = numStack.pop();
        if (logic == LogicTypes.AND) {
            numStack.push(b1 != false && b2 != false);
        }
        if (logic == LogicTypes.OR) {
            numStack.push(b1 != false || b2 != false);
        }
    }

    private static void calculate(Stack<Boolean> numStack, Stack<LogicTypes> logicTypesStack, LogicTypes logicType) {
        if (logicTypesStack.isEmpty() || logicType.getPriority() > logicTypesStack.peek().getPriority()) {
            logicTypesStack.push(logicType);
            return;
        }
        FilterUtil.calculateOne(numStack, logicTypesStack);
        FilterUtil.calculate(numStack, logicTypesStack, logicType);
    }

    public static List<Condition> getConditionList(String filterSetting, String dataSource) {
        ArrayList<Condition> conditionList = new ArrayList<Condition>(10);
        EntityType entryType = FilterUtil.getEntryType(dataSource);
        if (entryType == null) {
            return conditionList;
        }
        Map map = (Map)SerializationUtils.fromJsonString((String)filterSetting, Map.class);
        Object conditionJson = map.get("condition");
        if (StringUtils.isBlank((CharSequence)filterSetting)) {
            return conditionList;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)String.valueOf(conditionJson), FilterCondition.class);
        List filterRows = filterCondition.getFilterRow();
        for (int i = 0; i < filterRows.size(); ++i) {
            IDataEntityProperty property;
            SimpleFilterRow simpleFilterRow = (SimpleFilterRow)filterRows.get(i);
            String fieldName = simpleFilterRow.getFieldName();
            List values = simpleFilterRow.getValue();
            String leftBracket = simpleFilterRow.getLeftBracket();
            String rightBracket = simpleFilterRow.getRightBracket();
            String compare = simpleFilterRow.getCompareType();
            String logic = simpleFilterRow.getLogic();
            if ("0".equals(logic)) {
                logic = "&&";
            } else if ("1".equals(logic)) {
                logic = "||";
            }
            LogicTypes logicTypes = logicTypesMap.get(logic);
            LogicTypes compareType = logicTypesMap.get(compare);
            List<Object> valueList = values.stream().map(FilterValue::getValue).collect(Collectors.toList());
            if ((LogicTypes.IN == compareType || LogicTypes.COLLECTION_CONTAIN == compareType) && (property = FilterUtil.getEntityProperty(entryType, fieldName)) instanceof BooleanProp) {
                ArrayList newValues = new ArrayList(valueList.size());
                for (Object t : valueList) {
                    if ("1".equals(t)) {
                        newValues.add("true");
                        continue;
                    }
                    newValues.add("false");
                }
                valueList = newValues;
            }
            if (i == filterRows.size() - 1) {
                logicTypes = null;
            }
            Condition condition = new Condition(FilterUtil.getBrackets(logicTypesMap, leftBracket), FilterUtil.getBrackets(logicTypesMap, rightBracket), fieldName, compareType, valueList, logicTypes);
            conditionList.add(condition);
        }
        return conditionList;
    }

    private static IDataEntityProperty getEntityProperty(EntityType entryType, String fieldName) {
        String[] split = fieldName.split("\\.");
        if (split.length == 2) {
            BasedataProp basedataProp;
            IDataEntityType complexType;
            String baseDataPro = split[0];
            IDataEntityProperty property = (IDataEntityProperty)entryType.getProperties().get((Object)baseDataPro);
            if (property instanceof BasedataProp && (complexType = (basedataProp = (BasedataProp)property).getComplexType()) != null) {
                return (IDataEntityProperty)complexType.getProperties().get((Object)split[1]);
            }
        }
        IDataEntityProperty property = (IDataEntityProperty)entryType.getProperties().get((Object)fieldName);
        return property;
    }

    private static Map<String, LogicTypes> getLogicTypesMap() {
        HashMap<String, LogicTypes> logicTypesMap = new HashMap<String, LogicTypes>(16);
        for (LogicTypes logicType : LogicTypes.values()) {
            logicTypesMap.put(logicType.getId(), logicType);
        }
        logicTypesMap.put("800", LogicTypes.EQUAL);
        logicTypesMap.put("801", LogicTypes.NOT_EQUAL);
        logicTypesMap.put("802", LogicTypes.STRING_CONTAIN);
        logicTypesMap.put("803", LogicTypes.NOT_CONTAIN);
        logicTypesMap.put("806", LogicTypes.ISNULL);
        logicTypesMap.put("807", LogicTypes.IS_NOTNULL);
        logicTypesMap.put("808", LogicTypes.START_WITH);
        logicTypesMap.put("809", LogicTypes.END_WITH);
        return logicTypesMap;
    }

    private static List<LogicTypes> getBrackets(Map<String, LogicTypes> logicTypesMap, String leftBracket) {
        ArrayList<LogicTypes> brackets = new ArrayList<LogicTypes>(10);
        if (StringUtils.isNotBlank((CharSequence)leftBracket)) {
            for (char c : leftBracket.toCharArray()) {
                LogicTypes bracket = logicTypesMap.get(String.valueOf(c));
                brackets.add(bracket);
            }
        }
        return brackets;
    }

    public static List<Map<String, Object>> hideFieldWhenDataLayOutFilter(String filterEntityNumber, MainEntityType mainEntityType, List<Map<String, Object>> cols) {
        Map<String, String> supportFieldMap = FilterUtil.getSupportFieldMap(mainEntityType, filterEntityNumber);
        List<Map<String, Object>> filter = cols.stream().filter(col -> supportFieldMap.containsKey(col.get("fieldName"))).collect(Collectors.toList());
        Iterator iterator = filter.iterator();
        while (iterator.hasNext()) {
            List compareTypeDtoList;
            Map col2 = (Map)iterator.next();
            Object compareTypes = col2.get("compareTypes");
            String fieldName = String.valueOf(col2.get("fieldName"));
            if (!(compareTypes instanceof List) || (compareTypeDtoList = (List)compareTypes).isEmpty()) continue;
            String[] split = fieldName.split("\\.");
            if (split.length > 2) {
                iterator.remove();
                continue;
            }
            if (split.length == 2 && -9 == (Integer)col2.get("fieldType")) {
                IDataEntityProperty property = (IDataEntityProperty)mainEntityType.getAllFields().get(split[0]);
                if (property instanceof IAttachmentProp) {
                    col2.put("fieldName", split[0]);
                    col2.put("fieldCaption", String.valueOf(property.getParent().getDisplayName()) + "." + String.valueOf(property.getDisplayName()));
                }
                col2.put("type", "text");
            }
            String className = supportFieldMap.get(fieldName);
            Set<String> supportLogicIds = SUPPORT_PROPERTIES_MAP.get(className);
            ArrayList<CompareTypeDto> newCompareTypeDtoList = new ArrayList<CompareTypeDto>(10);
            for (int i = 0; i < compareTypeDtoList.size(); ++i) {
                CompareTypeDto compareTypeDto = (CompareTypeDto)compareTypeDtoList.get(i);
                if (!supportLogicIds.contains(compareTypeDto.getId())) continue;
                newCompareTypeDtoList.add(compareTypeDto);
            }
            col2.put("compareTypes", newCompareTypeDtoList);
        }
        return filter;
    }

    private static Map<String, String> getSupportFieldMap(MainEntityType mainEntityType, String filterEntityNumber) {
        EntityType entityType = (EntityType)mainEntityType.getAllEntities().get(filterEntityNumber);
        DataEntityPropertyCollection properties = entityType.getProperties();
        HashMap<String, String> supportFieldMap = new HashMap<String, String>(properties.size());
        for (IDataEntityProperty prop : properties) {
            String propClassName;
            Object number;
            if (FilterUtil.isPropNotSupport(prop)) continue;
            String propName = prop.getName();
            if (prop instanceof ItemClassProp) {
                ItemClassProp itemClassProp = (ItemClassProp)prop;
                String name = itemClassProp.getName() + ".name";
                number = itemClassProp.getName() + ".number";
                propClassName = FilterUtil.getPropClassName((IDataEntityProperty)itemClassProp);
                supportFieldMap.put(name, propClassName);
                supportFieldMap.put((String)number, propClassName);
                continue;
            }
            if (prop instanceof BasedataProp) {
                BasedataProp basedataProp = (BasedataProp)prop;
                IDataEntityType complexType = basedataProp.getComplexType();
                if (complexType == null) continue;
                for (IDataEntityProperty property : complexType.getProperties()) {
                    if (FilterUtil.isPropNotSupport(property) || property instanceof BasedataProp) continue;
                    String className = FilterUtil.getPropClassName(property);
                    String pName = basedataProp.getName() + "." + property.getName();
                    supportFieldMap.put(pName, className);
                }
                continue;
            }
            if (prop instanceof IAttachmentProp) {
                MulBasedataProp mulBasedataProp = (MulBasedataProp)prop;
                String numberProperty = ((BasedataEntityType)mulBasedataProp.getComplexType()).getNumberProperty();
                number = mulBasedataProp.getName() + "." + numberProperty;
                propClassName = FilterUtil.getPropClassName(prop);
                supportFieldMap.put((String)number, propClassName);
                continue;
            }
            supportFieldMap.put(propName, FilterUtil.getPropClassName(prop));
        }
        return supportFieldMap;
    }

    private static boolean isPropNotSupport(IDataEntityProperty prop) {
        DateTimeProp dateProp;
        TimeProp timeProp;
        String propClassName = FilterUtil.getPropClassName(prop);
        if (!SUPPORT_PROPERTIES_MAP.containsKey(propClassName)) {
            return true;
        }
        if (prop instanceof TimeProp && StringUtils.isNotBlank((CharSequence)(timeProp = (TimeProp)prop).getRelateTimeRange())) {
            return true;
        }
        return prop instanceof DateTimeProp && StringUtils.isNotBlank((CharSequence)(dateProp = (DateTimeProp)prop).getRelateDateTimeRange());
    }

    private static String getPropClassName(IDataEntityProperty prop) {
        if (prop instanceof TextProp) {
            return TextProp.class.getName();
        }
        if (prop instanceof ItemClassProp) {
            return ItemClassProp.class.getName();
        }
        if (prop instanceof BasedataProp) {
            return BasedataProp.class.getName();
        }
        if (prop instanceof TimeProp) {
            return TimeProp.class.getName();
        }
        if (prop instanceof DecimalProp) {
            return DecimalProp.class.getName();
        }
        if (prop instanceof DateTimeProp) {
            return DateTimeProp.class.getName();
        }
        if (prop instanceof BooleanProp) {
            return BooleanProp.class.getName();
        }
        if (prop instanceof MulComboProp) {
            return MulComboProp.class.getName();
        }
        if (prop instanceof ComboProp) {
            return ComboProp.class.getName();
        }
        return prop.getClass().getName();
    }

    private static Map<String, Set<String>> getSupportPropertiesMap() {
        HashSet<String> numberLogicIds = new HashSet<String>(16);
        numberLogicIds.addAll(Arrays.asList(LogicTypes.EQUAL.getId(), LogicTypes.NOT_EQUAL.getId(), LogicTypes.GREATER_THEN.getId(), LogicTypes.LESS_THEN.getId(), LogicTypes.GREATER_OR_EQUAL_THEN.getId(), LogicTypes.LESS_OR_EQUAL_THEN.getId()));
        HashSet<String> textLogicIds = new HashSet<String>(16);
        textLogicIds.addAll(Arrays.asList(LogicTypes.EQUAL.getId(), LogicTypes.NOT_EQUAL.getId(), LogicTypes.STRING_CONTAIN.getId(), LogicTypes.NOT_CONTAIN.getId(), LogicTypes.START_WITH.getId(), LogicTypes.END_WITH.getId(), LogicTypes.ISNULL.getId(), LogicTypes.IS_NOTNULL.getId()));
        HashSet<String> dateLogicIds = new HashSet<String>(16);
        dateLogicIds.addAll(Arrays.asList(LogicTypes.EQUAL.getId(), LogicTypes.TODAY.getId(), LogicTypes.THIS_WEEK.getId(), LogicTypes.THIS_MONTH.getId(), LogicTypes.LAST_MONTH.getId(), LogicTypes.LAST_THREE_MONTH.getId(), LogicTypes.FROM_TO.getId()));
        HashSet<String> enumLogicIds = new HashSet<String>(16);
        enumLogicIds.add(LogicTypes.IN.getId());
        HashSet<String> collectionLogicIds = new HashSet<String>(16);
        collectionLogicIds.addAll(Arrays.asList(LogicTypes.COLLECTION_CONTAIN.getId(), LogicTypes.ISNULL.getId(), LogicTypes.IS_NOTNULL.getId()));
        HashSet<String> itemClassLogicIds = new HashSet<String>(16);
        itemClassLogicIds.addAll(Arrays.asList("800", "801", "802", "803", "806", "807", "808", "809"));
        HashSet<String> picLogicIds = new HashSet<String>(16);
        picLogicIds.addAll(Arrays.asList(LogicTypes.ISNULL.getId(), LogicTypes.IS_NOTNULL.getId()));
        HashMap<String, Set<String>> supportPropertiesMap = new HashMap<String, Set<String>>(16);
        supportPropertiesMap.put(TextProp.class.getName(), textLogicIds);
        supportPropertiesMap.put(BasedataProp.class.getName(), textLogicIds);
        supportPropertiesMap.put(MulBasedataProp.class.getName(), textLogicIds);
        supportPropertiesMap.put(TimeProp.class.getName(), textLogicIds);
        supportPropertiesMap.put(AdminDivisionProp.class.getName(), textLogicIds);
        supportPropertiesMap.put(DecimalProp.class.getName(), numberLogicIds);
        supportPropertiesMap.put(DateTimeProp.class.getName(), dateLogicIds);
        supportPropertiesMap.put(BooleanProp.class.getName(), enumLogicIds);
        supportPropertiesMap.put(ComboProp.class.getName(), enumLogicIds);
        supportPropertiesMap.put(MulComboProp.class.getName(), collectionLogicIds);
        supportPropertiesMap.put(ItemClassProp.class.getName(), itemClassLogicIds);
        supportPropertiesMap.put("kd.bos.entity.property.PictureProp", picLogicIds);
        supportPropertiesMap.put("kd.bos.entity.property.AttachmentProp", picLogicIds);
        return supportPropertiesMap;
    }

    private static EntityType getEntryType(String dataSource) {
        String[] split = dataSource.split("\\.");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)split[0]);
        EntityType entityType = (EntityType)dataEntityType.getAllEntities().get(split[split.length - 1]);
        return entityType;
    }
}

