/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.utils;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.entity.param.CustomParam;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.util.StringUtils;

public class PrintConst {
    public static final int ONE_PDF_MAXPAGE = 1000;
    public static final int MAX_CONSUME_THREAD = 2;
    private static final int THREAD_POLL_SIZE = 6;
    private static final int MAX_PREVIEW_NUM = 50;
    public static final String LIMITER_SCENE_CODE = "BOS_PRINT_LIMIT";
    public static final String LIMITER_BIZ_CODE = "printEngineTask";
    private static final int MAX_BILLNO_CREATE_FILE_NUM = 100;

    public static int onePdfMaxPage() {
        return PrintConst.getTenantIntProp("PRINRT_ONE_PDF_MAXPAGE", 1000);
    }

    public static int maxConsumeThread() {
        int threadPoolSize = PrintConst.getThreadPollSize();
        int maxConsumeThread = PrintConst.getTenantIntProp("PRINRT_MAX_CONSUME_THREAD", 2);
        if (maxConsumeThread < 1) {
            maxConsumeThread = 1;
        }
        if (maxConsumeThread > threadPoolSize) {
            maxConsumeThread = threadPoolSize;
        }
        return maxConsumeThread;
    }

    public static int getThreadPollSize() {
        int threadSize = PrintConst.getTenantIntProp("PRINRT_THREAD_SIZE", 6);
        if (threadSize < 1) {
            threadSize = 1;
        }
        return threadSize;
    }

    private static int getTenantIntProp(String key, int defaultValue) {
        int result = defaultValue;
        try {
            String tenantVal = SystemPropertyUtils.getProptyByTenant((String)key, (String)RequestContext.get().getTenantId());
            if (StringUtils.isNumericString((String)tenantVal)) {
                result = Integer.parseInt(tenantVal);
            }
        }
        catch (Exception e) {
            result = defaultValue;
        }
        return result;
    }

    public static int getMaxPreviewNum() {
        return 50;
    }

    public static int getMaxBillNoCreateFileNum() {
        Map customParam = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)new CustomParam());
        String maxZipFileNum = (String)customParam.get("MAX_BILLNO_CREATE_FILE_NUM");
        if (StringUtils.isNumeric((String)maxZipFileNum)) {
            try {
                return Integer.parseInt(maxZipFileNum);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 100;
    }
}

