/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.condition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormConfig;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.PrintJob;
import kd.bos.print.api.PrintWork;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.beanutils.MethodUtils;

public class PrintConditionUtils {
    private static final Log log = LogFactory.getLog(PrintConditionUtils.class);
    private static final String BOS_NOTEPRINT = "bos-noteprint";
    private static final String CLASS_NAME = "kd.bos.print.business.scheme.service.PrintConditionServiceImpl";

    public static boolean haveNewPrintCondition(String entityTypeId) {
        if (StringUtils.isBlank((CharSequence)entityTypeId)) {
            return false;
        }
        String className = CLASS_NAME;
        try {
            Class factory = TypesContainer.getOrRegister((String)className);
            return (Boolean)MethodUtils.invokeMethod(factory.newInstance(), (String)"haveNewPrintCondition", (Object[])new Object[]{entityTypeId});
        }
        catch (Exception e) {
            log.error("\u53cd\u5c04\u8c03\u7528\u670d\u52a1\u65b9\u6cd5\u6821\u9a8c\u5355\u636e\u662f\u5426\u914d\u7f6e\u65b0\u6253\u5370\u6761\u4ef6\u51fa\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    public static Map<String, Object> buildPrintJobByNewCondition(IFormView view, String billFormNumber, List<Object> pkIds, Map<String, Object> wfParams, Object defaultPrinter) {
        String className = CLASS_NAME;
        try {
            Class factory = TypesContainer.getOrRegister((String)className);
            String caption = view.getFormShowParameter().getFormConfig().getCaption().getLocaleValue();
            Object[] params = new Object[]{billFormNumber, pkIds, view, defaultPrinter, caption, wfParams};
            return (Map)MethodUtils.invokeMethod(factory.newInstance(), (String)"buildPrintJobByCondition", (Object[])params);
        }
        catch (Exception e) {
            log.error("\u53cd\u5c04\u8c03\u7528\u670d\u52a1\u65b9\u6cd5\u6784\u5efa\u6253\u5370\u4efb\u52a1\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public static Tuple<Integer, List<PrintJob>> newPrintCondition(IFormView view, String billFormNumber, String type, List<Object> pkIds, Object printerId, boolean showSelectPrintForm) {
        HashMap<String, Object> workflowParam = new HashMap<String, Object>(16);
        Map<String, Object> result = PrintConditionUtils.buildPrintJobByNewCondition(view, billFormNumber, pkIds, workflowParam, printerId == null ? "" : printerId);
        if (result.get("status") != null && "0".equals(result.get("status").toString())) {
            String jobStr;
            Object unMatchBillIdObj = result.get("unMatchBillIds");
            Object unUseTempIdObj = result.get("unUseTempIds");
            Object jobObj = result.get("jobs");
            List<PrintJob> jobs = new ArrayList<PrintJob>(0);
            List unMatchBillIds = null;
            List unUseTempIds = null;
            if (unMatchBillIdObj instanceof List) {
                unMatchBillIds = (List)unMatchBillIdObj;
            }
            if (unUseTempIdObj instanceof List) {
                unUseTempIds = (List)unUseTempIdObj;
            }
            if (jobObj instanceof List && StringUtils.isNotBlank((CharSequence)(jobStr = SerializationUtils.toJsonString((Object)jobObj)))) {
                jobs = SerializationUtils.fromJsonStringToList((String)jobStr, PrintJob.class);
            }
            if (!CollectionUtils.isEmpty((Collection)unMatchBillIds)) {
                PrintConditionUtils.showSelectPrintNew(view, billFormNumber, type, jobs, unMatchBillIds, unUseTempIds, new LinkedHashSet<String>(0), false, showSelectPrintForm, pkIds);
                return new Tuple((Object)0, jobs);
            }
            if (!CollectionUtils.isEmpty(pkIds) && pkIds.size() == 1 && !CollectionUtils.isEmpty(jobs) && jobs.size() > 1) {
                LinkedHashSet<String> matchIds = new LinkedHashSet<String>(16);
                for (PrintJob job : jobs) {
                    matchIds.add(String.valueOf(job.getTemplateId()));
                }
                PrintConditionUtils.showSelectPrintNew(view, billFormNumber, type, jobs, unMatchBillIds, unUseTempIds, matchIds, true, showSelectPrintForm, pkIds);
                return new Tuple((Object)0, jobs);
            }
            return new Tuple((Object)1, jobs);
        }
        return new Tuple((Object)-1, Collections.emptyList());
    }

    @Deprecated
    public static Tuple<Integer, List<PrintJob>> newPrintCondition(IFormView view, String billFormNumber, String type, List<Object> pkIds, Object printerId) {
        return PrintConditionUtils.newPrintCondition(view, billFormNumber, type, pkIds, printerId, false);
    }

    public static void showSelectPrintNew(IFormView view, String entityId, String type, List<PrintJob> jobs, List<Object> unMatchBillIds, List<String> unUseTempIds, Set<String> matchFilterTemplateId, boolean isShowPrintType, boolean showSelectPrintForm, List<Object> sortPkIds) {
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("bos_selecttemplate");
        param.setCustomParam("formid", (Object)entityId);
        String caption = "";
        FormShowParameter formShowParameter = view.getFormShowParameter();
        FormConfig fc = formShowParameter.getFormConfig();
        if (fc != null && fc.getCaption() != null) {
            caption = fc.getCaption().getLocaleValue();
        }
        param.setCustomParam("jobname", (Object)caption);
        param.setCustomParam("ServiceAppId", (Object)formShowParameter.getServiceAppId());
        String text = "";
        if (CollectionUtils.isEmpty(jobs)) {
            text = ResManager.loadKDString((String)"\u7531\u4e8e\u6253\u5370\u6761\u4ef6\u672a\u5339\u914d\u6210\u529f\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u53ef\u7528\u7684\u6253\u5370\u6a21\u677f\u3002", (String)"AbstractPrint_2", (String)BOS_NOTEPRINT, (Object[])new Object[0]);
        } else if (!CollectionUtils.isEmpty(unMatchBillIds)) {
            PrintConditionUtils.setJob(jobs, param);
            text = ResManager.loadKDString((String)"\u6279\u91cf\u6253\u5370\u65f6\uff0c\u5b58\u5728\u4e0d\u6ee1\u8db3\u6761\u4ef6\u7684\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u53ef\u7528\u7684\u6253\u5370\u6a21\u677f\u3002", (String)"AbstractPrint_7", (String)BOS_NOTEPRINT, (Object[])new Object[0]);
        }
        param.setCustomParam("text", (Object)text);
        param.setCustomParam("invisibleFilterTemplateId", (Object)SerializationUtils.toJsonString(unUseTempIds));
        param.setCustomParam("pkids", unMatchBillIds);
        param.setCustomParam("sortPkids", sortPkIds);
        if ("printexportexcel".equals(type)) {
            param.setCustomParam("type", (Object)"printexportexcel");
        } else if ("print".equals(type)) {
            param.setCustomParam("type", (Object)"print");
            param.setCustomParam("showSelectPrintForm", (Object)showSelectPrintForm);
        } else if (PrintWork.EXP_TYPE.EXP_CLIENTPREVIEW.getCode().equals(type)) {
            param.setCustomParam("type", (Object)PrintWork.EXP_TYPE.EXP_CLIENTPREVIEW.getCode());
        } else {
            param.setCustomParam("type", (Object)"printpreview");
        }
        param.setCustomParam("isShowPrintType", (Object)isShowPrintType);
        if (isShowPrintType) {
            PrintConditionUtils.setJob(jobs, param);
            text = ResManager.loadKDString((String)"\u7531\u4e8e\u6253\u5370\u6761\u4ef6\u5339\u914d\u591a\u4e2a\u6a21\u677f\uff0c\u8bf7\u9009\u62e9\u6253\u5370\u65b9\u5f0f\u3002", (String)"AbstractPrint_38", (String)BOS_NOTEPRINT, (Object[])new Object[0]);
            param.setCustomParam("text", (Object)text);
            param.setCustomParam("matchFilterTemplateId", (Object)SerializationUtils.toJsonString(matchFilterTemplateId));
        }
        param.setCustomParam("from", (Object)"newprintcondition");
        if (view.getFormShowParameter().getCustomParams().containsKey("extParam")) {
            param.setCustomParam("extParam", view.getFormShowParameter().getCustomParams().get("extParam"));
        }
        if (view.getFormShowParameter().getCustomParams().containsKey("showprogressrowcount")) {
            param.setCustomParam("showprogressrowcount", view.getFormShowParameter().getCustomParams().get("showprogressrowcount"));
        }
        view.showForm(param);
    }

    private static void setJob(List<PrintJob> jobs, FormShowParameter param) {
        List<PrintJob> oldPrintJobs;
        Map<String, List<PrintJob>> diffJobs = PrintConditionUtils.diffPrintJobs(jobs);
        List<PrintJob> newPrintJobs = diffJobs.get("newPrintJobs");
        if (!CollectionUtils.isEmpty(newPrintJobs)) {
            param.setCustomParam("newPrintJobs", (Object)SerializationUtils.toJsonString(newPrintJobs));
        }
        if (!CollectionUtils.isEmpty(oldPrintJobs = diffJobs.get("oldPrintJobs"))) {
            param.setCustomParam("oldPrintJobs", (Object)SerializationUtils.toJsonString(oldPrintJobs));
        }
    }

    private static Map<String, List<PrintJob>> diffPrintJobs(List<PrintJob> jobs) {
        List tplIds = jobs.stream().map(PrintJob::getTemplateId).collect(Collectors.toList());
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"bos_manageprinttpl", (String)"id,type,printtplid_id", (QFilter[])new QFilter[]{new QFilter("PRINTTPLID", "in", tplIds)});
        HashMap<String, Object> config = new HashMap<String, Object>(16);
        for (DynamicObject obj : dynamicObjectMap.values()) {
            String type = obj.getString("type");
            String tplId = obj.getString("printtplid_id");
            config.put(tplId, type);
        }
        ArrayList<PrintJob> oldPrintJobs = new ArrayList<PrintJob>(10);
        ArrayList<PrintJob> newPrintJobs = new ArrayList<PrintJob>(10);
        for (PrintJob job : jobs) {
            if (job.getTemplateId() == null) continue;
            String type = (String)config.get(job.getTemplateId().toString());
            if ("B".equals(type)) {
                newPrintJobs.add(job);
                continue;
            }
            oldPrintJobs.add(job);
        }
        HashMap<String, List<PrintJob>> result = new HashMap<String, List<PrintJob>>(2);
        result.put("oldPrintJobs", oldPrintJobs);
        result.put("newPrintJobs", newPrintJobs);
        return result;
    }

    public static Map<Object, List<Object>> getMatchIdsWithTemplate(String billFormNumber, List<Object> pkIds) {
        String className = CLASS_NAME;
        try {
            Class factory = TypesContainer.getOrRegister((String)className);
            Object[] params = new Object[]{billFormNumber, pkIds};
            return (Map)MethodUtils.invokeMethod(factory.newInstance(), (String)"getMatchIdsWithTemplate", (Object[])params);
        }
        catch (Exception e) {
            log.error("\u53cd\u5c04\u8c03\u7528\u670d\u52a1\u65b9\u6cd5\u6784\u5efa\u6253\u5370\u6a21\u7248\u6620\u5c04\u6570\u636eID\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return Collections.emptyMap();
        }
    }
}

