/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.param.CustomParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.PrintMetadata;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.print.api.utils.ConfigConstUtil;
import kd.bos.print.business.utils.OldPrintTemplateUtil;
import kd.bos.print.business.utils.PrintParamUtils;
import kd.bos.service.IFormDesignService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.PrintServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.svc.util.print.UpdateLocalNameUtil;
import kd.bos.template.orgctrl.utils.ParamUtils;

public class PrintDesignerService
implements IFormDesignService {
    private Log log = LogFactory.getLog(this.getClass());

    public void beforeSave(Map<String, Object> content) {
        boolean hasPermission;
        if (!PrintParamUtils.isTemplateOrgIsolated()) {
            return;
        }
        if (CollectionUtils.isEmpty(content)) {
            return;
        }
        String tplId = String.valueOf(content.get("id"));
        CustomParam customParam = new CustomParam();
        customParam.getSearchKeySet().add("printcheckPermission");
        Map paramMap = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)customParam);
        if ("false".equals(paramMap.get("printcheckPermission"))) {
            return;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_manageprinttpl", (String)"id,createorg", (QFilter[])new QFilter[]{new QFilter("printtplid", "=", (Object)tplId)});
        if (dynamicObject == null) {
            return;
        }
        DynamicObject orgObj = dynamicObject.getDynamicObject("createorg");
        if (orgObj == null) {
            return;
        }
        long createorg = orgObj.getLong("id");
        if (createorg == -1L) {
            return;
        }
        boolean bl = hasPermission = 1 == PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)createorg, (String)"15", (String)AppMetadataCache.getAppInfoByNumber((String)"cts").getId(), (String)"bos_manageprinttpl", (String)"4715a0df000000ac");
        if (!hasPermission) {
            String permItemName = String.valueOf(PermissionServiceHelper.getPermItemNameById((String)"4715a0df000000ac"));
            String formName = String.valueOf(FormMetadataCache.getFormConfig((String)"bos_manageprinttpl").getCaption());
            String msg = String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PrintDesignerPlugin_15", (String)"bos-print-business", (Object[])new Object[0]), formName, permItemName);
            throw new KDBizException(msg);
        }
    }

    public boolean isCanEditTpl(String tplId) {
        return this.checkPrintTemplateCanSave(tplId);
    }

    public void afterSave(Map<String, Object> content) {
        String name;
        String tplId = String.valueOf(content.get("id"));
        this.updateManagetpl(tplId);
        boolean isExists = QueryServiceHelper.exists((String)"bos_print_meta", (Object)tplId);
        if (!isExists) {
            QFilter qFilter = new QFilter("id", "=", (Object)tplId);
            DynamicObject formMeta = OldPrintTemplateUtil.loadSingleFromCache((String)"id,number,bizappid,basedatafield,modifierid", (QFilter[])new QFilter[]{qFilter});
            DynamicObject metaObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_print_meta");
            DynamicObject printTplInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"bas_manageprinttpl", (QFilter[])new QFilter[]{new QFilter("printtplid", "=", (Object)tplId)});
            Object createorg = this.getCreateorg(printTplInfo);
            String number = (String)formMeta.get("number");
            metaObj.set("id", (Object)tplId);
            metaObj.set("masterid", (Object)tplId);
            metaObj.set("number", (Object)number);
            metaObj.set("name", formMeta.get("name"));
            DynamicObject basedatafield = formMeta.getDynamicObject("basedatafield");
            metaObj.set("formid", basedatafield.get("number"));
            metaObj.set("creator", formMeta.get("modifierid"));
            metaObj.set("modifier", formMeta.get("modifierid"));
            metaObj.set("type", (Object)"A");
            metaObj.set("bizappid", formMeta.get("bizappid"));
            metaObj.set("createtime", (Object)new Date());
            metaObj.set("modifytime", (Object)new Date());
            metaObj.set("org", createorg);
            metaObj.set("status", (Object)"C");
            metaObj.set("enable", (Object)"1");
            metaObj.set("version", (Object)"1");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{metaObj});
        }
        if (isExists) {
            DynamicObject metaObj = BusinessDataServiceHelper.loadSingleFromCache((Object)tplId, (String)"bos_print_meta");
            metaObj.set("modifytime", (Object)new Date());
            SaveServiceHelper.update((DynamicObject)metaObj);
        }
        if (StringUtils.isBlank((CharSequence)(name = String.valueOf(content.get("caption"))))) {
            return;
        }
        String curLang = String.valueOf(content.get("language"));
        String sql = "delete from %s where fid=? and flocaleid=? ";
        sql = String.format(sql, "t_svc_printmeta_L");
        Object[] params = new SqlParameter[]{new SqlParameter("fid", 12, (Object)tplId), new SqlParameter("flocaleid", 12, (Object)curLang)};
        DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
        sql = "insert %s (fid,fpkid,fname,flocaleid) values(?,?,?,?)";
        sql = String.format(sql, "t_svc_printmeta_L");
        params = new SqlParameter[]{new SqlParameter("fid", 12, (Object)tplId), new SqlParameter("fpkid", 12, (Object)DB.genStringId((String)"t_svc_printmeta_L")), new SqlParameter("fname", 12, (Object)name), new SqlParameter("flocaleid", 12, (Object)curLang)};
        DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
        DataEntityCacheManager cacheManager = new DataEntityCacheManager("t_svc_printmeta");
        cacheManager.removeByPrimaryKey(new Object[]{tplId});
    }

    private Object getCreateorg(DynamicObject printTplInfo) {
        Object createorg = null;
        if (printTplInfo != null) {
            createorg = printTplInfo.get("createorg");
        }
        if (StringUtils.isBlank(createorg)) {
            createorg = RequestContext.get().getOrgId();
        }
        return createorg;
    }

    public String preview(String pageId, String formId, String templateFormId) {
        return PrintServiceHelper.createSamplePdfUrl(pageId, formId, templateFormId);
    }

    public Map<String, Object> copyPrintMetadata(Map<String, Object> params) {
        String bizFormId = (String)params.get("bizFormId");
        String bizAppId = (String)params.get("bizAppId");
        String bizUnitId = (String)params.get("bizUnitId");
        String formNumber = (String)params.get("formNumber");
        String tplName = (String)params.get("tplName");
        return PrintServiceHelper.copyPrintMetadata(bizFormId, bizAppId, bizUnitId, formNumber, new LocaleString(tplName));
    }

    public boolean isOldPrintClose() {
        return ConfigConstUtil.isOldPrintClose();
    }

    public void afterCreateTpl(Map<String, Object> params) {
        Object success = params.get("success");
        if (success instanceof Boolean && ((Boolean)success).booleanValue()) {
            try (TXHandle h = TX.requiresNew();){
                String tplId = (String)params.get("formid");
                PrintMetadata formMeta = OldPrintTemplateUtil.findOldPrintMetadata((String)tplId);
                DynamicObject metaObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_print_meta");
                String tplNum = formMeta.getKey();
                DynamicObject printTplInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"bas_manageprinttpl", (String)"createorg", (QFilter[])new QFilter[]{new QFilter("printtplid", "=", (Object)tplId)});
                boolean isExist = QueryServiceHelper.exists((String)"bos_print_meta", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)tplNum)});
                if (isExist) {
                    tplNum = tplNum + "(old)";
                }
                String creator = RequestContext.get().getUserId();
                metaObj.set("id", (Object)tplId);
                metaObj.set("masterid", (Object)tplId);
                metaObj.set("number", (Object)tplNum);
                metaObj.set("name", (Object)formMeta.getName());
                metaObj.set("formid", (Object)MetadataDao.getNumberById((String)formMeta.getEntityId()));
                metaObj.set("creator", (Object)creator);
                metaObj.set("org", this.getCreateorg(printTplInfo));
                metaObj.set("modifier", (Object)creator);
                metaObj.set("type", (Object)"A");
                metaObj.set("bizappid", (Object)formMeta.getBizappId());
                metaObj.set("createtime", (Object)new Date());
                metaObj.set("modifytime", (Object)new Date());
                metaObj.set("status", (Object)"C");
                metaObj.set("enable", (Object)"1");
                metaObj.set("version", (Object)"1");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{metaObj});
            }
            catch (Exception e) {
                this.log.info("\u5f80bos_print_meta\u5199\u5165\u6570\u636e\u5931\u8d25:", (Object)e);
            }
        }
    }

    private void updateManagetpl(String printMetaId) {
        String creator = RequestContext.get().getUserId();
        String updateSql = "update %s set  fmodifytime = ?,fmodifierid= ? where fprinttplid = ?";
        Object[] params = new SqlParameter[]{new SqlParameter("fmodifytime", 91, (Object)new Date()), new SqlParameter("fmodifierid", -5, (Object)creator), new SqlParameter("fprinttplid", 12, (Object)printMetaId)};
        updateSql = String.format(updateSql, "t_bas_printtplinfo");
        DB.execute((DBRoute)DBRoute.basedata, (String)updateSql, (Object[])params);
        UpdateLocalNameUtil.updateManageOldTplNameAndNumber((String)printMetaId);
    }

    private boolean checkPrintTemplateCanSave(String tplId) {
        try {
            if (!ParamUtils.isTemplateOrgIsolated()) {
                return true;
            }
            if (StringUtils.isNotBlank((CharSequence)tplId)) {
                String selectSql = "select fcreateorg,fctrlstrategy from t_bas_printtplinfo where fprinttplid =?";
                ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(10);
                params.add(new SqlParameter("fprinttplid", 12, (Object)tplId));
                Map data = (Map)DB.query((DBRoute)DBRoute.basedata, (String)selectSql, (Object[])params.toArray(new SqlParameter[0]), (ResultSetHandler)new ResultSetHandler<Map<String, Object>>(){

                    public Map<String, Object> handle(ResultSet resultSet) throws Exception {
                        if (resultSet.next()) {
                            long createOrg = resultSet.getLong("fcreateorg");
                            String ctrlStrategy = resultSet.getString("fctrlstrategy");
                            HashMap<String, Object> result = new HashMap<String, Object>(4);
                            result.put("createOrg", createOrg);
                            result.put("ctrlStrategy", ctrlStrategy);
                            return result;
                        }
                        return Collections.emptyMap();
                    }
                });
                if (!data.isEmpty()) {
                    String ctrlStrategy;
                    long userId = RequestContext.get().getCurrUserId();
                    HasPermOrgResult result = PermissionServiceHelper.getUserHasPermOrgs((long)userId);
                    List<Long> orgIds = null;
                    if (result != null) {
                        orgIds = result.hasAllOrgPerm() ? OrgUnitServiceHelper.getAllOrg((String)"15") : result.getHasPermOrgs();
                    }
                    if (orgIds == null || orgIds.isEmpty()) {
                        orgIds = new ArrayList<Long>(10);
                        orgIds.add(RequestContext.get().getOrgId());
                    }
                    if ("5".equals(ctrlStrategy = data.get("ctrlStrategy").toString())) {
                        return true;
                    }
                    Object org = data.get("createOrg");
                    if (org == null) {
                        return true;
                    }
                    long createOrg = Long.parseLong(org.toString());
                    return orgIds.contains(createOrg);
                }
            }
            return true;
        }
        catch (Exception e) {
            this.log.warn("\u65e7\u6253\u5370\u8bbe\u8ba1\u5668\u4e2d\u5224\u65ad\u6a21\u7248\u662f\u5426\u53ef\u7f16\u8f91\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return true;
        }
    }
}

