/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.print;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.property.print.CustomDataSourceHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.servicehelper.DBServiceHelper;

public class AddCustomDataSourceEdit
extends AbstractFormPlugin {
    private static final String CUSTOM_DATASOURCE_FORMID = "ide_editcustomdatasource";
    private static final String NUMBER = "number";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            String errorMessage = this.validateDataSource();
            if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
                this.getView().showErrorNotification(errorMessage);
            } else {
                String id = DBServiceHelper.genStringId();
                String name = (String)this.getModel().getValue("name");
                String number = (String)this.getModel().getValue(NUMBER);
                String json = this.getData(id, name);
                HashMap<String, String> ret = new HashMap<String, String>();
                ret.put("id", id);
                ret.put(NUMBER, number);
                ret.put("name", name);
                ret.put("data", json);
                this.getView().returnDataToParent(ret);
                this.getView().close();
            }
        }
    }

    private String validateDataSource() {
        String errorMessage = "";
        Object customDsNumber = this.getModel().getValue(NUMBER);
        if (StringUtils.isBlank((CharSequence)errorMessage)) {
            List dsList = (List)this.getView().getFormShowParameter().getCustomParam("ds");
            for (Map ds : dsList) {
                String data = (String)ds.get("data");
                if (!StringUtils.isNotBlank((CharSequence)data)) continue;
                Map mapData = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                String cusId = (String)mapData.get(NUMBER);
                if (!customDsNumber.toString().equals(cusId)) continue;
                errorMessage = ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6570\u636e\u6e90\u5df2\u6dfb\u52a0\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0", (String)"AddCustomDataSourceEdit_0", (String)"bos-designer-plugin", (Object[])new Object[0]);
                break;
            }
        }
        return errorMessage;
    }

    private String getData(String id, String name) {
        IDataModel model = this.getModel();
        DynamicObject obj = null;
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)CUSTOM_DATASOURCE_FORMID);
        obj = new DynamicObject((DynamicObjectType)entityType);
        obj.set("id", (Object)id);
        obj.set("name", (Object)name);
        obj.set(NUMBER, model.getValue(NUMBER));
        return CustomDataSourceHelper.toDynamicObjectJson(obj);
    }
}

