/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.print;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.designer.property.print.CustomDataSourceHelper;
import kd.bos.designer.property.print.RefField;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.login.utils.JSONUtils;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.businessfield.AmountField;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.FlexField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.PictureField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.util.StringUtils;

@Deprecated
public class AddRefFieldEdit
extends AbstractFormPlugin {
    private static final String FIELD_TREE = "fieldtree";
    private static final String FUNC_KEY = "funckey";
    private static final String REGEX = "\\$\\$";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnok", "btncancel"});
        this.addTreeQueryListener();
        this.setSingleSelect();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter showParam = this.getView().getFormShowParameter();
        TreeNode root = null;
        String treeNode = (String)this.getView().getFormShowParameter().getCustomParam("treeNode");
        if (treeNode != null) {
            try {
                root = (TreeNode)JSONUtils.cast((String)treeNode, TreeNode.class);
            }
            catch (IOException ex) {
                throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[0]);
            }
        } else {
            String dsType = (String)showParam.getCustomParam("dsType");
            if ("1".equals(dsType)) {
                root = this.buildEntityFieldTree(showParam);
            } else if ("3".equals(dsType)) {
                TreeView treeView = (TreeView)this.getControl(FIELD_TREE);
                treeView.setRootVisible(false);
                root = this.buildJoinFieldTree(showParam);
            }
        }
        TreeView treeView = (TreeView)this.getControl(FIELD_TREE);
        treeView.addNode(root);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            IFormView parentView = this.getView().getParentView();
            if (parentView == null) {
                return;
            }
            IDataModel parentModel = parentView.getModel();
            TreeView treeView = (TreeView)this.getControl(FIELD_TREE);
            List nodeList = treeView.getTreeState().getCheckedNodes();
            FormShowParameter showParam = this.getView().getFormShowParameter();
            String dsType = (String)showParam.getCustomParam("dsType");
            if ("1".equals(dsType)) {
                this.importEntryField(nodeList);
            } else if ("3".equals(dsType)) {
                this.importJoinDSField(nodeList, parentModel);
            } else {
                Boolean singleSelect = (Boolean)showParam.getCustomParam("singleSelect");
                if (singleSelect != null && singleSelect.booleanValue()) {
                    String funckey = (String)showParam.getCustomParam(FUNC_KEY);
                    HashMap<String, String> rs = new HashMap<String, String>(1);
                    String selectedField = treeView.getTreeState().getFocusNodeId();
                    rs.put("value", selectedField);
                    rs.put(FUNC_KEY, funckey);
                    this.getView().returnDataToParent(rs);
                }
            }
            this.getView().close();
        }
    }

    private void setSingleSelect() {
        FormShowParameter showParam = this.getView().getFormShowParameter();
        Boolean singleSelect = (Boolean)showParam.getCustomParam("singleSelect");
        if (singleSelect != null && singleSelect.booleanValue()) {
            TreeView treeView = (TreeView)this.getControl(FIELD_TREE);
            treeView.setMulti(false);
        }
    }

    private void addTreeQueryListener() {
        TreeView treeView = (TreeView)this.getControl(FIELD_TREE);
        treeView.addTreeNodeQueryListener(new TreeNodeQueryListener(){

            public void queryTreeNodeChildren(TreeNodeEvent evt) {
                String nodeId = (String)evt.getNodeId();
                String[] fs = nodeId.split(AddRefFieldEdit.REGEX);
                EntityMetadata meta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)fs[fs.length - 1], (MetaCategory)MetaCategory.Entity);
                MainEntity entity = meta.getRootEntity();
                TreeNode node = new TreeNode();
                node.setId(nodeId);
                node.setText(entity.getName().getLocaleValue());
                node.setParentid((String)evt.getParentNodeId());
                AddRefFieldEdit.this.addIdFieldNode(node);
                AddRefFieldEdit.this.addPropertyNode(node, entity.getItems());
                TreeView tree = (TreeView)evt.getSource();
                tree.updateNode(node);
                tree.expand(nodeId);
            }
        });
    }

    private void importEntryField(List<Map<String, Object>> nodeList) {
        FormShowParameter showParam = this.getView().getFormShowParameter();
        List<RefField> fields = this.getSelectedFields(nodeList);
        if (fields.isEmpty()) {
            return;
        }
        String funckey = (String)showParam.getCustomParam(FUNC_KEY);
        HashMap<String, List<RefField>> rs = new HashMap<String, List<RefField>>(1);
        rs.put(funckey, fields);
        this.getView().returnDataToParent(rs);
    }

    private List<RefField> getSelectedFields(List<Map<String, Object>> nodeList) {
        ArrayList<RefField> fields = new ArrayList<RefField>(10);
        for (Map<String, Object> node : nodeList) {
            String nodeId = (String)node.get("id");
            String parentId = (String)node.get("parentid");
            LocaleString text = new LocaleString((String)node.get("text"));
            RefField field = new RefField();
            String[] fs = nodeId.split(REGEX);
            if (StringUtils.isEmpty((String)fs[0])) continue;
            field.setFieldKey(fs[0]);
            field.setDataType(fs[1]);
            field.setFieldName(text);
            field.setEntityId(parentId);
            fields.add(field);
        }
        return fields;
    }

    private void importJoinDSField(List<Map<String, Object>> nodeList, IDataModel parentModel) {
        for (Map<String, Object> node : nodeList) {
            int rowIndex;
            String nodeId = (String)node.get("id");
            String parentNodeName = (String)node.get("parentid");
            if (StringUtils.isEmpty((String)nodeId) || StringUtils.isEmpty((String)parentNodeName)) continue;
            String nodeName = (String)node.get("text");
            String[] fs = nodeId.split(REGEX);
            FormShowParameter showParam = this.getView().getFormShowParameter();
            Object obj = showParam.getCustomParam("isfilter");
            if (obj != null && ((Boolean)obj).booleanValue()) {
                rowIndex = parentModel.createNewEntryRow("filterentry");
                parentModel.setValue("filterfield", (Object)fs[0], rowIndex);
                continue;
            }
            if (this.existDSField(parentNodeName, fs[0], parentModel)) continue;
            rowIndex = parentModel.createNewEntryRow("selectentry");
            parentModel.setValue("queryds", (Object)parentNodeName, rowIndex);
            parentModel.setValue("queryfield", (Object)fs[0], rowIndex);
            parentModel.setValue("fieldname", (Object)fs[0], rowIndex);
            parentModel.setValue("displayname", (Object)nodeName, rowIndex);
            parentModel.setValue("datatype", (Object)fs[1], rowIndex);
        }
    }

    private boolean existDSField(String dsName, String fieldName, IDataModel parentModel) {
        int rowCount = parentModel.getEntryRowCount("selectentry");
        for (int i = 0; i < rowCount; ++i) {
            String f = (String)parentModel.getValue("queryfield", i);
            String ds = (String)parentModel.getValue("queryds", i);
            if (!dsName.equals(ds) || !fieldName.equals(f)) continue;
            return true;
        }
        return false;
    }

    private TreeNode buildEntityFieldTree(FormShowParameter showParam) {
        String entityNumber = (String)showParam.getCustomParam("entityid");
        String entityId = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Entity);
        EntityMetadata meta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        MainEntity entity = meta.getRootEntity();
        TreeNode root = new TreeNode();
        root.setId("$$" + entity.getKey());
        root.setText(entity.getName().getLocaleValue());
        root.setIsOpened(true);
        this.addIdFieldNode(root);
        this.addPropertyNode(root, entity.getItems());
        return root;
    }

    private TreeNode buildJoinFieldTree(FormShowParameter showParam) {
        String clientdsJson = (String)showParam.getCustomParam("clientds");
        String clientdsType = (String)showParam.getCustomParam("clientdstype");
        TreeNode clientTree = this.buildDSFieldTree(clientdsType, clientdsJson);
        String supplierdsJson = (String)showParam.getCustomParam("supplierds");
        String supplierdsType = (String)showParam.getCustomParam("supplierdstype");
        TreeNode supplierTree = this.buildDSFieldTree(supplierdsType, supplierdsJson);
        TreeNode root = new TreeNode();
        if (clientTree != null) {
            root.addChild(clientTree);
        }
        if (supplierTree != null) {
            root.addChild(supplierTree);
        }
        root.setIsOpened(true);
        return root;
    }

    private TreeNode buildDSFieldTree(String dsType, String dsJson) {
        if (StringUtils.isEmpty((String)dsJson)) {
            return null;
        }
        DynamicObject ds = this.getDS(dsType, dsJson);
        String name = ds.getString("name");
        String number = ds.getString("number");
        TreeNode root = new TreeNode();
        root.setId(number);
        root.setText(name);
        root.setIsOpened(true);
        for (DynamicObject obj : ds.getDynamicObjectCollection("queryfieldentry")) {
            TreeNode node = new TreeNode();
            node.setId(obj.getString("fieldname") + "$$" + obj.getString("datatype"));
            node.setText(obj.getString("displayname"));
            node.setParentid(number);
            root.addChild(node);
        }
        return root;
    }

    private DynamicObject getDS(String dsType, String dsJson) {
        String clientdsEntityId = CustomDataSourceHelper.getEntityId(dsType);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)clientdsEntityId);
        return CustomDataSourceHelper.toDynamicObject(dsJson, entityType);
    }

    private void addPropertyNode(TreeNode root, List<EntityItem<?>> entityItems) {
        for (EntityItem<?> item : entityItems) {
            if (item instanceof Field) {
                if (StringUtils.isEmpty((String)((Field)item).getFieldName())) continue;
                this.addFieldNode(root, (Field)item);
                continue;
            }
            if (!(item instanceof Entity)) continue;
            Entity entity = (Entity)item;
            this.addPropertyNode(root, entity.getItems());
        }
    }

    private void addIdFieldNode(TreeNode root) {
        TreeNode node = new TreeNode();
        String[] parentId = root.getId().split(REGEX);
        String id = StringUtils.isEmpty((String)parentId[0]) ? "id" : parentId[0] + ".id";
        id = id + "$$id";
        String txt = "ID";
        node.setId(id);
        node.setText(txt);
        node.setParentid(root.getId());
        root.addChild(node);
    }

    private void addFieldNode(TreeNode root, Field<?> f) {
        TreeNode node = new TreeNode();
        String[] parentId = root.getId().split(REGEX);
        String id = StringUtils.isEmpty((String)parentId[0]) ? f.getKey() : parentId[0] + "." + f.getKey();
        String txt = f.getName().getLocaleValue();
        if (f instanceof TextField || f instanceof ComboField) {
            id = id + "$$text";
        } else if (f instanceof IntegerField) {
            id = id + "$$integer";
        } else if (f instanceof AmountField) {
            id = id + "$$amount";
        } else if (f instanceof DecimalField) {
            id = id + "$$decimal";
        } else if (f instanceof DateTimeField) {
            id = id + "$$date";
        } else if (f instanceof CheckBoxField) {
            id = id + "$$boolean";
        } else if (f instanceof PictureField) {
            id = id + "$$picture";
        } else if (f instanceof FlexField) {
            id = id + "$$flex";
        } else if (f instanceof BasedataField) {
            id = id + "$$basedata$$" + ((BasedataField)f).getBaseEntityId();
            node.addChild(null);
        } else {
            id = id + "$$text";
        }
        node.setId(id);
        node.setText(txt);
        node.setParentid(root.getId());
        root.addChild(node);
    }
}

