/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.print;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.QueryEntity;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.LargeTextField;
import kd.bos.metadata.entity.commonfield.MuliLangTextField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.report.ReportEntity;

public class AddRefImportEntityInfoPlugin
extends AbstractFormPlugin {
    private static final String IMPORT_ENTITY_ID = "importentityId";
    private static Log log = LogFactory.getLog(AddRefImportEntityInfoPlugin.class);
    private static final String KEY_FILTERGRID = "filtergridap";
    private static final String MAINENTITY_UNIONFIELD = "mainunionfield";
    private static final String IMPOETENTITY_UNIONFIELD = "importunionfield";
    private static final String QUERY_ENTITY = "queryentity";
    private static final String ALIAS = "alias";

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String uniondata = (String)showParameter.getCustomParam("unionfield");
        MainEntityType entityType = this.getModel().getDataEntityType();
        if (StringUtils.isNotEmpty((CharSequence)uniondata)) {
            DynamicObject obj = AddRefImportEntityInfoPlugin.toDynamicObject(uniondata, entityType);
            e.setDataEntity((Object)obj);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map cusParams = this.getView().getFormShowParameter().getCustomParams();
        if (cusParams != null) {
            if (!ObjectUtils.isEmpty(cusParams.get("mainentityId"))) {
                String mainentityId = (String)cusParams.get("mainentityId");
                List<ComboItem> billHeadCols = this.getQueryFiled(mainentityId);
                ComboEdit sortfield = (ComboEdit)this.getView().getControl(MAINENTITY_UNIONFIELD);
                sortfield.setComboItems(billHeadCols);
            }
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(KEY_FILTERGRID);
            if (!ObjectUtils.isEmpty(cusParams.get(IMPORT_ENTITY_ID))) {
                this.initControlData(cusParams.get(IMPORT_ENTITY_ID).toString());
            } else {
                filterGrid.setFieldColumns(new ArrayList());
            }
            Object openSourceType = cusParams.get("openSourceType");
            if ("PrintNew".equals(openSourceType)) {
                ComboEdit importunionfield = (ComboEdit)this.getView().getControl(IMPOETENTITY_UNIONFIELD);
                String capture = ResManager.loadKDString((String)"\u5173\u8054\u6570\u636e\u6e90\u5b57\u6bb5", (String)"AddRefImportEntityInfoPlugin_0", (String)"bos-noteprint", (Object[])new Object[0]);
                importunionfield.setCaption(new LocaleString(capture));
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object filterCondition = this.getView().getFormShowParameter().getCustomParam("filtercondition");
        if (!ObjectUtils.isEmpty((Object)filterCondition)) {
            FilterCondition fCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterCondition.toString(), FilterCondition.class);
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(KEY_FILTERGRID);
            filterGrid.SetValue(fCondition);
        }
        Object queryentityId = this.getView().getFormShowParameter().getCustomParam(IMPORT_ENTITY_ID);
        Object alias = this.getView().getFormShowParameter().getCustomParam(ALIAS);
        String number = MetadataDao.getEntityNumberById((String)queryentityId.toString());
        this.getModel().setValue(QUERY_ENTITY, (Object)number);
        this.getModel().setValue(ALIAS, alias);
        this.getView().updateView(QUERY_ENTITY);
    }

    private void initControlData(String importentityId) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(KEY_FILTERGRID);
        List<ComboItem> billHeadCols = this.getQueryFiled(importentityId);
        ComboEdit sortfield = (ComboEdit)this.getView().getControl(IMPOETENTITY_UNIONFIELD);
        sortfield.setComboItems(billHeadCols);
        String entityNumber = MetadataDao.getEntityNumberById((String)importentityId);
        MainEntityType entityType = EntityMetadataCache.getDataEntityTypeById((String)importentityId);
        if (entityType instanceof QueryEntityType) {
            ArrayList<String> filterFieldKeys = new ArrayList<String>(10);
            List slectFields = ((QueryEntityType)entityType).getSelectFields();
            for (QuerySelectField field : slectFields) {
                filterFieldKeys.add(field.getAlias());
            }
            filterGrid.setFilterFieldKeys(filterFieldKeys);
        }
        EntityTypeUtil helper = new EntityTypeUtil();
        List cols = helper.getFilterColumns((IDataEntityType)entityType, true);
        filterGrid.setFilterColumns(cols);
        filterGrid.setEntityNumber(entityNumber);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        try {
            IDataModel parentModel = this.getView().getParentView().getModel();
            if (this.checkMustInput()) {
                FormShowParameter showParameter = this.getView().getFormShowParameter();
                Integer rowIndex = (Integer)showParameter.getCustomParam("rowIndex");
                if (rowIndex == null) {
                    return;
                }
                int rowCount = parentModel.getEntryRowCount("entryentity");
                DynamicObject qentity = (DynamicObject)this.getModel().getValue(QUERY_ENTITY);
                Object queryentityId = "";
                if (qentity != null) {
                    queryentityId = qentity.getPkValue();
                }
                Object alias = this.getModel().getValue(ALIAS);
                if (rowCount - 1 >= rowIndex) {
                    parentModel.setValue(QUERY_ENTITY, queryentityId, rowIndex.intValue());
                    parentModel.setValue(ALIAS, alias, rowIndex.intValue());
                    parentModel.setValue("unionfield", (Object)this.getUnionInfo(), rowIndex.intValue());
                    parentModel.setValue("filtercondition", (Object)this.getFilterInfo(), rowIndex.intValue());
                }
            }
        }
        catch (Exception e1) {
            log.error("\u7531\u4e8e\u5feb\u901f\u70b9\u51fb\u5bfc\u81f4\u8bfb\u53d6\u5f02\u5e38\uff01");
        }
    }

    private boolean checkMustInput() {
        DynamicObject queryentity = (DynamicObject)this.getModel().getValue(QUERY_ENTITY);
        if (ObjectUtils.isEmpty((Object)queryentity)) {
            this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AddRefImportEntityInfoPlugin_1", (String)"bos-noteprint", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String property = e.getProperty().getName();
        if (QUERY_ENTITY.equals(property)) {
            DynamicObject bizentity = (DynamicObject)this.getModel().getValue(QUERY_ENTITY);
            ILocaleString alias = null;
            if (bizentity != null) {
                alias = (ILocaleString)bizentity.get("name");
                this.getModel().setValue(ALIAS, (Object)alias);
                this.getModel().setValue(IMPOETENTITY_UNIONFIELD, (Object)"");
                String importentityId = MetadataDao.getIdByNumber((String)bizentity.getPkValue().toString(), (MetaCategory)MetaCategory.Entity);
                FilterGrid filterGrid = (FilterGrid)this.getView().getControl(KEY_FILTERGRID);
                filterGrid.SetValue(new FilterCondition());
                this.initControlData(importentityId);
                this.getView().updateView(KEY_FILTERGRID);
            }
        }
    }

    private String getFilterInfo() {
        String filter = "";
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(KEY_FILTERGRID);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition condition = filterGridState.getFilterCondition();
        if (condition != null) {
            filter = SerializationUtils.toJsonString((Object)condition);
        }
        return filter;
    }

    private String getUnionInfo() {
        DynamicObject obj = this.getModel().getDataEntity(true);
        return AddRefImportEntityInfoPlugin.toDynamicObjectJson(obj);
    }

    private List<ComboItem> getQueryFiled(String entityId) {
        List<ComboItem> entries = new ArrayList<ComboItem>();
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        MainEntity rootEntiry = entityMetadata.getRootEntity();
        if (rootEntiry instanceof QueryEntity) {
            List mainSelectFields = ((QueryEntity)rootEntiry).getSelectFields();
            for (QuerySelectField field : mainSelectFields) {
                entries.add(new ComboItem(new LocaleString(field.getDisplayName()), field.getAlias()));
            }
        } else {
            if (rootEntiry instanceof ReportEntity) {
                return entries;
            }
            entries = this.getBillHeadFields(entityMetadata);
        }
        return entries;
    }

    private List<ComboItem> getBillHeadFields(EntityMetadata entityMetadata) {
        ArrayList<ComboItem> entries = new ArrayList<ComboItem>();
        entries.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5185\u7801", (String)"AddRefImportEntityInfoPlugin_2", (String)"bos-noteprint", (Object[])new Object[0])), "id"));
        List entities = entityMetadata.getRootEntity().getItems();
        if (!entities.isEmpty()) {
            for (EntityItem entity : entities) {
                if (!(entity instanceof Field) || (!(entity instanceof TextField) || entity instanceof MuliLangTextField || entity instanceof LargeTextField) && !(entity instanceof IntegerField) && !(entity instanceof DecimalField) && !(entity instanceof BasedataField)) continue;
                entries.add(new ComboItem(entity.getName(), entity.getKey()));
            }
        }
        return entries;
    }

    private static DynamicObject toDynamicObject(String value, MainEntityType entityType) {
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder((DynamicObjectType)entityType);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        return (DynamicObject)jser.deserializeFromString(value, null);
    }

    private static String toDynamicObjectJson(DynamicObject obj) {
        DynamicObjectType type = obj.getDynamicObjectType();
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(type);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        jser.setIsLocaleValueFull(true);
        binder.setOnlyDbProperty(false);
        return jser.serializeToString((Object)obj, null);
    }
}

