/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.print;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.report.ReportFormAp;
import kd.bos.metadata.report.ReportListAp;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;

public class AddRefQueryEntityList
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String ENTRY_KEY = "entryentity";
    private static final String ADD_IMPORTDATASOURCE_FORMID = "ide_addimportentityinfo";
    private static final String IMPORTDATASOURCE_FORMID = "ide_importentityinfo";
    private static final String BTN_CLOSR = "btnclose";
    private static final String BTN_OK = "btnok";
    private static final String QUERY_ENTITY = "queryentity";
    private static final String ALIAS = "alias";
    private static final String UNION_FIELD = "unionfield";
    private static final String FILTER_CONDITION = "filtercondition";
    private static final String CUS_NUMBER = "customnumber";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String CURRENT_ROW_INDEX = "currentRowIndex";
    private static final String DS_PAGE = "dspage";
    private static final String NUMBER = "number";
    private static final String PRINT_NEW = "PrintNew";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CLOSR, BTN_OK});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_KEY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        Object openSourceType = this.getView().getFormShowParameter().getCustomParam("openSourceType");
        if (PRINT_NEW.equals(openSourceType)) {
            BasedataEdit formobject = (BasedataEdit)this.getView().getControl(QUERY_ENTITY);
            ArrayList<QFilter> qFilters = formobject.getQFilters();
            if (qFilters == null) {
                qFilters = new ArrayList<QFilter>();
            }
            qFilters.add(new QFilter("dentityid", "!=", (Object)this.getCurrentEntityId()));
            formobject.setQFilters(qFilters);
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormMetadata formMeta;
        List refs;
        String entityId = this.getCurrentEntityId();
        if (StringUtils.isBlank((CharSequence)entityId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u5355\u636e", (String)"AddRefQueryEntityList_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            this.getView().close();
            return;
        }
        Object value = this.getView().getFormShowParameter().getCustomParams().get("value");
        if (!ObjectUtils.isEmpty(value) && !(refs = (List)SerializationUtils.fromJsonString((String)((String)value), List.class)).isEmpty()) {
            IDataModel model = this.getModel();
            int[] rowIndexs = model.batchCreateNewEntryRow(ENTRY_KEY, refs.size());
            int i = 0;
            for (Map ref : refs) {
                model.setValue(QUERY_ENTITY, ref.get("id"), rowIndexs[i]);
                model.setValue(ALIAS, ref.get(ALIAS), rowIndexs[i]);
                model.setValue(UNION_FIELD, ref.get(UNION_FIELD), rowIndexs[i]);
                model.setValue(FILTER_CONDITION, ref.get(FILTER_CONDITION), rowIndexs[i]);
                model.setValue(CUS_NUMBER, ref.get(CUS_NUMBER), rowIndexs[i]);
                ++i;
            }
        }
        if ((formMeta = (FormMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Form)).getRootAp() instanceof ReportFormAp && !PRINT_NEW.equals(this.getView().getFormShowParameter().getCustomParams().get("openSourceType"))) {
            String queryEntityId = "";
            List lstItems = formMeta.getRootAp().getItems();
            for (ControlAp ctlAp : lstItems) {
                ReportListAp rlAp;
                if (!(ctlAp instanceof ReportListAp) || (rlAp = (ReportListAp)ctlAp).getQueryDataSource() == null) continue;
                queryEntityId = ((ReportListAp)ctlAp).getQueryDataSource().getDataSourceId();
            }
            if (StringUtils.isNotEmpty((CharSequence)queryEntityId)) {
                MainEntityType queryEntityType = EntityMetadataCache.getDataEntityTypeById((String)queryEntityId);
                if (value == null || !value.toString().contains(queryEntityType.getName())) {
                    IDataModel model = this.getModel();
                    int index = model.createNewEntryRow(ENTRY_KEY);
                    model.setValue(QUERY_ENTITY, (Object)queryEntityType.getName(), index);
                    model.setValue(ALIAS, (Object)queryEntityType.getName(), index);
                }
            }
        }
    }

    public void afterBindData(EventObject e) {
        if (this.getModel().getEntryRowCount(ENTRY_KEY) > 0) {
            int rowIndex = 0;
            this.showDSForm(rowIndex);
            IClientViewProxy viewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            viewProxy.invokeControlMethod(ENTRY_KEY, "selectRows", new Object[]{rowIndex});
            viewProxy.getEntryState(ENTRY_KEY).selectRow(rowIndex);
        }
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        switch (btn.getKey().toLowerCase()) {
            case "btnclose": {
                this.getView().close();
                break;
            }
            case "btnok": {
                this.closeInnerView(false);
                this.returnData();
                break;
            }
        }
    }

    public void entryRowDoubleClick(RowClickEvent e) {
    }

    public void entryRowClick(RowClickEvent e) {
        int rowIndex = e.getRow();
        if (rowIndex < 0) {
            return;
        }
        String cacheRowIndex = this.getPageCache().get(CURRENT_ROW_INDEX);
        if (StringUtils.isNotBlank((CharSequence)cacheRowIndex)) {
            if (rowIndex != Integer.parseInt(cacheRowIndex)) {
                this.closeInnerView(true);
                this.showDSForm(rowIndex);
                this.getPageCache().put(CURRENT_ROW_INDEX, String.valueOf(rowIndex));
            }
        } else {
            this.closeInnerView(true);
            this.showDSForm(rowIndex);
            this.getPageCache().put(CURRENT_ROW_INDEX, String.valueOf(rowIndex));
        }
    }

    private void closeInnerView(boolean closeSubView) {
        IPageCache pageCache = this.getPageCache();
        String dsPageId = pageCache.get(DS_PAGE);
        if (StringUtils.isBlank((CharSequence)dsPageId)) {
            return;
        }
        IFormView dsView = SessionManager.getCurrent().getView(dsPageId);
        if (dsView != null) {
            dsView.close();
            if (closeSubView) {
                pageCache.put(DS_PAGE, "");
                HashMap<String, String> arg = new HashMap<String, String>(2);
                arg.put("pageId", dsPageId);
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("closeWindow", arg);
            }
        }
    }

    private void showDSForm(int rowIndex) {
        if (rowIndex >= 0) {
            Object unionfield = this.getModel().getValue(UNION_FIELD, rowIndex);
            Object filterCondition = this.getModel().getValue(FILTER_CONDITION, rowIndex);
            String importentityId = "";
            if (this.getModel().getValue(QUERY_ENTITY, rowIndex) != null) {
                DynamicObject importentity = (DynamicObject)this.getModel().getValue(QUERY_ENTITY, rowIndex);
                Object alias = this.getModel().getValue(ALIAS, rowIndex);
                String importentityNumber = (String)importentity.getPkValue();
                importentityId = MetadataDao.getIdByNumber((String)importentityNumber, (MetaCategory)MetaCategory.Entity);
                FormShowParameter parameter = new FormShowParameter();
                parameter.setCustomParam("mainentityId", (Object)this.getCurrentEntityId());
                parameter.setCustomParam("importentityId", (Object)importentityId);
                parameter.setCustomParam("rowIndex", (Object)rowIndex);
                Object openSourceType = this.getView().getFormShowParameter().getCustomParams().get("openSourceType");
                parameter.setCustomParam("openSourceType", openSourceType);
                parameter.getOpenStyle().setShowType(ShowType.InContainer);
                parameter.getOpenStyle().setTargetKey("dspanelap");
                parameter.setCustomParam(ALIAS, alias);
                parameter.setCustomParam(UNION_FIELD, unionfield);
                parameter.setCustomParam(FILTER_CONDITION, filterCondition);
                parameter.setFormId(IMPORTDATASOURCE_FORMID);
                IPageCache pageCache = this.getPageCache();
                pageCache.put(DS_PAGE, parameter.getPageId());
                this.getView().showForm(parameter);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if ("btndel".equals(evt.getItemKey())) {
            this.deleteRefQueryEntity();
        } else if ("btnnew".equals(evt.getItemKey())) {
            this.addRefQueryEntity();
        }
    }

    private void addRefQueryEntity() {
        String entityId = this.getCurrentEntityId();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(ADD_IMPORTDATASOURCE_FORMID);
        OpenStyle style = new OpenStyle();
        style.setShowType(ShowType.Modal);
        parameter.setOpenStyle(style);
        Object openSourceType = this.getView().getFormShowParameter().getCustomParam("openSourceType");
        parameter.setCustomParam("openSourceType", openSourceType);
        parameter.setCustomParam("currentEntityId", (Object)entityId);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "adddatasource"));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (evt.getReturnData() != null) {
            IDataModel model = this.getModel();
            if ("adddatasource".equals(evt.getActionId())) {
                Map retData = (Map)evt.getReturnData();
                Object queryentityId = retData.get(QUERY_ENTITY);
                Object alias = retData.get(ALIAS);
                Object customnumber = retData.get(CUS_NUMBER);
                int rowIndex = model.createNewEntryRow(ENTRY_KEY);
                model.setValue(QUERY_ENTITY, queryentityId, rowIndex);
                model.setValue(ALIAS, alias, rowIndex);
                model.setValue(CUS_NUMBER, customnumber, rowIndex);
                IClientViewProxy viewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                viewProxy.invokeControlMethod(ENTRY_KEY, "selectRows", new Object[]{rowIndex});
                viewProxy.getEntryState(ENTRY_KEY).selectRow(rowIndex);
                this.getModel().setEntryCurrentRowIndex(ENTRY_KEY, rowIndex);
                this.closeInnerView(true);
                this.showDSForm(rowIndex);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent arg0) {
        super.confirmCallBack(arg0);
        if (arg0.getCallBackId().equals("deleteRefQueryEntity") && MessageBoxResult.Yes.equals((Object)arg0.getResult())) {
            int[] rowIndex;
            AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_KEY);
            for (int i : rowIndex = grid.getEntryState().getSelectedRows()) {
                this.getModel().deleteEntryRow(ENTRY_KEY, i);
                if (this.getModel().getEntryRowCount(ENTRY_KEY) < 1) {
                    this.closeInnerView(true);
                    continue;
                }
                if (i == 0) {
                    this.closeInnerView(true);
                    this.showDSForm(i);
                    continue;
                }
                this.closeInnerView(true);
                this.showDSForm(i - 1);
            }
        }
    }

    private void deleteRefQueryEntity() {
        int count = this.getModel().getEntryRowCount(ENTRY_KEY);
        if (count <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5220\u9664\u884c\u3002", (String)"AddRefQueryEntityList_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_KEY);
        if (rowIndex >= 0) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("deleteRefQueryEntity", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u6570\u636e\u6e90\u53ef\u80fd\u5df2\u88ab\u4f7f\u7528\uff0c\u60a8\u786e\u8ba4\u9700\u8981\u5220\u9664\u4e48\uff1f", (String)"AddRefQueryEntityList_1", (String)"bos-noteprint", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5220\u9664\u884c\u3002", (String)"AddRefQueryEntityList_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
    }

    protected void returnData() {
        ArrayList queryentities = new ArrayList();
        int count = this.getModel().getEntryRowCount(ENTRY_KEY);
        ArrayList<String> aliaslist = new ArrayList<String>();
        ArrayList<Object> numberlist = new ArrayList<Object>();
        ArrayList<String> msgList = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            DynamicObject obj = this.getModel().getEntryRowEntity(ENTRY_KEY, i);
            Object filterCondition = obj.get(FILTER_CONDITION);
            DynamicObject query = (DynamicObject)obj.get(QUERY_ENTITY);
            HashMap<String, Object> mp = new HashMap<String, Object>();
            StringBuilder builder = new StringBuilder();
            if (query != null) {
                mp.put("id", query.get("id"));
                mp.put(NUMBER, query.get(NUMBER));
                mp.put("name", query.get("name"));
                numberlist.add(query.get(NUMBER));
                Object unionfield = obj.get(UNION_FIELD);
                if (!this.isSetUnionField(unionfield)) {
                    builder.append(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u5173\u8054\u6761\u4ef6", (String)"AddRefQueryEntityList_9", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])).append("\u3002");
                }
                mp.put(UNION_FIELD, unionfield);
                if (ObjectUtils.isEmpty((Object)filterCondition)) {
                    filterCondition = "";
                }
                mp.put(FILTER_CONDITION, filterCondition);
                Object alias = obj.get(ALIAS);
                if (ObjectUtils.isEmpty((Object)alias)) {
                    builder.append(ResManager.loadKDString((String)"\u672a\u586b\u5199\u5225\u540d", (String)"AddRefQueryEntityList_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])).append("\u3002");
                } else {
                    mp.put(ALIAS, alias);
                    aliaslist.add(((ILocaleString)alias).getLocaleValue());
                }
                if (builder.length() != 0) {
                    builder.insert(0, MessageFormat.format(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u201c{0}\u201d: ", (String)"AddRefQueryEntityList_8", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), query.get("name")));
                }
                mp.put(CUS_NUMBER, obj.get(CUS_NUMBER));
                queryentities.add(mp);
            } else {
                builder.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b9e\u4f53", (String)"AddRefQueryEntityList_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
            if (builder.length() == 0) continue;
            msgList.add(builder.toString());
        }
        HashSet set = Sets.newHashSet(aliaslist);
        if (set.size() != aliaslist.size()) {
            msgList.add(ResManager.loadKDString((String)"\u5225\u540d\u4e0d\u5141\u8bb8\u91cd\u590d", (String)"AddRefQueryEntityList_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
        if ((set = Sets.newHashSet(numberlist)).size() != numberlist.size()) {
            msgList.add(ResManager.loadKDString((String)"\u5b9e\u4f53\u4e0d\u5141\u8bb8\u91cd\u590d", (String)"AddRefQueryEntityList_10", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
        if (msgList.size() == 1) {
            this.getView().showMessage((String)msgList.get(0));
            return;
        }
        if (msgList.size() > 1) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6e29\u99a8\u63d0\u793a", (String)"AddRefQueryEntityList_0", (String)"bos-noteprint", (Object[])new Object[0]), StringUtils.join((Object[])msgList.toArray(), (String)"\n"), MessageTypes.Commit);
            return;
        }
        ArrayList paras = new ArrayList();
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        para.put("value", SerializationUtils.toJsonString(queryentities));
        if (!aliaslist.isEmpty()) {
            if (aliaslist.size() > 1) {
                para.put(ALIAS, ResManager.loadKDString((String)"\u5b9e\u4f53", (String)"AddRefQueryEntityList_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            } else {
                para.put(ALIAS, aliaslist.get(0));
            }
        }
        paras.add(para);
        this.getView().returnDataToParent(paras);
        this.getView().close();
    }

    private boolean isSetUnionField(Object unionfield) {
        JSONObject json;
        return !ObjectUtils.isEmpty((Object)unionfield) && StringUtils.isNotBlank((CharSequence)(json = JSONObject.parseObject((String)unionfield.toString())).getString("importunionfield")) && StringUtils.isNotBlank((CharSequence)json.getString("mainunionfield"));
    }

    private String getCurrentEntityId() {
        List items;
        String currentEntityId = null;
        List context = (List)this.getView().getFormShowParameter().getCustomParam("context");
        if (context != null && !context.isEmpty() && (items = (List)context.get(0)).get(0) != null) {
            currentEntityId = (String)((Map)items.get(0)).get("EntityId");
        }
        return currentEntityId;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        String rowIndexString = this.getPageCache().get(CURRENT_ROW_INDEX);
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        if (newValue != null && oldValue != null && newValue.toString().equals(oldValue.toString())) {
            return;
        }
        if ((ALIAS.equals(name) || QUERY_ENTITY.equals(name)) && rowIndexString != null) {
            int rowIndex = Integer.parseInt(rowIndexString);
            this.showDSForm(rowIndex);
        }
    }
}

