/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.print;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.report.QueryDataSource;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.metadata.report.ReportListAp;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;

public class BindDataSourcePlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String DATA_SOURCE = "datasource";
    private static final String DATA_SOURCE_NAME = "datasourcename";
    private static final String DATA_SOURCE_KEY = "datasourcekey";
    private static final String DATA_SOURCE_TYPE = "datasourcetype";
    private static final String DATA_SOURCE_CUSNUM = "customnumber";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String NUMBER = "number";
    private static final String CONTEXT = "context";
    private static final String ITEM_ID = "itemId";
    private static final String META_TYPE = "metaType";
    private static final String PROPERTY_NAME = "propertyName";
    private static final String VALUE = "value";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btncancel", "btnreset"});
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(DATA_SOURCE);
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        List<Map<String, Object>> entryList;
        List<Map<String, Object>> queryEntryList;
        List lstItems;
        String entityId = this.getCurrentEntityId();
        if (StringUtils.isBlank((CharSequence)entityId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u5355\u636e", (String)"BindDataSourcePlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            this.getView().close();
            return;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityTypeById((String)entityId);
        List<Map<String, Object>> refQueryentities = this.getRefQueryEntity();
        FormMetadata formMeta = (FormMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Form);
        String bindType = this.getBindType();
        if (!"combination".equals(bindType)) {
            this.addCustomDs();
        }
        if ("ReportFormModel".equals(formMeta.getModelType())) {
            String queryEntityId = "";
            lstItems = formMeta.getRootAp().getItems();
            for (ControlAp ctlAp : lstItems) {
                QueryDataSource querDataSource;
                if (!(ctlAp instanceof ReportListAp) || (querDataSource = ((ReportListAp)ctlAp).getQueryDataSource()) == null) continue;
                queryEntityId = ((ReportListAp)ctlAp).getQueryDataSource().getDataSourceId();
            }
            if (StringUtils.isNotEmpty((CharSequence)queryEntityId)) {
                MainEntityType queryEntityType = EntityMetadataCache.getDataEntityTypeById((String)queryEntityId);
                if (refQueryentities == null || refQueryentities.isEmpty()) {
                    List<Map<String, Object>> queryEntryList2 = this.getQueryEntryInfo((EntityType)queryEntityType);
                    this.addEntityDs(queryEntryList2);
                } else {
                    Optional<Map> opt = refQueryentities.stream().filter(arg_0 -> BindDataSourcePlugin.lambda$afterCreateNewData$0((EntityType)queryEntityType, arg_0)).findAny();
                    if (!opt.isPresent()) {
                        queryEntryList = this.getQueryEntryInfo((EntityType)queryEntityType);
                        this.addEntityDs(queryEntryList);
                    }
                }
            }
            IDataModel model = this.getModel();
            int idx = model.createNewEntryRow(DATA_SOURCE);
            model.setValue(DATA_SOURCE_KEY, (Object)mainEntityType.getName(), idx);
            model.setValue(DATA_SOURCE_NAME, (Object)formMeta.getName(), idx);
            model.setValue(DATA_SOURCE_TYPE, (Object)"1", idx);
        } else if ("QueryListModel".equals(formMeta.getModelType())) {
            entryList = this.getMainEntryInfo((EntityType)mainEntityType);
            this.addEntityDs(entryList);
        } else {
            entryList = this.getMainEntryInfo((EntityType)mainEntityType);
            this.addEntityDs(entryList);
            if (!"combination".equals(bindType) && !"DynamicFormModel".equals(formMeta.getModelType())) {
                this.addApproveLineDs();
                this.addApproveActivityDs(entityId);
            }
            lstItems = formMeta.getItems();
            boolean hasAttachPanel = Boolean.FALSE;
            for (ControlAp ctlAp : lstItems) {
                if (!(ctlAp instanceof AttachmentPanelAp)) continue;
                hasAttachPanel = Boolean.TRUE;
                break;
            }
            if (hasAttachPanel) {
                this.addAttachDs();
            }
        }
        if (refQueryentities != null && !refQueryentities.isEmpty()) {
            for (Map<String, Object> mp : refQueryentities) {
                String queryEntityNumber = (String)mp.get(NUMBER);
                MainEntityType queryEntityType = EntityMetadataCache.getDataEntityType((String)queryEntityNumber);
                queryEntryList = null;
                queryEntryList = queryEntityType instanceof QueryEntityType ? this.getQueryEntryInfo((EntityType)queryEntityType, mp) : this.getImportEntryInfo(mp);
                this.addEntityDs(queryEntryList);
            }
        }
    }

    private List<Map<String, Object>> getImportEntryInfo(Map<String, Object> mp) {
        ArrayList<Map<String, Object>> entryList = new ArrayList<Map<String, Object>>();
        LinkedHashMap<String, Object> etMap = new LinkedHashMap<String, Object>();
        String sourceName = "";
        Object alias = mp.get("alias");
        if (alias == null) {
            alias = mp.get("name");
        }
        sourceName = (String)((Map)alias).get("zh_CN");
        etMap.put(DATA_SOURCE_NAME, sourceName);
        etMap.put(DATA_SOURCE_TYPE, "9");
        etMap.put(DATA_SOURCE_KEY, mp.get(NUMBER));
        etMap.put(DATA_SOURCE_CUSNUM, mp.get(DATA_SOURCE_CUSNUM));
        entryList.add(etMap);
        return entryList;
    }

    private void addEntityDs(List<Map<String, Object>> entryList) {
        IDataModel model = this.getModel();
        if (!entryList.isEmpty()) {
            int[] indexs = model.batchCreateNewEntryRow(DATA_SOURCE, entryList.size());
            int j = 0;
            for (int i = 0; i < indexs.length; ++i) {
                Map<String, Object> map = entryList.get(j);
                model.setValue(DATA_SOURCE_NAME, map.get(DATA_SOURCE_NAME), indexs[i]);
                model.setValue(DATA_SOURCE_KEY, map.get(DATA_SOURCE_KEY), indexs[i]);
                model.setValue(DATA_SOURCE_TYPE, map.get(DATA_SOURCE_TYPE), indexs[i]);
                if (map.get(DATA_SOURCE_CUSNUM) != null) {
                    model.setValue(DATA_SOURCE_CUSNUM, map.get(DATA_SOURCE_CUSNUM), indexs[i]);
                }
                ++j;
            }
        }
    }

    private void addApproveActivityDs(String entityId) {
        String entityNumber = MetadataDao.getNumberById((String)entityId);
        Collection approveActivities = WorkflowServiceHelper.getPrintMetaEntityNumber((String)entityNumber);
        if (!approveActivities.isEmpty()) {
            IDataModel model = this.getModel();
            int idx = model.createNewEntryRow(DATA_SOURCE);
            model.setValue(DATA_SOURCE_KEY, (Object)"workflow.activity", idx);
            model.setValue(DATA_SOURCE_NAME, (Object)ResManager.loadKDString((String)"\u5ba1\u6279\u8282\u70b9", (String)"BindDataSourcePlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), idx);
            model.setValue(DATA_SOURCE_TYPE, (Object)"8", idx);
        }
    }

    private void addAttachDs() {
        IDataModel model = this.getModel();
        int idx = model.createNewEntryRow(DATA_SOURCE);
        model.setValue(DATA_SOURCE_KEY, (Object)"attachpanel", idx);
        model.setValue(DATA_SOURCE_NAME, (Object)ResManager.loadKDString((String)"\u9644\u4ef6\u9762\u677f", (String)"PrintBindDataSourceConverter_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), idx);
        model.setValue(DATA_SOURCE_TYPE, (Object)"10", idx);
    }

    private void addApproveLineDs() {
        IDataModel model = this.getModel();
        int idx = model.createNewEntryRow(DATA_SOURCE);
        model.setValue(DATA_SOURCE_KEY, (Object)"workflow.approveline", idx);
        model.setValue(DATA_SOURCE_NAME, (Object)ResManager.loadKDString((String)"\u5ba1\u6279\u7ebf\u8def", (String)"BindDataSourcePlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), idx);
        model.setValue(DATA_SOURCE_TYPE, (Object)"4", idx);
    }

    private void addCustomDs() {
        IDataModel model = this.getModel();
        List<Map<String, Object>> customDs = this.getCustomDataSource();
        if (customDs != null && !customDs.isEmpty()) {
            int[] index = model.batchCreateNewEntryRow(DATA_SOURCE, customDs.size());
            for (int i = 0; i < index.length; ++i) {
                Map<String, Object> map = customDs.get(i);
                model.setValue(DATA_SOURCE_NAME, map.get("dsname"), index[i]);
                model.setValue(DATA_SOURCE_KEY, map.get("dsnumber"), index[i]);
                model.setValue(DATA_SOURCE_TYPE, (Object)"5", index[i]);
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        Button btn = (Button)evt.getSource();
        switch (key = btn.getKey()) {
            case "btnok": {
                this.returnData();
                break;
            }
            case "btnreset": {
                this.reset();
                break;
            }
            case "btncancel": {
                break;
            }
        }
        this.getView().close();
    }

    public void entryRowClick(RowClickEvent arg0) {
    }

    public void entryRowDoubleClick(RowClickEvent arg0) {
        this.returnDataToDesigner();
        this.getView().close();
    }

    private void returnData() {
        if (this.getModel().getEntryRowCount(DATA_SOURCE) > 0 && this.getModel().getEntryCurrentRowIndex(DATA_SOURCE) >= 0) {
            this.returnDataToDesigner();
        }
    }

    private void reset() {
        this.returnDataToDesigner("", null);
    }

    private List<Map<String, Object>> getMainEntryInfo(EntityType entityType) {
        ArrayList<Map<String, Object>> entryList = new ArrayList<Map<String, Object>>();
        MainEntityType mainType = (MainEntityType)entityType;
        Map entities = mainType.getAllEntities();
        for (EntityType et : entities.values()) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            if (et instanceof MainEntityType) {
                if (et instanceof QueryEntityType) {
                    map.put(DATA_SOURCE_NAME, et.getName());
                    map.put(DATA_SOURCE_TYPE, "1");
                    map.put(DATA_SOURCE_KEY, et.getName());
                    entryList.add(map);
                    break;
                }
                map.put(DATA_SOURCE_NAME, ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"BindDataSourcePlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                map.put(DATA_SOURCE_TYPE, "1");
            } else {
                map.put(DATA_SOURCE_NAME, et.getDisplayName().toString());
                if (et instanceof SubEntryType) {
                    map.put(DATA_SOURCE_TYPE, "3");
                } else {
                    map.put(DATA_SOURCE_TYPE, "2");
                }
            }
            map.put(DATA_SOURCE_KEY, et.getName());
            entryList.add(map);
        }
        return entryList;
    }

    private List<Map<String, Object>> getQueryEntryInfo(EntityType entityType, Map<String, Object> mp) {
        ArrayList<Map<String, Object>> entryList = new ArrayList<Map<String, Object>>();
        QueryEntityType type = (QueryEntityType)entityType;
        LinkedHashMap<String, Object> mainEtMap = new LinkedHashMap<String, Object>();
        mainEtMap.put(DATA_SOURCE_NAME, type.getDisplayName().toString());
        mainEtMap.put(DATA_SOURCE_TYPE, "7");
        mainEtMap.put(DATA_SOURCE_KEY, type.getName());
        if (mp != null) {
            mainEtMap.put(DATA_SOURCE_CUSNUM, mp.get(DATA_SOURCE_CUSNUM));
        }
        entryList.add(mainEtMap);
        return entryList;
    }

    private List<Map<String, Object>> getQueryEntryInfo(EntityType entityType) {
        return this.getQueryEntryInfo(entityType, null);
    }

    private String getBindType() {
        String currentEntityId = null;
        List context = (List)this.getView().getFormShowParameter().getCustomParam(CONTEXT);
        if (context != null && !context.isEmpty()) {
            List items = null;
            items = context.size() > 1 ? (List)context.get(1) : (List)context.get(0);
            if (items.get(0) != null) {
                currentEntityId = (String)((Map)items.get(0)).get("BindType");
            }
        }
        return currentEntityId;
    }

    private String getCurrentEntityId() {
        List items;
        String currentEntityId = null;
        List context = (List)this.getView().getFormShowParameter().getCustomParam(CONTEXT);
        if (context != null && !context.isEmpty() && (items = (List)context.get(0)).get(0) != null) {
            currentEntityId = (String)((Map)items.get(0)).get("EntityId");
        }
        return currentEntityId;
    }

    private List<Map<String, Object>> getRefQueryEntity() {
        List items;
        List queryDataSource = null;
        List context = (List)this.getView().getFormShowParameter().getCustomParam(CONTEXT);
        if (context != null && !context.isEmpty() && (items = (List)context.get(0)).get(0) != null && ((Map)items.get(0)).get("RefQueryDataSource") != null) {
            queryDataSource = (List)SerializationUtils.fromJsonString((String)((Map)items.get(0)).get("RefQueryDataSource").toString(), List.class);
        }
        return queryDataSource;
    }

    private List<Map<String, Object>> getCustomDataSource() {
        String custDs;
        List dataSource;
        List context = (List)this.getView().getFormShowParameter().getCustomParam(CONTEXT);
        if (context != null && !context.isEmpty() && (dataSource = (List)context.get(0)) != null && !dataSource.isEmpty() && dataSource.get(0) != null && StringUtils.isNotBlank((CharSequence)(custDs = (String)((Map)dataSource.get(0)).get("CustomDataSource")))) {
            Map custDsMap = (Map)SerializationUtils.fromJsonString((String)custDs, Map.class);
            List dsEntrys = (List)custDsMap.get("dsentry");
            return dsEntrys;
        }
        return Collections.emptyList();
    }

    private void returnDataToDesigner(String name, Object value) {
        ArrayList paras = new ArrayList();
        HashMap param = new HashMap();
        param.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
        param.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
        param.put(PROPERTY_NAME, this.getView().getFormShowParameter().getCustomParams().get(PROPERTY_NAME));
        if (ObjectUtils.isEmpty((Object)value)) {
            param.put(VALUE, "");
        } else {
            param.put(VALUE, SerializationUtils.toJsonString((Object)value));
        }
        param.put("alias", name);
        paras.add(param);
        HashMap bindFieldProperty = new HashMap();
        bindFieldProperty.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
        bindFieldProperty.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
        bindFieldProperty.put(PROPERTY_NAME, "BindField");
        bindFieldProperty.put(VALUE, "");
        paras.add(bindFieldProperty);
        this.getView().returnDataToParent(paras);
    }

    private void returnDataToDesigner() {
        int focusRow = this.getModel().getEntryCurrentRowIndex(DATA_SOURCE);
        String dsKey = (String)this.getModel().getValue(DATA_SOURCE_KEY, focusRow);
        String dsType = (String)this.getModel().getValue(DATA_SOURCE_TYPE, focusRow);
        String dsName = (String)this.getModel().getValue(DATA_SOURCE_NAME, focusRow);
        String dsCusKey = (String)this.getModel().getValue(DATA_SOURCE_CUSNUM, focusRow);
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("key", dsKey);
        values.put("type", dsType);
        values.put("name", dsName);
        values.put("cuskey", dsCusKey);
        this.returnDataToDesigner(dsName, values);
    }

    private static /* synthetic */ boolean lambda$afterCreateNewData$0(EntityType queryEntityType, Map p) {
        return p.get(NUMBER).equals(queryEntityType.getName());
    }
}

