/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.print;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.dao.PrintDataSourceReader;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.TimeRangeField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;

public class BindFieldPlugin
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener {
    private static final String KEY_TREE_ENTRY = "treeentryentity";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String NUMBER = "number";
    private static final String IS_CHECK = "ischeck";
    private static final String IS_CAN_BIND = "iscanbind";
    private static final String ITEM_ID = "itemId";
    private static final String META_TYPE = "metaType";
    private static final String PROPERTY_NAME = "propertyName";
    private static final String VALUE = "value";
    private static final String DATA_SOURCE = "DataSource";
    private static final String CONTEXT = "context";
    private static final String ITEMS = "Items";

    public void initialize() {
        this.addClickListeners(new String[]{"btnconfilm", "btncancel", "btnreset"});
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(KEY_TREE_ENTRY);
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String entityId = this.getCurrentEntityId();
        if (StringUtils.isBlank((CharSequence)entityId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u5355\u636e", (String)"BindFieldPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            this.getView().close();
            return;
        }
        Map<String, Object> dataSource = this.getBindedDataSource();
        if (dataSource == null || dataSource.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u8be5\u5b57\u6bb5\u5bf9\u5e94\u7684\u6570\u636e\u6e90\u3002", (String)"BindFieldPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        PrintDataSourceReader dataSourceReader = new PrintDataSourceReader();
        String dsKey = (String)dataSource.get("key");
        String dsType = (String)dataSource.get("type");
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl(KEY_TREE_ENTRY);
        grid.setCollapse(false);
        Map<String, Object> entityTree = new HashMap<String, Object>(16);
        if ("4".equals(dsType)) {
            Map wfAproveLine = WorkflowServiceHelper.getApprovalRecordMeta();
            int parentRow = 0;
            this.getModel().setValue("name", (Object)ResManager.loadKDString((String)"\u5ba1\u6279\u7ebf\u8def", (String)"BindFieldPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), parentRow);
            this.getModel().setValue(NUMBER, (Object)"workflow.approveline", parentRow);
            this.getView().setEnable(Boolean.valueOf(false), parentRow, new String[]{IS_CHECK});
            this.buildApproveLineTree(wfAproveLine, parentRow);
        } else if ("10".equals(dsType)) {
            int parentRow = 0;
            this.getModel().setValue("name", (Object)ResManager.loadKDString((String)"\u9644\u4ef6\u9762\u677f", (String)"BindFieldPlugin_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), parentRow);
            this.getModel().setValue(NUMBER, (Object)"attachpanel", parentRow);
            this.getView().setEnable(Boolean.valueOf(false), parentRow, new String[]{IS_CHECK});
            FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Form);
            this.buildAttachTree(formMeta, parentRow);
        } else if ("8".equals(dsType)) {
            int parentRow = 0;
            this.getModel().setValue("name", (Object)ResManager.loadKDString((String)"\u5ba1\u6279\u8282\u70b9", (String)"BindFieldPlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), parentRow);
            this.getModel().setValue(NUMBER, (Object)"workflow.activity", parentRow);
            this.getView().setEnable(Boolean.valueOf(false), parentRow, new String[]{IS_CHECK});
            this.buildApproveAcvitityTree(entityId, parentRow);
        } else if ("5".equals(dsType)) {
            List<Map<String, Object>> customFields = this.getCustomFields(dsKey);
            if (customFields != null && !customFields.isEmpty()) {
                int parentRow = 0;
                this.getModel().setValue("name", (Object)ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6570\u636e\u6e90", (String)"BindFieldPlugin_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), parentRow);
                this.getModel().setValue(NUMBER, (Object)"custom", parentRow);
                this.getView().setEnable(Boolean.valueOf(false), parentRow, new String[]{IS_CHECK});
                this.buildCustomTree(customFields, parentRow);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u63a7\u4ef6\u7ed1\u5b9a\u7684\u6570\u636e\u6e90\u4e0d\u5b58\u5728\u6216\u5b57\u6bb5\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u7ed1\u5b9a", (String)"BindFieldPlugin_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
        } else if ("7".equals(dsType)) {
            String queryEntityId = MetadataDao.getIdByNumber((String)dsKey, (MetaCategory)MetaCategory.Entity);
            if (StringUtils.isNotBlank((CharSequence)queryEntityId)) {
                MetadataReader reader = new MetadataReader(false);
                EntityMetadata entityMetadata = (EntityMetadata)reader.readMeta(queryEntityId, OrmUtils.getDataEntityType(DesignEntityMeta.class), true);
                entityTree = dataSourceReader.buildQueryEntityDataSourceTree(entityMetadata);
            }
            this.bindTreeList(dsKey, entityTree);
        } else if ("9".equals(dsType)) {
            entityId = MetadataDao.getIdByNumber((String)dsKey, (MetaCategory)MetaCategory.Entity);
            entityTree = dataSourceReader.buildDataSourceTree(entityId);
            this.bindTreeList(dsKey, entityTree, true, false);
        } else {
            String dsentityId;
            MetadataReader reader = new MetadataReader(false);
            EntityMetadata entityMetadata = (EntityMetadata)reader.readMeta(entityId, OrmUtils.getDataEntityType(DesignEntityMeta.class), true);
            entityTree = "QueryListModel".equals(entityMetadata.getModelType()) ? dataSourceReader.buildQueryEntityDataSourceTree(entityMetadata) : ((dsentityId = MetadataDao.getIdByNumber((String)dsKey, (MetaCategory)MetaCategory.Entity)) == null ? dataSourceReader.buildDataSourceTree(entityId, dsKey, null) : dataSourceReader.buildDataSourceTree(dsentityId));
            this.bindTreeList(dsKey, entityTree);
        }
    }

    public void click(EventObject evt) {
        String key;
        Button btn = (Button)evt.getSource();
        switch (key = btn.getKey()) {
            case "btnconfilm": {
                if (this.getModel().getEntryRowCount(KEY_TREE_ENTRY) > 0) {
                    int currentRowIndex = this.getModel().getEntryCurrentRowIndex(KEY_TREE_ENTRY);
                    boolean isCanBind = (Boolean)this.getModel().getValue(IS_CAN_BIND, currentRowIndex);
                    if (!isCanBind) break;
                    this.returnDataToDesigner();
                    this.getView().close();
                    break;
                }
                this.getView().close();
                break;
            }
            case "btnreset": {
                this.reset();
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
        }
    }

    public void entryRowClick(RowClickEvent arg0) {
    }

    public void entryRowDoubleClick(RowClickEvent arg) {
        boolean isCanBind = (Boolean)this.getModel().getValue(IS_CAN_BIND, arg.getRow());
        if (isCanBind && this.getModel().getEntryRowCount(KEY_TREE_ENTRY) > 0 && this.getModel().getEntryCurrentRowIndex(KEY_TREE_ENTRY) >= 0) {
            this.returnDataToDesigner();
            this.getView().close();
        }
    }

    private void reset() {
        ArrayList paras = new ArrayList();
        HashMap returnData = new HashMap();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        returnData.put(ITEM_ID, customParams.get(ITEM_ID));
        returnData.put(META_TYPE, customParams.get(META_TYPE));
        returnData.put(PROPERTY_NAME, customParams.get(PROPERTY_NAME));
        returnData.put(VALUE, "");
        paras.add(returnData);
        if (DATA_SOURCE.equals(customParams.get(PROPERTY_NAME))) {
            HashMap bindFieldProperty = new HashMap();
            bindFieldProperty.put(ITEM_ID, customParams.get(ITEM_ID));
            bindFieldProperty.put(META_TYPE, customParams.get(META_TYPE));
            bindFieldProperty.put(PROPERTY_NAME, "BindField");
            bindFieldProperty.put(VALUE, "");
            paras.add(bindFieldProperty);
        }
        this.getView().returnDataToParent(paras);
        this.getView().close();
    }

    private Map<String, Object> getBindedDataSource() {
        List context = (List)this.getView().getFormShowParameter().getCustomParam(CONTEXT);
        if (context != null && !context.isEmpty()) {
            Object ds;
            List dataSource = null;
            List lastList = (List)context.get(context.size() - 1);
            Map typeMap = (Map)lastList.get(0);
            Object type = typeMap.get("_Type_");
            dataSource = "DataCell".equals(type) || "DataRow".equals(type) ? (List)context.get(1) : (List)context.get(2);
            if (dataSource != null && !dataSource.isEmpty() && dataSource.get(0) != null && (ds = ((Map)dataSource.get(0)).get(DATA_SOURCE)) != null) {
                HashMap<String, Object> mpds = new HashMap<String, String>();
                try {
                    Map mapData = (Map)SerializationUtils.fromJsonString((String)((String)ds), Map.class);
                    mpds = mapData;
                }
                catch (Exception e) {
                    mpds.put("key", ds.toString());
                    if (ds.toString().contains("workflow.approveline")) {
                        mpds.put("type", "4");
                    }
                    if (ds.toString().contains("workflow.activity")) {
                        mpds.put("type", "8");
                    }
                    if (StringUtils.equals((CharSequence)ds.toString(), (CharSequence)"attachpanel")) {
                        mpds.put("type", "10");
                    }
                    mpds.put("type", "1");
                }
                return mpds;
            }
        }
        return null;
    }

    private List<Map<String, Object>> getCustomFields(String dsKey) {
        List dataSource;
        List context = (List)this.getView().getFormShowParameter().getCustomParam(CONTEXT);
        if (context != null && !context.isEmpty() && (dataSource = (List)context.get(0)) != null && !dataSource.isEmpty() && dataSource.get(0) != null) {
            Object ds = ((Map)dataSource.get(0)).get("CustomDataSource");
            if (ds == null) {
                return Collections.emptyList();
            }
            Map mapData = (Map)SerializationUtils.fromJsonString((String)((String)ds), Map.class);
            List oo = (List)mapData.get("dsentry");
            Map dsData = null;
            for (Map item : oo) {
                if (!dsKey.equals(item.get("dsnumber"))) continue;
                dsData = (Map)SerializationUtils.fromJsonString((String)((String)item.get("dsdata")), Map.class);
                break;
            }
            if (dsData != null) {
                List fields = (List)dsData.get("queryfieldentry");
                return fields;
            }
        }
        return Collections.emptyList();
    }

    private String getCurrentEntityId() {
        List items;
        String currentEntityId = null;
        List context = (List)this.getView().getFormShowParameter().getCustomParam(CONTEXT);
        if (context != null && !context.isEmpty() && (items = (List)context.get(0)).get(0) != null) {
            currentEntityId = (String)((Map)items.get(0)).get("EntityId");
        }
        return currentEntityId;
    }

    private void returnDataToDesigner() {
        int focusRow = this.getModel().getEntryCurrentRowIndex(KEY_TREE_ENTRY);
        String fieldKey = (String)this.getModel().getValue(NUMBER, focusRow);
        Map<String, Object> dataSource = this.getBindedDataSource();
        if (dataSource != null && "9".equals((String)dataSource.get("type"))) {
            fieldKey = this.updateFieldKey((String)dataSource.get("key"), fieldKey);
        }
        String fieldName = (String)this.getModel().getValue("name", focusRow);
        ArrayList paras = new ArrayList();
        HashMap param = new HashMap();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        param.put(ITEM_ID, customParams.get(ITEM_ID));
        param.put(META_TYPE, customParams.get(META_TYPE));
        param.put(PROPERTY_NAME, customParams.get(PROPERTY_NAME));
        param.put(VALUE, fieldKey);
        param.put("alias", fieldName);
        paras.add(param);
        if (DATA_SOURCE.equals(customParams.get(PROPERTY_NAME))) {
            HashMap bindFieldProperty = new HashMap();
            bindFieldProperty.put(ITEM_ID, customParams.get(ITEM_ID));
            bindFieldProperty.put(META_TYPE, customParams.get(META_TYPE));
            bindFieldProperty.put(PROPERTY_NAME, "BindField");
            bindFieldProperty.put(VALUE, "");
            paras.add(bindFieldProperty);
        }
        this.getView().returnDataToParent(paras);
    }

    private String updateFieldKey(String dsKey, String fieldKey) {
        EntityItem item2;
        String newFieldKey = fieldKey;
        String entityId = MetadataDao.getIdByNumber((String)dsKey, (MetaCategory)MetaCategory.Entity);
        EntityMetadata meta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        List items = meta.getItems();
        HashMap<String, EntityItem> mapItem = new HashMap<String, EntityItem>(16);
        for (EntityItem item2 : items) {
            mapItem.put(item2.getKey(), item2);
            if (item2 instanceof DateRangeField) {
                DateRangeField dateRangeField = (DateRangeField)item2;
                mapItem.put(dateRangeField.getStartDateFieldKey(), item2);
                mapItem.put(dateRangeField.getEndDateFieldKey(), item2);
                continue;
            }
            if (!(item2 instanceof TimeRangeField)) continue;
            TimeRangeField timeRangeField = (TimeRangeField)item2;
            mapItem.put(timeRangeField.getStartDateFieldKey(), item2);
            mapItem.put(timeRangeField.getEndDateFieldKey(), item2);
        }
        EntityItem entityItem = (EntityItem)mapItem.get(fieldKey.split("\\.")[0]);
        if (entityItem != null && StringUtils.isNotBlank((CharSequence)entityItem.getParentId()) && (item2 = meta.getItemById(entityItem.getParentId())) instanceof EntryEntity) {
            newFieldKey = item2.getKey() + "." + fieldKey;
        }
        return newFieldKey;
    }

    private void bindTreeList(String dataSourceName, Map<String, Object> billFieldsTree, boolean isShowEntry, boolean isShowSubEntry) {
        block3: {
            ArrayList<Map<String, Object>> fieldsInds;
            block2: {
                fieldsInds = new ArrayList<Map<String, Object>>();
                if (!Objects.equals(billFieldsTree.get("Id"), dataSourceName)) break block2;
                DynamicObject firstRow = this.getModel().getEntryRowEntity(KEY_TREE_ENTRY, 0);
                firstRow.set("name", billFieldsTree.get("Name"));
                firstRow.set(NUMBER, billFieldsTree.get("Id"));
                this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{IS_CHECK});
                Object items = billFieldsTree.get(ITEMS);
                if (!(items instanceof List)) break block3;
                this.buildTreeNode(fieldsInds, (List)items, 0, isShowEntry, isShowSubEntry);
                break block3;
            }
            Object items = billFieldsTree.get(ITEMS);
            if (items instanceof List) {
                for (Map fieldTree : (List)items) {
                    if (!Objects.equals(fieldTree.get("Id"), dataSourceName)) continue;
                    DynamicObject firstRow = this.getModel().getEntryRowEntity(KEY_TREE_ENTRY, 0);
                    firstRow.set("name", billFieldsTree.get("Name"));
                    firstRow.set(NUMBER, billFieldsTree.get("Id"));
                    this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{IS_CHECK});
                    Object itemss = fieldTree.get(ITEMS);
                    if (!(itemss instanceof List)) break;
                    this.buildTreeNode(fieldsInds, (List)itemss, 0, isShowEntry, isShowSubEntry);
                    break;
                }
            }
        }
    }

    private void bindTreeList(String dataSourceName, Map<String, Object> billFieldsTree) {
        this.bindTreeList(dataSourceName, billFieldsTree, false, false);
    }

    private void buildApproveLineTree(Map<String, String> billFieldsTree, int parentRow) {
        for (Map.Entry<String, String> entry : billFieldsTree.entrySet()) {
            DynamicObject parentObj = this.getModel().getEntryRowEntity(KEY_TREE_ENTRY, parentRow);
            Long pid = (Long)parentObj.getPkValue();
            int row = this.getModel().createNewEntryRow(KEY_TREE_ENTRY);
            DynamicObject newRow = this.getModel().getEntryRowEntity(KEY_TREE_ENTRY, row);
            newRow.set("pid", (Object)pid);
            this.getModel().setValue("name", (Object)entry.getValue(), row);
            this.getModel().setValue(NUMBER, (Object)entry.getKey(), row);
            this.getModel().setValue(IS_CAN_BIND, (Object)true, row);
        }
    }

    private void buildAttachTree(FormMetadata formMetadata, int parentRow) {
        List items = formMetadata.getItems();
        DynamicObject parentObj = this.getModel().getEntryRowEntity(KEY_TREE_ENTRY, parentRow);
        Long pid = (Long)parentObj.getPkValue();
        for (ControlAp controlAp : items) {
            if (!(controlAp instanceof AttachmentPanelAp)) continue;
            int row = this.getModel().createNewEntryRow(KEY_TREE_ENTRY);
            DynamicObject newRow = this.getModel().getEntryRowEntity(KEY_TREE_ENTRY, row);
            newRow.set("pid", (Object)pid);
            this.getModel().setValue("name", (Object)controlAp.getName().toString(), row);
            this.getModel().setValue(NUMBER, (Object)controlAp.getKey(), row);
            this.getModel().setValue(IS_CAN_BIND, (Object)true, row);
        }
    }

    private void buildApproveAcvitityTree(String entityId, int parentRow) {
        String entityNumber = MetadataDao.getNumberById((String)entityId);
        Collection approveActivities = WorkflowServiceHelper.getPrintMetaEntityNumber((String)entityNumber);
        for (Map entry : approveActivities) {
            DynamicObject parentObj = this.getModel().getEntryRowEntity(KEY_TREE_ENTRY, parentRow);
            Long pid = (Long)parentObj.getPkValue();
            int arow = this.getModel().createNewEntryRow(KEY_TREE_ENTRY);
            DynamicObject newRow = this.getModel().getEntryRowEntity(KEY_TREE_ENTRY, arow);
            newRow.set("pid", (Object)pid);
            this.getModel().setValue("name", entry.get("activityName"), arow);
            this.getModel().setValue(NUMBER, entry.get("bizIdentifyKey"), arow);
            this.getModel().setValue(IS_CAN_BIND, (Object)false, arow);
            Map printMeta = (Map)entry.get("printMeta");
            for (Map.Entry meta : printMeta.entrySet()) {
                DynamicObject parentObj2 = this.getModel().getEntryRowEntity(KEY_TREE_ENTRY, arow);
                Long pid2 = (Long)parentObj2.getPkValue();
                int mrow = this.getModel().createNewEntryRow(KEY_TREE_ENTRY);
                DynamicObject newRow2 = this.getModel().getEntryRowEntity(KEY_TREE_ENTRY, mrow);
                newRow2.set("pid", (Object)pid2);
                this.getModel().setValue("name", (Object)(entry.get("activityName") + "." + meta.getValue()), mrow);
                this.getModel().setValue(NUMBER, (Object)(entry.get("bizIdentifyKey") + "_" + (String)meta.getKey()), mrow);
                this.getModel().setValue(IS_CAN_BIND, (Object)true, mrow);
            }
        }
    }

    private void buildCustomTree(List<Map<String, Object>> customFields, int parentRow) {
        for (Map<String, Object> fieldItem : customFields) {
            DynamicObject parentObj = this.getModel().getEntryRowEntity(KEY_TREE_ENTRY, parentRow);
            Long pid = (Long)parentObj.getPkValue();
            int row = this.getModel().createNewEntryRow(KEY_TREE_ENTRY);
            DynamicObject newRow = this.getModel().getEntryRowEntity(KEY_TREE_ENTRY, row);
            newRow.set("pid", (Object)pid);
            this.getModel().setValue("name", fieldItem.get("displayname"), row);
            this.getModel().setValue(NUMBER, fieldItem.get("fieldname"), row);
            this.getModel().setValue(IS_CAN_BIND, (Object)true, row);
        }
    }

    private void buildTreeNode(List<Map<String, Object>> fieldsInds, List<Map<String, Object>> billFieldsTree, int parentRow, boolean isShowEntry, boolean isShowSubEntry) {
        ArrayList<Integer> collapseRows = new ArrayList<Integer>();
        for (Map<String, Object> fieldTreeNode : billFieldsTree) {
            if (!isShowEntry && "EntryEntity".equals(fieldTreeNode.get("Type")) || !isShowSubEntry && "SubEntryEntity".equals(fieldTreeNode.get("Type"))) continue;
            DynamicObject parentObj = this.getModel().getEntryRowEntity(KEY_TREE_ENTRY, parentRow);
            Long pid = (Long)parentObj.getPkValue();
            int row = this.getModel().createNewEntryRow(KEY_TREE_ENTRY);
            DynamicObject newRow = this.getModel().getEntryRowEntity(KEY_TREE_ENTRY, row);
            newRow.set("pid", (Object)pid);
            newRow.set("name", fieldTreeNode.get("Name"));
            newRow.set(NUMBER, fieldTreeNode.get("Id"));
            List items = (List)fieldTreeNode.get(ITEMS);
            if (items != null) {
                collapseRows.add(row);
                this.getView().setEnable(Boolean.valueOf(false), row, new String[]{IS_CHECK});
                this.buildTreeNode(fieldsInds, items, row);
                continue;
            }
            newRow.set(IS_CAN_BIND, (Object)true);
        }
        if (!collapseRows.isEmpty()) {
            TreeEntryGrid grid = (TreeEntryGrid)this.getControl(KEY_TREE_ENTRY);
            grid.collapse(collapseRows.stream().mapToInt(Integer::valueOf).toArray());
        }
    }

    private void buildTreeNode(List<Map<String, Object>> fieldsInds, List<Map<String, Object>> billFieldsTree, int parentRow) {
        this.buildTreeNode(fieldsInds, billFieldsTree, parentRow, false, false);
    }
}

