/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.print;

import java.io.IOException;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.property.print.CustomDataSourceHelper;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.util.JSONUtils;

public class CustomDataSourceEdit
extends AbstractFormPlugin {
    private String queryFieldEntry = "queryfieldentry";

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"queryfieldlbar"});
        this.addQueryFieldClickListener();
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String data = (String)showParameter.getCustomParam("dsdata");
        MainEntityType entityType = this.getModel().getDataEntityType();
        if (data != null) {
            DynamicObject obj = CustomDataSourceHelper.toDynamicObject(data, entityType);
            e.setDataEntity((Object)obj);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        Object name;
        super.beforeClosed(e);
        IDataModel parentModel = this.getView().getParentView().getModel();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        IDataModel model = this.getModel();
        Integer rowIndex = (Integer)showParameter.getCustomParam("rowIndex");
        if (rowIndex == null) {
            return;
        }
        int rowCount = parentModel.getEntryRowCount("dsentry");
        if (rowCount - 1 >= rowIndex && StringUtils.isNotBlank((Object)(name = model.getValue("name")))) {
            parentModel.setValue("dsdata", (Object)this.getDSData(), rowIndex.intValue());
        }
    }

    protected String getDSData() {
        DynamicObject obj = this.getModel().getDataEntity(true);
        return CustomDataSourceHelper.toDynamicObjectJson(obj);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("addnew".equals(key)) {
            this.getModel().createNewEntryRow(this.queryFieldEntry);
        } else if ("deletesf".equals(key)) {
            this.deleteRow(this.queryFieldEntry);
        }
    }

    private void deleteRow(String entryKey) {
        EntryGrid dsentry = (EntryGrid)this.getControl(entryKey);
        int[] rowIndexs = dsentry.getEntryState().getSelectedRows();
        if (rowIndexs != null && rowIndexs.length > 0) {
            this.getModel().deleteEntryRows(entryKey, rowIndexs);
        }
    }

    private void addQueryFieldClickListener() {
        EntryGrid selectentry = (EntryGrid)this.getControl(this.queryFieldEntry);
        selectentry.addCellClickListener(new CellClickListener(){

            public void cellClick(CellClickEvent e) {
                String fieldKey = e.getFieldKey();
                int row = e.getRow();
                if (row < 0) {
                    return;
                }
                if ("queryfield".equals(fieldKey)) {
                    CustomDataSourceEdit.this.showQueryFieldEdit(fieldKey, row);
                }
            }

            public void cellDoubleClick(CellClickEvent e) {
            }
        });
    }

    private void showQueryFieldEdit(String fieldKey, int rowIndex) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("ide_fieldedit");
        parameter.setCustomParam("fieldKey", (Object)fieldKey);
        parameter.setCustomParam("rowIndex", (Object)rowIndex);
        IDataModel model = this.getModel();
        String filterValue = (String)model.getValue(fieldKey, rowIndex);
        parameter.setCustomParam("value", (Object)filterValue);
        DynamicObject entity = (DynamicObject)model.getValue("entity");
        String entityId = (String)entity.getPkValue();
        TreeNode tree = CustomDataSourceHelper.getFieldTreeNode(entityId);
        try {
            parameter.setCustomParam("treeNode", (Object)JSONUtils.toString((Object)tree));
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, this.getView().getEntityId()));
        this.getView().showForm(parameter);
    }
}

