/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.print;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.property.print.CustomDataSourceHelper;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.SessionManager;

public class CustomDataSourceList
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String KEY_DS_ENTRY = "dsentry";
    private static final String ADD_DATASOURCE_FORMID = "ide_adddcustomatasource";
    private static final String CUSTOM_DATASOURCE_FORMID = "ide_editcustomdatasource";
    private static final String DS_DATA = "dsdata";
    private static final String DS_NAME = "dsname";
    private static final String DS_PAGE = "dspage";

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"dsop"});
        this.addClickListeners(new String[]{"btnok", "btncancel"});
        EntryGrid dsentry = (EntryGrid)this.getControl(KEY_DS_ENTRY);
        dsentry.addRowClickListener((RowClickEventListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("dsop".equals(key)) {
            if ("add".equals(evt.getItemKey())) {
                this.addDataSource();
            } else if ("delete".equals(evt.getItemKey())) {
                this.deleteDataSource();
            }
        }
    }

    public void afterBindData(EventObject e) {
        int rowIndex = 0;
        String data = (String)this.getModel().getValue(DS_DATA, rowIndex);
        if (StringUtils.isNotBlank((CharSequence)data)) {
            this.closeInnerView(true);
            this.showDSForm(rowIndex, data);
        }
    }

    public void createNewData(BizDataEventArgs e) {
        Object value = this.getView().getFormShowParameter().getCustomParams().get("value");
        if (StringUtils.isBlank(value)) {
            return;
        }
        MainEntityType entityType = this.getModel().getDataEntityType();
        DynamicObject dataSource = CustomDataSourceHelper.toDynamicObject((String)value, entityType);
        e.setDataEntity((Object)dataSource);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals("btnok")) {
            this.closeInnerView(false);
            this.returnData();
        } else {
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (evt.getReturnData() != null) {
            IDataModel model = this.getModel();
            if ("adddatasource".equals(evt.getActionId())) {
                Map retData = (Map)evt.getReturnData();
                String id = (String)retData.get("id");
                String number = (String)retData.get("number");
                String name = (String)retData.get("name");
                String data = (String)retData.get("data");
                int rowIndex = model.createNewEntryRow(KEY_DS_ENTRY);
                this.getModel().setEntryCurrentRowIndex(KEY_DS_ENTRY, rowIndex);
                model.setValue("dsid", (Object)id, rowIndex);
                model.setValue("dsnumber", (Object)number, rowIndex);
                model.setValue(DS_NAME, (Object)name, rowIndex);
                model.setValue(DS_DATA, (Object)data, rowIndex);
                IClientViewProxy viewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                viewProxy.invokeControlMethod(KEY_DS_ENTRY, "selectRows", new Object[]{rowIndex});
                viewProxy.getEntryState(KEY_DS_ENTRY).selectRow(rowIndex);
                this.closeInnerView(true);
                this.showDSForm(rowIndex, data);
            }
        }
    }

    public void entryRowClick(RowClickEvent e) {
        int rowIndex = e.getRow();
        if (rowIndex < 0) {
            return;
        }
        String data = (String)this.getModel().getValue(DS_DATA, rowIndex);
        this.closeInnerView(true);
        this.showDSForm(rowIndex, data);
    }

    public void entryRowDoubleClick(RowClickEvent arg0) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("ismainds".equals(e.getProperty().getName())) {
            IDataModel model = this.getModel();
            int idx = model.getEntryCurrentRowIndex(KEY_DS_ENTRY);
            int count = model.getEntryRowCount(KEY_DS_ENTRY);
            boolean newValue = (Boolean)e.getChangeSet()[0].getNewValue();
            if (newValue) {
                for (int i = 0; i < count; ++i) {
                    if (i == idx) continue;
                    model.setValue("ismainds", (Object)false, i);
                }
            }
        } else if (DS_NAME.equals(e.getProperty().getName())) {
            IDataModel model = this.getModel();
            int idx = model.getEntryCurrentRowIndex(KEY_DS_ENTRY);
            String newValue = (String)e.getChangeSet()[0].getNewValue();
            model.setValue(DS_NAME, (Object)newValue, idx);
        }
    }

    private String getCurrentEntityId() {
        List items;
        String currentEntityId = null;
        List context = (List)this.getView().getFormShowParameter().getCustomParam("context");
        if (context != null && !context.isEmpty() && (items = (List)context.get(0)).get(0) != null) {
            currentEntityId = (String)((Map)items.get(0)).get("EntityId");
        }
        return currentEntityId;
    }

    private void returnData() {
        String returnValue = null;
        int count = this.getModel().getEntryRowCount(KEY_DS_ENTRY);
        if (count > 0) {
            returnValue = CustomDataSourceHelper.toDynamicObjectJson(this.getModel().getDataEntity(true));
        }
        HashMap para = new HashMap(4);
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        para.put("value", returnValue);
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    private void addDataSource() {
        String entityId = this.getCurrentEntityId();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(ADD_DATASOURCE_FORMID);
        OpenStyle style = new OpenStyle();
        style.setShowType(ShowType.Modal);
        parameter.setOpenStyle(style);
        parameter.setCustomParam("ds", this.getDSList());
        parameter.setCustomParam("currentEntityId", (Object)entityId);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "adddatasource"));
        this.getView().showForm(parameter);
    }

    private void deleteDataSource() {
        IDataModel model = this.getModel();
        int rowIndex = model.getEntryCurrentRowIndex(KEY_DS_ENTRY);
        if (rowIndex > -1) {
            this.closeInnerView(true);
            model.deleteEntryRow(KEY_DS_ENTRY, rowIndex);
        }
        int preIndex = rowIndex - 1;
        int rowCount = model.getEntryRowCount(KEY_DS_ENTRY);
        EntryGrid dsentry = (EntryGrid)this.getControl(KEY_DS_ENTRY);
        if (preIndex >= 0) {
            dsentry.entryRowClick(Integer.valueOf(preIndex));
        } else if (preIndex == -1 && rowCount > 0) {
            dsentry.entryRowClick(Integer.valueOf(0));
        } else {
            this.showDSForm(0, null);
        }
    }

    private void showDSForm(int rowIndex, String data) {
        if (rowIndex >= 0) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setCustomParam(DS_DATA, (Object)data);
            parameter.setCustomParam("rowIndex", (Object)rowIndex);
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getOpenStyle().setTargetKey("dspanel");
            parameter.setCustomParam("ds", this.getDSList());
            parameter.setFormId(CUSTOM_DATASOURCE_FORMID);
            IPageCache pageCache = this.getPageCache();
            pageCache.put(DS_PAGE, parameter.getPageId());
            this.getView().showForm(parameter);
        }
    }

    private List<Map<String, String>> getDSList() {
        DynamicObjectCollection dynObjColl = this.getModel().getEntryEntity(KEY_DS_ENTRY);
        ArrayList<Map<String, String>> dsList = new ArrayList<Map<String, String>>();
        for (DynamicObject obj : dynObjColl) {
            HashMap<String, String> ds = new HashMap<String, String>(4);
            ds.put("number", obj.getString("dsnumber"));
            ds.put("name", obj.getString(DS_NAME));
            ds.put("id", obj.getString("dsid"));
            ds.put("data", obj.getString(DS_DATA));
            dsList.add(ds);
        }
        return dsList;
    }

    private void closeInnerView(boolean closeSubView) {
        IPageCache pageCache = this.getPageCache();
        String dsPageId = pageCache.get(DS_PAGE);
        if (StringUtils.isBlank((CharSequence)dsPageId)) {
            return;
        }
        IFormView dsView = SessionManager.getCurrent().getView(dsPageId);
        if (dsView != null) {
            dsView.close();
            pageCache.put(DS_PAGE, "");
            if (closeSubView) {
                HashMap<String, String> arg = new HashMap<String, String>(2);
                arg.put("pageId", dsPageId);
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("closeWindow", arg);
            }
        }
    }
}

