/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.print;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.StringUtils;

public class FormatModel {
    static final int GENERAL = 0;
    static final int NUMBER = 1;
    static final int CURRENCY = 2;
    static final int ACCOUNT = 3;
    static final int DATE = 4;
    static final int TIME = 5;
    static final int PERCENT = 6;
    static final int FRACTION = 7;
    static final int SCIENCE = 8;
    static final int TEXT = 9;
    static final int SPECIAL = 10;
    static final int CUSTOM = 11;
    static final String[] typeTexts = new String[]{FormatModel.getMLS("itemNormal", ResManager.loadKDString((String)"\u5e38\u89c4", (String)"FormatModel_0", (String)"bos-designer-plugin", (Object[])new Object[0])), FormatModel.getMLS("itemNumber", ResManager.loadKDString((String)"\u6570\u503c", (String)"FormatModel_1", (String)"bos-designer-plugin", (Object[])new Object[0])), FormatModel.getMLS("itemMoney", ResManager.loadKDString((String)"\u8d27\u5e01", (String)"FormatModel_2", (String)"bos-designer-plugin", (Object[])new Object[0])), FormatModel.getMLS("itemAccountant", ResManager.loadKDString((String)"\u4f1a\u8ba1\u4e13\u7528", (String)"FormatModel_3", (String)"bos-designer-plugin", (Object[])new Object[0])), FormatModel.getMLS("itemDate", ResManager.loadKDString((String)"\u65e5\u671f", (String)"FormatModel_4", (String)"bos-designer-plugin", (Object[])new Object[0])), FormatModel.getMLS("itemTime", ResManager.loadKDString((String)"\u65f6\u95f4", (String)"FormatModel_5", (String)"bos-designer-plugin", (Object[])new Object[0])), FormatModel.getMLS("itemPercent", ResManager.loadKDString((String)"\u767e\u5206\u6bd4", (String)"FormatModel_6", (String)"bos-designer-plugin", (Object[])new Object[0])), FormatModel.getMLS("itemFraction", ResManager.loadKDString((String)"\u5206\u6570", (String)"FormatModel_7", (String)"bos-designer-plugin", (Object[])new Object[0])), FormatModel.getMLS("itemScience", ResManager.loadKDString((String)"\u79d1\u5b66\u8bb0\u6570", (String)"FormatModel_8", (String)"bos-designer-plugin", (Object[])new Object[0])), FormatModel.getMLS("itemText", ResManager.loadKDString((String)"\u6587\u672c", (String)"FormatModel_9", (String)"bos-designer-plugin", (Object[])new Object[0])), FormatModel.getMLS("itemSpecial", ResManager.loadKDString((String)"\u7279\u6b8a", (String)"FormatModel_10", (String)"bos-designer-plugin", (Object[])new Object[0])), FormatModel.getMLS("itemCustom", ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49", (String)"FormatModel_11", (String)"bos-designer-plugin", (Object[])new Object[0]))};
    static final String[] dateTexts;
    static final String[] timeTexts;
    static final String[] fractionTexts;
    static final String[] specialTexts;
    static final String[] currencyTexts;
    static final String[] cardTypes;
    static final String[] currencySymbols;
    private static final String groupSepPattern;
    private static final String numberReg;
    private static final String redPattern;
    private static final String redPattern1;
    private static final String generalPattern;
    private static final String[] numRegs;
    private static final String[] groupNumRegs;
    private static final String[] currencyRegs;
    private static final String accountReg;
    static final String[] datePatterns;
    public static final String[] timePatterns;
    private static final String percentReg;
    static final String[] fractionPatterns;
    private static final String scienceReg;
    private static final String textPattern;
    static final String[] specialPatterns;
    static final Map<Integer, String> formatType;
    static final Map<String, LocaleString> specialFormat;
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String NUMBER1 = "number";
    private static final String STRING = "\u20ac";
    private static final String STRING1 = "\u00a3";
    private String _pattern;
    private int _type;
    private String _zeroStr;
    private int decNums;
    private int currencyIndex;
    private boolean hasGroupSep;
    private int negativeIndex;
    private int dateIndex;
    private int timeIndex;
    private int fractionIndex;
    private int specialIndex;
    private boolean tailZero;

    static String getMLS(String key, String defaultValue) {
        return defaultValue;
    }

    static final String getGeneral() {
        return generalPattern;
    }

    static final String getGeneralDate() {
        return datePatterns[0];
    }

    static final String getGeneralPercent() {
        return "0%";
    }

    static final String getGeneralScience() {
        return "0.00E00";
    }

    static final String getGeneralTime() {
        return "h:mm";
    }

    static final String getGeneralCurrency(String currencySymbol) {
        StringBuilder sb = new StringBuilder("#,##0.00;[red](#,##0.00)");
        sb.insert(sb.indexOf("(") + 1, currencySymbol);
        sb.insert(0, currencySymbol);
        return sb.toString();
    }

    int getType() {
        return this._type;
    }

    void setType(int type) {
        if (this._type != type) {
            this._type = type;
            if (this._type >= 0) {
                this.generatePattern();
            }
        }
    }

    int getDecNums() {
        return this.decNums;
    }

    void setDecNums(int num) {
        if (num != this.decNums) {
            this.decNums = num;
            if (this._type == 1 || this._type == 2 || this._type == 3 || this._type == 6 || this._type == 8) {
                this.generatePattern();
            }
        }
    }

    int getCurrencyIndex() {
        return this.currencyIndex;
    }

    void setCurrencyIndex(int i) {
        if (i != this.currencyIndex) {
            this.currencyIndex = i;
            if (this._type == 2 || this._type == 3) {
                this.generatePattern();
            }
        }
    }

    boolean hasGroupSep() {
        return this.hasGroupSep;
    }

    void setHasGroupSep(boolean b) {
        if (this.hasGroupSep != b) {
            this.hasGroupSep = b;
            if (this._type == 1) {
                this.generatePattern();
            }
        }
    }

    boolean isTailZero() {
        return this.tailZero;
    }

    void setTailZero(boolean b) {
        if (this.tailZero != b) {
            this.tailZero = b;
            if (this._type == 1 || this._type == 3 || this._type == 6 || this._type == 2 || this._type == 8) {
                this.generatePattern();
            }
        }
    }

    String getZeroString() {
        return this._zeroStr;
    }

    void setZeroString(String str) {
        this._zeroStr = str;
        if (this._type == 1 || this._type == 2) {
            this.generatePattern();
        }
    }

    int getNegativeIndex() {
        return this.negativeIndex;
    }

    void setNegativeIndex(int i) {
        if (i != this.negativeIndex) {
            this.negativeIndex = i;
            if (this._type == 1 || this._type == 2) {
                this.generatePattern();
            }
        }
    }

    int getDateIndex() {
        return this.dateIndex;
    }

    void setDateIndex(int i) {
        if (i != this.dateIndex) {
            this.dateIndex = i;
            if (this._type == 4) {
                this.generatePattern();
            }
        }
    }

    int getTimeIndex() {
        return this.timeIndex;
    }

    void setTimeIndex(int i) {
        if (i != this.timeIndex) {
            this.timeIndex = i;
            if (this._type == 5) {
                this.generatePattern();
            }
        }
    }

    int getFractionIndex() {
        return this.fractionIndex;
    }

    void setFractionIndex(int i) {
        if (i != this.fractionIndex) {
            this.fractionIndex = i;
            if (this._type == 7) {
                this.generatePattern();
            }
        }
    }

    int getSpecialIndex() {
        return this.specialIndex;
    }

    void setSpecialIndex(int i) {
        if (i != this.specialIndex) {
            this.specialIndex = i;
            if (this._type == 10) {
                this.generatePattern();
            }
        }
    }

    FormatModel(String pattern) {
        this.initDefaults();
        this.applyPattern(pattern);
    }

    FormatModel() {
        this.initDefaults();
    }

    String getPattern() {
        return this._pattern;
    }

    private void setPattern(String pattern) {
        this._pattern = pattern;
    }

    void applyPattern(String pattern) {
        if (StringUtils.isEmpty((Object)pattern)) {
            pattern = generalPattern;
        }
        this._zeroStr = "";
        pattern = pattern.toLowerCase();
        this.setPattern(pattern);
        if (this.initAsGeneral(pattern)) {
            return;
        }
        if (this.initAsNumber(pattern)) {
            return;
        }
        if (this.initAsCurrency(pattern)) {
            return;
        }
        if (this.initAsAccount(pattern)) {
            return;
        }
        if (this.initAsDate(pattern)) {
            return;
        }
        if (this.initAsTime(pattern)) {
            return;
        }
        if (this.initAsPercent(pattern)) {
            return;
        }
        if (this.initAsFraction(pattern)) {
            return;
        }
        if (this.initAsScience(pattern)) {
            return;
        }
        if (this.initAsText(pattern)) {
            return;
        }
        if (this.initAsSpecial(pattern)) {
            return;
        }
        if (this.initAsCustom(pattern)) {
            return;
        }
    }

    private boolean initAsGeneral(String pattern) {
        if (generalPattern.equalsIgnoreCase(pattern)) {
            this._type = 0;
            return true;
        }
        return false;
    }

    private boolean initAsNumber(String pattern) {
        int j;
        String[] strs = pattern.split(";");
        if (strs.length > 3 || strs.length < 2) {
            return false;
        }
        if (strs.length == 3) {
            this._zeroStr = strs[2];
        }
        if ((j = strs[0].indexOf(94)) == 0) {
            this.setTailZero(true);
            strs[0] = strs[0].substring(1, strs[0].length());
        }
        pattern = strs[0] + ";" + strs[1];
        for (int i = numRegs.length - 1; i >= 0; --i) {
            boolean b1 = pattern.matches(numRegs[i]);
            boolean b2 = pattern.matches(groupNumRegs[i]);
            if (!b1 && !b2) continue;
            int t1 = pattern.indexOf(".");
            int t2 = pattern.indexOf(";");
            int t3 = pattern.lastIndexOf(".");
            int t4 = pattern.lastIndexOf("0");
            if (t1 == t3 && t1 >= 0) {
                return false;
            }
            if (t1 == -1) {
                this.negativeIndex = i;
                this.decNums = 0;
                this.hasGroupSep = b2;
                this._type = 1;
                return true;
            }
            if (t2 - t1 - 1 != t4 - t3) {
                return false;
            }
            this.negativeIndex = i;
            this.decNums = t4 - t3;
            this.hasGroupSep = b2;
            this._type = 1;
            return true;
        }
        return false;
    }

    private boolean initAsCurrency(String pattern) {
        int j;
        String[] strs = pattern.split(";");
        if (strs.length > 3 || strs.length < 2) {
            return false;
        }
        if (strs.length == 3) {
            this._zeroStr = strs[2];
        }
        if ((j = strs[0].indexOf(94)) == 0) {
            this.setTailZero(true);
            strs[0] = strs[0].substring(1);
        }
        pattern = strs[0] + ";" + strs[1];
        for (int i = currencyRegs.length - 1; i >= 0; --i) {
            if (!pattern.matches(currencyRegs[i])) continue;
            int t1 = pattern.indexOf(".");
            int t2 = pattern.indexOf(";");
            int t3 = pattern.lastIndexOf(".");
            int t4 = pattern.lastIndexOf("0");
            if (t1 == t3 && t1 >= 0) {
                return false;
            }
            if (t1 == -1) {
                this.negativeIndex = i;
                this.decNums = 0;
                this._type = 1;
                return true;
            }
            if (t2 - t1 - 1 != t4 - t3) {
                return false;
            }
            int t5 = pattern.indexOf("#");
            String currSymbol = pattern.substring(0, t5);
            if (pattern.lastIndexOf(currSymbol) == 0) {
                return false;
            }
            this.negativeIndex = i;
            this.decNums = t4 - t3;
            this.currencyIndex = this.getCurrencyIndex(currSymbol);
            this._type = 2;
            return true;
        }
        return false;
    }

    private boolean initAsAccount(String pattern) {
        int i = pattern.indexOf(94);
        if (i == 0) {
            this.setTailZero(true);
            pattern = pattern.substring(1, pattern.length());
        }
        if (pattern.matches(accountReg)) {
            int t1 = pattern.indexOf(".");
            int t2 = pattern.indexOf(";");
            int t3 = pattern.indexOf(".", t2 + 1);
            int t4 = pattern.indexOf(";", t2 + 1);
            int t5 = pattern.indexOf("?");
            int t6 = pattern.lastIndexOf("?");
            int dec1 = t1 == -1 || t1 > t2 ? 0 : t2 - t1 - 1;
            int dec2 = t3 == -1 || t3 > t4 ? 0 : t4 - t3 - 1;
            int dec3 = t5 == -1 ? 0 : t6 - t5 + 1;
            if (dec1 != dec2 || dec1 != dec3) {
                return false;
            }
            int t7 = pattern.indexOf("*");
            int t8 = pattern.indexOf("*", t7 + 1);
            int t9 = pattern.indexOf("*", t8 + 1);
            String c1 = pattern.substring(0, t7);
            String c2 = pattern.substring(t2 + 1, t8);
            String c3 = pattern.substring(t4 + 1, t9);
            if (!c1.equalsIgnoreCase(c2) || !c1.equalsIgnoreCase(c3)) {
                return false;
            }
            this._type = 3;
            this.decNums = dec1;
            this.currencyIndex = this.getCurrencyIndex(c1);
            return true;
        }
        return false;
    }

    private int getCurrencyIndex(String symbol) {
        for (int i = currencySymbols.length - 1; i >= 0; --i) {
            if (!currencySymbols[i].equalsIgnoreCase(symbol)) continue;
            return i;
        }
        return -1;
    }

    private boolean initAsDate(String pattern) {
        for (int i = datePatterns.length - 1; i >= 0; --i) {
            if (!datePatterns[i].equalsIgnoreCase(pattern)) continue;
            this.dateIndex = i;
            this._type = 4;
            return true;
        }
        return false;
    }

    private boolean initAsTime(String pattern) {
        for (int i = timePatterns.length - 1; i >= 0; --i) {
            if (!timePatterns[i].equalsIgnoreCase(pattern)) continue;
            this.timeIndex = i;
            this._type = 5;
            return true;
        }
        return false;
    }

    private boolean initAsPercent(String pattern) {
        int i = pattern.indexOf(94);
        if (i == 0) {
            this.setTailZero(true);
            pattern = pattern.substring(1, pattern.length());
        }
        if (pattern.matches(percentReg)) {
            this._type = 6;
            this.decNums = pattern.length() == 2 ? 0 : pattern.length() - 3;
            return true;
        }
        return false;
    }

    private boolean initAsFraction(String pattern) {
        for (int i = fractionPatterns.length - 1; i >= 0; --i) {
            if (!fractionPatterns[i].equalsIgnoreCase(pattern)) continue;
            this.fractionIndex = i;
            this._type = 7;
            return true;
        }
        return false;
    }

    private boolean initAsScience(String pattern) {
        int i = pattern.indexOf(94);
        if (i == 0) {
            this.setTailZero(true);
            pattern = pattern.substring(1, pattern.length());
        }
        if (pattern.matches(scienceReg)) {
            this._type = 8;
            this.decNums = pattern.length() == 4 ? 0 : pattern.length() - 5;
            return true;
        }
        return false;
    }

    private boolean initAsText(String pattern) {
        if (textPattern.equalsIgnoreCase(pattern)) {
            this._type = 9;
            return true;
        }
        return false;
    }

    private boolean initAsSpecial(String pattern) {
        for (int i = specialPatterns.length - 1; i >= 0; --i) {
            if (!specialPatterns[i].equalsIgnoreCase(pattern)) continue;
            this.specialIndex = i;
            this._type = 10;
            return true;
        }
        return false;
    }

    private boolean initAsCustom(String pattern) {
        this._type = 11;
        return true;
    }

    private void initDefaults() {
        this.setPattern(generalPattern);
        this._type = 0;
        this.decNums = 2;
        this.currencyIndex = 0;
        this.hasGroupSep = false;
        this.negativeIndex = 3;
        this.dateIndex = 0;
        this.timeIndex = 0;
        this.fractionIndex = 0;
        this.specialIndex = 0;
    }

    private void generatePattern() {
        switch (this._type) {
            case 0: {
                this.setPattern(this.toGeneralPattern());
                break;
            }
            case 1: {
                this.setPattern(this.toNumberPattern());
                break;
            }
            case 2: {
                this.setPattern(this.toCurrencyPattern());
                break;
            }
            case 3: {
                this.setPattern(this.toAccountPattern());
                break;
            }
            case 4: {
                this.setPattern(this.toDatePattern());
                break;
            }
            case 5: {
                this.setPattern(this.toTimePattern());
                break;
            }
            case 6: {
                this.setPattern(this.toPercentPattern());
                break;
            }
            case 7: {
                this.setPattern(this.toFractionPattern());
                break;
            }
            case 8: {
                this.setPattern(this.toSciencePattern());
                break;
            }
            case 9: {
                this.setPattern(this.toTextPattern());
                break;
            }
            case 10: {
                this.setPattern(this.toSpecialPattern());
                break;
            }
            case 11: {
                break;
            }
            default: {
                this.setPattern(generalPattern);
            }
        }
    }

    private boolean hasNegativeSign() {
        return this.negativeIndex >= 3;
    }

    private boolean hasBracket() {
        return this.negativeIndex <= 1;
    }

    private boolean isRed() {
        return this.negativeIndex % 2 == 0;
    }

    private String toNumberPattern() {
        StringBuilder sb = new StringBuilder();
        if (this.tailZero) {
            sb.append("^");
        }
        if (this.hasGroupSep) {
            sb.append("#,##");
        }
        sb.append('0');
        if (this.decNums > 0) {
            sb.append('.');
        }
        for (int i = this.decNums - 1; i >= 0; --i) {
            sb.append('0');
        }
        StringBuilder sb2 = new StringBuilder();
        if (this.isRed()) {
            sb2.append("[Red]");
        }
        if (this.hasNegativeSign()) {
            sb2.append('-');
        }
        if (this.hasBracket()) {
            sb2.append('(');
        }
        if (this.isTailZero()) {
            String str = sb.toString();
            str = str.substring(1);
            sb2.append(str);
        } else {
            sb2.append((CharSequence)sb);
        }
        if (this.hasBracket()) {
            sb2.append(')');
        }
        sb.append(';');
        sb.append((CharSequence)sb2);
        if (!StringUtils.isEmpty((Object)this._zeroStr)) {
            sb.append(';');
            sb.append(this._zeroStr);
        }
        return sb.toString();
    }

    private String toCurrencyPattern() {
        boolean oldHasGS = this.hasGroupSep;
        this.hasGroupSep = true;
        String str = this.toNumberPattern();
        String symbol = currencySymbols[this.currencyIndex];
        StringBuilder sb = new StringBuilder();
        sb.append(str);
        if (this.isTailZero()) {
            sb.insert(1, symbol);
        } else {
            sb.insert(0, symbol);
        }
        if (this.hasNegativeSign()) {
            sb.insert(sb.indexOf("-#"), symbol);
        } else {
            sb.insert(sb.lastIndexOf("#,"), symbol);
        }
        this.hasGroupSep = oldHasGS;
        return sb.toString();
    }

    private String toSpecialPattern() {
        return specialPatterns[this.specialIndex];
    }

    private String toTextPattern() {
        return textPattern;
    }

    private String toSciencePattern() {
        StringBuilder sb = new StringBuilder();
        if (this.tailZero) {
            sb.append('^');
        }
        sb.append('0');
        if (this.decNums > 0) {
            sb.append('.');
        }
        for (int i = this.decNums - 1; i >= 0; --i) {
            sb.append('0');
        }
        sb.append("E00");
        return sb.toString();
    }

    private String toFractionPattern() {
        return fractionPatterns[this.fractionIndex];
    }

    private String toPercentPattern() {
        StringBuilder sb = new StringBuilder();
        if (this.tailZero) {
            sb.append('^');
        }
        sb.append('0');
        if (this.decNums > 0) {
            sb.append('.');
        }
        for (int i = this.decNums - 1; i >= 0; --i) {
            sb.append('0');
        }
        sb.append('%');
        return sb.toString();
    }

    private String toAccountPattern() {
        String symbol = currencySymbols[this.currencyIndex];
        StringBuffer sb = new StringBuffer();
        if (this.tailZero) {
            sb.append('^');
        }
        sb.append(symbol);
        sb.append("* #,##0");
        if (this.decNums > 0) {
            sb.append('.');
        }
        for (int i = this.decNums - 1; i >= 0; --i) {
            sb.append('0');
        }
        sb.append(";");
        StringBuffer sb2 = new StringBuffer();
        sb2.append(sb);
        sb2.insert(symbol.length() + 2, '-');
        sb.append(sb2);
        sb.append(symbol);
        sb.append("* -");
        sb.append(";");
        sb.append("@");
        return sb.toString();
    }

    private String toGeneralPattern() {
        return generalPattern;
    }

    private String toDatePattern() {
        return datePatterns[this.dateIndex];
    }

    private String toTimePattern() {
        return timePatterns[this.timeIndex];
    }

    public static boolean isSpecialFormat(String format) {
        for (int i = specialPatterns.length - 1; i >= 0; --i) {
            if (!specialPatterns[i].equalsIgnoreCase(format)) continue;
            return true;
        }
        return false;
    }

    static {
        cardTypes = new String[]{"general", NUMBER1, NUMBER1, NUMBER1, "date", "time", NUMBER1, "fraction", NUMBER1, "text", "special", "custom"};
        currencySymbols = new String[]{"\u00a5", "$", "\"US$\"", STRING, STRING1};
        currencyTexts = new String[]{"\u00a5", "$", "US$", STRING, STRING1};
        StringBuilder sb = new StringBuilder();
        groupSepPattern = "#,##";
        numberReg = "(0|0(.0){1}[0]*){1}";
        redPattern = "\\[red\\]";
        redPattern1 = ResManager.loadKDString((String)"\\[\u7ea2\u8272\\]", (String)"FormatModel_12", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
        generalPattern = ResManager.loadKDString((String)"G/\u901a\u7528\u683c\u5f0f", (String)"FormatModel_13", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
        numRegs = new String[8];
        sb.delete(0, sb.length());
        sb.append(numberReg);
        sb.append(';');
        sb.append(redPattern);
        sb.append('\\');
        sb.append('(');
        sb.append(numberReg);
        sb.append('\\');
        sb.append(')');
        FormatModel.numRegs[0] = sb.toString();
        sb.delete(0, sb.length());
        sb.append(numberReg);
        sb.append(';');
        sb.append(redPattern1);
        sb.append('\\');
        sb.append('(');
        sb.append(numberReg);
        sb.append('\\');
        sb.append(')');
        FormatModel.numRegs[6] = sb.toString();
        sb.delete(0, sb.length());
        sb.append(numberReg);
        sb.append(';');
        sb.append('\\');
        sb.append('(');
        sb.append(numberReg);
        sb.append('\\');
        sb.append(')');
        FormatModel.numRegs[1] = sb.toString();
        sb.delete(0, sb.length());
        sb.append(numberReg);
        sb.append(';');
        sb.append(redPattern);
        sb.append(numberReg);
        FormatModel.numRegs[2] = sb.toString();
        sb.delete(0, sb.length());
        sb.append(numberReg);
        sb.append(';');
        sb.append(redPattern1);
        sb.append(numberReg);
        FormatModel.numRegs[7] = sb.toString();
        sb.delete(0, sb.length());
        sb.append(numberReg);
        sb.append(';');
        sb.append('-');
        sb.append(numberReg);
        FormatModel.numRegs[3] = sb.toString();
        sb.delete(0, sb.length());
        sb.append(numberReg);
        sb.append(';');
        sb.append(redPattern);
        sb.append('-');
        sb.append(numberReg);
        FormatModel.numRegs[4] = sb.toString();
        sb.delete(0, sb.length());
        sb.append(numberReg);
        sb.append(';');
        sb.append(redPattern1);
        sb.append('-');
        sb.append(numberReg);
        FormatModel.numRegs[5] = sb.toString();
        groupNumRegs = new String[8];
        sb.delete(0, sb.length());
        sb.append(groupSepPattern);
        sb.append(numberReg);
        sb.append(';');
        sb.append(redPattern);
        sb.append('\\');
        sb.append('(');
        sb.append(groupSepPattern);
        sb.append(numberReg);
        sb.append('\\');
        sb.append(')');
        FormatModel.groupNumRegs[0] = sb.toString();
        sb.delete(0, sb.length());
        sb.append(groupSepPattern);
        sb.append(numberReg);
        sb.append(';');
        sb.append(redPattern1);
        sb.append('\\');
        sb.append('(');
        sb.append(groupSepPattern);
        sb.append(numberReg);
        sb.append('\\');
        sb.append(')');
        FormatModel.groupNumRegs[6] = sb.toString();
        sb.delete(0, sb.length());
        sb.append(groupSepPattern);
        sb.append(numberReg);
        sb.append(';');
        sb.append('\\');
        sb.append('(');
        sb.append(groupSepPattern);
        sb.append(numberReg);
        sb.append('\\');
        sb.append(')');
        FormatModel.groupNumRegs[1] = sb.toString();
        sb.delete(0, sb.length());
        sb.append(groupSepPattern);
        sb.append(numberReg);
        sb.append(';');
        sb.append(redPattern);
        sb.append(groupSepPattern);
        sb.append(numberReg);
        FormatModel.groupNumRegs[2] = sb.toString();
        sb.delete(0, sb.length());
        sb.append(groupSepPattern);
        sb.append(numberReg);
        sb.append(';');
        sb.append(redPattern1);
        sb.append(groupSepPattern);
        sb.append(numberReg);
        FormatModel.groupNumRegs[7] = sb.toString();
        sb.delete(0, sb.length());
        sb.append(groupSepPattern);
        sb.append(numberReg);
        sb.append(';');
        sb.append('-');
        sb.append(groupSepPattern);
        sb.append(numberReg);
        FormatModel.groupNumRegs[3] = sb.toString();
        sb.delete(0, sb.length());
        sb.append(groupSepPattern);
        sb.append(numberReg);
        sb.append(';');
        sb.append(redPattern);
        sb.append('-');
        sb.append(groupSepPattern);
        sb.append(numberReg);
        FormatModel.groupNumRegs[4] = sb.toString();
        sb.delete(0, sb.length());
        sb.append(groupSepPattern);
        sb.append(numberReg);
        sb.append(';');
        sb.append(redPattern1);
        sb.append('-');
        sb.append(groupSepPattern);
        sb.append(numberReg);
        FormatModel.groupNumRegs[5] = sb.toString();
        currencyRegs = new String[5];
        String[] regSymbols = new String[]{"\u00a5", "\\$", "\"us\\$\"", STRING, STRING1};
        sb = new StringBuilder();
        sb.append('(');
        for (int i = 4; i >= 1; --i) {
            sb.append(regSymbols[i]);
            sb.append('|');
        }
        sb.append(regSymbols[0]);
        sb.append(')');
        sb.append('{');
        sb.append('1');
        sb.append('}');
        String currencySymbReg = sb.toString();
        sb = new StringBuilder(groupNumRegs[0]);
        sb.insert(sb.indexOf("(#") + 1, currencySymbReg);
        sb.insert(0, currencySymbReg);
        FormatModel.currencyRegs[0] = sb.toString();
        sb = new StringBuilder(groupNumRegs[1]);
        sb.insert(sb.indexOf("(#") + 1, currencySymbReg);
        sb.insert(0, currencySymbReg);
        FormatModel.currencyRegs[1] = sb.toString();
        sb = new StringBuilder(groupNumRegs[2]);
        sb.insert(sb.indexOf("]#") + 1, currencySymbReg);
        sb.insert(0, currencySymbReg);
        FormatModel.currencyRegs[2] = sb.toString();
        sb = new StringBuilder(groupNumRegs[3]);
        sb.insert(sb.indexOf(";") + 1, currencySymbReg);
        sb.insert(0, currencySymbReg);
        FormatModel.currencyRegs[3] = sb.toString();
        sb = new StringBuilder(groupNumRegs[4]);
        sb.insert(sb.indexOf(";") + 1, currencySymbReg);
        sb.insert(0, currencySymbReg);
        FormatModel.currencyRegs[4] = sb.toString();
        sb = new StringBuilder();
        sb.append(currencySymbReg).append('\\').append('*').append(groupSepPattern).append(numberReg).append(';');
        sb.append(currencySymbReg).append('\\').append('*').append('-').append(groupSepPattern).append(numberReg).append(';');
        sb.append(currencySymbReg).append('\\').append('*').append("[?]*").append(';');
        sb.append('@');
        accountReg = sb.toString();
        datePatterns = new String[]{"yyyy-m-d", "yyyy\\/m\\/d", ResManager.loadKDString((String)"[DBNum1]yyyy\u5e74m\u6708d\u65e5;@", (String)"FormatModel_14", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"[DBNum1]yyyy\u5e74m\u6708;@", (String)"FormatModel_15", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"[DBNum1]m\u6708d\u65e5;@", (String)"FormatModel_16", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"yyyy\u5e74m\u6708d\u65e5;@", (String)"FormatModel_17", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"yyyy\u5e74m\u6708;@", (String)"FormatModel_18", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"m\u6708d\u65e5;@", (String)"FormatModel_19", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "aaaa;@", "aaa;@", "yyyy-m-d h:mm AM/PM;@", "yyyy-m-d h:mm;@", "yy-m-d;@", "m-d;@", "m-d-yy;@", "mm-dd-yy;@", "d-mmm;@", "dd-mmm-yy;@", "mmm-yy;@", "mmmm-yy;@", "mmmmm;@", "mmmmm-yy;@"};
        dateTexts = new String[]{"2001-3-14", "2001/3/14", ResManager.loadKDString((String)"\u4e8c\u3007\u3007\u4e00\u5e74\u4e09\u6708\u5341\u56db\u65e5", (String)"FormatModel_20", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e8c\u3007\u3007\u4e00\u5e74\u4e09\u6708", (String)"FormatModel_21", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e09\u6708\u5341\u56db\u65e5", (String)"FormatModel_22", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"2001\u5e743\u670814\u65e5", (String)"FormatModel_23", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"2001\u5e743\u6708", (String)"FormatModel_24", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"3\u670814\u65e5", (String)"FormatModel_25", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"\u661f\u671f\u56db", (String)"FormatModel_26", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"\u56db", (String)"FormatModel_27", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "2001-3-14 8:55 AM", "2001-3-14 8:55", "01-3-14", "3-14", "3-14-01", "03-14-01", "14-Mar", "14-Mar-01", "Mar-01", "March-01", "M", "M-01"};
        timePatterns = new String[]{"h:mm:ss AM/PM;@", "h:mm;@", "h:mm AM/PM;@", "h:mm:ss;@", ResManager.loadKDString((String)"h\u65f6mm\u5206;@", (String)"FormatModel_28", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"h\u65f6mm\u5206ss\u79d2;@", (String)"FormatModel_29", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"[DBNum1]h\u65f6mm\u5206;@", (String)"FormatModel_30", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])};
        timeTexts = new String[]{"8:55:10 AM", "8:55", "8:55 AM", "8:55:10", ResManager.loadKDString((String)"8\u65f655\u5206", (String)"FormatModel_31", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"8\u65f655\u520610\u79d2", (String)"FormatModel_32", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"\u516b\u65f6\u4e94\u5341\u4e94\u5206", (String)"FormatModel_33", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])};
        percentReg = numberReg + "%";
        fractionPatterns = new String[]{"?/?", "??/??", "???/???", "?/2", "?/4", "?/8", "??/16", "?/10", "??/100"};
        fractionTexts = new String[]{FormatModel.getMLS("fractionOne", ResManager.loadKDString((String)"\u5206\u6bcd\u4e3a\u4e00\u4f4d\u65701/4", (String)"FormatModel_34", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), FormatModel.getMLS("fractionTwo", ResManager.loadKDString((String)"\u5206\u6bcd\u4e3a\u4e24\u4f4d\u657021/25", (String)"FormatModel_35", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), FormatModel.getMLS("fractionTree", ResManager.loadKDString((String)"\u5206\u6bcd\u4e3a\u4e09\u4f4d\u6570312/943", (String)"FormatModel_36", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), FormatModel.getMLS("fractionFour", ResManager.loadKDString((String)"\u4ee52\u4e3a\u5206\u6bcd1/2", (String)"FormatModel_37", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), FormatModel.getMLS("fractionFive", ResManager.loadKDString((String)"\u4ee54\u4e3a\u5206\u6bcd2/4", (String)"FormatModel_38", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), FormatModel.getMLS("fractionSix", ResManager.loadKDString((String)"\u4ee58\u4e3a\u5206\u6bcd4/8", (String)"FormatModel_39", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), FormatModel.getMLS("fractionSeven", ResManager.loadKDString((String)"\u4ee516\u4e3a\u5206\u6bcd8/16", (String)"FormatModel_40", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), FormatModel.getMLS("fractionEight", ResManager.loadKDString((String)"\u4ee510\u4e3a\u5206\u6bcd3/10", (String)"FormatModel_41", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), FormatModel.getMLS("fractionNine", ResManager.loadKDString((String)"\u767e\u5206\u4e4b\u51e030/100", (String)"FormatModel_42", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]))};
        scienceReg = numberReg + "e00";
        textPattern = "@";
        specialPatterns = new String[]{"000000", ResManager.loadKDString((String)"[DBNum1]G/\u901a\u7528\u683c\u5f0f", (String)"FormatModel_43", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"[DBNum2]G/\u901a\u7528\u683c\u5f0f", (String)"FormatModel_44", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"[Dollar]0.00;[Dollar](\u8d1f\u6570)0.00", (String)"FormatModel_45", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"[Rmb]0.00;[Rmb](\u8d1f\u6570)0.00", (String)"FormatModel_46", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])};
        specialTexts = new String[]{FormatModel.getMLS("postalcode", ResManager.loadKDString((String)"\u90ae\u653f\u7f16\u7801", (String)"FormatModel_47", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), FormatModel.getMLS("ChineseLowercase", ResManager.loadKDString((String)"\u4e2d\u6587\u5c0f\u5199\u6570\u5b57", (String)"FormatModel_48", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), FormatModel.getMLS("ChineseUppercase", ResManager.loadKDString((String)"\u4e2d\u6587\u5927\u5199\u6570\u5b57", (String)"FormatModel_49", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), FormatModel.getMLS("ChineseUSDStyle", ResManager.loadKDString((String)"\u4e2d\u6587\u7f8e\u5143\u6837\u5f0f", (String)"FormatModel_50", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), FormatModel.getMLS("ChineseRMBStyle", ResManager.loadKDString((String)"\u4e2d\u6587\u4eba\u6c11\u5e01\u6837\u5f0f", (String)"FormatModel_51", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]))};
        formatType = new HashMap<Integer, String>();
        for (int i = 0; i < typeTexts.length; ++i) {
            formatType.put(i, typeTexts[i]);
        }
        specialFormat = new HashMap<String, LocaleString>();
        specialFormat.put("000000", new LocaleString(ResManager.loadKDString((String)"\u90ae\u653f\u7f16\u7801", (String)"FormatModel_47", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        specialFormat.put(ResManager.loadKDString((String)"[DBNum1]G/\u901a\u7528\u683c\u5f0f", (String)"FormatModel_43", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), new LocaleString(ResManager.loadKDString((String)"\u4e2d\u6587\u5c0f\u5199\u6570\u5b57", (String)"FormatModel_48", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        specialFormat.put(ResManager.loadKDString((String)"[DBNum2]G/\u901a\u7528\u683c\u5f0f", (String)"FormatModel_44", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), new LocaleString(ResManager.loadKDString((String)"\u4e2d\u6587\u5927\u5199\u6570\u5b57", (String)"FormatModel_49", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        specialFormat.put(ResManager.loadKDString((String)"[Dollar]0.00;[Dollar](\u8d1f\u6570)0.00", (String)"FormatModel_45", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), new LocaleString(ResManager.loadKDString((String)"\u4e2d\u6587\u7f8e\u5143\u6837\u5f0f", (String)"FormatModel_50", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        specialFormat.put(ResManager.loadKDString((String)"[Rmb]0.00;[Rmb](\u8d1f\u6570)0.00", (String)"FormatModel_46", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), new LocaleString(ResManager.loadKDString((String)"\u4e2d\u6587\u4eba\u6c11\u5e01\u6837\u5f0f", (String)"FormatModel_51", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
    }
}

