/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.print;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.property.print.FormatModel;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;

public class FormatPlugin
extends AbstractFormPlugin
implements ListboxClickListener {
    static final String ITEM = "ITEM";
    static final String TYPE = "TYPE";
    static final String DECIMAL_DIGITS = "DECIMAL_DIGITS";
    static final String MONEY_SYMBOL = "MONEY_SYMBOL";
    static final String KILLO_SEPARATOR = "KILLO_SEPARATOR";
    static final String FORMAT_STRING = "FORMAT_STRING";
    static final String NORMAL = "NORMAL";
    static final String NUMBER = "NUMBER";
    static final String MONEY = "MONEY";
    static final String ACCOUNT = "ACCOUNT";
    static final String DATE = "DATE";
    static final String TIME = "TIME";
    static final String PERCENT = "PERCENT";
    static final String FRACTION = "FRACTION";
    static final String SCIENCE = "SCIENCE";
    static final String TEXT = "TEXT";
    static final String SPECIAL = "SPECIAL";
    static final String CUSTOM = "CUSTOM";
    static final String YEAR = "YEAR";
    static final String MONTH = "MONTH";
    static final String DAY = "DAY";
    static final String WEEK = "WEEK";
    static final String HOUR = "HOUR";
    static final String MINUTE = "MINUTE";
    static final String SECOND = "SECOND";
    static final String ONE = "ONE";
    static final String TWO = "TWO";
    static final String THREE = "THREE";
    static final String FOUR = "FOUR";
    static final String FIVE = "FIVE";
    static final String SIX = "SIX";
    static final String SEVEN = "SEVEN";
    static final String EIGHT = "EIGHT";
    static final String NINE = "NINE";
    static final String TEN = "TEN";
    static final String POSTALCODE = "POSTALCODE";
    static final String CHINESE_CAPITAL_NUMBER = "CHINESE_CAPITAL_NUMBER";
    static final String CHINESE_MINUSCULE_NUMBER = "CHINESE_MINUSCULE_NUMBER";
    static final String DENOMINATOR = "DENOMINATOR";
    private static final String VALUE = "value";
    private String SETTING_STRING = "settingstring";
    private String BTN_OK = "btnok";
    private String BTN_CANCEL = "btncancel";
    private String LISTBOXAP = "listboxap";
    private String CUNRRENT_NODE = "cunrrentnode";
    private String ZERO_STR = "zerostr";
    private String ZERO_STR_COMBO = "zerostrcombo";
    private String FORMMAT_TYPE = "formattype";
    private String SCALE = "scale";
    private String TAIL_ZERO = "tailzero";
    private String TYPE_PANEL = "typepanel";
    private String NUMBER_PANEL = "numberpanel";
    private String CURRENCY_SYMBOL = "currencysymbol";
    private String THOUSANDTH_SPLIT = "thousandthsplit";
    private String NEGATIVE = "negative";
    private FormatModel fmodel;

    public void initialize() {
        this.addClickListeners(new String[]{this.BTN_OK, this.BTN_CANCEL});
        Listbox listbox = (Listbox)this.getView().getControl(this.LISTBOXAP);
        listbox.addListboxClickListener((ListboxClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Object value = this.getView().getFormShowParameter().getCustomParams().get(VALUE);
        String format = "";
        if (!ObjectUtils.isEmpty(value)) {
            try {
                Map cusInfo = (Map)SerializationUtils.fromJsonString((String)((String)value), Map.class);
                format = (String)cusInfo.get(VALUE);
            }
            catch (Exception e1) {
                format = value.toString();
            }
            this.fmodel = new FormatModel(format);
            this.getView().getModel().setValue(this.SETTING_STRING, (Object)this.fmodel.getPattern());
        } else {
            this.fmodel = new FormatModel();
        }
        int type = this.fmodel.getType();
        this.getPageCache().put(this.CUNRRENT_NODE, String.valueOf(type));
        Listbox listbox = (Listbox)this.getControl(this.LISTBOXAP);
        List<ListboxItem> listboxItems = this.getFormatTypes();
        listbox.addItems(listboxItems);
        this.showControls(type);
        listbox.activeItem(String.valueOf(type));
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        String key = btn.getKey();
        if (this.BTN_OK.equalsIgnoreCase(key)) {
            Object zerostr = this.getModel().getValue(this.ZERO_STR);
            String zerostrcombo = (String)this.getModel().getValue(this.ZERO_STR_COMBO);
            if (StringUtils.equals((CharSequence)zerostrcombo, (CharSequence)"1") && ObjectUtils.isEmpty((Object)zerostr)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5176\u4ed6\u503c\u4e3a\uff1a", (String)"FormatPlugin_0", (String)"bos-noteprint", (Object[])new Object[0]));
                return;
            }
            this.returnData();
            this.getView().close();
        }
    }

    public void listboxClick(ListboxEvent evt) {
        String itemId = evt.getItemId();
        this.getPageCache().put(this.CUNRRENT_NODE, itemId);
        int type = Integer.parseInt(itemId);
        this.fmodel = new FormatModel();
        this.fmodel.setType(type);
        this.showControls(type);
        if (type != 11) {
            this.getView().getModel().setValue(this.SETTING_STRING, (Object)this.fmodel.getPattern());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String currentNode = this.getPageCache().get(this.CUNRRENT_NODE);
        int nodeType = 0;
        if (StringUtils.isNotEmpty((CharSequence)currentNode) && (nodeType = Integer.parseInt(currentNode)) == 11) {
            return;
        }
        if (this.fmodel == null) {
            this.fmodel = new FormatModel();
        }
        this.fmodel.setType(nodeType);
        String changeName = e.getProperty().getName();
        Object changeValue = e.getChangeSet()[0].getNewValue();
        String settingString = this.fmodel.getPattern();
        switch (nodeType) {
            case 1: {
                settingString = this.setNumberFormatModel(changeName, changeValue);
                break;
            }
            case 2: {
                settingString = this.setCurrencyFormatModel(changeName, changeValue);
                break;
            }
            case 3: {
                settingString = this.setAccountFormatModel(changeName, changeValue);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: {
                settingString = String.valueOf(changeValue);
                break;
            }
            case 6: 
            case 8: {
                settingString = this.setPercentFormatModel(changeName, changeValue);
                break;
            }
        }
        this.getModel().setValue(this.SETTING_STRING, (Object)settingString);
    }

    private String setNumberFormatModel(String changeName, Object changeValue) {
        int scale = this.getScale(changeName, changeValue);
        this.fmodel.setDecNums(scale);
        boolean tailZero = this.getTailZero(changeName, changeValue);
        this.fmodel.setTailZero(tailZero);
        boolean thousandthsplit = this.getThousandthsplit(changeName, changeValue);
        this.fmodel.setHasGroupSep(thousandthsplit);
        int negative = this.getNegative(changeName, changeValue);
        this.fmodel.setNegativeIndex(negative);
        this.initNegativeList(scale, thousandthsplit);
        String zeroStr = this.getZeroStr(changeName, changeValue);
        this.fmodel.setZeroString(zeroStr);
        return this.fmodel.getPattern();
    }

    private String setCurrencyFormatModel(String changeName, Object changeValue) {
        int symbolIndex = this.getCurrencySymbol(changeName, changeValue);
        this.fmodel.setCurrencyIndex(symbolIndex);
        return this.setNumberFormatModel(changeName, changeValue);
    }

    private String setPercentFormatModel(String changeName, Object changeValue) {
        int scale = this.getScale(changeName, changeValue);
        this.fmodel.setDecNums(scale);
        boolean tailZero = this.getTailZero(changeName, changeValue);
        this.fmodel.setTailZero(tailZero);
        boolean thousandthsplit = (Boolean)this.getModel().getValue("thousandthsplit");
        this.fmodel.setHasGroupSep(thousandthsplit);
        Object negativeObj = this.getView().getModel().getValue("negative");
        if (negativeObj != null) {
            int negativeIndex = Integer.parseInt(negativeObj.toString());
            this.initNegativeList(scale, thousandthsplit);
            this.fmodel.setNegativeIndex(negativeIndex);
        }
        return this.fmodel.getPattern();
    }

    private String setAccountFormatModel(String changeName, Object changeValue) {
        int symbolIndex = this.getCurrencySymbol(changeName, changeValue);
        this.fmodel.setCurrencyIndex(symbolIndex);
        return this.setPercentFormatModel(changeName, changeValue);
    }

    private void showControls(int type) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"formatstringpanel"});
        if (type == 0 || type == 9) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{this.TYPE_PANEL, this.NUMBER_PANEL});
            this.getModel().setValue(this.SETTING_STRING, (Object)FormatModel.getGeneral());
        } else if (type == 1) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{this.TYPE_PANEL});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{this.NUMBER_PANEL});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{this.CURRENCY_SYMBOL});
            if (" ".equals(this.fmodel.getZeroString())) {
                this.getModel().setValue(this.ZERO_STR_COMBO, (Object)0);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{this.ZERO_STR});
            } else if ("".equals(this.fmodel.getZeroString()) || this.fmodel.getZeroString() == null) {
                this.getModel().setValue(this.ZERO_STR_COMBO, (Object)2);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{this.ZERO_STR});
            } else {
                this.getModel().setValue(this.ZERO_STR_COMBO, (Object)1);
                this.getView().setVisible(Boolean.valueOf(true), new String[]{this.ZERO_STR});
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{this.ZERO_STR_COMBO});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{this.THOUSANDTH_SPLIT});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{this.TAIL_ZERO});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{this.NEGATIVE});
            this.initNegativeList(this.fmodel.getDecNums(), this.fmodel.hasGroupSep());
        } else if (type == 2) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{this.TYPE_PANEL});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{this.NUMBER_PANEL});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{this.CURRENCY_SYMBOL});
            if (" ".equals(this.fmodel.getZeroString())) {
                this.getModel().setValue(this.ZERO_STR_COMBO, (Object)0);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{this.ZERO_STR});
            } else if ("".equals(this.fmodel.getZeroString()) || this.fmodel.getZeroString() == null) {
                this.getModel().setValue(this.ZERO_STR_COMBO, (Object)2);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{this.ZERO_STR});
            } else {
                this.getModel().setValue(this.ZERO_STR_COMBO, (Object)1);
                this.getView().setVisible(Boolean.valueOf(true), new String[]{this.ZERO_STR});
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{this.ZERO_STR_COMBO});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{this.THOUSANDTH_SPLIT});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{this.NEGATIVE});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{this.TAIL_ZERO});
            this.initNegativeList(this.fmodel.getDecNums(), true);
            ComboEdit currencySymbol = (ComboEdit)this.getView().getControl(this.CURRENCY_SYMBOL);
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
            for (int i = 0; i < FormatModel.currencyTexts.length; ++i) {
                String value = Integer.toString(i);
                String caption = FormatModel.currencyTexts[i];
                ComboItem item = new ComboItem();
                item.setValue(value);
                item.setCaption(new LocaleString(caption));
                comboItems.add(item);
            }
            currencySymbol.setComboItems(comboItems);
        } else if (type == 3) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{this.TYPE_PANEL});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{this.NUMBER_PANEL});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{this.ZERO_STR});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{this.ZERO_STR_COMBO});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{this.CURRENCY_SYMBOL});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{this.THOUSANDTH_SPLIT});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{this.TAIL_ZERO});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{this.NEGATIVE});
            ComboEdit currencySymbol = (ComboEdit)this.getView().getControl(this.CURRENCY_SYMBOL);
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
            for (int i = 0; i < FormatModel.currencyTexts.length; ++i) {
                String value = Integer.toString(i);
                String caption = FormatModel.currencySymbols[i];
                ComboItem item = new ComboItem();
                item.setValue(value);
                item.setCaption(new LocaleString(caption));
                comboItems.add(item);
            }
            currencySymbol.setComboItems(comboItems);
        } else if (type == 4) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{this.TYPE_PANEL});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{this.NUMBER_PANEL});
            ComboEdit formateType = (ComboEdit)this.getView().getControl(this.FORMMAT_TYPE);
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
            for (int i = 0; i < FormatModel.dateTexts.length; ++i) {
                String value = FormatModel.datePatterns[i].toLowerCase();
                String caption = FormatModel.dateTexts[i];
                ComboItem item = new ComboItem();
                item.setValue(value);
                item.setCaption(new LocaleString(caption));
                comboItems.add(item);
            }
            formateType.setComboItems(comboItems);
            this.getModel().setValue(this.FORMMAT_TYPE, (Object)this.fmodel.getPattern());
        } else if (type == 5) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{this.TYPE_PANEL});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{this.NUMBER_PANEL});
            ComboEdit formateType = (ComboEdit)this.getView().getControl(this.FORMMAT_TYPE);
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
            for (int i = 0; i < FormatModel.timeTexts.length; ++i) {
                String value = FormatModel.timePatterns[i].toLowerCase();
                String caption = FormatModel.timeTexts[i];
                ComboItem item = new ComboItem();
                item.setValue(value);
                item.setCaption(new LocaleString(caption));
                comboItems.add(item);
            }
            formateType.setComboItems(comboItems);
            this.getModel().setValue(this.FORMMAT_TYPE, (Object)this.fmodel.getPattern());
        } else if (type == 6 || type == 8) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{this.TYPE_PANEL});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{this.NUMBER_PANEL});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{this.ZERO_STR});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{this.ZERO_STR_COMBO});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{this.CURRENCY_SYMBOL});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{this.THOUSANDTH_SPLIT});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{this.TAIL_ZERO});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{this.NEGATIVE});
        } else if (type == 7) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{this.TYPE_PANEL});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{this.NUMBER_PANEL});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{this.NEGATIVE});
            ComboEdit formateType = (ComboEdit)this.getView().getControl(this.FORMMAT_TYPE);
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
            for (int i = 0; i < FormatModel.fractionTexts.length; ++i) {
                String value = FormatModel.fractionPatterns[i];
                String caption = FormatModel.fractionTexts[i];
                ComboItem item = new ComboItem();
                item.setValue(value);
                item.setCaption(new LocaleString(caption));
                comboItems.add(item);
            }
            formateType.setComboItems(comboItems);
            this.getModel().setValue(this.FORMMAT_TYPE, (Object)this.fmodel.getPattern());
        } else if (type == 10) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{this.TYPE_PANEL});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{this.NUMBER_PANEL});
            ComboEdit formateType = (ComboEdit)this.getView().getControl(this.FORMMAT_TYPE);
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
            for (Map.Entry<String, LocaleString> entry : FormatModel.specialFormat.entrySet()) {
                ComboItem item = new ComboItem();
                item.setValue(entry.getKey().toLowerCase());
                item.setCaption(entry.getValue());
                comboItems.add(item);
            }
            formateType.setComboItems(comboItems);
            this.getModel().setValue(this.FORMMAT_TYPE, (Object)this.fmodel.getPattern());
        } else if (type == 11) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{this.TYPE_PANEL});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{this.NUMBER_PANEL});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"formatstringpanel"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{this.TYPE_PANEL});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{this.NUMBER_PANEL});
        }
        this.getModel().setValue(this.TAIL_ZERO, (Object)this.fmodel.isTailZero());
        this.getModel().setValue(this.CURRENCY_SYMBOL, (Object)this.fmodel.getCurrencyIndex());
        this.getModel().setValue(this.SCALE, (Object)this.fmodel.getDecNums());
        this.getModel().setValue(this.THOUSANDTH_SPLIT, (Object)this.fmodel.hasGroupSep());
        this.getModel().setValue(this.NEGATIVE, (Object)this.fmodel.getNegativeIndex());
        this.getModel().setValue(this.ZERO_STR, (Object)this.fmodel.getZeroString());
    }

    private void initNegativeList(int decimal, boolean group) {
        String dd = "";
        StringBuilder sdec = new StringBuilder();
        for (int i = decimal - 1; i >= 0; --i) {
            int n = i;
            if (n >= 10) {
                n %= 10;
            }
            sdec.append(n);
        }
        if (sdec.length() > 0) {
            dd = sdec.insert(0, '.').toString();
        }
        String str = group ? "1,234" : "1234";
        ComboEdit negativeCombo = (ComboEdit)this.getView().getControl(this.NEGATIVE);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        negativeCombo.setComboItems(comboItems);
        String e = '(' + str + dd + ')';
        ComboItem item = new ComboItem();
        item.setValue("1");
        item.setCaption(new LocaleString(e));
        comboItems.add(item);
        e = '-' + str + dd;
        item = new ComboItem();
        item.setValue("3");
        item.setCaption(new LocaleString(e));
        comboItems.add(item);
        negativeCombo.setComboItems(comboItems);
        negativeCombo.selectedStore(item);
    }

    private void returnData() {
        Object formatValue = this.getView().getModel().getValue(this.SETTING_STRING);
        HashMap returnData = new HashMap();
        returnData.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        returnData.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        returnData.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        String itemValue = this.getPageCache().get(this.CUNRRENT_NODE);
        if (StringUtils.isNotBlank((CharSequence)itemValue)) {
            returnData.put("alias", FormatModel.formatType.get(Integer.parseInt(itemValue)));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(VALUE, formatValue);
        map.put("alias", FormatModel.formatType.get(Integer.parseInt(itemValue)));
        returnData.put(VALUE, SerializationUtils.toJsonString(map));
        this.getView().returnDataToParent(returnData);
    }

    private List<ListboxItem> getFormatTypes() {
        ArrayList<ListboxItem> items = new ArrayList<ListboxItem>(10);
        for (Map.Entry<Integer, String> entry : FormatModel.formatType.entrySet()) {
            ListboxItem item = new ListboxItem();
            item.setId(entry.getKey().toString());
            item.setContent(entry.getValue());
            items.add(item);
        }
        return items;
    }

    private int getScale(String changeName, Object changeValue) {
        int scale = 2;
        if (this.SCALE.equals(changeName)) {
            scale = Integer.parseInt(changeValue == null ? "2" : changeValue.toString());
        } else {
            Object scaleObj = this.getModel().getValue(this.SCALE);
            if (scaleObj != null) {
                scale = Integer.parseInt(scaleObj.toString());
            }
        }
        return scale;
    }

    private boolean getTailZero(String changeName, Object changeValue) {
        boolean tailZero = false;
        tailZero = this.TAIL_ZERO.equals(changeName) ? ((Boolean)changeValue).booleanValue() : ((Boolean)this.getModel().getValue(this.TAIL_ZERO)).booleanValue();
        return tailZero;
    }

    private boolean getThousandthsplit(String changeName, Object changeValue) {
        boolean thousandthsplit = true;
        thousandthsplit = this.THOUSANDTH_SPLIT.equals(changeName) ? ((Boolean)changeValue).booleanValue() : ((Boolean)this.getModel().getValue(this.THOUSANDTH_SPLIT)).booleanValue();
        return thousandthsplit;
    }

    private int getNegative(String changeName, Object changeValue) {
        int negativeIndex = 1;
        if (this.SCALE.equals(changeName)) {
            negativeIndex = Integer.parseInt(changeValue == null ? "1" : changeValue.toString());
        } else {
            Object negativeObj = this.getView().getModel().getValue(this.NEGATIVE);
            if (negativeObj != null) {
                negativeIndex = Integer.parseInt(negativeObj.toString());
            }
        }
        return negativeIndex;
    }

    private int getCurrencySymbol(String changeName, Object changeValue) {
        int symbolIndex = 0;
        if (this.CURRENCY_SYMBOL.equals(changeName)) {
            String changeVal = (String)changeValue;
            if (changeVal == null) {
                changeVal = "0";
            } else if (!changeVal.matches("\\d+")) {
                changeVal = "0";
            }
            symbolIndex = Integer.parseInt(changeVal);
        } else {
            Object currencyIndex = this.getView().getModel().getValue(this.CURRENCY_SYMBOL);
            if (currencyIndex != null) {
                symbolIndex = Integer.parseInt(currencyIndex.toString());
            }
        }
        return symbolIndex;
    }

    private String getZeroStr(String changeName, Object changeValue) {
        String zeroStr = "";
        if (this.ZERO_STR_COMBO.equals(changeName)) {
            String zerostrcombo = (String)this.getModel().getValue(this.ZERO_STR_COMBO);
            if ("0".equals(zerostrcombo)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{this.ZERO_STR});
                this.getModel().setValue(this.ZERO_STR, (Object)" ");
            } else if ("2".equals(zerostrcombo)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{this.ZERO_STR});
                this.getModel().setValue(this.ZERO_STR, (Object)"");
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{this.ZERO_STR});
            }
        } else if (this.ZERO_STR.equals(changeName)) {
            zeroStr = (String)changeValue;
        } else {
            Object showText = this.getModel().getValue(this.ZERO_STR);
            if (showText != null) {
                zeroStr = (String)showText;
            }
        }
        return zeroStr;
    }
}

